/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.HashMap;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IPath;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;

public class ExternalToolsPattern {
    private String fKind;
    private String fName;
    private String fType;
    private String fDescription;
    private String fPatternString;
    private Pattern fPattern;
    private HashMap<String, Integer> fVariablesMap;
    private HashMap<String, DVTHyperlinkCommand> fHyperlinkCommandsMap;
    private boolean fEnabled;
    private boolean fModified;
    private String fOldKind;
    private String fOldName;
    private String fOldType;
    private String fOldDescription;
    private String fOldPatternString;
    private Pattern fOldPattern;
    private HashMap<String, Integer> fOldVariablesMap;
    private HashMap<String, DVTHyperlinkCommand> fOldHyperlinkCommandsMap;
    private Boolean fOldEnabled;
    private IPath fWorkingDir;

    public ExternalToolsPattern(ExternalToolsPattern convention) {
        this.fKind = convention.getKind();
        this.fName = convention.getName();
        this.fType = convention.getType();
        this.fDescription = convention.getDescription();
        this.fPatternString = convention.getPatternString();
        this.fEnabled = convention.getEnabled();
        this.fPattern = Pattern.compile(convention.getPattern().pattern());
        this.fVariablesMap = convention.getVariablesMap();
        this.fHyperlinkCommandsMap = convention.getHyperlinkCommandsMap();
    }

    public HashMap<String, Integer> getVariablesMap() {
        return this.fVariablesMap;
    }

    public HashMap<String, DVTHyperlinkCommand> getHyperlinkCommandsMap() {
        return this.fHyperlinkCommandsMap;
    }

    public Pattern getPattern() {
        return this.fPattern;
    }

    public ExternalToolsPattern(String kind, String name, String type, String description, String pattern, Pattern compiled, HashMap<String, Integer> variablesMap, HashMap<String, DVTHyperlinkCommand> hyperlinkCommandsMap, boolean enabled) {
        this.fKind = kind;
        this.fName = name;
        this.fType = type;
        this.fPatternString = pattern;
        this.fPattern = compiled;
        this.fVariablesMap = variablesMap;
        this.fHyperlinkCommandsMap = hyperlinkCommandsMap;
        this.fEnabled = enabled;
        this.fDescription = description;
    }

    public String getKind() {
        return this.fKind;
    }

    public String getName() {
        return this.fName;
    }

    public String getType() {
        return this.fType;
    }

    public String getPatternString() {
        return this.fPatternString;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public boolean isModified() {
        return this.fModified;
    }

    public void setModified() {
        this.fModified = true;
    }

    public void revert() {
        if (this.fModified) {
            if (this.fOldKind != null) {
                this.fKind = this.fOldKind;
            }
            if (this.fOldName != null) {
                this.fName = this.fOldName;
            }
            if (this.fOldType != null) {
                this.fType = this.fOldType;
            }
            if (this.fOldDescription != null) {
                this.fDescription = this.fOldDescription;
            }
            if (this.fOldPatternString != null) {
                this.fPatternString = this.fOldPatternString;
            }
            if (this.fOldPattern != null) {
                this.fPattern = this.fOldPattern;
            }
            if (this.fOldVariablesMap != null) {
                this.fVariablesMap = this.fOldVariablesMap;
            }
            if (this.fOldHyperlinkCommandsMap != null) {
                this.fHyperlinkCommandsMap = this.fOldHyperlinkCommandsMap;
            }
            if (this.fOldEnabled != null) {
                this.fEnabled = this.fOldEnabled;
            }
        }
        this.fModified = false;
    }

    public void setKind(String kind) {
        this.fModified = true;
        this.fOldKind = this.fKind;
        this.fKind = kind;
    }

    public void setName(String name) {
        this.fModified = true;
        this.fOldName = this.fName;
        this.fName = name;
    }

    public void setType(String type) {
        this.fModified = true;
        this.fOldType = this.fType;
        this.fType = type;
    }

    public void setPatternString(String pattern) {
        this.fModified = true;
        this.fOldPatternString = this.fPatternString;
        this.fPatternString = pattern;
    }

    public void setPattern(Pattern pattern) {
        this.fModified = true;
        this.fOldPattern = this.fPattern;
        this.fPattern = pattern;
    }

    public void setVariablesMap(HashMap<String, Integer> variablesMap) {
        this.fModified = true;
        this.fOldVariablesMap = this.fVariablesMap;
        this.fVariablesMap = variablesMap;
    }

    public void setHyperlinkCommandsMap(HashMap<String, DVTHyperlinkCommand> hyperlinkCommandsMap) {
        this.fModified = true;
        this.fOldHyperlinkCommandsMap = this.fHyperlinkCommandsMap;
        this.fHyperlinkCommandsMap = hyperlinkCommandsMap;
    }

    public void setDescription(String description) {
        this.fModified = true;
        this.fOldDescription = this.fDescription;
        this.fDescription = description;
    }

    public void setEnabled(boolean enabled) {
        this.fModified = true;
        this.fOldEnabled = this.fEnabled;
        this.fEnabled = enabled;
    }

    public String toString() {
        return "[" + this.fKind + "][" + this.fName + "][" + this.fPatternString + "]";
    }

    public void setWorkingDir(IPath workingDir) {
        this.fWorkingDir = workingDir;
    }

    public IPath getWorkingDir() {
        return this.fWorkingDir;
    }
}

