/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.HashMap;
import java.util.Map;

public class ExternalToolsProblem {
    public static final int NONE = 0;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    private int fSeverity;
    private String fMessage;
    private String fFileName;
    private int fLineNumber;
    private Map<String, String> fAttributes = new HashMap<String, String>();

    public ExternalToolsProblem(int severity, String fileName, int lineNumber, String message) {
        this.fSeverity = severity;
        this.fFileName = fileName;
        this.fLineNumber = lineNumber;
        this.fMessage = message;
    }

    public int getLine() {
        return this.fLineNumber;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public int getSeverity() {
        return this.fSeverity;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public ExternalToolsProblem setAttribute(String key, String value) {
        this.fAttributes.put(key, value);
        return this;
    }

    public ExternalToolsProblem addAttributes(Map<String, String> attributes) {
        this.fAttributes.putAll(attributes);
        return this;
    }

    public String getAttribute(String key) {
        return this.fAttributes.get(key);
    }

    public Map<String, String> getAllAttributes() {
        return this.fAttributes;
    }

    public ExternalToolsProblem removeAttribute(String key) {
        this.fAttributes.remove(key);
        return this;
    }

    public void clearAttributes() {
        this.fAttributes.clear();
    }
}

