/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsReference;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;
import ro.amiq.dvt.externaltools.pattern.PatternException;
import ro.amiq.dvt.externaltools.pattern.PatternTranslator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTUtilsCommon;
import ro.amiq.dvt.utils.XMLErrorHandler;

public class ExternalToolsReaderWriter {
    private static final String CONFIGURATIONS_ROOT = "configurations";
    private static final String CONFIGURATION_NODE = "configuration";
    private static final String REFERENCE_NODE = "reference";
    private static final String PATTERNS_ROOT = "patterns";
    private static final String PATTERN_NODE = "pattern";
    private static final String ENV_VARS_ROOT = "environment_variables";
    private static final String ENV_VARS_NODE = "environment_variable";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String KIND_ATTRIBUTE = "kind";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String TYPE_ATTRIBUTE = "type";

    public IExternalToolsConfiguration[] read(File file, Map<String, ExternalToolsConfiguration> commonConfigurations) throws IOException {
        BufferedInputStream input = null;
        IExternalToolsConfiguration[] result = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            result = this.read(new InputSource(input), commonConfigurations);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(input);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(input);
        return result;
    }

    public IExternalToolsConfiguration[] read(File file) throws IOException {
        BufferedInputStream input = null;
        IExternalToolsConfiguration[] result = null;
        try {
            input = new BufferedInputStream(new FileInputStream(file));
            result = this.read(new InputSource(input), null);
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(input);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(input);
        return result;
    }

    private IExternalToolsConfiguration[] read(InputSource source, Map<String, ExternalToolsConfiguration> commonConfigurations) throws IOException {
        try {
            ArrayList<IExternalToolsConfiguration> result = new ArrayList<IExternalToolsConfiguration>();
            ArrayList<ExternalToolsPattern> patterns = new ArrayList<ExternalToolsPattern>();
            HashSet<String> ids = new HashSet<String>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            parser.setErrorHandler(XMLErrorHandler.INSTANCE);
            Document document = parser.parse(source);
            document.getDocumentElement().normalize();
            NodeList roots = document.getElementsByTagName(CONFIGURATIONS_ROOT);
            if (roots.getLength() > 0) {
                NodeList elements = roots.item(0).getChildNodes();
                int count = elements.getLength();
                int i = 0;
                while (i < count) {
                    Node node = elements.item(i);
                    if (node instanceof Element) {
                        String builderName;
                        ExternalToolsConfiguration referencedConfiguration;
                        NamedNodeMap attributes;
                        Element element = (Element)node;
                        if (element.getTagName().equals(CONFIGURATION_NODE)) {
                            patterns.clear();
                            ids.clear();
                            attributes = element.getAttributes();
                            if (attributes != null) {
                                ExternalToolsConfiguration config = new ExternalToolsConfiguration();
                                String builderName2 = this.getStringValue(attributes, "ATTR_BUILDER_NAME", null);
                                config.setName(builderName2);
                                boolean builderEnable = this.getBooleanValue(attributes, "ATTR_BUILDER_ENABLED", true);
                                config.setEnable(builderEnable);
                                String runKinds = this.getStringValue(attributes, "ATTR_FILTERS_KIND", null);
                                config.setFilterKinds(runKinds.split(","));
                                String workingDir = this.getStringValue(attributes, "ATTR_WORKING_DIRECTORY", null);
                                config.setWorkingDir(workingDir);
                                String autoCommand = this.getStringValue(attributes, "ATTR_AUTO_COMMAND", null);
                                config.setAutoCommand(autoCommand);
                                String fullCommand = this.getStringValue(attributes, "ATTR_FULL_COMMAND", null);
                                config.setFullCommand(fullCommand);
                                String cleanCommand = this.getStringValue(attributes, "ATTR_CLEAN_COMMAND", null);
                                config.setCleanCommand(cleanCommand);
                                Element nodeElement = (Element)node;
                                NodeList patternRootNode = nodeElement.getElementsByTagName(PATTERNS_ROOT);
                                int p1 = 0;
                                while (p1 < patternRootNode.getLength()) {
                                    Element patternElement = (Element)patternRootNode.item(p1);
                                    NodeList patternNodes = patternElement.getElementsByTagName(PATTERN_NODE);
                                    int j = 0;
                                    while (j != patternNodes.getLength()) {
                                        node = patternNodes.item(j);
                                        attributes = node.getAttributes();
                                        if (attributes != null) {
                                            String name = this.getStringValue(attributes, NAME_ATTRIBUTE, null);
                                            if (name != null && ids.contains(name)) {
                                                throw new IOException("ExternalBuilderReaderWriter.error.duplicate_id");
                                            }
                                            ids.add(name);
                                            String description = this.getStringValue(attributes, DESCRIPTION_ATTRIBUTE, "");
                                            String kind = this.getStringValue(attributes, KIND_ATTRIBUTE, null);
                                            if (name == null || kind == null) {
                                                throw new IOException("ExternalBuilderReaderWriter.error.missing_attribute");
                                            }
                                            boolean enabled = this.getBooleanValue(attributes, ENABLED_ATTRIBUTE, true);
                                            String priority = this.getStringValue(attributes, TYPE_ATTRIBUTE, "");
                                            StringBuilder buffer = new StringBuilder();
                                            NodeList children2 = node.getChildNodes();
                                            int k = 0;
                                            while (k != children2.getLength()) {
                                                String value = children2.item(k).getNodeValue();
                                                if (value != null) {
                                                    buffer.append(value);
                                                }
                                                ++k;
                                            }
                                            String pattern = buffer.toString();
                                            PatternTranslator translator = new PatternTranslator();
                                            translator.translate(pattern);
                                            Pattern compiledPattern = translator.getCompiledPattern();
                                            HashMap<String, Integer> variablesMap = translator.getVariablesMap();
                                            HashMap<String, DVTHyperlinkCommand> hyperlinkCommandsMap = translator.getHyperlinkCommandsMap();
                                            ExternalToolsPattern convention = new ExternalToolsPattern(kind, name, priority, description, pattern, compiledPattern, variablesMap, hyperlinkCommandsMap, enabled);
                                            patterns.add(convention);
                                        }
                                        ++j;
                                    }
                                    config.setPatterns(patterns.toArray(new ExternalToolsPattern[patterns.size()]));
                                    ++p1;
                                }
                                NodeList envVarsRootsList = nodeElement.getElementsByTagName(ENV_VARS_ROOT);
                                Node envVarsNode = envVarsRootsList.item(0);
                                if (envVarsNode != null) {
                                    attributes = envVarsNode.getAttributes();
                                    if (attributes != null) {
                                        boolean appendEnvVars = this.getBooleanValue(attributes, "ATTR_APPEND_ENVIRONMENT_VARIABLES", true);
                                        config.setAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES", appendEnvVars);
                                    } else {
                                        config.setAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES", true);
                                    }
                                }
                                int p12 = 0;
                                while (p12 < envVarsRootsList.getLength()) {
                                    Element envVarRootElement = (Element)envVarsRootsList.item(p12);
                                    NodeList envVarsList = envVarRootElement.getElementsByTagName(ENV_VARS_NODE);
                                    HashMap<String, String> envVars = new HashMap<String, String>();
                                    if (envVarsList != null) {
                                        int k = 0;
                                        while (k < envVarsList.getLength()) {
                                            node = envVarsList.item(k);
                                            attributes = node.getAttributes();
                                            if (attributes != null) {
                                                String attrName = this.getStringValue(attributes, NAME_ATTRIBUTE, null);
                                                String attrValue = this.getStringValue(attributes, VALUE_ATTRIBUTE, null);
                                                if (attrName != null && !attrName.isEmpty() && attrValue != null && !attrValue.isEmpty()) {
                                                    envVars.put(attrName, attrValue);
                                                }
                                            }
                                            ++k;
                                        }
                                    }
                                    config.setAttribute("ATTR_ENVIRONMENT_VARIABLES", envVars);
                                    ++p12;
                                }
                                result.add(config);
                            }
                        } else if (commonConfigurations != null && !commonConfigurations.isEmpty() && element.getTagName().equals(REFERENCE_NODE) && (attributes = element.getAttributes()) != null && (referencedConfiguration = commonConfigurations.get(builderName = this.getStringValue(attributes, "ATTR_BUILDER_NAME", null))) != null) {
                            ExternalToolsReference reference = new ExternalToolsReference(referencedConfiguration);
                            boolean builderEnable = this.getBooleanValue(attributes, "ATTR_BUILDER_ENABLED", true);
                            reference.setEnable(builderEnable);
                            result.add(reference);
                        }
                    }
                    ++i;
                }
            }
            return result.toArray(new IExternalToolsConfiguration[patterns.size()]);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
        catch (PatternException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public void save(IExternalToolsConfiguration[] configurations, File file) throws IOException {
        BufferedOutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(file));
            this.save(configurations, new StreamResult(output));
        }
        catch (Throwable throwable) {
            DVTUtilsCommon.INSTANCE.closeClosable(output);
            throw throwable;
        }
        DVTUtilsCommon.INSTANCE.closeClosable(output);
    }

    private void save(IExternalToolsConfiguration[] configurations, StreamResult result) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(CONFIGURATIONS_ROOT);
            document.appendChild(root);
            int i = 0;
            while (i < configurations.length) {
                IExternalToolsConfiguration config = configurations[i];
                if (config instanceof ExternalToolsReference) {
                    Element referenceNode = document.createElement(REFERENCE_NODE);
                    root.appendChild(referenceNode);
                    attributes = referenceNode.getAttributes();
                    if (config != null) {
                        name = document.createAttribute("ATTR_BUILDER_NAME");
                        name.setValue(config.getName());
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_BUILDER_ENABLED");
                        name.setValue(Boolean.toString(config.getEnable()));
                        attributes.setNamedItem(name);
                    }
                } else {
                    Element configNode = document.createElement(CONFIGURATION_NODE);
                    root.appendChild(configNode);
                    attributes = configNode.getAttributes();
                    if (config != null) {
                        name = document.createAttribute("ATTR_BUILDER_NAME");
                        name.setValue(config.getName());
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_BUILDER_ENABLED");
                        name.setValue(Boolean.toString(config.getEnable()));
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_FILTERS_KIND");
                        String[] filterKinds = config.getFilterKinds();
                        String kinds = "";
                        int j = 0;
                        while (j < filterKinds.length) {
                            kinds = String.valueOf(kinds) + filterKinds[j] + ",";
                            ++j;
                        }
                        name.setValue(kinds);
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_WORKING_DIRECTORY");
                        name.setValue(config.getWorkingDir());
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_AUTO_COMMAND");
                        name.setValue(config.getAutoCommand());
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_FULL_COMMAND");
                        name.setValue(config.getFullCommand());
                        attributes.setNamedItem(name);
                        name = document.createAttribute("ATTR_CLEAN_COMMAND");
                        name.setValue(config.getCleanCommand());
                        attributes.setNamedItem(name);
                        Element patternRoot = document.createElement(PATTERNS_ROOT);
                        configNode.appendChild(patternRoot);
                        if (config.getPatterns() != null) {
                            int j2 = 0;
                            while (j2 < config.getPatterns().length) {
                                ExternalToolsPattern filter = config.getPatterns()[j2];
                                Element node = document.createElement(PATTERN_NODE);
                                patternRoot.appendChild(node);
                                attributes = node.getAttributes();
                                if (filter != null) {
                                    name = document.createAttribute(NAME_ATTRIBUTE);
                                    name.setValue(filter.getName());
                                    attributes.setNamedItem(name);
                                    Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                                    description.setValue(filter.getDescription());
                                    attributes.setNamedItem(description);
                                    Attr context = document.createAttribute(KIND_ATTRIBUTE);
                                    context.setValue(filter.getKind());
                                    attributes.setNamedItem(context);
                                    Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                                    enabled.setValue(filter.getEnabled() ? Boolean.toString(true) : Boolean.toString(false));
                                    attributes.setNamedItem(enabled);
                                    Attr priority = document.createAttribute(TYPE_ATTRIBUTE);
                                    priority.setValue(filter.getType());
                                    attributes.setNamedItem(priority);
                                    Text pattern = document.createTextNode(filter.getPatternString());
                                    node.appendChild(pattern);
                                }
                                ++j2;
                            }
                        }
                        if (config.hasAttribute("ATTR_ENVIRONMENT_VARIABLES")) {
                            Map envVars = config.getAttribute("ATTR_ENVIRONMENT_VARIABLES", new HashMap());
                            Element envVarsRoot = document.createElement(ENV_VARS_ROOT);
                            attributes = envVarsRoot.getAttributes();
                            name = document.createAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES");
                            name.setValue(String.valueOf(config.getAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES", true)));
                            attributes.setNamedItem(name);
                            if (envVars != null) {
                                for (Object attrNameObj : envVars.keySet()) {
                                    Element node = document.createElement(ENV_VARS_NODE);
                                    envVarsRoot.appendChild(node);
                                    attributes = node.getAttributes();
                                    String attrName = (String)attrNameObj;
                                    String attrValue = (String)envVars.get(attrName);
                                    name = document.createAttribute(NAME_ATTRIBUTE);
                                    name.setValue(attrName);
                                    attributes.setNamedItem(name);
                                    Attr value = document.createAttribute(VALUE_ATTRIBUTE);
                                    value.setValue(attrValue);
                                    attributes.setNamedItem(value);
                                }
                            }
                            configNode.appendChild(envVarsRoot);
                        }
                    }
                }
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private boolean getBooleanValue(NamedNodeMap attributes, String attribute, boolean defaultValue) throws SAXException {
        Node enabledNode = attributes.getNamedItem(attribute);
        if (enabledNode == null) {
            return defaultValue;
        }
        if (enabledNode.getNodeValue().equals(Boolean.toString(true))) {
            return true;
        }
        if (enabledNode.getNodeValue().equals(Boolean.toString(false))) {
            return false;
        }
        throw new SAXException("ExternalBuilderReaderWriter.error.illegal_boolean_attribute");
    }

    private String getStringValue(NamedNodeMap attributes, String name, String defaultValue) {
        Node node = attributes.getNamedItem(name);
        return node == null ? defaultValue : node.getNodeValue();
    }
}

