/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import ro.amiq.dvt.externaltools.ExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ExternalToolsReaderWriter;
import ro.amiq.dvt.externaltools.ExternalToolsReference;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.settings.DVTSFiles;
import ro.amiq.dvt.startup.core.DVTLogger;

public class ExternalToolsStoreUtil {
    private static Map<IProject, List<IExternalToolsConfiguration>> fConfigurationsMap = new HashMap<IProject, List<IExternalToolsConfiguration>>();
    private static Map<String, ExternalToolsConfiguration> fCommonConfigurationsMap = new LinkedHashMap<String, ExternalToolsConfiguration>();

    public static void save(IProject project, List<IExternalToolsConfiguration> builderConfigsWorkingCopy) throws IOException {
        fConfigurationsMap.put(project, builderConfigsWorkingCopy);
        ExternalToolsStoreUtil.save(project);
    }

    public static void save(IProject project) throws IOException {
        ArrayList<IExternalToolsConfiguration> custom = new ArrayList<IExternalToolsConfiguration>();
        for (IExternalToolsConfiguration data : fConfigurationsMap.get(project)) {
            custom.add(data);
        }
        File file = ExternalToolsUtil.getPropertyFile(project);
        if (file == null) {
            return;
        }
        ExternalToolsReaderWriter writer = new ExternalToolsReaderWriter();
        writer.save(custom.toArray(new IExternalToolsConfiguration[custom.size()]), file);
    }

    private static void add(IProject project, IExternalToolsConfiguration configuration, boolean insert) {
        if (configuration == null) {
            return;
        }
        if (configuration instanceof ExternalToolsReference && !fCommonConfigurationsMap.containsKey(configuration.getName())) {
            return;
        }
        List<Object> configurations = null;
        if (!fConfigurationsMap.containsKey(project)) {
            configurations = new ArrayList();
            fConfigurationsMap.put(project, configurations);
        } else {
            configurations = fConfigurationsMap.get(project);
        }
        int i = 0;
        while (i < configurations.size()) {
            IExternalToolsConfiguration existing = (IExternalToolsConfiguration)configurations.get(i);
            if (existing.getName().equals(configuration.getName())) {
                configurations.set(i, configuration);
                return;
            }
            ++i;
        }
        if (insert) {
            configurations.add(0, configuration);
        } else {
            configurations.add(configuration);
        }
    }

    public static List<IExternalToolsConfiguration> getBuilderConfigurations(IProject project) {
        try {
            ExternalToolsStoreUtil.load(project);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return fConfigurationsMap.get(project);
    }

    public static void load(IProject project) throws IOException {
        HashSet<ExternalToolsConfiguration> referencedCommonConfigurations;
        block12: {
            File file;
            IExternalToolsConfiguration[] datas;
            ExternalToolsReaderWriter reader;
            block11: {
                reader = new ExternalToolsReaderWriter();
                datas = null;
                fCommonConfigurationsMap.clear();
                List files = DVTSFiles.EXTERNAL_BUILDERS.getAllFiles(true);
                if (files != null) {
                    for (File file2 : files) {
                        datas = reader.read(file2);
                        if (datas == null) continue;
                        IExternalToolsConfiguration[] iExternalToolsConfigurationArray = datas;
                        int n = datas.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IExternalToolsConfiguration data = iExternalToolsConfigurationArray[n2];
                            if (data instanceof ExternalToolsConfiguration) {
                                fCommonConfigurationsMap.put(data.getName(), (ExternalToolsConfiguration)data);
                            }
                            ++n2;
                        }
                    }
                }
                referencedCommonConfigurations = new HashSet<ExternalToolsConfiguration>();
                file = ExternalToolsUtil.getPropertyFile(project);
                if (file != null && file.exists()) break block11;
                fConfigurationsMap.put(project, new ArrayList());
                break block12;
            }
            datas = reader.read(file, fCommonConfigurationsMap);
            List<Object> configurations = null;
            if (!fConfigurationsMap.containsKey(project)) {
                configurations = new ArrayList();
                fConfigurationsMap.put(project, configurations);
            } else {
                configurations = fConfigurationsMap.get(project);
                configurations.clear();
            }
            int i = 0;
            while (i < datas.length) {
                block14: {
                    block13: {
                        if (!(datas[i] instanceof ExternalToolsReference)) break block13;
                        ExternalToolsConfiguration referencedConfiguration = fCommonConfigurationsMap.get(datas[i].getName());
                        if (referencedConfiguration == null) break block14;
                        referencedCommonConfigurations.add(referencedConfiguration);
                    }
                    ExternalToolsStoreUtil.add(project, datas[i], false);
                }
                ++i;
            }
        }
        for (ExternalToolsConfiguration commonConfiguration : fCommonConfigurationsMap.values()) {
            if (referencedCommonConfigurations.contains(commonConfiguration)) continue;
            ExternalToolsStoreUtil.add(project, new ExternalToolsReference(commonConfiguration), true);
        }
    }
}

