/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.IConsoleDocumentPartitioner;
import org.eclipse.ui.internal.console.ConsoleHyperlinkPosition;
import ro.amiq.dvt.externaltools.ExternalToolsMessageStyle;
import ro.amiq.dvt.externaltools.ExternalToolsPosition;

public class ExternalToolsStyleListener
implements LineStyleListener,
LineBackgroundListener {
    private IDocument fDocument;
    public static final String HYPER_LINK_CATEGORY = ConsoleHyperlinkPosition.HYPER_LINK_CATEGORY;

    public ExternalToolsStyleListener(IDocument document) {
        this.fDocument = document;
    }

    public void lineGetStyle(LineStyleEvent event) {
        IDocument document = this.getDocument();
        if (document != null && document.getLength() > 0) {
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>();
            int offset = event.lineOffset;
            int length = event.lineText.length();
            StyleRange[] partitionerStyles = null;
            IConsoleDocumentPartitioner documentPartitioner = (IConsoleDocumentPartitioner)document.getDocumentPartitioner();
            if (documentPartitioner != null) {
                partitionerStyles = documentPartitioner.getStyleRanges(event.lineOffset, event.lineText.length());
            }
            if (partitionerStyles != null) {
                int i = 0;
                while (i < partitionerStyles.length) {
                    ranges.add(partitionerStyles[i]);
                    ++i;
                }
            } else {
                ranges.add(new StyleRange(offset, length, null, null));
            }
            try {
                Position[] positions = this.getDocument().getPositions(HYPER_LINK_CATEGORY);
                Position[] overlap = this.findPosition(offset, length, positions);
                ExternalToolsMessageStyle messageStyle = null;
                if (overlap != null) {
                    int i = 0;
                    while (i < overlap.length) {
                        Position position = overlap[i];
                        StyleRange linkRange = new StyleRange(position.offset, position.length, null, null);
                        if (position instanceof ExternalToolsPosition) {
                            messageStyle = ((ExternalToolsPosition)position).getMessageStyle();
                            if (messageStyle.isBackground()) {
                                linkRange.background = messageStyle.getColor();
                            } else {
                                linkRange.foreground = messageStyle.getColor();
                            }
                            linkRange.borderStyle = messageStyle.getBorderStyle();
                            linkRange.fontStyle = messageStyle.getFontStyle();
                        } else {
                            linkRange.foreground = JFaceColors.getHyperlinkText((Display)Display.getCurrent());
                            linkRange.underline = true;
                        }
                        this.override(ranges, linkRange);
                        ++i;
                    }
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            if (!ranges.isEmpty()) {
                event.styles = ranges.toArray(new StyleRange[ranges.size()]);
            }
        }
    }

    private IDocument getDocument() {
        return this.fDocument;
    }

    private void override(List<StyleRange> ranges, StyleRange newRange) {
        if (ranges.isEmpty()) {
            ranges.add(newRange);
            return;
        }
        int start = newRange.start;
        int end = start + newRange.length;
        int i = 0;
        while (i < ranges.size()) {
            StyleRange existingRange = ranges.get(i);
            int rEnd = existingRange.start + existingRange.length;
            if (end > existingRange.start && start < rEnd) {
                if (start < existingRange.start && end > existingRange.start) {
                    start = existingRange.start;
                }
                if (start >= existingRange.start && end <= rEnd) {
                    existingRange.length = start - existingRange.start;
                    ranges.add(++i, newRange);
                    if (end != rEnd) {
                        ranges.add(++i, new StyleRange(end, rEnd - end - 1, existingRange.foreground, existingRange.background));
                    }
                    return;
                }
                if (start >= existingRange.start && start < rEnd) {
                    existingRange.length = start - existingRange.start;
                    ranges.add(++i, newRange);
                } else if (end >= rEnd) {
                    ranges.remove(i);
                } else {
                    ranges.add(++i, new StyleRange(end + 1, rEnd - end + 1, existingRange.foreground, existingRange.background));
                }
            }
            ++i;
        }
    }

    private Position[] findPosition(int offset, int length, Position[] positions) {
        if (positions.length == 0) {
            return null;
        }
        int rangeEnd = offset + length;
        int left = 0;
        int right = positions.length - 1;
        int mid = 0;
        Position position = null;
        while (left < right) {
            mid = (left + right) / 2;
            position = positions[mid];
            if (rangeEnd < position.getOffset()) {
                if (left == mid) {
                    right = left;
                    continue;
                }
                right = mid - 1;
                continue;
            }
            if (offset > position.getOffset() + position.getLength() - 1) {
                if (right == mid) {
                    left = right;
                    continue;
                }
                left = mid + 1;
                continue;
            }
            left = right = mid;
        }
        ArrayList<Position> list = new ArrayList<Position>();
        int index = left - 1;
        if (index >= 0) {
            position = positions[index];
            while (index >= 0 && position.getOffset() + position.getLength() > offset) {
                if (--index <= 0) continue;
                position = positions[index];
            }
        }
        position = positions[++index];
        while (index < positions.length && position.getOffset() < rangeEnd) {
            list.add(position);
            if (++index >= positions.length) continue;
            position = positions[index];
        }
        if (list.isEmpty()) {
            return null;
        }
        return list.toArray(new Position[list.size()]);
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        event.lineBackground = null;
    }
}

