/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Set;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.IBuildConfigParserConstants;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtilCommon;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.IExternalToolsDelegate;
import ro.amiq.dvt.externaltools.pattern.PatternStoreUtil;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.model.problems.DVTProblemCategories;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;
import ro.amiq.dvt.utils.DVTExceptionHandler;
import ro.amiq.dvt.utils.DVTProcessRunner;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUtilsCommon;

public class ExternalToolsUtil
extends ExternalToolsUtilCommon {
    public static final String VAR_DVT_CONFIG_LOC = "run_config_loc";
    private static final String BUILDERS_FILE_NAME_DEPRECATED = "builders";
    private static final String BUILDERS_FILE_NAME = "external_builders.xml";
    public static final boolean IS_WINDOWS;
    public static final String DISTRO_BUSYBOX;
    public static final List<String> KNOWN_SHELLS;
    private static volatile List<String> fAvailableShells;
    public static final String SESSION_TEST_ARG = "--test";
    public static final String SESSION_TERMINATE_ON_EXIT_ARG = "--terminate-on-exit";
    public static final String SESSION_USE_XTERM_SESSION_ARG = "--use-xterm-session";
    public static final String SESSION_REDIRECT_XTERM_OUT_ARG = "--redirect-xterm-out";
    public static final String SESSION_HOLD_XTERM_WINDOW_ARG = "--hold-xterm-window";
    public static final String RUNNER_SCRIPT_NAME = "dvt_launch_session.sh";
    public static final String RUNNER_SCRIPT_PATH = "/resources/scripts/dvt_launch_session.sh";
    public static final String LAUNCH_SCRIPTS_DIR = "/launch_scripts/";
    private static volatile boolean SESSION_SUPPORT_CHECKED;
    public static volatile boolean HAS_SESSION_SUPPORT;
    public static volatile boolean HAS_XTERM_SUPPORT;
    public static volatile boolean HAS_REDIRECT_SUPPORT;

    static {
        File distroBusyboxFile;
        IS_WINDOWS = Platform.getOS().equals("win32");
        String distroBusybox = null;
        String dvtHome = System.getenv("DVT_HOME");
        if (dvtHome != null && (distroBusyboxFile = new File(String.valueOf(dvtHome) + File.separatorChar + "bin" + File.separatorChar + "utils" + File.separatorChar + "busybox.exe")).exists()) {
            try {
                distroBusybox = distroBusyboxFile.getCanonicalPath();
            }
            catch (IOException iOException) {}
        }
        DISTRO_BUSYBOX = distroBusybox;
        KNOWN_SHELLS = Arrays.asList("sh", "bash", "csh", "tcsh", "zsh", "ksh");
        SESSION_SUPPORT_CHECKED = false;
        HAS_SESSION_SUPPORT = false;
        HAS_XTERM_SUPPORT = false;
        HAS_REDIRECT_SUPPORT = false;
    }

    public static IPath getWorkingDirectory(IExternalToolsConfiguration configuration) throws CoreException {
        String expandedLocation;
        String location = configuration.getWorkingDir();
        if (location != null && (expandedLocation = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(location)).length() > 0) {
            File path = new File(expandedLocation);
            if (path.isDirectory()) {
                return new Path(expandedLocation);
            }
            String msg = NLS.bind((String)ExternalToolsMessages.ExternalToolsUtil_invalidDirectory__0_, (Object[])new Object[]{expandedLocation, configuration.getName()});
            ExternalToolsUtil.abort(msg, null, 0);
        }
        return null;
    }

    public static void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", code, message, exception));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean defaultBuilderEnabled(IProject project, String builderID) {
        try {
            ICommand command;
            IProjectDescription desc = project.getDescription();
            ArrayList<ICommand> commands = new ArrayList<ICommand>(Arrays.asList(desc.getBuildSpec()));
            Iterator i = commands.iterator();
            do {
                if (i.hasNext()) continue;
                return false;
            } while (!(command = (ICommand)i.next()).getBuilderName().equals(builderID));
            return true;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static ExternalToolsPattern findUserDefPattern(String name, IExternalToolsConfiguration config) {
        ExternalToolsPattern[] allPatterns = config.getPatterns();
        if (allPatterns == null) {
            return null;
        }
        ExternalToolsPattern[] externalToolsPatternArray = allPatterns;
        int n = allPatterns.length;
        int n2 = 0;
        while (n2 < n) {
            ExternalToolsPattern pattern = externalToolsPatternArray[n2];
            if (pattern.getName().equals(name)) {
                return pattern;
            }
            ++n2;
        }
        return null;
    }

    public static String getPathToPropertyFile(IProject project, String fileName, boolean withPrefix) {
        try {
            return String.valueOf(project.getLocation().toOSString()) + '/' + ".dvt" + '/' + (withPrefix ? ".dvt_" : "") + fileName;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }

    public static File getPropertyFile(IProject project) {
        String path = ExternalToolsUtil.getPathToPropertyFile(project, BUILDERS_FILE_NAME, false);
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            String deprecatedPath = ExternalToolsUtil.getPathToPropertyFile(project, BUILDERS_FILE_NAME_DEPRECATED, true);
            if (deprecatedPath == null) {
                return null;
            }
            File deprecatedFile = new File(deprecatedPath);
            if (deprecatedFile.exists()) {
                return deprecatedFile;
            }
        }
        return file;
    }

    public static List<ExternalToolsPattern> getPatterns(IExternalToolsConfiguration config) {
        ArrayList<ExternalToolsPattern> listPatterns = new ArrayList<ExternalToolsPattern>();
        if (config != null) {
            String[] filterKinds;
            String[] stringArray = filterKinds = config.getFilterKinds();
            int n = filterKinds.length;
            int n2 = 0;
            while (n2 < n) {
                String category = stringArray[n2];
                listPatterns.addAll(ExternalToolsUtil.getCategoryPatterns(category));
                ++n2;
            }
            ExternalToolsPattern[] patterns = config.getPatterns();
            if (patterns == null) {
                return listPatterns;
            }
            ExternalToolsPattern[] externalToolsPatternArray = patterns;
            int n3 = patterns.length;
            n = 0;
            while (n < n3) {
                ExternalToolsPattern pattern = externalToolsPatternArray[n];
                listPatterns.add(pattern);
                ++n;
            }
        }
        return listPatterns;
    }

    public static List<ExternalToolsPattern> getCategoryPatterns(String filterCtg) {
        ArrayList<ExternalToolsPattern> listCategoryPatterns = new ArrayList<ExternalToolsPattern>();
        try {
            PatternStoreUtil.load();
        }
        catch (IOException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        List<ExternalToolsPattern> listPatterns = PatternStoreUtil.getPatterns();
        int i = 0;
        while (i < listPatterns.size()) {
            ExternalToolsPattern pattern = listPatterns.get(i);
            if (pattern.getKind().equals(filterCtg)) {
                listCategoryPatterns.add(pattern);
            }
            ++i;
        }
        return listCategoryPatterns;
    }

    public static String[] getFilterCategories() {
        return PrefConst.FILTER_TYPES;
    }

    public static ExternalToolsPattern findPredefPattern(String namePat) {
        ArrayList<ExternalToolsPattern> allPatterns = new ArrayList<ExternalToolsPattern>();
        String[] fltCtgs = PrefConst.FILTER_TYPES;
        int i = 0;
        while (i < fltCtgs.length) {
            List<ExternalToolsPattern> ctgPatterns = ExternalToolsUtil.getCategoryPatterns(fltCtgs[i]);
            allPatterns.addAll(ctgPatterns);
            ++i;
        }
        i = 0;
        while (i < allPatterns.size()) {
            ExternalToolsPattern pattern = (ExternalToolsPattern)allPatterns.get(i);
            if (pattern.getName().equals(namePat)) {
                return pattern;
            }
            ++i;
        }
        return null;
    }

    public static List<ExternalToolsPattern> getEnabledPatterns(List<ExternalToolsPattern> patterns) {
        ArrayList<ExternalToolsPattern> enabledPatterns = new ArrayList<ExternalToolsPattern>();
        int i = 0;
        while (i < patterns.size()) {
            ExternalToolsPattern pattern = patterns.get(i);
            if (pattern.getEnabled()) {
                enabledPatterns.add(pattern);
            }
            ++i;
        }
        return enabledPatterns;
    }

    public static boolean isUserDefined(ExternalToolsPattern d) {
        String[] categories = PrefConst.FILTER_TYPES;
        int i = 0;
        while (i < categories.length) {
            if (categories[i].equals(d.getKind())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static String[] getCommandLine(IProject project, IExternalToolsConfiguration config, int kind) {
        String args = null;
        if (kind == 6) {
            args = config.getFullCommand();
        } else if (kind == 10 || kind == 9) {
            args = config.getAutoCommand();
        } else if (kind == 15) {
            args = config.getCleanCommand();
        }
        if (args != null) {
            try {
                String expanded = ExternalToolsUtil.getStringVariableManager().performStringSubstitution(args);
                return ExternalToolsUtil.parseStringIntoList(expanded);
            }
            catch (Exception ex) {
                if (!(ex instanceof OperationCanceledException)) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            CoreException e = new CoreException((IStatus)new Status(4, "ro.amiq.dvt", 150, ex.getMessage(), null));
                            DVTExceptionHandler.handle(e, "", "DVT External Builder Error");
                        }
                    });
                }
                return null;
            }
        }
        return null;
    }

    public static String commandToString(String[] commands) {
        String result = "";
        if (commands == null) {
            return result;
        }
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            result = String.valueOf(result) + " '" + command + "'";
            ++n2;
        }
        return result;
    }

    public static void setVariables(IProject project, ILaunchConfiguration config, boolean setProjectVariables) {
        try {
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            ArrayList<IValueVariable> variables = new ArrayList<IValueVariable>();
            if (config != null && config.getLocation() != null) {
                IValueVariable configLocVar = varManager.newValueVariable(VAR_DVT_CONFIG_LOC, "");
                configLocVar.setValue(config.getLocation().toOSString());
                variables.add(configLocVar);
            }
            if (setProjectVariables) {
                IValueVariable projectLocVar = varManager.newValueVariable("project_loc", "");
                projectLocVar.setValue(project.getLocation().toOSString());
                variables.add(projectLocVar);
                IValueVariable projectNameVar = varManager.newValueVariable("project_name", "");
                projectNameVar.setValue(project.getName());
                variables.add(projectNameVar);
            }
            java.nio.file.Path dvtDataPath = IBuildConfigParserConstants.getDVTDataPath(project);
            IValueVariable dvtDataVar = varManager.newValueVariable("DVT_DATA", "");
            dvtDataVar.setValue(dvtDataPath.toString());
            variables.add(dvtDataVar);
            IValueVariable[] variablesArr = variables.toArray(new IValueVariable[variables.size()]);
            varManager.removeVariables(variablesArr);
            varManager.addVariables(variablesArr);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void removeVariables() {
        try {
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            ArrayList<IValueVariable> variables = new ArrayList<IValueVariable>();
            variables.add(varManager.newValueVariable("project_loc", ""));
            variables.add(varManager.newValueVariable("project_name", ""));
            variables.add(varManager.newValueVariable(VAR_DVT_CONFIG_LOC, ""));
            varManager.removeVariables(variables.toArray(new IValueVariable[variables.size()]));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static IFile delegateResolveResource(IProject project, String fileName) {
        block9: {
            if (project != null && project.isOpen()) break block9;
            return null;
        }
        try {
            IFile file;
            IExternalToolsDelegate delegate;
            if (project.hasNature("ro.amiq.edt.enature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.edtKind")) != null && (file = delegate.getResource(project, fileName)) != null) {
                return file;
            }
            if (project.hasNature("ro.amiq.slndt.slnnature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.slndtKind")) != null && (file = delegate.getResource(project, fileName)) != null) {
                return file;
            }
            if (project.hasNature("ro.amiq.msdldt.msdlnature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.msdldtKind")) != null && (file = delegate.getResource(project, fileName)) != null) {
                return file;
            }
            if (project.hasNature("ro.amiq.pssdt.pssnature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.pssdtKind")) != null && (file = delegate.getResource(project, fileName)) != null) {
                return file;
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.vlogdtKind")) != null && (file = delegate.getResource(project, fileName)) != null) {
                return file;
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.vhdldtKind")) != null && (file = delegate.getResource(project, fileName)) != null) {
                return file;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public static boolean delegateHasRelevantContentType(IFile file) {
        IExternalToolsDelegate delegate;
        IProject project;
        block16: {
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    if (file != null) break block10;
                                    return false;
                                }
                                project = file.getProject();
                                if (project != null && project.isOpen()) break block11;
                                return false;
                            }
                            if (!project.hasNature("ro.amiq.edt.enature") || (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.edtKind")) == null || !delegate.hasRelevantContentType(file.getName())) break block12;
                            return true;
                        }
                        if (!project.hasNature("ro.amiq.slndt.slnnature") || (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.slndtKind")) == null || !delegate.hasRelevantContentType(file.getName())) break block13;
                        return true;
                    }
                    if (!project.hasNature("ro.amiq.msdldt.msdlnature") || (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.msdldtKind")) == null || !delegate.hasRelevantContentType(file.getName())) break block14;
                    return true;
                }
                if (!project.hasNature("ro.amiq.pssdt.pssnature") || (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.pssdtKind")) == null || !delegate.hasRelevantContentType(file.getName())) break block15;
                return true;
            }
            if (!project.hasNature("ro.amiq.vlogdt.VlogNature") || (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.vlogdtKind")) == null || !delegate.hasRelevantContentType(file.getName())) break block16;
            return true;
        }
        try {
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.vhdldtKind")) != null && delegate.hasRelevantContentType(file.getName())) {
                return true;
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return false;
    }

    public static void delegateOpenEditor(IProject project, String workingDirectory, String fileName, int line) {
        try {
            IExternalToolsDelegate delegate;
            if (project == null || !project.isOpen()) {
                return;
            }
            if (project.hasNature("ro.amiq.edt.enature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.edtKind")) != null) {
                delegate.openEditor(project, workingDirectory, fileName, line);
            }
            if (project.hasNature("ro.amiq.slndt.slnnature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.slndtKind")) != null) {
                delegate.openEditor(project, workingDirectory, fileName, line);
            }
            if (project.hasNature("ro.amiq.msdldt.msdlnature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.msdldtKind")) != null) {
                delegate.openEditor(project, workingDirectory, fileName, line);
            }
            if (project.hasNature("ro.amiq.pssdt.pssnature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.pssdtKind")) != null) {
                delegate.openEditor(project, workingDirectory, fileName, line);
            }
            if (project.hasNature("ro.amiq.vlogdt.VlogNature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.vlogdtKind")) != null) {
                delegate.openEditor(project, workingDirectory, fileName, line);
            }
            if (project.hasNature("ro.amiq.vhdldt.VhdlNature") && (delegate = ExternalToolsModelManager.getInstance().getExternalToolDelegate(project, "ro.amiq.dvt.vhdldtKind")) != null) {
                delegate.openEditor(project, workingDirectory, fileName, line);
            }
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void clean(IResource resource, String builderName) {
        try {
            ExternalToolsUtil.deleteMarkers(resource, DVTProblemCategories.EXTERNALTOOLS.getMarkerId(), true, 2, builderName);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void deleteMarkers(IResource resource, String type, boolean includeSubtypes, int depth, List<String> builderNames) {
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = resource.findMarkers(type, includeSubtypes, depth);
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker = iMarkerArray[n2];
                String builderName = marker.getAttribute("MarkerBuilderName", null);
                if (builderName != null && builderNames.contains(builderName)) {
                    marker.delete();
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void deleteMarkers(IResource resource, String type, boolean includeSubtypes, int depth, String builderName) {
        try {
            if (builderName == null) {
                resource.deleteMarkers(type, includeSubtypes, depth);
            } else {
                IMarker[] markers;
                IMarker[] iMarkerArray = markers = resource.findMarkers(type, includeSubtypes, depth);
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    String markerName = marker.getAttribute("MarkerBuilderName", null);
                    if (markerName != null && markerName.equals(builderName)) {
                        marker.delete();
                    }
                    ++n2;
                }
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public static void clean(IProject project, List<IExternalToolsConfiguration> newConfigs, List<IExternalToolsConfiguration> oldConfigs) {
        if (newConfigs == null) {
            if (oldConfigs == null) {
                return;
            }
            for (IExternalToolsConfiguration oldConfig : oldConfigs) {
                if (!oldConfig.getEnable()) continue;
                ExternalToolsUtil.clean((IResource)project, oldConfig.getName());
            }
        } else {
            for (IExternalToolsConfiguration oldConfig : oldConfigs) {
                boolean cleanBuilder = true;
                for (IExternalToolsConfiguration newConfig : newConfigs) {
                    if (!oldConfig.getEnable() || !newConfig.getEnable() || !oldConfig.getName().equals(newConfig.getName())) continue;
                    cleanBuilder = false;
                    break;
                }
                if (!cleanBuilder) continue;
                ExternalToolsUtil.clean((IResource)project, oldConfig.getName());
            }
        }
    }

    public static String getShell() {
        String shell = null;
        if (IS_WINDOWS) {
            shell = "cmd";
        } else {
            shell = System.getenv("SHELL");
            if (shell == null) {
                shell = "sh";
            } else {
                for (String knownShell : KNOWN_SHELLS) {
                    if (!new File(shell).getName().equals(knownShell)) continue;
                    return shell;
                }
                shell = "sh";
            }
        }
        return shell;
    }

    public static String getShellDefaultCommand(boolean isHashExclam) {
        String shell = ExternalToolsUtil.getShell();
        if (isHashExclam) {
            if (!shell.startsWith("/")) {
                shell = "/bin/" + shell;
            }
            if (!shell.endsWith("csh")) {
                shell = String.valueOf(shell) + " -i";
            }
        } else {
            shell = !shell.endsWith("csh") ? String.valueOf(shell) + " -ic" : String.valueOf(shell) + " -c";
        }
        return shell;
    }

    public static synchronized List<String> getSystemShells() {
        if (fAvailableShells != null) {
            return fAvailableShells;
        }
        fAvailableShells = new ArrayList<String>();
        if (IS_WINDOWS) {
            fAvailableShells.add("cmd.exe");
        } else {
            String preferredShell = System.getenv("SHELL");
            if (preferredShell == null) {
                preferredShell = "/bin/sh";
            }
            if (new File(preferredShell).exists()) {
                fAvailableShells.add(preferredShell);
            }
            try {
                Throwable throwable = null;
                Object var2_3 = null;
                try (Scanner scanner = new Scanner(new File("/etc/shells"));){
                    while (scanner.hasNext()) {
                        String shell = scanner.next();
                        if (shell.trim().startsWith("#") || !KNOWN_SHELLS.contains(shell.replaceFirst("^.*/", "")) || !new File(shell).exists()) continue;
                        fAvailableShells.add(shell);
                    }
                    scanner.close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        if (fAvailableShells.isEmpty()) {
            DVTLogger.INSTANCE.logError("We cannot locate any system shell.");
        }
        return fAvailableShells;
    }

    public static List<String> getEnvironment(IProject project, Object configEnv, Object append) throws CoreException {
        if (!(configEnv instanceof Map)) {
            return ExternalToolsUtil.makeEnv(BuildConfigManager.getenv(project));
        }
        Map configEnvMap = (Map)configEnv;
        boolean appendBoolean = true;
        if (append instanceof Boolean) {
            appendBoolean = (Boolean)append;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        if (appendBoolean) {
            env.putAll(BuildConfigManager.getenv(project));
        }
        Iterator iter = configEnvMap.entrySet().iterator();
        Map.Entry entry = null;
        String key = null;
        String value = null;
        Object nativeValue = null;
        Iterator envIter = null;
        Object var12_12 = null;
        String nativeKey = null;
        while (iter.hasNext()) {
            entry = iter.next();
            key = (String)entry.getKey();
            value = (String)entry.getValue();
            if (value != null) {
                value = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(value);
            }
            boolean added = false;
            if (IS_WINDOWS) {
                nativeValue = env.get(key);
                if (nativeValue != null) {
                    env.put(key, value);
                } else {
                    for (Map.Entry entry2 : env.entrySet()) {
                        nativeKey = (String)entry2.getKey();
                        if (!nativeKey.equalsIgnoreCase(key)) continue;
                        entry2.setValue(value);
                        added = true;
                        break;
                    }
                }
            }
            if (added) continue;
            env.put(key, value);
        }
        return ExternalToolsUtil.makeEnv(env);
    }

    public static List<String> makeEnv(Map<String, String> env) {
        Iterator<Map.Entry<String, String>> iter = env.entrySet().iterator();
        ArrayList<String> strings = new ArrayList<String>(env.size());
        StringBuilder buffer = null;
        while (iter.hasNext()) {
            Map.Entry<String, String> entry = iter.next();
            buffer = new StringBuilder(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        return strings;
    }

    public static void checkSessionSupport() {
        if (SESSION_SUPPORT_CHECKED) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (SESSION_SUPPORT_CHECKED) {
                    return;
                }
                SESSION_SUPPORT_CHECKED = true;
                String script = ExternalToolsUtil.createRunnerScript();
                if (script == null) {
                    return;
                }
                DVTProcessRunner processRunner = new DVTProcessRunner(script, ExternalToolsUtil.SESSION_TEST_ARG);
                try {
                    processRunner.run(null);
                }
                catch (IOException iOException) {
                    return;
                }
                String output = processRunner.getStandardOutput();
                if (output != null && !output.isEmpty()) {
                    String[] splitOutput = output.split("\\s+");
                    boolean hasBasicSpport = false;
                    String[] stringArray = splitOutput;
                    int n = splitOutput.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String line = stringArray[n2];
                        if (line.equals("basic")) {
                            hasBasicSpport = true;
                        } else if (line.equals("session")) {
                            HAS_SESSION_SUPPORT = true;
                        } else if (line.equals("xterm")) {
                            HAS_XTERM_SUPPORT = true;
                        } else if (line.equals("redirect")) {
                            HAS_REDIRECT_SUPPORT = true;
                        }
                        ++n2;
                    }
                    if (!hasBasicSpport) {
                        HAS_SESSION_SUPPORT = false;
                        HAS_XTERM_SUPPORT = false;
                        HAS_REDIRECT_SUPPORT = false;
                    }
                }
            }
        }, "External Tools Session Support Check").start();
    }

    private static String createLaunchScriptsArea() {
        IPath launchScriptsPath = DVTPlugin.getDefault().getStateLocation().append(LAUNCH_SCRIPTS_DIR);
        File launchScriptsDir = launchScriptsPath.toFile();
        if (launchScriptsDir.exists()) {
            if (!launchScriptsDir.isDirectory()) {
                DVTLogger.INSTANCE.logError("Can't create " + launchScriptsDir.getAbsolutePath() + " it already exists as a file!");
                return null;
            }
            if (!launchScriptsDir.canWrite() && !launchScriptsDir.setWritable(true)) {
                DVTLogger.INSTANCE.logError("Can't make writable " + launchScriptsDir.getAbsolutePath() + "!");
                return null;
            }
            if (!launchScriptsDir.canExecute() && !launchScriptsDir.setExecutable(true)) {
                DVTLogger.INSTANCE.logError("Can't make executable " + launchScriptsDir.getAbsolutePath() + "!");
                return null;
            }
        } else {
            launchScriptsDir.mkdir();
        }
        return launchScriptsDir.getAbsolutePath();
    }

    public static String createRunnerScript() {
        String runnersScriptPath;
        block14: {
            runnersScriptPath = null;
            BufferedInputStream runnerScriptFileStream = null;
            BufferedWriter runnerScriptWriter = null;
            InputStream pluginScriptStream = null;
            boolean shouldCreateRunnerScript = false;
            try {
                try {
                    URL pluginScriptURL = DVTPlugin.getDefault().getBundle().getEntry(RUNNER_SCRIPT_PATH);
                    if (pluginScriptURL != null) {
                        pluginScriptStream = pluginScriptURL.openStream();
                        String pluginScriptContent = DVTStringUtil.streamToString(pluginScriptStream);
                        String runnerScriptDir = ExternalToolsUtil.createLaunchScriptsArea();
                        if (runnerScriptDir != null) {
                            File runnerScriptFile = new File(runnerScriptDir, RUNNER_SCRIPT_NAME);
                            if (runnerScriptFile.exists()) {
                                runnerScriptFileStream = new BufferedInputStream(new FileInputStream(runnerScriptFile));
                                String runnerScriptContent = DVTStringUtil.streamToString(runnerScriptFileStream);
                                if (!Arrays.equals(DVTStringUtil.md5sum(runnerScriptContent), DVTStringUtil.md5sum(pluginScriptContent))) {
                                    shouldCreateRunnerScript = true;
                                }
                            } else {
                                shouldCreateRunnerScript = true;
                            }
                            if (shouldCreateRunnerScript) {
                                runnerScriptWriter = new BufferedWriter(new FileWriter(runnerScriptFile));
                                runnerScriptWriter.write(pluginScriptContent);
                                ((Writer)runnerScriptWriter).flush();
                            }
                            if (!runnerScriptFile.canExecute()) {
                                runnerScriptFile.setExecutable(true);
                            }
                            runnersScriptPath = runnerScriptFile.getAbsolutePath();
                        } else {
                            runnersScriptPath = null;
                        }
                    } else {
                        DVTLogger.INSTANCE.logError("Can't find dvt_launch_session.sh in plugin!");
                        runnersScriptPath = null;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    runnersScriptPath = null;
                    DVTUtilsCommon.INSTANCE.closeClosable(pluginScriptStream);
                    DVTUtilsCommon.INSTANCE.closeClosable(runnerScriptFileStream);
                    DVTUtilsCommon.INSTANCE.closeClosable(runnerScriptWriter);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                DVTUtilsCommon.INSTANCE.closeClosable(pluginScriptStream);
                DVTUtilsCommon.INSTANCE.closeClosable(runnerScriptFileStream);
                DVTUtilsCommon.INSTANCE.closeClosable(runnerScriptWriter);
                throw throwable;
            }
            DVTUtilsCommon.INSTANCE.closeClosable(pluginScriptStream);
            DVTUtilsCommon.INSTANCE.closeClosable(runnerScriptFileStream);
            DVTUtilsCommon.INSTANCE.closeClosable(runnerScriptWriter);
        }
        return runnersScriptPath;
    }

    public static String createScript(String name, String content) {
        String scriptPath;
        block12: {
            scriptPath = null;
            BufferedWriter scriptWriter = null;
            boolean shouldCreateScript = false;
            try {
                try {
                    String scriptDir = ExternalToolsUtil.createLaunchScriptsArea();
                    if (scriptDir != null) {
                        String scriptName = String.valueOf(name) + "." + DVTStringUtil.bytes2hex(DVTStringUtil.md5sum(content)) + "." + System.currentTimeMillis();
                        File scriptFile = new File(scriptDir, String.valueOf(scriptName) + (IS_WINDOWS ? ".bat" : ".sh"));
                        if (scriptFile.exists()) {
                            scriptFile = new File(scriptDir, String.valueOf(scriptName = String.valueOf(scriptName) + "." + Long.toHexString(new Random(System.currentTimeMillis()).nextLong())) + (IS_WINDOWS ? ".bat" : ".sh"));
                            if (scriptFile.exists()) {
                                DVTLogger.INSTANCE.logError("Can't find an unique name for the script!");
                            } else {
                                shouldCreateScript = true;
                            }
                        } else {
                            shouldCreateScript = true;
                        }
                        if (shouldCreateScript) {
                            scriptWriter = new BufferedWriter(new FileWriter(scriptFile));
                            scriptWriter.write(content);
                            scriptWriter.write(System.getProperty("line.separator"));
                            ((Writer)scriptWriter).flush();
                        }
                        if (!scriptFile.canExecute()) {
                            scriptFile.setExecutable(true);
                        }
                        scriptPath = scriptFile.getAbsolutePath();
                        break block12;
                    }
                    scriptPath = null;
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                    scriptPath = null;
                    DVTUtilsCommon.INSTANCE.closeClosable(scriptWriter);
                }
            }
            finally {
                DVTUtilsCommon.INSTANCE.closeClosable(scriptWriter);
            }
        }
        return scriptPath;
    }

    public static String[] prependArguments(String[] originalCommand, ArrayList<String> newArguments) {
        if (newArguments == null || newArguments.isEmpty()) {
            return originalCommand;
        }
        ArrayList<String> commandList = new ArrayList<String>(newArguments);
        commandList.addAll(Arrays.asList(originalCommand));
        return commandList.toArray(new String[commandList.size()]);
    }

    public static String silentGetDynamicVariable(String variable) {
        try {
            IStringVariableManager varManager = VariablesPlugin.getDefault().getStringVariableManager();
            IDynamicVariable dynamicVariable = varManager.getDynamicVariable(variable);
            return dynamicVariable.getValue(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void addCustomEnv(List<String> envpForProcess, IProject project) {
        Set<String> svpExtensions = BuildConfigManager.getSvp2SvExtMap(project).getSvpExtensions();
        if (!svpExtensions.isEmpty()) {
            envpForProcess.add("DVT_PVERILOG_EXTENSIONS=" + DVTStringUtil.join(svpExtensions, " "));
        }
        List<String> varNames = Arrays.asList("selected_resource_loc", "selected_resource_path", "project_name", "project_loc", "workspace_loc");
        for (String varName : varNames) {
            String varValue = ExternalToolsUtil.silentGetDynamicVariable(varName);
            if (varValue == null) continue;
            envpForProcess.add("DVT_" + varName.toUpperCase() + "=" + varValue);
        }
    }
}

