/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.startup.core.DVTUiUtils;

public class SelectedResourceLine
implements IDynamicVariableResolver {
    private static final String ERROR_PREFIX = "Cannot resolve DVT Run Configuration variable ${selected_resource_line}: ";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        try {
            return this.internalResolveValue();
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", ERROR_PREFIX + e.getMessage()));
        }
    }

    public String internalResolveValue() throws Exception {
        IWorkbenchPage activePage = DVTUiUtils.getActivePage();
        if (activePage == null) {
            throw new Exception("internal error (null active page).");
        }
        IEditorPart activeEditorPart = activePage.getActiveEditor();
        if (activeEditorPart == null) {
            throw new Exception("no open text editor.");
        }
        if (!(activeEditorPart instanceof EditorPart)) {
            throw new Exception("unsupported text editor type.");
        }
        ITextEditor activeEditor = null;
        if (activeEditorPart instanceof ITextEditor) {
            activeEditor = (ITextEditor)activeEditorPart;
        } else if (activeEditorPart instanceof MultiPageEditorPart) {
            activeEditor = (ITextEditor)this.getSelectedPage(activeEditorPart);
        }
        if (activeEditor == null) {
            throw new Exception("unsupported text editor type.");
        }
        int lineNumber = this.getCursorLineNumber(activeEditor);
        if (lineNumber == -1) {
            throw new Exception("internal error (invalid line number).");
        }
        return String.valueOf(lineNumber);
    }

    private Object getSelectedPage(IEditorPart activeEditorPart) throws Exception {
        AtomicReference result = new AtomicReference();
        Runnable r = () -> {
            try {
                Object page = ((MultiPageEditorPart)activeEditorPart).getSelectedPage();
                if (page instanceof ITextEditor) {
                    result.set((ITextEditor)page);
                }
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                result.set(null);
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(r);
        }
        return result.get();
    }

    private int getCursorLineNumber(ITextEditor editor) {
        AtomicInteger result = new AtomicInteger(Integer.MAX_VALUE);
        Runnable r = () -> {
            try {
                IDocumentProvider provider = editor.getDocumentProvider();
                if (provider == null) {
                    result.set(-1);
                    return;
                }
                IDocument document = provider.getDocument((Object)editor.getEditorInput());
                if (document == null) {
                    result.set(-1);
                    return;
                }
                IWorkbenchPartSite editorSite = editor.getSite();
                if (editorSite == null) {
                    result.set(-1);
                    return;
                }
                ISelectionProvider selectionProvider = editorSite.getSelectionProvider();
                if (selectionProvider == null) {
                    result.set(-1);
                    return;
                }
                ISelection selection = selectionProvider.getSelection();
                if (!(selection instanceof ITextSelection)) {
                    result.set(-1);
                    return;
                }
                result.set(document.getLineOfOffset(((ITextSelection)selection).getOffset()) + 1);
            }
            catch (Exception e) {
                DVTLogger.INSTANCE.logError((Throwable)e);
                result.set(-1);
            }
        };
        if (Display.getCurrent() != null) {
            r.run();
        } else {
            DVTUiUtils.getActiveWorkbenchShell().getDisplay().syncExec(r);
        }
        return result.get();
    }
}

