/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.compilescript;

import antlr.Token;
import freemarker.core.ParseException;
import freemarker.template.TemplateException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import ro.amiq.dvt.buildconfig.BuildConfigLexer;
import ro.amiq.dvt.buildconfig.BuildConfigManager;
import ro.amiq.dvt.buildconfig.BuildConfigParser;
import ro.amiq.dvt.buildconfig.IBuildConfigLexerListener;
import ro.amiq.dvt.buildconfig.Invocation;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.externaltools.DVTProjectEnhancedDynamicVariableResolver;
import ro.amiq.dvt.externaltools.ExternalToolsBuilder;
import ro.amiq.dvt.externaltools.compilescript.CompileInvocation;
import ro.amiq.dvt.externaltools.compilescript.CompileModel;
import ro.amiq.dvt.externaltools.compilescript.CompileScriptGenerator;
import ro.amiq.dvt.externaltools.compilescript.FreemarkerConsoleViewer;
import ro.amiq.dvt.model.problems.DVTProblem;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTFileUtils;
import ro.amiq.dvt.utils.parser.IDVTFileInstance;

public class DVTCompileScriptVariableResolver
extends DVTProjectEnhancedDynamicVariableResolver
implements IBuildConfigLexerListener {
    private static final String DVT_COMPILE_SCRIPT = "dvt_compile_script";
    private static final String ERROR_PREFIX = "Cannot resolve ${dvt_compile_script}: ";

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        try {
            return this.internalResolveValue(argument);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", ERROR_PREFIX + e.getMessage()));
        }
    }

    public String internalResolveValue(String argument) throws Exception {
        File scriptFile;
        File scriptParentFile;
        File templateFile;
        IProject project = this.getProject();
        if (project == null) {
            throw new Exception("unable to infer project.");
        }
        if (!project.isAccessible() || project.getLocation() == null) {
            throw new Exception("project '" + project.getName() + "' is not accessible.");
        }
        List<Invocation> allInvocations = BuildConfigManager.getInvocations(project);
        if (allInvocations == null || allInvocations.isEmpty()) {
            throw new Exception("project '" + project.getName() + "' has not been built by DVT (no invocations).");
        }
        int indexOfColon = argument.indexOf(":");
        if (indexOfColon == -1) {
            throw new Exception("argument should be <template_location>:<script_location>");
        }
        String templatePathString = argument.substring(0, indexOfColon);
        IPath templateIPath = Path.fromOSString((String)templatePathString);
        if (!templateIPath.isAbsolute()) {
            templateIPath = project.getLocation().append(templateIPath);
        }
        if (!(templateFile = templateIPath.toFile()).exists()) {
            throw new Exception("template file " + templateFile.getAbsolutePath() + " does not exist.");
        }
        String scriptPathString = argument.substring(indexOfColon + 1);
        IPath scriptIPath = Path.fromOSString((String)scriptPathString);
        if (!scriptIPath.isAbsolute()) {
            scriptIPath = project.getLocation().append(scriptIPath);
        }
        if (!(scriptParentFile = (scriptFile = scriptIPath.toFile()).getParentFile()).exists()) {
            throw new Exception("script file parent " + scriptParentFile.getAbsolutePath() + " does not exist.");
        }
        if (!scriptParentFile.canWrite()) {
            throw new Exception("script file parent " + scriptParentFile.getAbsolutePath() + " is not writable.");
        }
        CompileModel compileModel = new CompileModel();
        List<Invocation> relevantInvocations = allInvocations;
        if (ExternalToolsBuilder.fIncrementalFile != null) {
            relevantInvocations = this.computeRelevantInvocations(allInvocations, project, ExternalToolsBuilder.fIncrementalFile);
            compileModel.setIncremental(true);
            compileModel.setIncrementalFile(ExternalToolsBuilder.fIncrementalFile.getLocation().toOSString());
        }
        IPath activeBuildConfigPath = BuildConfigManager.getActiveBuildConfigIFile(project).getLocation();
        for (Invocation invocation : relevantInvocations) {
            BuildConfigParser.InvocationState invocationState = invocation.getState();
            IPath startFilePath = this.getPath(project, invocationState.fStartFile);
            if (!activeBuildConfigPath.equals((Object)startFilePath)) {
                throw new Exception(" invocation #" + invocation.getIndex() + " starts outside active buid configuration file:\n" + activeBuildConfigPath.toOSString() + "\n(line #" + invocationState.fStartLine + " in " + invocationState.fStartFile + ")");
            }
            IPath endFilePath = this.getPath(project, invocationState.fEndFile);
            if (!activeBuildConfigPath.equals((Object)endFilePath)) {
                throw new Exception(" invocation #" + invocation.getIndex() + " ends outside active buid configuration file:\n" + activeBuildConfigPath.toOSString() + "\n(line #" + invocationState.fEndLine + " in " + invocationState.fEndFile + ")");
            }
            CompileInvocation compileInvocation = new CompileInvocation(invocation);
            compileInvocation.setToolCompat(invocation.getState().fToolCompat);
            compileInvocation.setCompilationRoot(invocation.getState().fCompilationRoot);
            compileInvocation.setDirectives(this.getDirectives(invocationState, activeBuildConfigPath.toOSString()));
            compileInvocation.setEnvMap(this.getEnvMap(invocationState.fDVTDefinedEnvVariablesMap));
            compileModel.addInvocation(compileInvocation);
        }
        String content = null;
        try {
            content = CompileScriptGenerator.INSTANCE.getContent(templateFile, compileModel);
        }
        catch (ParseException | TemplateException e) {
            FreemarkerConsoleViewer.INSTANCE.print(e.getMessage(), this.getProject());
            throw e;
        }
        if (content == null) {
            return "";
        }
        DVTFileUtils.getInstance().writeStringToFile(scriptFile, content, false);
        if (!scriptFile.setExecutable(true)) {
            throw new Exception("Unable to make result script executable: " + scriptFile.getAbsolutePath());
        }
        return scriptFile.getAbsolutePath();
    }

    private IPath getPath(IProject project, String file) {
        IPath filePath = Path.fromOSString((String)file);
        if (!filePath.isAbsolute()) {
            filePath = project.getLocation().append(filePath);
        }
        return filePath;
    }

    private Map<String, String> getEnvMap(Map<String, BuildConfigParser.Definition> dvtDefinedEnvVariablesMap) {
        HashMap<String, String> result = new HashMap<String, String>();
        dvtDefinedEnvVariablesMap.entrySet().forEach(e -> result.put((String)e.getKey(), ((BuildConfigParser.Definition)e.getValue()).value));
        return result;
    }

    private List<String> getDirectives(BuildConfigParser.InvocationState invocationState, String activeBuildConfig) throws Exception {
        ArrayList<String> result = new ArrayList<String>();
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(activeBuildConfig));){
            if (((InputStream)fis).skip(invocationState.fStartOffset) != (long)invocationState.fStartOffset) {
                return result;
            }
            int length = invocationState.fEndOffset - invocationState.fStartOffset;
            byte[] content = new byte[length];
            if (((InputStream)fis).read(content) != length) {
                return result;
            }
            BuildConfigLexer lexer = new BuildConfigLexer(new ByteArrayInputStream(content));
            lexer.setParser(this);
            Token tok = null;
            while ((tok = lexer.nextToken()) != null) {
                if (tok.getType() == 1) {
                    break;
                }
                String directive = tok.getText();
                if (directive.startsWith("-")) {
                    int nofArgs = invocationState.getNofArgs(directive.substring(1));
                    int i = 0;
                    while (i < nofArgs) {
                        tok = lexer.nextToken();
                        if (tok == null || tok.getType() == 1) break;
                        directive = directive.concat(" ").concat(tok.getText());
                        ++i;
                    }
                }
                result.add(directive);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return result;
    }

    private List<Invocation> computeRelevantInvocations(List<Invocation> invocations, IProject project, IFile incrementalFile) throws Exception {
        ArrayList<Invocation> result = new ArrayList<Invocation>();
        if (!DVTNature.hasNature(project, "ro.amiq.vlogdt.VlogNature") && !DVTNature.hasNature(project, "ro.amiq.vhdldt.VhdlNature")) {
            return result;
        }
        List<? extends IDVTFileInstance> fileInstances = RfMixedLangManager.getInstance().getFileInstances(project, DVTFileUtils.getInstance().resource2parser((IResource)incrementalFile));
        if (fileInstances == null) {
            return result;
        }
        HashSet invocNumbers = new HashSet();
        fileInstances.stream().forEach(fileInstance -> {
            boolean bl = invocNumbers.add(fileInstance.getInvocNumber());
        });
        for (Integer invocNo : invocNumbers) {
            if (invocNo < 0) continue;
            if (invocNo >= invocations.size()) {
                throw new Exception("The project database is out of sync, please rebuild the project (invocation index out of range).");
            }
            result.add(invocations.get(invocNo));
        }
        return result;
    }

    @Override
    public DVTProblem reportProblem(int severity, String message, String filename, int line) {
        return null;
    }

    @Override
    public void registerComment(String string, int line) {
    }
}

