/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.compilescript;

import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import ro.amiq.dvt.core.DVTNature;
import ro.amiq.dvt.externaltools.DVTProjectEnhancedDynamicVariableResolver;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.QFileCompileInfo;
import ro.amiq.dvt.model.reflection.RfMixedLangManager;
import ro.amiq.dvt.startup.core.DVTLogger;

public class DVTExternalToolCompileOrder
extends DVTProjectEnhancedDynamicVariableResolver {
    private static final String ARG_INCL_COMPS = "comp_deps";
    private static final String DVT_COMPILE_ORDER = "dvt_sim_compile_file_list";
    private static final String ERROR_PREFIX = "Cannot resolve ${dvt_sim_compile_file_list}: ";
    private String argPath;
    private boolean inclComps;

    public String resolveValue(IDynamicVariable variable, String argument) throws CoreException {
        try {
            return this.internalResolveValue(argument);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            throw new CoreException((IStatus)new Status(4, "ro.amiq.dvt", ERROR_PREFIX + e.getMessage()));
        }
    }

    public String internalResolveValue(String argument) throws Exception {
        this.reset();
        IProject project = this.getProject();
        if (project == null) {
            throw new Exception("unable to infer project.");
        }
        if (!project.isAccessible() || project.getLocation() == null) {
            throw new Exception("project '" + project.getName() + "' is not accessible.");
        }
        if (!DVTNature.hasNature(project, "ro.amiq.vhdldt.VhdlNature")) {
            throw new Exception("'" + project.getName() + "' is not a VHDL project.");
        }
        List<QFileCompileInfo> fileCompileInfos = null;
        this.parseArg(argument);
        fileCompileInfos = this.argPath != null ? RfMixedLangManager.getInstance().getQFileCompileInfos(project, new ParserPath(this.argPath), true, this.inclComps) : RfMixedLangManager.getInstance().getQFileCompileInfos(project, null, true, this.inclComps);
        if (fileCompileInfos == null) {
            if (this.argPath == null) {
                throw new Exception("project '" + project.getName() + "' has not been built by DVT (no compile info available)");
            }
            throw new Exception("file '" + this.argPath + "' has not been built by DVT (no compile info available)");
        }
        return fileCompileInfos.stream().map(x -> String.valueOf(x.getSyntax().id) + " " + x.getLibrary() + " " + x.getPath()).collect(Collectors.joining("\n"));
    }

    private void reset() {
        this.argPath = null;
        this.inclComps = false;
    }

    private void parseArg(String argument) throws Exception {
        IPath argumentIPath;
        if (argument == null) {
            return;
        }
        int indexOfColon = argument.indexOf(58);
        if (indexOfColon != -1 && ARG_INCL_COMPS.equals(argument.substring(0, indexOfColon))) {
            this.inclComps = true;
            argument = argument.substring(indexOfColon + 1);
        }
        if (!(argumentIPath = Path.fromOSString((String)argument)).isAbsolute()) {
            argumentIPath = this.getProject().getLocation().append(argumentIPath);
        }
        if (!argumentIPath.toFile().exists()) {
            throw new Exception("argument path '" + argument + "' does not exist!");
        }
        if (!argumentIPath.toFile().isFile()) {
            throw new Exception("argument path '" + argument + "' is not a file!");
        }
        this.argPath = argumentIPath.toOSString();
    }
}

