/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.compilescript;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import ro.amiq.dvt.builders.DVTConsoleButtonsDescription;
import ro.amiq.dvt.builders.DVTMessageConsole;
import ro.amiq.dvt.externaltools.IDVTTerminatable;
import ro.amiq.dvt.startup.core.DVTLogger;

public enum FreemarkerConsoleViewer {
    INSTANCE;

    private static final String SEPARATOR_LINE = "\n==============================================================================================================\n";
    private static final String TITLE = "DVT Freemarker";

    public void print(final String message, final IProject project) {
        if (message == null) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    DVTMessageConsole console = FreemarkerConsoleViewer.getOrCreate(FreemarkerConsoleViewer.TITLE, project);
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (MessageConsoleStream out = console.newMessageStream();){
                        out.setActivateOnWrite(true);
                        out.println(FreemarkerConsoleViewer.SEPARATOR_LINE.concat(message).concat(FreemarkerConsoleViewer.SEPARATOR_LINE));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
            }
        });
    }

    private static DVTMessageConsole getOrCreate(String name, IProject project) {
        DVTMessageConsole result = FreemarkerConsoleViewer.findMessageConsole(name);
        if (result == null) {
            result = new FreemarkerConsole(name, null, project);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{result});
        }
        return result;
    }

    private static DVTMessageConsole findMessageConsole(String title) {
        IConsole[] consoles;
        IConsole[] iConsoleArray = consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = consoles.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole iConsole = iConsoleArray[n2];
            if (iConsole instanceof DVTMessageConsole && iConsole.getName().equals(title)) {
                return (DVTMessageConsole)iConsole;
            }
            ++n2;
        }
        return null;
    }

    static class FreemarkerConsole
    extends DVTMessageConsole
    implements IDVTTerminatable {
        public FreemarkerConsole(String name, ImageDescriptor imageDescriptor, IProject project) {
            super(project, name, imageDescriptor, new DVTConsoleButtonsDescription(false, false, true));
        }

        @Override
        public void terminate() {
            ConsolePlugin.getDefault().getConsoleManager().removeConsoles(new IConsole[]{this});
        }
    }
}

