/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.pattern;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.RangeMarker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;
import ro.amiq.dvt.externaltools.pattern.PatternBuffer;
import ro.amiq.dvt.externaltools.pattern.PatternContext;
import ro.amiq.dvt.externaltools.pattern.PatternException;
import ro.amiq.dvt.externaltools.pattern.PatternTranslator;
import ro.amiq.dvt.externaltools.pattern.PatternVariable;
import ro.amiq.dvt.externaltools.pattern.PatternVariableResolver;

public class PatternContextType {
    private String fId = null;
    private final Map<String, PatternVariableResolver> fResolvers = new HashMap<String, PatternVariableResolver>();
    private String fName = null;
    private Pattern fPattern;
    private HashMap<String, Integer> fVariablesMap;
    private HashMap<String, DVTHyperlinkCommand> fHyperlinkCommandsMap;

    public PatternContextType(String id) {
        this(id, id);
    }

    public PatternContextType(String id, String name) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull((Object)name);
        this.fId = id;
        this.fName = name;
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }

    public PatternContextType() {
    }

    public final void setId(String id) throws RuntimeException {
        Assert.isNotNull((Object)id);
        Assert.isTrue((this.fId == null ? 1 : 0) != 0);
        this.fId = id;
    }

    public final void setName(String name) {
        Assert.isTrue((this.fName == null ? 1 : 0) != 0);
        this.fName = name;
    }

    public void addResolver(PatternVariableResolver resolver) {
        Assert.isNotNull((Object)resolver);
        this.fResolvers.put(resolver.getType(), resolver);
    }

    public void removeResolver(PatternVariableResolver resolver) {
        Assert.isNotNull((Object)resolver);
        this.fResolvers.remove(resolver.getType());
    }

    public void removeAllResolvers() {
        this.fResolvers.clear();
    }

    public Iterator<PatternVariableResolver> resolvers() {
        return Collections.unmodifiableMap(this.fResolvers).values().iterator();
    }

    protected PatternVariableResolver getResolver(String type) {
        return this.fResolvers.get(type);
    }

    public void validate(String pattern) throws PatternException {
        PatternTranslator translator = new PatternTranslator();
        PatternBuffer buffer = translator.translate(pattern);
        this.validateVariables(buffer.getVariables());
        this.fPattern = translator.getCompiledPattern();
        this.fVariablesMap = translator.getVariablesMap();
        this.fHyperlinkCommandsMap = translator.getHyperlinkCommandsMap();
    }

    protected void validateVariables(PatternVariable[] variables) throws PatternException {
    }

    public void resolve(PatternBuffer buffer, PatternContext context) throws BadLocationException {
        Assert.isNotNull((Object)context);
        PatternVariable[] variables = buffer.getVariables();
        List<RangeMarker> positions = PatternContextType.variablesToPositions(variables);
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>(5);
        int i = 0;
        while (i != variables.length) {
            PatternVariable variable = variables[i];
            if (!variable.isUnambiguous()) {
                int[] oldOffsets = variable.getOffsets();
                int oldLength = variable.getLength();
                String oldValue = variable.getDefaultValue();
                String type = variable.getType();
                PatternVariableResolver resolver = this.fResolvers.get(type);
                if (resolver == null) {
                    resolver = new PatternVariableResolver(type, "");
                }
                resolver.resolve(variable, context);
                String value = variable.getDefaultValue();
                if (!oldValue.equals(value)) {
                    int k = 0;
                    while (k != oldOffsets.length) {
                        edits.add(new ReplaceEdit(oldOffsets[k], oldLength, value));
                        ++k;
                    }
                }
            }
            ++i;
        }
        Document document = new Document(buffer.getString());
        MultiTextEdit edit = new MultiTextEdit(0, document.getLength());
        edit.addChildren(positions.toArray(new TextEdit[positions.size()]));
        edit.addChildren(edits.toArray(new TextEdit[edits.size()]));
        edit.apply((IDocument)document, 2);
        PatternContextType.positionsToVariables(positions, variables);
        buffer.setContent(document.get(), variables);
    }

    private static List<RangeMarker> variablesToPositions(PatternVariable[] variables) {
        ArrayList<RangeMarker> positions = new ArrayList<RangeMarker>(5);
        int i = 0;
        while (i != variables.length) {
            int[] offsets = variables[i].getOffsets();
            int j = 0;
            while (j != offsets.length) {
                positions.add(new RangeMarker(offsets[j], 0));
                ++j;
            }
            ++i;
        }
        return positions;
    }

    private static void positionsToVariables(List<RangeMarker> positions, PatternVariable[] variables) {
        Iterator<RangeMarker> iterator = positions.iterator();
        int i = 0;
        while (i != variables.length) {
            PatternVariable variable = variables[i];
            int[] offsets = new int[variable.getOffsets().length];
            int j = 0;
            while (j != offsets.length) {
                offsets[j] = ((TextEdit)iterator.next()).getOffset();
                ++j;
            }
            variable.setOffsets(offsets);
            ++i;
        }
    }

    public Pattern getCompiledPattern() {
        return this.fPattern;
    }

    public HashMap<String, Integer> getVariablesMap() {
        return this.fVariablesMap;
    }

    public HashMap<String, DVTHyperlinkCommand> getHyperlinkCommandsMap() {
        return this.fHyperlinkCommandsMap;
    }
}

