/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.pattern;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.externaltools.pattern.PatternContextType;
import ro.amiq.dvt.externaltools.pattern.PatternContextTypeRegistry;
import ro.amiq.dvt.externaltools.pattern.PatternVariableResolver;

public class PatternContributionContextTypeRegistry
extends PatternContextTypeRegistry {
    public void addContextType(String id) {
        Assert.isNotNull((Object)id);
        if (this.getContextType(id) != null) {
            return;
        }
        PatternContextType type = PatternContributionContextTypeRegistry.createContextType(id);
        if (type != null) {
            this.addContextType(type);
        }
    }

    public static PatternContextType createContextType(String id) {
        PatternContextType type;
        Assert.isNotNull((Object)id);
        try {
            type = new PatternContextType(id);
            if (type != null) {
                PatternVariableResolver[] resolvers = PatternContributionContextTypeRegistry.createResolvers(id);
                int i = 0;
                while (i < resolvers.length) {
                    type.addResolver(resolvers[i]);
                    ++i;
                }
            }
        }
        catch (Exception exception) {
            type = null;
        }
        return type;
    }

    private static PatternVariableResolver[] createResolvers(String contextTypeId) {
        ArrayList<PatternVariableResolver> resolvers = new ArrayList<PatternVariableResolver>();
        PatternVariableResolver resolver = new PatternVariableResolver("line", "Line at which the message occurs");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("message", "Error/warning/info message");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("message_g", "Error/warning/info message (greedy)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("message_l", "Error/warning/info message - can match a limited number of characters");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("url", "URL - can match a file, http, https, ftp url");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("message_lg", "Error/warning/info message (greedy) - can match a limited number of characters");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("message_qml", "Error/warning/info message (Questa multi line pattern)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("message_sl", "Error/warning/info message (single line)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("file", "File in which the message occurs");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("nc_error_id", "A message specific error code used to get additional info from 'nchelp' (works only with IUS filters)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("nc_tool", "Tool's name - used to get additional info from 'nchelp' (works only with IUS filters)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("v_error_id", "A message specific error code used to get additional info from 'verror' (works only with Questa filters)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("v_error_tool", "Tool's name - used to get additional info from 'verror' (works only with Questa filters)");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("max_lines", "Max. consecutive lines that a regex filter can match");
        resolvers.add(resolver);
        resolver = new PatternVariableResolver("cmd:run_configuration:regular_expression", "Matches <regular_expression> and creates a hyperlink which launches <run_configuration>");
        resolvers.add(resolver);
        return resolvers.toArray(new PatternVariableResolver[resolvers.size()]);
    }
}

