/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.pattern;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;
import ro.amiq.dvt.externaltools.pattern.PatternException;
import ro.amiq.dvt.externaltools.pattern.PatternTranslator;
import ro.amiq.dvt.startup.core.DVTLogger;

public class PatternReaderWriter {
    private static final String PATTERNS_ROOT = "patterns";
    private static final String PATTERN_NODE = "pattern";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String KIND_ATTRIBUTE = "kind";
    private static final String ENABLED_ATTRIBUTE = "enabled";
    private static final String TYPE_ATTRIBUTE = "type";

    public ExternalToolsPattern[] read(InputStream stream, ResourceBundle bundle) throws IOException {
        return this.read(new InputSource(stream), bundle);
    }

    public ExternalToolsPattern[] read(Reader reader) throws IOException {
        return this.read(reader, null);
    }

    public ExternalToolsPattern[] read(Reader reader, ResourceBundle bundle) throws IOException {
        return this.read(new InputSource(reader), bundle);
    }

    private ExternalToolsPattern[] read(InputSource source, ResourceBundle bundle) throws IOException {
        try {
            ArrayList<ExternalToolsPattern> patterns = new ArrayList<ExternalToolsPattern>();
            HashSet<String> ids = new HashSet<String>();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(source);
            NodeList elements = document.getElementsByTagName(PATTERN_NODE);
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    String name = this.getStringValue(attributes, NAME_ATTRIBUTE, null);
                    if (name != null && ids.contains(name)) {
                        throw new IOException("ExternalToolsPattern.error.duplicate_id");
                    }
                    ids.add(name);
                    String description = this.getStringValue(attributes, DESCRIPTION_ATTRIBUTE, "");
                    String kind = this.getStringValue(attributes, KIND_ATTRIBUTE);
                    if (name == null || kind == null) {
                        throw new IOException("ExternalToolsPattern.error.missing_attribute");
                    }
                    boolean enabled = this.getBooleanValue(attributes, ENABLED_ATTRIBUTE, true);
                    String priority = this.getStringValue(attributes, TYPE_ATTRIBUTE, "");
                    StringBuilder buffer = new StringBuilder();
                    NodeList children = node.getChildNodes();
                    int j = 0;
                    while (j != children.getLength()) {
                        String value = children.item(j).getNodeValue();
                        if (value != null) {
                            buffer.append(value);
                        }
                        ++j;
                    }
                    String pattern = buffer.toString();
                    PatternTranslator translator = new PatternTranslator();
                    translator.translate(pattern);
                    Pattern compiledPattern = translator.getCompiledPattern();
                    HashMap<String, Integer> variablesMap = translator.getVariablesMap();
                    HashMap<String, DVTHyperlinkCommand> hyperlinkCommandsMap = translator.getHyperlinkCommandsMap();
                    ExternalToolsPattern convention = new ExternalToolsPattern(kind, name, priority, description, pattern, compiledPattern, variablesMap, hyperlinkCommandsMap, enabled);
                    patterns.add(convention);
                }
                ++i;
            }
            return patterns.toArray(new ExternalToolsPattern[patterns.size()]);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (SAXException e) {
            Throwable t = e.getCause();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t != null) {
                throw new IOException(t.getMessage());
            }
            throw new IOException(e.getMessage());
        }
        catch (PatternException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    public void save(ExternalToolsPattern[] patterns, OutputStream stream) throws IOException {
        this.save(patterns, new StreamResult(stream));
    }

    public void save(ExternalToolsPattern[] patterns, Writer writer) throws IOException {
        this.save(patterns, new StreamResult(writer));
    }

    private void save(ExternalToolsPattern[] patterns, StreamResult result) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement(PATTERNS_ROOT);
            document.appendChild(root);
            int i = 0;
            while (i < patterns.length) {
                ExternalToolsPattern convention = patterns[i];
                Element node = document.createElement(PATTERN_NODE);
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                if (convention != null) {
                    Attr name = document.createAttribute(NAME_ATTRIBUTE);
                    name.setValue(convention.getName());
                    attributes.setNamedItem(name);
                    Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                    description.setValue(convention.getDescription());
                    attributes.setNamedItem(description);
                    Attr context = document.createAttribute(KIND_ATTRIBUTE);
                    context.setValue(convention.getKind());
                    attributes.setNamedItem(context);
                    Attr enabled = document.createAttribute(ENABLED_ATTRIBUTE);
                    enabled.setValue(convention.getEnabled() ? Boolean.toString(true) : Boolean.toString(false));
                    attributes.setNamedItem(enabled);
                    Attr priority = document.createAttribute(TYPE_ATTRIBUTE);
                    priority.setValue(convention.getType());
                    attributes.setNamedItem(priority);
                    Text pattern = document.createTextNode(convention.getPatternString());
                    node.appendChild(pattern);
                }
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Assert.isTrue((boolean)false);
        }
        catch (TransformerException e) {
            if (e.getException() instanceof IOException) {
                throw (IOException)e.getException();
            }
            Assert.isTrue((boolean)false);
        }
    }

    private boolean getBooleanValue(NamedNodeMap attributes, String attribute, boolean defaultValue) throws SAXException {
        Node enabledNode = attributes.getNamedItem(attribute);
        if (enabledNode == null) {
            return defaultValue;
        }
        if (enabledNode.getNodeValue().equals(Boolean.toString(true))) {
            return true;
        }
        if (enabledNode.getNodeValue().equals(Boolean.toString(false))) {
            return false;
        }
        throw new SAXException("ConventionReaderWriter.error.illegal_boolean_attribute");
    }

    private String getStringValue(NamedNodeMap attributes, String name) throws SAXException {
        String val = this.getStringValue(attributes, name, null);
        if (val == null) {
            throw new SAXException("ConventionReaderWriter.error.missing_attribute");
        }
        return val;
    }

    private String getStringValue(NamedNodeMap attributes, String name, String defaultValue) {
        Node node = attributes.getNamedItem(name);
        return node == null ? defaultValue : node.getNodeValue();
    }
}

