/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.pattern;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ro.amiq.dvt.DVTPlugin;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;
import ro.amiq.dvt.externaltools.pattern.PatternBuffer;
import ro.amiq.dvt.externaltools.pattern.PatternException;
import ro.amiq.dvt.externaltools.pattern.PatternMessages;
import ro.amiq.dvt.externaltools.pattern.PatternVariable;

public class PatternTranslator {
    private static final int TEXT = 0;
    private static final int ESCAPE = 1;
    private static final int IDENTIFIER = 2;
    private static final int BACKSLASH = 3;
    private static final char ESCAPE_CHARACTER = '$';
    private static final char IDENTIFIER_BEGIN = '{';
    private static final char IDENTIFIER_END = '}';
    private static final char BACKSLASH_CHARACTER = '\\';
    public static final String LINE = "__DVT_L";
    public static final String FILE = "__DVT_F";
    public static final String TYPE = "__DVT_T";
    public static final String MESSAGE = "__DVT_M";
    public static final String NC_ERROR_ID = "__DVT_NC_E";
    public static final String NC_TOOL = "__DVT_NC_T";
    public static final String URL = "__DVT_U";
    public static final String V_ERROR_ID = "__DVT_V_E";
    public static final String V_ERROR_TOOL = "__DVT_V_T";
    public static final String CMD = "__DVT_C_R";
    private static final String FILE_NAME = "[a-zA-Z0-9&:_\\-\\.]+";
    private static final String COMMON_WS_PATH = "(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*";
    private static final String COMMON_NWS_PATH = "(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*";
    private static final String WINDOWS_PATH = "[a-zA-Z][a-zA-Z_0-9]*:[\\\\/]";
    private static final String LINUX_PATH = "[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*";
    public static final String FILE_PATTERN = "(?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+";
    public static final String LINE_PATTERN = "[0-9]+(?:[,.][0-9]+)*";
    public static final String URL_PATTERN = "(?:http|https|ftp|file)://\\S+";
    public static final Pattern CMD_PATTERN = Pattern.compile("\\$\\{cmd:(.*?):(.*?)\\}");
    private final StringBuilder fBuffer = new StringBuilder();
    public final ArrayList<Integer> fOffsets = new ArrayList();
    public final ArrayList<Integer> fLengths = new ArrayList();
    private Pattern fPattern;
    private int fState;
    private String fErrorMessage;
    private HashMap<String, Integer> fVariablesMap = new HashMap();
    private HashMap<String, DVTHyperlinkCommand> fHyperlinkCommandsMap = new HashMap();

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public PatternBuffer translate(ExternalToolsPattern pattern) throws PatternException {
        return this.translate(pattern.getPatternString());
    }

    public PatternBuffer translate(String string) throws PatternException {
        String maxCharsText = DVTPlugin.getDefault().getPreferenceStore().getString("max_characters_per_line");
        if (maxCharsText.isEmpty()) {
            maxCharsText = "512";
        }
        maxCharsText = "{1," + maxCharsText + "}";
        String maxLinesText = DVTPlugin.getDefault().getPreferenceStore().getString("max_consecutive_lines");
        if (maxLinesText.isEmpty()) {
            maxLinesText = "8";
        }
        maxLinesText = "{0," + maxLinesText + "}";
        this.fBuffer.setLength(0);
        this.fOffsets.clear();
        this.fLengths.clear();
        this.fState = 0;
        this.fErrorMessage = null;
        string = this.extractHyperlinkCommands(string);
        if (!this.parse(string)) {
            throw new PatternException(this.fErrorMessage);
        }
        switch (this.fState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                throw new PatternException(PatternMessages.Pattern_error_message);
            }
            case 3: {
                throw new PatternException(PatternMessages.PatternCompile_error_message);
            }
        }
        int[] offsets = new int[this.fOffsets.size()];
        int[] lengths = new int[this.fLengths.size()];
        int i = 0;
        while (i < this.fOffsets.size()) {
            offsets[i] = this.fOffsets.get(i);
            lengths[i] = this.fLengths.get(i);
            ++i;
        }
        PatternVariable[] variables = this.findVariables(this.fBuffer.toString(), offsets, lengths);
        String translatedString = string.replace("${line}", "(?<__DVT_L>[0-9]+(?:[,.][0-9]+)*)").replace("${message}", "(?<__DVT_M>.*?)").replace("${message_g}", "(?<__DVT_M>.*)").replace("${message_l}", "(?<__DVT_M>." + maxCharsText + "?)").replace("${message_lg}", "(?<__DVT_M>." + maxCharsText + ")").replace("${message_qml}", "(?<__DVT_M>(?:.(?!\\*\\*\\s+(?:Error|Fatal):|^\\n|^\\s+\\n))+)").replace("${message_sl}", "(?<__DVT_M>[^\\n\\r]*?)").replace("${type}", "(?<__DVT_T>(?:[a-zA-Z_][a-zA-Z0-9_]*::)?[a-zA-Z_][a-zA-Z0-9_]*)").replace("${file}", "(?<__DVT_F>(?:(?:[\\.]*[\\\\/]+(?:[\\.]+[\\\\/]+)*|[a-zA-Z][a-zA-Z_0-9]*:[\\\\/])(?:\\.?[a-zA-Z0-9&$:_\\-][ a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*|(?:\\.?[a-zA-Z0-9&$:_\\-][a-zA-Z0-9&$:_\\-\\.]*[\\\\/.]+)*)?[a-zA-Z0-9&:_\\-\\.]+)").replace("${nc_error_id}", "(?<__DVT_NC_E>[A-Za-z0-9]+)").replace("${nc_tool}", "(?<__DVT_NC_T>[A-Za-z0-9_]+)").replace("${url}", "(?<__DVT_U>(?:http|https|ftp|file)://\\S+)").replace("${v_error_id}", "(?<__DVT_V_E>[A-Za-z0-9]+)").replace("${v_error_tool}", "(?<__DVT_V_T>[A-Za-z][A-Za-z0-9_\\-]*)").replace("${max_lines}", maxLinesText);
        translatedString = this.extractTags(translatedString);
        this.fPattern = null;
        try {
            this.fPattern = Pattern.compile(translatedString);
        }
        catch (Exception exception) {
            throw new PatternException(PatternMessages.PatternCompile_error_message);
        }
        return new PatternBuffer(translatedString, variables);
    }

    private String extractHyperlinkCommands(String string) {
        int i = 0;
        Matcher matcher = CMD_PATTERN.matcher(string);
        while (matcher.find()) {
            String command = matcher.group(1);
            String pattern = matcher.group(2);
            string = string.replace(matcher.group(), "(?<__DVT_C_R" + i + ">" + pattern + ")");
            this.fHyperlinkCommandsMap.put(CMD + i, new DVTHyperlinkCommand(command, pattern));
            ++i;
        }
        return string;
    }

    private String extractTags(String patternString) {
        if (patternString == null) {
            return null;
        }
        boolean backslash = false;
        boolean candidate = false;
        int groups = 0;
        StringBuilder label = new StringBuilder();
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < patternString.length()) {
            char c = patternString.charAt(i);
            switch (c) {
                case '\\': {
                    backslash = !backslash;
                    candidate = false;
                    result.append(c);
                    break;
                }
                case '(': {
                    if (!backslash) {
                        ++groups;
                    }
                    backslash = false;
                    candidate = true;
                    result.append(c);
                    break;
                }
                case '<': {
                    backslash = false;
                    if (label.length() == 1) {
                        label.append(c);
                    } else {
                        result.append((CharSequence)label).append(c);
                        label.delete(0, label.length());
                    }
                    candidate = false;
                    break;
                }
                case '?': {
                    backslash = false;
                    if (candidate) {
                        label.append(c);
                        --groups;
                    } else {
                        result.append(c);
                    }
                    candidate = false;
                    break;
                }
                case '>': {
                    backslash = false;
                    if (label.length() > 2) {
                        this.fVariablesMap.put(label.toString().substring(2), ++groups);
                        label.delete(0, label.length());
                    } else {
                        result.append((CharSequence)label).append(c);
                        label.delete(0, label.length());
                    }
                    candidate = false;
                    break;
                }
                default: {
                    if (label.length() > 1 && (Character.isLetter(c) || Character.isDigit(c) || c == '_')) {
                        label.append(c);
                    } else {
                        result.append((CharSequence)label).append(c);
                        label.delete(0, label.length());
                    }
                    backslash = false;
                    candidate = false;
                }
            }
            ++i;
        }
        return result.toString();
    }

    public final Pattern getCompiledPattern() {
        return this.fPattern;
    }

    private PatternVariable[] findVariables(String string, int[] offsets, int[] lengths) throws PatternException {
        String content = null;
        HashMap<String, ArrayList<Integer>> map = new HashMap<String, ArrayList<Integer>>();
        int i = 0;
        while (i != offsets.length) {
            int offset = offsets[i];
            int length = lengths[i];
            content = string.substring(offset, offset + length);
            if (!(content.equals("nc_tool") || content.equals("nc_error_id") || content.equals("v_error_tool") || content.equals("v_error_id") || content.equals("line") || content.equals("file") || content.equals("url") || content.equals("message") || content.equals("message_g") || content.equals("message_l") || content.equals("message_lg") || content.equals("message_qml") || content.equals("message_sl") || content.equals("max_lines") || content.startsWith("cmd:"))) {
                throw new PatternException(String.valueOf(PatternMessages.Pattern_Unknown_variable_error_message) + " '" + content + "'");
            }
            ArrayList<Integer> vector = (ArrayList<Integer>)map.get(content);
            if (vector == null) {
                vector = new ArrayList<Integer>();
                map.put(content, vector);
            }
            vector.add(offset);
            ++i;
        }
        PatternVariable[] variables = new PatternVariable[map.size()];
        int k = 0;
        Set keys = map.keySet();
        for (String name : keys) {
            ArrayList vector = (ArrayList)map.get(name);
            int[] computedOffsets = new int[vector.size()];
            int j = 0;
            while (j != computedOffsets.length) {
                computedOffsets[j] = (Integer)vector.get(j);
                ++j;
            }
            variables[k] = this.createVariable(name, name, computedOffsets);
            ++k;
        }
        return variables;
    }

    public HashMap<String, Integer> getVariablesMap() {
        return this.fVariablesMap;
    }

    public HashMap<String, DVTHyperlinkCommand> getHyperlinkCommandsMap() {
        return this.fHyperlinkCommandsMap;
    }

    protected PatternVariable createVariable(String type, String name, int[] offsets) {
        return new PatternVariable(type, name, offsets);
    }

    private boolean parse(String string) throws PatternException {
        int i = 0;
        while (i != string.length()) {
            char ch = string.charAt(i);
            block0 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case '$': {
                            this.fState = 1;
                            break block0;
                        }
                        case '\\': {
                            this.fState = 3;
                            break block0;
                        }
                    }
                    this.fBuffer.append(ch);
                    break;
                }
                case 1: {
                    switch (ch) {
                        case '$': {
                            this.fBuffer.append(ch);
                            this.fState = 0;
                            break block0;
                        }
                        case '{': {
                            this.fOffsets.add(this.fBuffer.length());
                            this.fState = 2;
                            break block0;
                        }
                    }
                    this.fErrorMessage = PatternMessages.Pattern_error_message;
                    this.fBuffer.append('$');
                    this.fBuffer.append(ch);
                    this.fState = 0;
                    return false;
                }
                case 2: {
                    switch (ch) {
                        case '}': {
                            int offset = this.fOffsets.get(this.fOffsets.size() - 1);
                            this.fLengths.add(this.fBuffer.length() - offset);
                            this.fState = 0;
                            break block0;
                        }
                    }
                    if (!Character.isUnicodeIdentifierStart(ch) && !Character.isUnicodeIdentifierPart(ch)) {
                        this.fErrorMessage = PatternMessages.Pattern_error_message;
                        return false;
                    }
                    this.fBuffer.append(ch);
                    break;
                }
                case 3: {
                    this.fBuffer.append(ch);
                    this.fState = 0;
                }
            }
            ++i;
        }
        return true;
    }
}

