/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.pattern;

import org.eclipse.core.runtime.Assert;
import ro.amiq.dvt.externaltools.pattern.PatternContext;
import ro.amiq.dvt.externaltools.pattern.PatternVariable;

public class PatternVariableResolver {
    private String fType = null;
    private String fDescription = null;

    protected PatternVariableResolver(String type, String description) {
        this.setType(type);
        this.setDescription(description);
    }

    public PatternVariableResolver() {
    }

    public String getType() {
        return this.fType;
    }

    public String getDescription() {
        return this.fDescription;
    }

    protected String resolve(PatternContext context) {
        return context.getVariable(this.getType());
    }

    protected String[] resolveAll(PatternContext context) {
        String binding = this.resolve(context);
        if (binding == null) {
            return new String[0];
        }
        return new String[]{binding};
    }

    public void resolve(PatternVariable variable, PatternContext context) {
        String[] bindings = this.resolveAll(context);
        if (bindings.length != 0) {
            variable.setValues(bindings);
        }
        if (bindings.length > 1) {
            variable.setUnambiguous(false);
        } else {
            variable.setUnambiguous(this.isUnambiguous(context));
        }
    }

    protected boolean isUnambiguous(PatternContext context) {
        return false;
    }

    public final void setDescription(String description) {
        Assert.isNotNull((Object)description);
        Assert.isTrue((this.fDescription == null ? 1 : 0) != 0);
        this.fDescription = description;
    }

    public final void setType(String type) {
        Assert.isNotNull((Object)type);
        Assert.isTrue((this.fType == null ? 1 : 0) != 0);
        this.fType = type;
    }
}

