/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.PropertyPage;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsReference;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ui.BuilderLabelProvider;
import ro.amiq.dvt.externaltools.ui.EditBuilderConfiguration;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTExceptionHandler;

public class BuilderPropertyPage
extends PropertyPage
implements ICheckStateListener {
    private Button fUpButton;
    private Button fDownButton;
    private Button fNewButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private CheckboxTableViewer fViewer;
    private SelectionListener fButtonListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            BuilderPropertyPage.this.handleButtonPressed((Button)e.widget);
        }
    };
    private List<IExternalToolsConfiguration> fOriginalConfigs;

    public BuilderPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    private void addBuildersToTable() {
        List<IExternalToolsConfiguration> configs = ExternalToolsModelManager.getInstance().getBuilderConfigsWorkingCopy(this.getProject(), false);
        this.fOriginalConfigs = this.copyConfigs(configs);
        if (configs == null) {
            return;
        }
        for (IExternalToolsConfiguration config : configs) {
            if (config == null) continue;
            this.fViewer.add((Object)config);
            this.setChecked(config, config.getEnable());
        }
    }

    private List<IExternalToolsConfiguration> copyConfigs(List<IExternalToolsConfiguration> configs) {
        ArrayList<IExternalToolsConfiguration> workingCopy = new ArrayList<IExternalToolsConfiguration>();
        if (configs == null) {
            return workingCopy;
        }
        for (IExternalToolsConfiguration config : configs) {
            workingCopy.add(config.getWorkingCopy());
        }
        return workingCopy;
    }

    private Button createButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        GridData data = new GridData();
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)data);
        button.setFont(parent.getFont());
        button.setText(JFaceResources.getString((String)key));
        button.setEnabled(false);
        button.addSelectionListener(this.fButtonListener);
        return button;
    }

    protected Control createContents(Composite parent) {
        try {
            IProject project = this.getProject();
            if (project.hasNature("ro.amiq.vlogdt.VlogNature")) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.external_builder");
            }
        }
        catch (Exception exception) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.edt.help.external_builder");
        }
        Font font = parent.getFont();
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(1808));
        Label description = new Label(topLevel, 64);
        description.setText("Configure the builders for the &project:");
        description.setLayoutData((Object)new GridData(768));
        description.setFont(font);
        Composite tableAndButtons = new Composite(topLevel, 0);
        tableAndButtons.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        tableAndButtons.setLayout((Layout)layout);
        this.fViewer = CheckboxTableViewer.newCheckList((Composite)tableAndButtons, (int)68354);
        this.fViewer.setLabelProvider((IBaseLabelProvider)new BuilderLabelProvider(false));
        this.fViewer.addCheckStateListener((ICheckStateListener)this);
        Table builderTable = this.fViewer.getTable();
        builderTable.setLayoutData((Object)new GridData(1808));
        builderTable.setFont(font);
        builderTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuilderPropertyPage.this.handleTableSelectionChanged();
            }
        });
        builderTable.addListener(8, event -> this.handleEditButtonPressed());
        Composite buttonArea = new Composite(tableAndButtons, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonArea.setLayout((Layout)layout);
        buttonArea.setFont(font);
        buttonArea.setLayoutData((Object)new GridData(1040));
        this.fNewButton = this.createButton(buttonArea, "ListEditor.add");
        this.fEditButton = this.createButton(buttonArea, "&Edit...");
        this.fRemoveButton = this.createButton(buttonArea, "ListEditor.remove");
        new Label(buttonArea, 16384);
        this.fUpButton = this.createButton(buttonArea, "ListEditor.up");
        this.fDownButton = this.createButton(buttonArea, "ListEditor.down");
        this.fNewButton.setEnabled(true);
        this.addBuildersToTable();
        return topLevel;
    }

    private void handleButtonPressed(Button button) {
        if (button == this.fNewButton) {
            this.handleNewButtonPressed();
        } else if (button == this.fEditButton) {
            this.handleEditButtonPressed();
        } else if (button == this.fRemoveButton) {
            this.handleRemoveButtonPressed();
        } else if (button == this.fUpButton) {
            this.moveSelectionUp();
        } else if (button == this.fDownButton) {
            this.moveSelectionDown();
        }
        if (this.getControl().isDisposed()) {
            return;
        }
        this.handleTableSelectionChanged();
        this.fViewer.getTable().setFocus();
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object element = event.getElement();
        boolean checked = event.getChecked();
        if (element instanceof IExternalToolsConfiguration) {
            ((IExternalToolsConfiguration)element).setEnable(checked);
        }
    }

    private void handleRemoveButtonPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (selection != null) {
            for (Object item : selection) {
                this.fViewer.remove(item);
            }
        }
    }

    private void handleNewButtonPressed() {
        try {
            IExternalToolsConfiguration config = this.promptForConfigurationType();
            if (config == null) {
                return;
            }
            int code = this.editConfiguration(config, false);
            if (code == 1) {
                return;
            }
            this.fViewer.add((Object)config);
            this.setChecked(config, config.getEnable());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    private void setChecked(IExternalToolsConfiguration config, boolean value) {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IExternalToolsConfiguration c1;
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getData() != null && (c1 = (IExternalToolsConfiguration)tableItem.getData()).getName().equals(config.getName())) {
                tableItem.setChecked(value);
            }
            ++n2;
        }
    }

    private boolean getChecked(IExternalToolsConfiguration configuration) {
        TableItem[] items;
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IExternalToolsConfiguration c1;
            TableItem tableItem = tableItemArray[n2];
            if (tableItem.getData() != null && (c1 = (IExternalToolsConfiguration)tableItem.getData()).getName().equals(configuration.getName())) {
                return tableItem.getChecked();
            }
            ++n2;
        }
        return false;
    }

    private int editConfiguration(IExternalToolsConfiguration config, boolean edit) {
        Shell shell = this.getShell();
        if (shell == null) {
            return 1;
        }
        EditBuilderConfiguration dialog = new EditBuilderConfiguration(shell, edit, this.fViewer, this.getProject(), config);
        return dialog.open();
    }

    private IExternalToolsConfiguration promptForConfigurationType() {
        List<IExternalToolsConfiguration> builderTypes = ExternalToolsModelManager.getInstance().getBuilderTypes();
        if (builderTypes == null) {
            return null;
        }
        Shell shell = this.getShell();
        if (shell == null) {
            return null;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new BuilderLabelProvider(true));
        dialog.setElements(builderTypes.toArray());
        dialog.setMultipleSelection(false);
        dialog.setTitle("New External Builder");
        dialog.setMessage("&Choose an external builder type to create:");
        dialog.open();
        Object[] result = dialog.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        if (result[0] == null) {
            return null;
        }
        return ((IExternalToolsConfiguration)result[0]).getWorkingCopy();
    }

    private void handleEditButtonPressed() {
        Object data;
        TableItem[] items = this.fViewer.getTable().getSelection();
        if (items.length == 0) {
            return;
        }
        TableItem selection = items[0];
        if (selection != null && (data = selection.getData()) instanceof IExternalToolsConfiguration) {
            IExternalToolsConfiguration config = (IExternalToolsConfiguration)data;
            IExternalToolsConfiguration workingCopy = config.getWorkingCopy();
            int code = this.editConfiguration(workingCopy, true);
            if (code == 1) {
                return;
            }
            if (!config.getName().equals(workingCopy.getName()) && MessageDialog.openQuestion((Shell)this.getShell(), (String)"Edit External Builder", (String)"The name of the builder has been changed. Click 'Yes' to create an additional builder with the new name or 'No' to rename the existing one.")) {
                this.fViewer.add((Object)workingCopy);
                this.setChecked(workingCopy, config.getEnable());
            } else {
                config.setName(workingCopy.getName());
                config.setAutoCommand(workingCopy.getAutoCommand());
                config.setCleanCommand(workingCopy.getCleanCommand());
                config.setEnable(workingCopy.getEnable());
                config.setFullCommand(workingCopy.getFullCommand());
                config.setPatterns(workingCopy.getPatterns());
                config.setFilterKinds(workingCopy.getFilterKinds());
                config.setWorkingDir(workingCopy.getWorkingDir());
                config.setAttributes(workingCopy.getAttributes());
                this.fViewer.refresh((Object)config, true, true);
            }
        }
    }

    private void handleTableSelectionChanged() {
        boolean validSelection;
        this.fNewButton.setEnabled(true);
        Table builderTable = this.fViewer.getTable();
        TableItem[] items = builderTable.getSelection();
        boolean enableEdit = validSelection = items != null && items.length > 0;
        boolean enableRemove = validSelection;
        boolean enableUp = validSelection;
        boolean enableDown = validSelection;
        if (validSelection) {
            if (items != null && items.length > 1) {
                enableEdit = false;
            }
            if (items != null) {
                int i = 0;
                while (i < items.length) {
                    if (items[i] != null && items[i].getData() instanceof ExternalToolsReference) {
                        enableRemove = false;
                    }
                    ++i;
                }
            }
            int[] indices = builderTable.getSelectionIndices();
            int max = builderTable.getItemCount();
            enableUp = indices[0] != 0;
            enableDown = indices[indices.length - 1] < max - 1;
        }
        this.fEditButton.setEnabled(enableEdit);
        this.fRemoveButton.setEnabled(enableRemove);
        this.fUpButton.setEnabled(enableUp);
        this.fDownButton.setEnabled(enableDown);
    }

    private void move(TableItem item, int index) {
        Object data = item.getData();
        item.dispose();
        this.fViewer.insert(data, index);
        IExternalToolsConfiguration configuration = (IExternalToolsConfiguration)data;
        this.setChecked(configuration, configuration.getEnable());
    }

    private void moveSelectionDown() {
        Table builderTable = this.fViewer.getTable();
        int[] indices = builderTable.getSelectionIndices();
        if (indices.length < 1) {
            return;
        }
        int[] newSelection = new int[indices.length];
        int max = builderTable.getItemCount() - 1;
        int i = indices.length - 1;
        while (i >= 0) {
            int index = indices[i];
            if (index < max) {
                this.move(builderTable.getItem(index), index + 1);
                newSelection[i] = index + 1;
            }
            --i;
        }
        builderTable.setSelection(newSelection);
    }

    private void moveSelectionUp() {
        Table builderTable = this.fViewer.getTable();
        int[] indices = builderTable.getSelectionIndices();
        int[] newSelection = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index > 0) {
                this.move(builderTable.getItem(index), index - 1);
                newSelection[i] = index - 1;
            }
            ++i;
        }
        builderTable.setSelection(newSelection);
    }

    public boolean performOk() {
        Table builderTable = this.fViewer.getTable();
        TableItem[] items = builderTable.getItems();
        ArrayList<IExternalToolsConfiguration> configsWorkingCopy = new ArrayList<IExternalToolsConfiguration>();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            IExternalToolsConfiguration config = (IExternalToolsConfiguration)item.getData();
            configsWorkingCopy.add(config);
            ++n2;
        }
        try {
            ExternalToolsModelManager.getInstance().saveBuilderConfigs(this.getProject(), configsWorkingCopy, this.fOriginalConfigs);
        }
        catch (CoreException e) {
            DVTExceptionHandler.handle(e, this.getShell(), this.getTitle(), "Error occured during external builder save. Please see .log file for more details.");
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            ErrorDialog.openError((Shell)this.getShell(), (String)this.getTitle(), (String)"Error occured during external builder save. Please see .log file for more details.", (IStatus)Status.OK_STATUS);
        }
        return super.performOk();
    }

    public boolean performCancel() {
        return super.performCancel();
    }

    public Shell getShell() {
        if (this.getControl().isDisposed()) {
            return null;
        }
        return super.getShell();
    }

    private IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }
}

