/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.debug.internal.ui.launchConfigurations.EnvironmentVariable;
import org.eclipse.debug.ui.EnvironmentTab;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsReference;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMainTab;
import ro.amiq.dvt.externaltools.ui.ExternalToolsPatternsTab;
import ro.amiq.dvt.ui.DVTImages;

public final class EditBuilderConfiguration
extends TitleAreaDialog {
    private Text fNameLabel;
    private IExternalToolsConfiguration fConfiguration;
    private boolean fEdit;
    private boolean fReadOnly;
    private String fOriginalName;
    private CheckboxTableViewer fViewer;
    private ExternalToolsMainTab fMainTab;
    private ExternalToolsPatternsTab fFilterTab;
    private IProject fProject;
    private ExternalBuildersEnvironmentTab fEnvironmentTab;

    public EditBuilderConfiguration(Shell parentShell, boolean edit, CheckboxTableViewer viewer, IProject project, IExternalToolsConfiguration config) {
        super(parentShell);
        this.setShellStyle(65552);
        this.setTitleImage(DVTImages.imageCache.getImage(DVTImages.EXT_TOOLS_WIZ));
        this.fConfiguration = config;
        this.fEdit = edit;
        this.fViewer = viewer;
        this.fProject = project;
        this.fReadOnly = config instanceof ExternalToolsReference;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.fReadOnly) {
            this.setTitle("View external builder properties");
            this.setMessage("The external builder is defined in a different settings location and referenced in the current project.\nIt can be enabled/disabled from the external builders table but it can't be modified.", 0);
        } else {
            this.setTitle("Edit external builder properties");
            this.setMessage("Please specify the commands the external tool will execute", 0);
        }
        this.createTabs(parent);
        return super.createDialogArea(parent);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.fNameLabel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditBuilderConfiguration.this.checkBuilderName();
            }
        });
        if (this.fEdit) {
            this.fOriginalName = this.fConfiguration.getName();
        }
        this.fNameLabel.setText(this.fConfiguration.getName());
    }

    protected Control createContents(Composite parent) {
        return super.createContents(parent);
    }

    private void createTabs(Composite parent) {
        Group group = new Group(parent, 0);
        GridData gd = new GridData(768);
        GridLayout layout = new GridLayout();
        group.setLayoutData((Object)gd);
        group.setLayout((Layout)layout);
        layout.numColumns = 2;
        Label label = new Label((Composite)group, 0);
        label.setText("Name:");
        label.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        label.setFont(parent.getFont());
        this.fNameLabel = new Text((Composite)group, 2048);
        this.fNameLabel.setLayoutData((Object)new GridData(4, 0, true, false, 1, 2));
        this.fNameLabel.setFont(parent.getFont());
        TabFolder tabFolder = new TabFolder(parent, 128);
        gd = new GridData(1808);
        tabFolder.setLayoutData((Object)gd);
        tabFolder.setFont(parent.getFont());
        Composite tabComposite = new Composite((Composite)tabFolder, 4);
        layout = new GridLayout();
        gd = new GridData(1808);
        tabComposite.setLayoutData((Object)gd);
        tabComposite.setFont(parent.getFont());
        tabComposite.setLayout((Layout)layout);
        this.fMainTab = new ExternalToolsMainTab(this, parent.getShell());
        this.fMainTab.createControl(tabComposite);
        this.fMainTab.setDefaults(this.fConfiguration);
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Main");
        tabItem.setImage(this.fMainTab.getImage());
        tabItem.setControl((Control)tabComposite);
        tabComposite = new Composite((Composite)tabFolder, 0);
        layout = new GridLayout();
        gd = new GridData(1808);
        tabComposite.setLayoutData((Object)gd);
        tabComposite.setFont(parent.getFont());
        tabComposite.setLayout((Layout)layout);
        this.fFilterTab = new ExternalToolsPatternsTab(this, parent.getShell());
        this.fFilterTab.createControl(tabComposite);
        this.fFilterTab.setDefaults(this.fProject, this.fConfiguration);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Filters");
        tabItem.setImage(this.fFilterTab.getImage());
        tabItem.setControl((Control)tabComposite);
        try {
            if (this.fProject.hasNature("ro.amiq.vlogdt.VlogNature")) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.external_builder");
            }
        }
        catch (Exception exception) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.edt.help.external_builder");
        }
        tabComposite = new Composite((Composite)tabFolder, 0);
        layout = new GridLayout();
        gd = new GridData(1808);
        tabComposite.setLayoutData((Object)gd);
        tabComposite.setFont(parent.getFont());
        tabComposite.setLayout((Layout)layout);
        this.fEnvironmentTab = new ExternalBuildersEnvironmentTab();
        this.fEnvironmentTab.createControl(tabComposite);
        this.fEnvironmentTab.initializeFrom(this.fConfiguration);
        tabItem = new TabItem(tabFolder, 0);
        tabItem.setText("Environment");
        tabItem.setImage(this.fEnvironmentTab.getImage());
        tabItem.setControl((Control)tabComposite);
        if (this.fReadOnly) {
            this.setEnabledAll((Control)parent, false);
        }
    }

    private void setEnabledAll(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                this.setEnabledAll(c, enabled);
                ++n2;
            }
        } else {
            control.setEnabled(enabled);
        }
    }

    protected void checkBuilderName() {
        if (this.fReadOnly) {
            return;
        }
        String name = this.fNameLabel.getText().trim();
        Button okButton = this.getButton(0);
        if (this.fEdit && this.fOriginalName.equals(name)) {
            this.setMessage("Please specify the commands the external tool will execute");
            this.setErrorMessage(null);
            okButton.setEnabled(true);
        } else if (name.length() == 0) {
            this.setMessage(null);
            this.setErrorMessage("A name is required for the configuration");
            okButton.setEnabled(false);
        } else {
            Table builderTable = this.fViewer.getTable();
            TableItem[] items = builderTable.getItems();
            ArrayList<IExternalToolsConfiguration> builderConfigs = new ArrayList<IExternalToolsConfiguration>();
            TableItem[] tableItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                IExternalToolsConfiguration config = (IExternalToolsConfiguration)item.getData();
                builderConfigs.add(config);
                ++n2;
            }
            if (ExternalToolsModelManager.getInstance().getBuilderForName(builderConfigs, name) != null) {
                this.setMessage(null);
                this.setErrorMessage("A configuration with this name already exists");
                okButton.setEnabled(false);
            } else {
                this.setMessage("Please specify the commands the external tool will execute");
                this.setErrorMessage(null);
                okButton.setEnabled(true);
            }
        }
    }

    public Button getButton(int id) {
        return super.getButton(id);
    }

    protected void okPressed() {
        this.fConfiguration.setName(this.fNameLabel.getText().trim());
        this.fMainTab.performApply(this.fConfiguration);
        this.fFilterTab.performApply(this.fConfiguration);
        this.fEnvironmentTab.performApply(this.fConfiguration);
        super.okPressed();
    }

    static class ExternalBuildersEnvironmentTab
    extends EnvironmentTab {
        protected void createEnvironmentTable(Composite parent) {
            super.createEnvironmentTable(parent);
            this.environmentTable.setContentProvider((IContentProvider)new ExtBuildersEnvTabContentProvider());
        }

        protected void updateEnvironment(IExternalToolsConfiguration configuration) {
            this.environmentTable.setInput((Object)configuration);
        }

        public void setDefaults(IExternalToolsConfiguration configuration) {
            configuration.removeAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES");
        }

        public void initializeFrom(IExternalToolsConfiguration configuration) {
            boolean append = true;
            try {
                append = configuration.getAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES", true);
            }
            catch (Exception exception) {}
            if (append) {
                this.appendEnvironment.setSelection(true);
                this.replaceEnvironment.setSelection(false);
            } else {
                this.replaceEnvironment.setSelection(true);
                this.appendEnvironment.setSelection(false);
            }
            this.updateEnvironment(configuration);
            this.updateAppendReplace();
        }

        public void performApply(IExternalToolsConfiguration configuration) {
            TableItem[] items = this.environmentTable.getTable().getItems();
            HashMap<String, String> map = new HashMap<String, String>(items.length);
            int i = 0;
            while (i < items.length) {
                EnvironmentVariable variable = (EnvironmentVariable)items[i].getData();
                map.put(variable.getName(), variable.getValue());
                ++i;
            }
            configuration.setAttribute("ATTR_ENVIRONMENT_VARIABLES", map.size() > 0 ? map : null);
            configuration.setAttribute("ATTR_APPEND_ENVIRONMENT_VARIABLES", this.appendEnvironment.getSelection());
        }

        static class ExtBuildersEnvTabContentProvider
        implements IStructuredContentProvider {
            ExtBuildersEnvTabContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                Map m;
                Object[] elements = new EnvironmentVariable[]{};
                IExternalToolsConfiguration config = (IExternalToolsConfiguration)inputElement;
                try {
                    m = config.getAttribute("ATTR_ENVIRONMENT_VARIABLES", (Map)null);
                }
                catch (Exception exception) {
                    return elements;
                }
                if (m != null && !m.isEmpty()) {
                    elements = new EnvironmentVariable[m.size()];
                    String[] varNames = new String[m.size()];
                    m.keySet().toArray(varNames);
                    int i = 0;
                    while (i < m.size()) {
                        elements[i] = new EnvironmentVariable(varNames[i], (String)m.get(varNames[i]));
                        ++i;
                    }
                }
                return elements;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (newInput == null) {
                    return;
                }
                if (viewer instanceof TableViewer) {
                    TableViewer tableViewer = (TableViewer)viewer;
                    if (tableViewer.getTable().isDisposed()) {
                        return;
                    }
                    tableViewer.setComparator(new ViewerComparator(){

                        public int compare(Viewer iviewer, Object e1, Object e2) {
                            if (e1 == null) {
                                return -1;
                            }
                            if (e2 == null) {
                                return 1;
                            }
                            return ((EnvironmentVariable)e1).getName().compareToIgnoreCase(((EnvironmentVariable)e2).getName());
                        }
                    });
                }
            }
        }
    }
}

