/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.pattern.DVTHyperlinkCommand;
import ro.amiq.dvt.externaltools.pattern.PatternBuffer;
import ro.amiq.dvt.externaltools.pattern.PatternContextType;
import ro.amiq.dvt.externaltools.pattern.PatternContextTypeRegistry;
import ro.amiq.dvt.externaltools.pattern.PatternContributionContextTypeRegistry;
import ro.amiq.dvt.externaltools.pattern.PatternException;
import ro.amiq.dvt.externaltools.pattern.PatternTranslator;
import ro.amiq.dvt.externaltools.pattern.PatternVariable;
import ro.amiq.dvt.externaltools.pattern.PatternVariableProcessor;
import ro.amiq.dvt.externaltools.pattern.StatusInfo;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.preferences.PrefConst;

public final class EditBuilderPatternDialog
extends StatusDialog {
    private final ExternalToolsPattern fOriginalConvention;
    private Text fNameText;
    private Text fDescriptionText;
    private Combo fTypeCombo;
    private SourceViewer fPatternEditor;
    private Button fEnabledCheckbox;
    private Button fInsertVariableButton;
    private boolean fIsNameModifiable;
    private StatusInfo fValidationStatus;
    private boolean fSuppressError = true;
    private Map<String, TextViewerAction> fGlobalActions = new HashMap<String, TextViewerAction>(10);
    private List<String> fSelectionActions = new ArrayList<String>(3);
    private PatternContextTypeRegistry fContextTypeRegistry;
    private ExternalToolsPattern fNewBuilderFilterPattern;
    private final PatternVariableProcessor fVariableProcessor = new PatternVariableProcessor();
    private Pattern fPattern;
    private HashMap<String, Integer> fVariablesMap;
    private HashMap<String, DVTHyperlinkCommand> fHyperlinkCommandsMap;
    private IExternalToolsConfiguration fConfiguration;
    private boolean fEdit;

    public EditBuilderPatternDialog(Shell parent, ExternalToolsPattern filterPattern, boolean edit, boolean isNameModifiable, PatternContextTypeRegistry registry, IExternalToolsConfiguration configuration) {
        super(parent);
        this.fEdit = edit;
        this.fConfiguration = configuration;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        String title = edit ? ExternalToolsMessages.EditRuleDialog_title_edit : ExternalToolsMessages.EditRuleDialog_title_new;
        this.setTitle(title);
        this.fOriginalConvention = filterPattern;
        this.fPattern = filterPattern.getPattern();
        this.fVariablesMap = filterPattern.getVariablesMap();
        this.fHyperlinkCommandsMap = filterPattern.getHyperlinkCommandsMap();
        this.fIsNameModifiable = isNameModifiable;
        this.fValidationStatus = new StatusInfo();
        this.fContextTypeRegistry = registry;
        PatternContextType type = this.fContextTypeRegistry.getContextType(filterPattern.getKind());
        if (type == null) {
            PatternContextType pct = PatternContributionContextTypeRegistry.createContextType(filterPattern.getKind());
            registry.addContextType(pct);
        }
        type = this.fContextTypeRegistry.getContextType(filterPattern.getKind());
        this.fVariableProcessor.setKind(type);
    }

    public void create() {
        boolean valid;
        super.create();
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            StatusInfo status = new StatusInfo();
            status.setError(ExternalToolsMessages.EditRuleDialog_error_noname);
            this.updateButtonsEnableState(status);
        }
    }

    protected Control createDialogArea(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditBuilderPatternDialog.this.doTextWidgetChanged(e.widget);
            }
        };
        if (this.fIsNameModifiable) {
            EditBuilderPatternDialog.createLabel(parent, ExternalToolsMessages.EditRuleDialog_name);
            Composite composite1 = new Composite(parent, 0);
            composite1.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite1.setLayout((Layout)layout);
            this.fNameText = EditBuilderPatternDialog.createText(composite1);
            this.fNameText.addModifyListener(listener);
            this.fNameText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                }

                public void focusLost(FocusEvent e) {
                    if (EditBuilderPatternDialog.this.fSuppressError) {
                        EditBuilderPatternDialog.this.fSuppressError = false;
                        EditBuilderPatternDialog.this.updateButtons();
                    }
                }
            });
            EditBuilderPatternDialog.createLabel(parent, ExternalToolsMessages.EditRuleDialog_type);
            Composite composite2 = new Composite(parent, 0);
            composite2.setLayoutData((Object)new GridData(768));
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            composite2.setLayout((Layout)layout);
            this.fTypeCombo = new Combo(composite2, 8);
            int i = 0;
            while (i < PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE.length) {
                this.fTypeCombo.add(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[i]);
                ++i;
            }
            this.fTypeCombo.select(0);
            this.fTypeCombo.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    EditBuilderPatternDialog.this.fValidationStatus.setOK();
                    EditBuilderPatternDialog.this.updateButtons();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
            this.fEnabledCheckbox = EditBuilderPatternDialog.createCheckbox(composite2, ExternalToolsMessages.EditRuleDialog_enabled);
            this.fEnabledCheckbox.setSelection(this.fOriginalConvention.getEnabled());
        }
        EditBuilderPatternDialog.createLabel(parent, ExternalToolsMessages.EditRuleDialog_description);
        int descFlags = this.fIsNameModifiable ? 2048 : 2056;
        this.fDescriptionText = new Text(parent, descFlags);
        this.fDescriptionText.setLayoutData((Object)new GridData(768));
        Label patternLabel = EditBuilderPatternDialog.createLabel(parent, ExternalToolsMessages.EditRuleDialog_pattern);
        patternLabel.setLayoutData((Object)new GridData(2));
        this.fPatternEditor = this.createEditor(parent, this.fOriginalConvention.getPatternString());
        Label filler = new Label(parent, 0);
        filler.setLayoutData((Object)new GridData());
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData());
        this.fInsertVariableButton = new Button(composite, 0);
        this.fInsertVariableButton.setLayoutData((Object)EditBuilderPatternDialog.getButtonGridData(this.fInsertVariableButton));
        this.fInsertVariableButton.setText(ExternalToolsMessages.EditRuleDialog_insert_variable);
        this.fInsertVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StyledText text = EditBuilderPatternDialog.this.fPatternEditor.getTextWidget();
                text.setFocus();
                EditBuilderPatternDialog.this.fPatternEditor.doOperation(13);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.fDescriptionText.setText(this.fOriginalConvention.getDescription());
        if (this.fIsNameModifiable) {
            this.fNameText.setText(this.fOriginalConvention.getName());
            this.fNameText.addModifyListener(listener);
            this.fTypeCombo.select(this.getPriorityIndex(this.fOriginalConvention.getType()));
        } else {
            this.fPatternEditor.getControl().setFocus();
        }
        this.initializeActions();
        EditBuilderPatternDialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "ro.amiq.vlogdt.help.external_builder_filter");
        return parent;
    }

    private void doTextWidgetChanged(Widget w) {
        if (w == this.fNameText) {
            if (this.fNameText.getText().length() == 0) {
                this.fSuppressError = true;
            } else {
                this.fSuppressError = false;
                this.updateButtons();
            }
        }
    }

    private String getName() {
        if (this.fNameText != null && !this.fNameText.isDisposed()) {
            return this.fNameText.getText();
        }
        return this.fOriginalConvention.getName();
    }

    private boolean getEnabled() {
        if (this.fEnabledCheckbox != null) {
            return this.fEnabledCheckbox.getSelection();
        }
        return this.fOriginalConvention.getEnabled();
    }

    private String getContextId() {
        return this.fOriginalConvention.getKind();
    }

    private String getKind() {
        return this.fOriginalConvention.getKind();
    }

    private String getPriority() {
        if (this.fTypeCombo != null && !this.fTypeCombo.isDisposed()) {
            return this.fTypeCombo.getText();
        }
        return this.fOriginalConvention.getType();
    }

    private void doSourceChanged(IDocument document) {
        String text = document.get();
        this.fValidationStatus.setOK();
        PatternContextType contextType = this.fContextTypeRegistry.getContextType(this.getContextId());
        if (contextType != null) {
            try {
                contextType.validate(text);
                this.fPattern = contextType.getCompiledPattern();
                this.fVariablesMap = contextType.getVariablesMap();
                this.fHyperlinkCommandsMap = contextType.getHyperlinkCommandsMap();
            }
            catch (PatternException e) {
                this.fValidationStatus.setError(e.getLocalizedMessage());
            }
        }
        this.updateUndoAction();
        this.updateButtons();
    }

    private static Label createLabel(Composite parent, String name) {
        Label label = new Label(parent, 0);
        label.setText(name);
        label.setLayoutData((Object)new GridData());
        return label;
    }

    private static Text createText(Composite parent) {
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private static Button createCheckbox(Composite parent, String name) {
        Button button = new Button(parent, 32);
        button.setText(name);
        button.setLayoutData((Object)new GridData());
        return button;
    }

    private static GridData getButtonGridData(Button button) {
        GridData data = new GridData(768);
        return data;
    }

    private SourceViewer createEditor(Composite parent, String pattern) {
        SourceViewer viewer = this.createViewer(parent);
        Document document = new Document(pattern);
        viewer.setEditable(true);
        viewer.setDocument((IDocument)document);
        int nLines = document.getNumberOfLines();
        if (nLines < 5) {
            nLines = 5;
        } else if (nLines > 12) {
            nLines = 12;
        }
        Control control = viewer.getControl();
        GridData data = new GridData(1808);
        data.widthHint = this.convertWidthInCharsToPixels(80);
        data.heightHint = this.convertHeightInCharsToPixels(nLines);
        control.setLayoutData((Object)data);
        viewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (event.getDocumentEvent() != null) {
                    EditBuilderPatternDialog.this.doSourceChanged(event.getDocumentEvent().getDocument());
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EditBuilderPatternDialog.this.updateSelectionDependentActions();
            }
        });
        viewer.prependVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                EditBuilderPatternDialog.this.handleVerifyKeyPressed(event);
            }
        });
        return viewer;
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration(){

            public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
                ContentAssistant assistant = new ContentAssistant();
                assistant.enableAutoActivation(true);
                assistant.enableAutoInsert(true);
                assistant.setContentAssistProcessor((IContentAssistProcessor)EditBuilderPatternDialog.this.fVariableProcessor, "__dftl_partition_content_type");
                return assistant;
            }
        };
        viewer.configure(configuration);
        return viewer;
    }

    private void handleVerifyKeyPressed(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (event.stateMask != SWT.MOD1) {
            return;
        }
        switch (event.character) {
            case ' ': {
                this.fPatternEditor.doOperation(13);
                event.doit = false;
                break;
            }
            case '\u001a': {
                this.fPatternEditor.doOperation(1);
                event.doit = false;
            }
        }
    }

    private void initializeActions() {
        TextViewerAction action = new TextViewerAction((ITextViewer)this.fPatternEditor, 1);
        action.setText(ExternalToolsMessages.EditRuleDialog_undo);
        this.fGlobalActions.put(ITextEditorActionConstants.UNDO, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 3);
        action.setText(ExternalToolsMessages.EditRuleDialog_cut);
        this.fGlobalActions.put(ITextEditorActionConstants.CUT, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 4);
        action.setText(ExternalToolsMessages.EditRuleDialog_copy);
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 5);
        action.setText(ExternalToolsMessages.EditRuleDialog_paste);
        this.fGlobalActions.put(ITextEditorActionConstants.PASTE, action);
        action = new TextViewerAction((ITextViewer)this.fPatternEditor, 7);
        action.setText(ExternalToolsMessages.EditRuleDialog_select_all);
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        this.fSelectionActions.add(ITextEditorActionConstants.CUT);
        this.fSelectionActions.add(ITextEditorActionConstants.COPY);
        this.fSelectionActions.add(ITextEditorActionConstants.PASTE);
        MenuManager manager = new MenuManager(null, null);
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EditBuilderPatternDialog.this.fillContextMenu(mgr);
            }
        });
        StyledText text = this.fPatternEditor.getTextWidget();
        Menu menu = manager.createContextMenu((Control)text);
        text.setMenu(menu);
    }

    private void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new GroupMarker("group.undo"));
        menu.appendToGroup("group.undo", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO));
        menu.add((IContributionItem)new Separator("group.edit"));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.CUT));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.PASTE));
        menu.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        menu.add((IContributionItem)new Separator("patterns"));
        menu.appendToGroup("patterns", (IAction)this.fGlobalActions.get("ContentAssistProposal"));
    }

    private void updateSelectionDependentActions() {
        Iterator<String> iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction(iterator.next());
        }
    }

    private void updateUndoAction() {
        IAction action = (IAction)this.fGlobalActions.get(ITextEditorActionConstants.UNDO);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    private int getPriorityIndex(String priority) {
        if (priority == null) {
            return -1;
        }
        int i = 0;
        while (i < PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE.length) {
            if (priority.equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void updateButtons() {
        StatusInfo status;
        boolean valid;
        boolean bl = valid = this.fNameText == null || this.fNameText.getText().trim().length() != 0;
        if (!valid) {
            status = new StatusInfo();
            if (!this.fSuppressError) {
                status.setError(ExternalToolsMessages.EditRuleDialog_error_noname);
            }
        } else {
            status = this.fValidationStatus;
        }
        this.updateStatus(status);
    }

    protected void okPressed() {
        boolean error = false;
        try {
            ExternalToolsPattern userDefPattern = ExternalToolsUtil.findUserDefPattern(this.fNameText.getText(), this.fConfiguration);
            ExternalToolsPattern predefPattern = ExternalToolsUtil.findPredefPattern(this.fNameText.getText());
            if (this.fEdit) {
                if (predefPattern != null || userDefPattern != null && !userDefPattern.getName().equals(this.fOriginalConvention.getName())) {
                    error = true;
                }
            } else if (userDefPattern != null || predefPattern != null) {
                error = true;
            }
            if (error) {
                StatusInfo status = new StatusInfo();
                status.setError(ExternalToolsMessages.Duplicate_Pattern_error_message);
                this.updateStatus(status);
                return;
            }
            StatusInfo status = null;
            String pattern = this.fPatternEditor.getDocument().get().trim();
            status = this.checkForVariables(pattern, this.fTypeCombo.getText());
            if (status.isError()) {
                this.updateStatus(status);
                return;
            }
            this.fNewBuilderFilterPattern = new ExternalToolsPattern(this.getKind(), this.getName(), this.getPriority(), this.getDescription(), pattern, this.fPattern, this.fVariablesMap, this.fHyperlinkCommandsMap, this.getEnabled());
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        super.okPressed();
    }

    private StatusInfo checkForVariables(String text, String severity) {
        PatternContextType contextType = this.fContextTypeRegistry.getContextType(this.getContextId());
        StatusInfo result = new StatusInfo(0, null);
        if (contextType != null) {
            try {
                PatternTranslator translator = new PatternTranslator();
                PatternBuffer buffer = translator.translate(text);
                PatternVariable[] vars = buffer.getVariables();
                int hasFile = 0;
                int hasLine = 0;
                int hasMessage = 0;
                int hasType = 0;
                int hasUrl = 0;
                boolean needMessage = severity.equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[0]) || severity.equals(PrefConst.EXTERNAL_BUILDER_NOTIFICATION_TYPE[1]);
                int i = 0;
                while (i < vars.length) {
                    PatternVariable variable = vars[i];
                    if (variable.getName().equals("file")) {
                        ++hasFile;
                    } else if (variable.getName().equals("type")) {
                        ++hasType;
                    } else if (variable.getName().equals("line")) {
                        ++hasLine;
                    } else if (variable.getName().equals("message") || variable.getName().equals("message_g") || variable.getName().equals("message_sl")) {
                        ++hasMessage;
                    } else if (variable.getName().equals("url")) {
                        ++hasUrl;
                    }
                    ++i;
                }
                if (hasLine > 1) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Multiple_Variable_in_filter__1, "${line}"));
                } else if (hasFile > 1) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Multiple_Variable_in_filter__1, "${file}"));
                } else if (hasMessage > 1) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Multiple_Variable_in_filter__1, "${message}, ${message_g} or ${message_sl}"));
                } else if (hasType > 1) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Multiple_Variable_in_filter__1, "${type}"));
                } else if (hasLine == 0 && needMessage) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Missing_Variables_in_filter__1, "${line}"));
                } else if (hasUrl > 1) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Multiple_Variable_in_filter__1, "${url}"));
                } else if (hasFile == 0 && needMessage) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Missing_Variables_in_filter__1, "${file}"));
                } else if (hasMessage == 0 && needMessage) {
                    result.setError(MessageFormat.format(ExternalToolsMessages.Missing_Variables_in_filter__1, "${message}, ${message_g} or ${message_sl}"));
                }
                return result;
            }
            catch (PatternException e) {
                this.fValidationStatus.setError(e.getLocalizedMessage());
            }
        }
        result.setError("");
        return result;
    }

    private String getDescription() {
        return this.fDescriptionText.getText();
    }

    public ExternalToolsPattern getBuilderFilterPattern() {
        return this.fNewBuilderFilterPattern;
    }

    private static class TextViewerAction
    extends Action
    implements IUpdate {
        private int fOperationCode = -1;
        private ITextOperationTarget fOperationTarget;

        public TextViewerAction(ITextViewer viewer, int operationCode) {
            this.fOperationCode = operationCode;
            this.fOperationTarget = viewer.getTextOperationTarget();
            this.update();
        }

        public void update() {
            boolean wasEnabled = this.isEnabled();
            boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(this.fOperationCode);
            this.setEnabled(isEnabled);
            if (wasEnabled != isEnabled) {
                this.firePropertyChange("enabled", wasEnabled ? Boolean.TRUE : Boolean.FALSE, isEnabled ? Boolean.TRUE : Boolean.FALSE);
            }
        }

        public void run() {
            if (this.fOperationCode != -1 && this.fOperationTarget != null) {
                this.fOperationTarget.doOperation(this.fOperationCode);
            }
        }
    }
}

