/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.ui;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import ro.amiq.dvt.ui.utils.DVTColorUtil;

public class ErrorIdMessageDialog
extends MessageDialog {
    private Text fText;
    private String fMessage;
    private String fCommandId;

    public ErrorIdMessageDialog(String commandId) {
        super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Error ID info", null, "", 0, new String[]{IDialogConstants.OK_LABEL}, 0);
        this.fCommandId = commandId;
        BusyIndicator.showWhile((Display)PlatformUI.getWorkbench().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    Process process = Runtime.getRuntime().exec(ErrorIdMessageDialog.this.fCommandId);
                    StringBuilder sb = new StringBuilder();
                    InputStream in = process.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    in.close();
                    in = process.getErrorStream();
                    br = new BufferedReader(new InputStreamReader(in));
                    while ((line = br.readLine()) != null) {
                        sb.append(String.valueOf(line) + "\n");
                    }
                    in.close();
                    ErrorIdMessageDialog.this.fMessage = sb.toString();
                }
                catch (Exception e) {
                    ErrorIdMessageDialog.this.fMessage = "Cannot run: " + ErrorIdMessageDialog.this.fCommandId + "\n\ndue to\n\n" + e.getMessage() + "\n\nPlease check that you can run it in the shell where you started DVT.";
                }
            }
        });
    }

    protected Control createCustomArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Text titleText = new Text(composite, 72);
        titleText.setEditable(false);
        DVTColorUtil.INSTANCE.setBackground((Control)titleText, DVTColorUtil.INSTANCE.getBackground((Control)composite), true);
        titleText.setText("Output of: " + this.fCommandId);
        this.fText = new Text(composite, 2120);
        this.fText.setEditable(false);
        this.fText.setText(this.fMessage);
        return composite;
    }

    protected Control createMessageArea(Composite composite) {
        return composite;
    }
}

