/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.ui;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ui.EditBuilderConfiguration;
import ro.amiq.dvt.externaltools.ui.ExternalToolsAbstractTab;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.DVTImages;

public final class ExternalToolsMainTab
extends ExternalToolsAbstractTab {
    protected Text fWorkDirectoryField;
    protected Button fFileWorkDirectoryButton;
    protected Button fWorkspaceWorkDirectoryButton;
    protected Button fVariablesWorkDirectoryButton;
    protected Text fFullField;
    protected Button fFullVariablesButton;
    protected Text fCleanField;
    protected Button fCleanVariablesButton;
    protected Text fAutoField;
    protected Button fAutoVariablesButton;
    protected SelectionAdapter fSelectionAdapter;
    protected WidgetListener fListener = new WidgetListener();
    private EditBuilderConfiguration fParentDialog;

    public ExternalToolsMainTab(EditBuilderConfiguration parentDialog, Shell parentShell) {
        super(parentShell);
        this.fParentDialog = parentDialog;
    }

    public void createControl(Composite parent) {
        this.createFullComponent(parent);
        this.createAutoComponent(parent);
        this.createCleanComponent(parent);
        this.createWorkDirectoryComponent(parent);
        ExternalToolsMainTab.createVerticalSpacer(parent, 1);
        Dialog.applyDialogFont((Control)parent);
    }

    protected String getLocationLabel() {
        return ExternalToolsMessages.ExternalToolsMainTab__Location___2;
    }

    protected void createWorkDirectoryComponent(Composite parent) {
        Group group = new Group(parent, 0);
        String groupName = ExternalToolsMessages.ExternalToolsMainTab_Working__Directory__5;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fWorkDirectoryField = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.widthHint = 200;
        this.fWorkDirectoryField.setLayoutData((Object)data);
        this.fWorkDirectoryField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fWorkDirectoryField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        gridData = new GridData(128);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fWorkspaceWorkDirectoryButton = ExternalToolsMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_Wor_kspace____6);
        this.fWorkspaceWorkDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fWorkspaceWorkDirectoryButton, String.valueOf(group.getText()) + " " + this.fWorkspaceWorkDirectoryButton.getText());
        this.fFileWorkDirectoryButton = ExternalToolsMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_Browse_F_ile_System____7);
        this.fFileWorkDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fFileWorkDirectoryButton, String.valueOf(group.getText()) + " " + this.fFileWorkDirectoryButton.getText());
        this.fVariablesWorkDirectoryButton = ExternalToolsMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_32);
        this.fVariablesWorkDirectoryButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fVariablesWorkDirectoryButton, String.valueOf(group.getText()) + " " + this.fVariablesWorkDirectoryButton.getText());
    }

    protected void createFullComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ExternalToolsMessages.ExternalToolsMainTab_Full);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fFullField = new Text((Composite)group, 2626);
        gridData = new GridData(1808);
        gridData.heightHint = 50;
        gridData.widthHint = 200;
        this.fFullField.setLayoutData((Object)gridData);
        this.fFullField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fFullField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        gridData = new GridData(130);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fFullVariablesButton = ExternalToolsMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_31);
        this.fFullVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fFullVariablesButton, String.valueOf(group.getText()) + " " + this.fFullVariablesButton.getText());
    }

    protected void createAutoComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ExternalToolsMessages.ExternalToolsMainTab_Auto);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fAutoField = new Text((Composite)group, 2626);
        gridData = new GridData(1808);
        gridData.heightHint = 50;
        gridData.widthHint = 200;
        this.fAutoField.setLayoutData((Object)gridData);
        this.fAutoField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fAutoField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        gridData = new GridData(130);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fAutoVariablesButton = ExternalToolsMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_31);
        this.fAutoVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fAutoVariablesButton, String.valueOf(group.getText()) + " " + this.fAutoVariablesButton.getText());
    }

    protected void createCleanComponent(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(ExternalToolsMessages.ExternalToolsMainTab_Clean);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        this.fCleanField = new Text((Composite)group, 2626);
        gridData = new GridData(1808);
        gridData.heightHint = 50;
        gridData.widthHint = 200;
        this.fCleanField.setLayoutData((Object)gridData);
        this.fCleanField.addModifyListener((ModifyListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fCleanField, group.getText());
        Composite buttonComposite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        gridData = new GridData(130);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setFont(parent.getFont());
        this.fCleanVariablesButton = ExternalToolsMainTab.createPushButton(buttonComposite, ExternalToolsMessages.ExternalToolsMainTab_31);
        this.fCleanVariablesButton.addSelectionListener((SelectionListener)this.fListener);
        this.addControlAccessibleListener((Control)this.fCleanVariablesButton, String.valueOf(group.getText()) + " " + this.fCleanVariablesButton.getText());
    }

    public void setDefaults(IExternalToolsConfiguration config) {
        this.fAutoField.setText(config.getAutoCommand());
        this.fFullField.setText(config.getFullCommand());
        this.fCleanField.setText(config.getCleanCommand());
        this.fWorkDirectoryField.setText(config.getWorkingDir());
    }

    public void performApply(IExternalToolsConfiguration config) {
        config.setAutoCommand(this.fAutoField.getText());
        config.setFullCommand(this.fFullField.getText());
        config.setCleanCommand(this.fCleanField.getText());
        config.setWorkingDir(this.fWorkDirectoryField.getText());
    }

    public String getName() {
        return ExternalToolsMessages.ExternalToolsMainTab__Main_17;
    }

    private boolean isValid() {
        this.setErrorMessage(null);
        this.setMessage(null);
        return this.validateWorkDirectory();
    }

    private void validateVaribles(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        manager.validateStringVariables(expression);
    }

    private String resolveValue(String expression) throws CoreException {
        String expanded = null;
        try {
            expanded = this.getValue(expression);
        }
        catch (CoreException coreException) {
            this.validateVaribles(expression);
            return null;
        }
        return expanded;
    }

    private String getValue(String expression) throws CoreException {
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        return manager.performStringSubstitution(expression);
    }

    protected boolean validateWorkDirectory() {
        String dir = this.fWorkDirectoryField.getText().trim();
        if (dir.length() <= 0) {
            return false;
        }
        String expandedDir = null;
        try {
            expandedDir = this.resolveValue(dir);
            if (expandedDir == null) {
                return true;
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getStatus().getMessage());
            return false;
        }
        File file = new File(expandedDir);
        if (!file.exists()) {
            this.setErrorMessage(ExternalToolsMessages.ExternalToolsMainTab_External_tool_working_directory_does_not_exist_or_is_invalid_21);
            return false;
        }
        if (!file.isDirectory()) {
            this.setErrorMessage(ExternalToolsMessages.ExternalToolsMainTab_Not_a_directory);
            return false;
        }
        return true;
    }

    protected void handleWorkspaceWorkingDirectoryButtonSelected() {
        ContainerSelectionDialog containerDialog = new ContainerSelectionDialog(this.getParentShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, ExternalToolsMessages.ExternalToolsMainTab_23);
        containerDialog.open();
        Object[] resource = containerDialog.getResult();
        String text = null;
        if (resource != null && resource.length > 0) {
            text = this.newVariableExpression("workspace_loc", ((IPath)resource[0]).toOSString());
        }
        if (text != null) {
            this.fWorkDirectoryField.setText(text);
        }
    }

    protected String newVariableExpression(String varName, String arg) {
        return VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression(varName, arg);
    }

    protected void handleFileWorkingDirectoryButtonSelected() {
        String text;
        DirectoryDialog dialog = new DirectoryDialog(this.getParentShell(), 8192);
        dialog.setMessage(ExternalToolsMessages.ExternalToolsMainTab_23);
        try {
            if (this.fWorkDirectoryField.getText().length() != 0) {
                dialog.setFilterPath(this.resolveValue(this.fWorkDirectoryField.getText()));
            }
        }
        catch (CoreException e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        if ((text = dialog.open()) != null) {
            this.fWorkDirectoryField.setText(text);
        }
    }

    private void handleVariablesButtonSelected(Text textField) {
        String variable = this.getVariable();
        if (variable != null) {
            textField.insert(variable);
        }
    }

    private String getVariable() {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getParentShell());
        dialog.open();
        return dialog.getVariableExpression();
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.DESC_LAUNCH_MAIN_TAB);
    }

    public void addControlAccessibleListener(Control control, String controlName) {
        String[] strs = controlName.split("&");
        StringBuilder stripped = new StringBuilder();
        int i = 0;
        while (i < strs.length) {
            stripped.append(strs[i]);
            ++i;
        }
        control.getAccessible().addAccessibleListener((AccessibleListener)new ControlAccessibleListener(stripped.toString()));
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.fParentDialog.setErrorMessage(errorMessage);
    }

    @Override
    protected void setMessage(String message) {
        this.fParentDialog.setMessage(message);
    }

    private static class ControlAccessibleListener
    extends AccessibleAdapter {
        private String controlName;

        ControlAccessibleListener(String name) {
            this.controlName = name;
        }

        public void getName(AccessibleEvent e) {
            e.result = this.controlName;
        }
    }

    protected class WidgetListener
    extends SelectionAdapter
    implements ModifyListener {
        protected WidgetListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ExternalToolsMainTab.this.fWorkDirectoryField.getText().trim().length() > 0) {
                Button okButton = ExternalToolsMainTab.this.fParentDialog.getButton(0);
                if (okButton != null && !okButton.isDisposed()) {
                    okButton.setEnabled(ExternalToolsMainTab.this.isValid());
                } else {
                    ExternalToolsMainTab.this.isValid();
                }
            }
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == ExternalToolsMainTab.this.fVariablesWorkDirectoryButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.fWorkDirectoryField);
            } else if (source == ExternalToolsMainTab.this.fFileWorkDirectoryButton) {
                ExternalToolsMainTab.this.handleFileWorkingDirectoryButtonSelected();
            } else if (source == ExternalToolsMainTab.this.fWorkspaceWorkDirectoryButton) {
                ExternalToolsMainTab.this.handleWorkspaceWorkingDirectoryButtonSelected();
            } else if (source == ExternalToolsMainTab.this.fFullVariablesButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.fFullField);
            } else if (source == ExternalToolsMainTab.this.fAutoVariablesButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.fAutoField);
            } else if (source == ExternalToolsMainTab.this.fCleanVariablesButton) {
                ExternalToolsMainTab.this.handleVariablesButtonSelected(ExternalToolsMainTab.this.fCleanField);
            }
        }
    }
}

