/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.externaltools.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import ro.amiq.dvt.externaltools.ExternalToolsModelManager;
import ro.amiq.dvt.externaltools.ExternalToolsPattern;
import ro.amiq.dvt.externaltools.ExternalToolsUtil;
import ro.amiq.dvt.externaltools.IExternalToolsConfiguration;
import ro.amiq.dvt.externaltools.ui.EditBuilderPatternDialog;
import ro.amiq.dvt.externaltools.ui.ExternalToolsAbstractTab;
import ro.amiq.dvt.externaltools.ui.ExternalToolsContentProvider;
import ro.amiq.dvt.externaltools.ui.ExternalToolsLabelProvider;
import ro.amiq.dvt.externaltools.ui.ExternalToolsMessages;
import ro.amiq.dvt.ui.DVTImages;

public final class ExternalToolsPatternsTab
extends ExternalToolsAbstractTab {
    private Button[] fSimulatorSelectButtons;
    private CheckboxTableViewer fTableViewer;
    private Button fAddButton;
    private Button fEditButton;
    private Button fRemoveButton;
    private Button fDuplicateButton;
    private SourceViewer fPatternViewer;
    private TitleAreaDialog fParentDialog;
    private SelectionListener fSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.getSource();
            List<Object> newInput = new ArrayList();
            TableItem[] items = ExternalToolsPatternsTab.this.fTableViewer.getTable().getItems();
            if (button.getSelection()) {
                newInput = ExternalToolsUtil.getCategoryPatterns(button.getText());
                int i = 0;
                while (i < items.length) {
                    ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
                    newInput.add(data);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < items.length) {
                    ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
                    if (!data.getKind().equals(button.getText())) {
                        newInput.add(data);
                    }
                    ++i;
                }
            }
            ExternalToolsPatternsTab.this.fTableViewer.setInput(newInput);
            ExternalToolsPatternsTab.this.fTableViewer.setAllChecked(false);
            ExternalToolsPatternsTab.this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
        }
    };
    private IExternalToolsConfiguration fConfiguration;
    private static final Set<String> METH_FILTERS = new HashSet<String>(Arrays.asList("OVM", "UVM", "VMM", "UVVM", "OSVVM"));

    public ExternalToolsPatternsTab(TitleAreaDialog parentDialog, Shell parent) {
        super(parent);
        this.fParentDialog = parentDialog;
    }

    private void addElementTableViewer(ExternalToolsPattern newPattern) {
        ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            newInput.add(data);
            ++i;
        }
        newInput.add(newPattern);
        this.fTableViewer.setInput(newInput);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
    }

    private void deleteElementTableViewer(ExternalToolsPattern pattern) {
        ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            newInput.add(data);
            ++i;
        }
        newInput.remove(pattern);
        this.fTableViewer.setInput(newInput);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
    }

    private void editElementTableViewer(ExternalToolsPattern newPattern, ExternalToolsPattern oldPattern) {
        ArrayList<ExternalToolsPattern> newInput = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            if (!data.equals(oldPattern)) {
                newInput.add(data);
            }
            ++i;
        }
        newInput.add(newPattern);
        this.fTableViewer.setInput(newInput);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(newInput).toArray());
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        GridLayout allLayout = new GridLayout();
        allLayout.marginHeight = 7;
        allLayout.marginWidth = 7;
        allLayout.numColumns = 5;
        GridData allGridData = new GridData(1808);
        mainComposite.setLayout((Layout)allLayout);
        mainComposite.setLayoutData((Object)allGridData);
        mainComposite.setFont(parent.getFont());
        this.createMainCompositeContents(mainComposite);
        Dialog.applyDialogFont((Control)mainComposite);
    }

    private void createMainCompositeContents(Composite allComposite) {
        this.createFilterCategoriesComposite(allComposite);
        this.createFiltersComposite(allComposite);
    }

    private void createFilterCategoriesComposite(Composite allComposite) {
        Group group = new Group(allComposite, 0);
        String groupName = ExternalToolsMessages.ExternalToolsFiterTabCategoryGroupName;
        group.setText(groupName);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(4, 4, true, true, 1, 1);
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gridData);
        String[] filterCategories = ExternalToolsUtil.getFilterCategories();
        ArrayList<String> methFilters = new ArrayList<String>();
        ArrayList<String> simFilters = new ArrayList<String>();
        String[] stringArray = filterCategories;
        int n = filterCategories.length;
        int n2 = 0;
        while (n2 < n) {
            String filterCat = stringArray[n2];
            if (METH_FILTERS.contains(filterCat)) {
                methFilters.add(filterCat);
            } else {
                simFilters.add(filterCat);
            }
            ++n2;
        }
        Collections.sort(methFilters);
        Collections.sort(simFilters);
        this.fSimulatorSelectButtons = new Button[filterCategories.length];
        int i = 0;
        while (i < simFilters.size()) {
            this.fSimulatorSelectButtons[i] = ExternalToolsPatternsTab.createCheckButton((Composite)group, (String)simFilters.get(i));
            this.fSimulatorSelectButtons[i].setSelection(false);
            this.fSimulatorSelectButtons[i].addSelectionListener(this.fSelectionListener);
            ++i;
        }
        new Label((Composite)group, 258).setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        i = 0;
        while (i < methFilters.size()) {
            this.fSimulatorSelectButtons[i + simFilters.size()] = ExternalToolsPatternsTab.createCheckButton((Composite)group, (String)methFilters.get(i));
            this.fSimulatorSelectButtons[i + simFilters.size()].setSelection(false);
            this.fSimulatorSelectButtons[i + simFilters.size()].addSelectionListener(this.fSelectionListener);
            ++i;
        }
    }

    public String getName() {
        return ExternalToolsMessages.ExternalToolsFiterTabName;
    }

    public void performApply(IExternalToolsConfiguration config) {
        ArrayList<String> filterKinds = new ArrayList<String>();
        int i = 0;
        while (i < this.fSimulatorSelectButtons.length) {
            if (this.fSimulatorSelectButtons[i].getSelection()) {
                filterKinds.add(this.fSimulatorSelectButtons[i].getText());
            }
            ++i;
        }
        config.setFilterKinds(filterKinds.toArray(new String[filterKinds.size()]));
        ArrayList<ExternalToolsPattern> patterns = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i2].getData();
            if (ExternalToolsUtil.isUserDefined(data)) {
                patterns.add(data);
            }
            ++i2;
        }
        config.setPatterns(patterns.toArray(new ExternalToolsPattern[patterns.size()]));
    }

    public void setDefaults(IProject project, IExternalToolsConfiguration config) {
        String[] filterKinds = config.getFilterKinds();
        int j = 0;
        while (j < this.fSimulatorSelectButtons.length) {
            String buttonName = this.fSimulatorSelectButtons[j].getText();
            int i = 0;
            while (i < filterKinds.length) {
                if (buttonName.equals(filterKinds[i])) {
                    this.fSimulatorSelectButtons[j].setSelection(true);
                }
                ++i;
            }
            ++j;
        }
        List<ExternalToolsPattern> patterns = ExternalToolsUtil.getPatterns(config);
        this.fTableViewer.setInput(patterns);
        this.fTableViewer.setAllChecked(false);
        this.fTableViewer.setCheckedElements(ExternalToolsUtil.getEnabledPatterns(patterns).toArray());
        this.fConfiguration = config;
    }

    public Image getImage() {
        return DVTImages.imageCache.getImage(DVTImages.IMG_TAB_FILTER);
    }

    private Control createFiltersComposite(Composite allComposite) {
        Composite parent = new Composite(allComposite, 0);
        GridData gridData = new GridData(4, 4, true, true, 4, 1);
        parent.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Composite innerParent = new Composite(parent, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        innerParent.setLayout((Layout)innerLayout);
        GridData gd = new GridData(1808);
        innerParent.setLayoutData((Object)gd);
        Table table = new Table(innerParent, 67618);
        GridData data = new GridData(1808);
        table.setLayoutData((Object)data);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn column1 = new TableColumn(table, 0);
        column1.setText(ExternalToolsMessages.RulePropertyPage_column_name);
        TableColumn column2 = new TableColumn(table, 0);
        column2.setText(ExternalToolsMessages.RulePropertyPage_column_context);
        TableColumn column3 = new TableColumn(table, 0);
        column3.setText(ExternalToolsMessages.RulePropertyPage_column_type);
        this.fTableViewer = new CheckboxTableViewer(table);
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ExternalToolsLabelProvider());
        this.fTableViewer.setContentProvider((IContentProvider)new ExternalToolsContentProvider());
        this.fTableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object object1, Object object2) {
                if (object1 instanceof ExternalToolsPattern && object2 instanceof ExternalToolsPattern) {
                    ExternalToolsPattern left = (ExternalToolsPattern)object1;
                    ExternalToolsPattern right = (ExternalToolsPattern)object2;
                    int result = left.getName().compareToIgnoreCase(right.getName());
                    if (result != 0) {
                        return result;
                    }
                    return left.getDescription().compareToIgnoreCase(right.getDescription());
                }
                return super.compare(viewer, object1, object2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ExternalToolsPatternsTab.this.edit();
            }
        });
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ExternalToolsPatternsTab.this.selectionChanged1();
            }
        });
        this.fTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ExternalToolsPattern d = (ExternalToolsPattern)event.getElement();
                if (ExternalToolsUtil.isUserDefined(d)) {
                    d.setEnabled(event.getChecked());
                } else {
                    ExternalToolsPatternsTab.this.fTableViewer.setChecked(event.getElement(), true);
                    ExternalToolsPatternsTab.this.fTableViewer.refresh();
                    ExternalToolsPatternsTab.this.openReadOnlyPatternDisableErrorDialog();
                }
            }
        });
        Composite buttons = new Composite(innerParent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.fAddButton = ExternalToolsPatternsTab.createPushButton(buttons, "ListEditor.add");
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ExternalToolsPatternsTab.this.add();
            }
        });
        this.fEditButton = ExternalToolsPatternsTab.createPushButton(buttons, "&Edit...");
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ExternalToolsPatternsTab.this.edit();
            }
        });
        this.fRemoveButton = ExternalToolsPatternsTab.createPushButton(buttons, "ListEditor.remove");
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ExternalToolsPatternsTab.this.remove();
            }
        });
        this.fDuplicateButton = ExternalToolsPatternsTab.createPushButton(buttons, "Duplicate...");
        this.fDuplicateButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ExternalToolsPatternsTab.this.duplicate();
            }
        });
        this.createSeparator(buttons);
        this.fPatternViewer = this.doCreateViewer(parent);
        this.updateButtons();
        ExternalToolsPatternsTab.configureTableResizing(table);
        Dialog.applyDialogFont((Control)parent);
        table.getHorizontalBar().setVisible(true);
        return parent;
    }

    private static void configureTableResizing(final Table table) {
        ControlAdapter resizer = new ControlAdapter(){
            private boolean fIsResizing = false;
            private final int[] fWidths = new int[]{340, 160, 160};
            private int fSum = 740;

            public void controlResized(ControlEvent e) {
                if (this.fIsResizing) {
                    return;
                }
                try {
                    this.fIsResizing = true;
                    int clientAreaWidth = table.getClientArea().width;
                    TableColumn[] columns = table.getColumns();
                    int tableWidth = 0;
                    if (e.widget == table) {
                        int toDistribute;
                        int[] initial = new int[]{200, 120, 120};
                        int[] minimums = new int[columns.length];
                        int minSum = 0;
                        int i = 0;
                        while (i < columns.length) {
                            minimums[i] = Math.min(this.fWidths[i], initial[i]);
                            minSum += minimums[i];
                            ++i;
                        }
                        int newWidth = this.fSum < clientAreaWidth ? clientAreaWidth : Math.max(clientAreaWidth, minSum);
                        int lastPart = toDistribute = newWidth - this.fSum;
                        if (toDistribute != 0) {
                            int[] nArray = new int[3];
                            nArray[0] = 2;
                            nArray[1] = 1;
                            int[] iteration = nArray;
                            int i2 = 0;
                            while (i2 < iteration.length) {
                                int width;
                                int c = iteration[i2];
                                if (this.fSum > 0) {
                                    int part = i2 == iteration.length - 1 ? lastPart : toDistribute * this.fWidths[c] / this.fSum;
                                    lastPart -= part;
                                    width = Math.max(minimums[c], this.fWidths[c] + part);
                                } else {
                                    width = toDistribute * initial[c] / 280;
                                }
                                columns[c].setWidth(width);
                                this.fWidths[c] = width;
                                tableWidth += width;
                                ++i2;
                            }
                            this.fSum = tableWidth;
                        }
                    } else {
                        if (e.widget == columns[2]) {
                            return;
                        }
                        int i = 0;
                        while (i < columns.length) {
                            this.fWidths[i] = columns[i].getWidth();
                            tableWidth += this.fWidths[i];
                            ++i;
                        }
                        this.fSum = tableWidth;
                    }
                    table.getHorizontalBar().setVisible(tableWidth > clientAreaWidth);
                }
                finally {
                    this.fIsResizing = false;
                    table.redraw();
                }
            }
        };
        table.addControlListener((ControlListener)resizer);
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].addControlListener((ControlListener)resizer);
            ++i;
        }
    }

    private SourceViewer doCreateViewer(Composite parent) {
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        Label label = new Label(parent, 0);
        label.setText(ExternalToolsMessages.RulePropertyPage_preview);
        label.setLayoutData((Object)data);
        data = new GridData(4, 4, true, true, 2, 1);
        data.heightHint = this.convertHeightInCharsToPixels(3, (Control)parent);
        SourceViewer viewer = this.createViewer(parent);
        viewer.setEditable(false);
        Control control = viewer.getControl();
        control.setLayoutData((Object)data);
        return viewer;
    }

    private int convertHeightInCharsToPixels(int chars, Control control) {
        GC gc = new GC((Drawable)control);
        gc.setFont(JFaceResources.getDialogFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        if (fontMetrics == null) {
            return 0;
        }
        return Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)chars);
    }

    protected SourceViewer createViewer(Composite parent) {
        SourceViewer viewer = new SourceViewer(parent, null, null, false, 2816);
        SourceViewerConfiguration configuration = new SourceViewerConfiguration();
        viewer.configure(configuration);
        Document document = new Document();
        viewer.setDocument((IDocument)document);
        return viewer;
    }

    private void selectionChanged1() {
        this.updateViewerInput();
        this.updateButtons();
    }

    protected void updateViewerInput() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection.size() == 1) {
            ExternalToolsPattern convention = (ExternalToolsPattern)selection.getFirstElement();
            this.fPatternViewer.getDocument().set(convention.getPatternString());
        } else {
            this.fPatternViewer.getDocument().set("");
        }
    }

    protected void updateButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        if (selection == null) {
            return;
        }
        int selectionCount = selection.size();
        int itemCount = this.fTableViewer.getTable().getItemCount();
        boolean canRemove = true;
        boolean canEdit = true;
        for (ExternalToolsPattern data : selection) {
            if (data == null || ExternalToolsUtil.isUserDefined(data)) continue;
            canEdit = false;
            canRemove = false;
            break;
        }
        this.fEditButton.setEnabled(selectionCount == 1 && canEdit);
        this.fRemoveButton.setEnabled(selectionCount > 0 && selectionCount <= itemCount && canRemove);
        this.fDuplicateButton.setEnabled(selectionCount == 1);
    }

    private void add() {
        ExternalToolsPattern convention = new ExternalToolsPattern("User defined", "", "", "", "", null, null, null, true);
        ExternalToolsPattern newConvention = this.editPattern(convention, false, true);
        if (newConvention != null) {
            this.addElementTableViewer(newConvention);
            this.updateFilterComposite();
            this.fTableViewer.setChecked((Object)newConvention, newConvention.getEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newConvention));
        }
        this.updateConfig();
    }

    private void duplicate() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        ExternalToolsPattern data = (ExternalToolsPattern)selection.getFirstElement();
        ExternalToolsPattern convention = new ExternalToolsPattern(data);
        convention.setKind("User defined");
        convention.setName("Copy of " + convention.getName());
        ExternalToolsPattern newConvention = this.editPattern(convention, false, true);
        if (newConvention != null) {
            this.addElementTableViewer(newConvention);
            this.updateFilterComposite();
            this.fTableViewer.setChecked((Object)newConvention, newConvention.getEnabled());
            this.fTableViewer.setSelection((ISelection)new StructuredSelection((Object)newConvention));
        }
        this.updateConfig();
    }

    protected ExternalToolsPattern editPattern(ExternalToolsPattern pattern, boolean edit, boolean isNameModifiable) {
        EditBuilderPatternDialog dialog = new EditBuilderPatternDialog(this.getParentShell(), pattern, edit, isNameModifiable, ExternalToolsModelManager.getInstance().getContextTypeRegistry(), this.fConfiguration);
        if (dialog.open() == 0) {
            return dialog.getBuilderFilterPattern();
        }
        return null;
    }

    private void edit() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        Object[] objects = selection.toArray();
        if (objects == null || objects.length != 1) {
            return;
        }
        ExternalToolsPattern data = (ExternalToolsPattern)selection.getFirstElement();
        if (ExternalToolsUtil.isUserDefined(data)) {
            this.edit(data);
        } else {
            this.openReadOnlyPatternEditErrorDialog();
        }
    }

    private void edit(ExternalToolsPattern oldConvention) {
        ExternalToolsPattern newConvention = this.editPattern(oldConvention, true, true);
        if (newConvention != null) {
            if (!newConvention.getName().equals(oldConvention.getName()) && MessageDialog.openQuestion((Shell)this.getParentShell(), (String)ExternalToolsMessages.RulePropertyPage_question_create_new_title, (String)ExternalToolsMessages.RulePropertyPage_question_create_new_message)) {
                this.addElementTableViewer(newConvention);
            } else {
                oldConvention.setName(newConvention.getName());
                oldConvention.setKind(newConvention.getKind());
                oldConvention.setDescription(newConvention.getDescription());
                oldConvention.setPatternString(newConvention.getPatternString());
                oldConvention.setPattern(newConvention.getPattern());
                oldConvention.setVariablesMap(newConvention.getVariablesMap());
                oldConvention.setHyperlinkCommandsMap(newConvention.getHyperlinkCommandsMap());
                oldConvention.setType(newConvention.getType());
                oldConvention.setEnabled(newConvention.getEnabled());
                this.editElementTableViewer(newConvention, oldConvention);
            }
            this.updateFilterComposite();
            this.selectionChanged1();
        }
    }

    public static String messageFormat(String message, Object argument) {
        return MessageFormat.format(message, argument);
    }

    private void remove() {
        IStructuredSelection selection = (IStructuredSelection)this.fTableViewer.getSelection();
        for (ExternalToolsPattern data : selection) {
            this.deleteElementTableViewer(data);
        }
        this.updateFilterComposite();
        this.updateConfig();
    }

    private void updateConfig() {
        ArrayList<ExternalToolsPattern> patterns = new ArrayList<ExternalToolsPattern>();
        TableItem[] items = this.fTableViewer.getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExternalToolsPattern data = (ExternalToolsPattern)items[i].getData();
            if (ExternalToolsUtil.isUserDefined(data)) {
                patterns.add(data);
            }
            ++i;
        }
        this.fConfiguration.setPatterns(patterns.toArray(new ExternalToolsPattern[patterns.size()]));
    }

    private void openReadOnlyPatternEditErrorDialog() {
        String title = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Edit_Error_Title;
        String message = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Edit_Error_Message;
        MessageDialog.openError((Shell)this.getParentShell(), (String)title, (String)message);
    }

    private void openReadOnlyPatternDisableErrorDialog() {
        String title = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Disable_Error_Title;
        String message = ExternalToolsMessages.ExternalToolFilterTabReadOnly_Disable_Error_Message;
        MessageDialog.openError((Shell)this.getParentShell(), (String)title, (String)message);
    }

    protected SourceViewer getViewer() {
        return this.fPatternViewer;
    }

    protected TableViewer getTableViewer() {
        return this.fTableViewer;
    }

    private void updateFilterComposite() {
        this.fTableViewer.refresh();
    }

    @Override
    public void setErrorMessage(String errorMessage) {
        this.fParentDialog.setErrorMessage(errorMessage);
    }

    @Override
    protected void setMessage(String message) {
        this.fParentDialog.setMessage(message);
    }
}

