/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.convert;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.buildconfig.ElaborationDebugZone;
import ro.amiq.dvt.buildconfig.ElaborationExpressionControl;
import ro.amiq.dvt.diagrams.fsm.model.FSMFactory;
import ro.amiq.dvt.diagrams.fsm.model.FSMInput;
import ro.amiq.dvt.diagrams.fsm.model.FSMModel;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.diagrams.fsm.model.FSMTransition;
import ro.amiq.dvt.diagrams.fsm.model.IFSMViewSelectable;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.core.ELBuildPhase;
import ro.amiq.dvt.elaboration.core.ELConstantsManager;
import ro.amiq.dvt.elaboration.core.ELManager;
import ro.amiq.dvt.elaboration.core.ELManagerConfiguration;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.ELParamValuesHidEvaluator;
import ro.amiq.dvt.elaboration.model.IELMemory;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMUtils;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.logic.form.LFConverter;
import ro.amiq.dvt.logic.form.LFConverterOptions;
import ro.amiq.dvt.logic.form.LFElementConverter;
import ro.amiq.dvt.logic.form.LogicForm;
import ro.amiq.dvt.logic.form.model.LFFanIn;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.model.LFProgram;
import ro.amiq.dvt.logic.form.utils.LFCloneTransformation;
import ro.amiq.dvt.logic.form.utils.LFFilterTransformation;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.GoToInfo;
import ro.amiq.dvt.model.reflection.IReparseElement;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfBlockElement;
import ro.amiq.dvt.model.reflection.IRfConstantsHolder;
import ro.amiq.dvt.model.reflection.IRfDesignElement;
import ro.amiq.dvt.model.reflection.IRfEnumElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;
import ro.amiq.dvt.model.reflection.IRfSingleLangProject;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorVisitor;
import ro.amiq.dvt.model.reflection.semantic.extension.HidQualifierCache;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.model.reflection.util.DesignUtils;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public final class FSMConverter {
    private static final long ASSIGNMENT_QUALIFIERS = HidQualifierCache.ALL_SIMPLE_ASSIGN_QUALIFIERS | HidQualifierCache.IS_ALIAS_QUALIFIER;

    private FSMConverter() {
    }

    public static IFSMModel convert(IRfFieldElement variable, IRfNamedElement designEnclosingScope, IProgressMonitor monitor) {
        if (variable == null) {
            return null;
        }
        if (designEnclosingScope == null) {
            IRfScopeElement enclosingScope = variable.getEnclosingScope();
            if (!(enclosingScope instanceof IRfNamedElement)) {
                return null;
            }
            designEnclosingScope = (IRfNamedElement)enclosingScope;
        }
        LogicForm normalizedForm = LFConverter.INSTANCE.convertElementAndNormalize(designEnclosingScope, new StateVariableCheck(Collections.singletonList(variable)), LFConverterOptions.FSM_SET, HidFlatteningOption.NONE_EXCLUDED, monitor);
        return FSMConverter.internalConvert(variable, designEnclosingScope, normalizedForm, monitor);
    }

    private static IFSMModel internalConvert(IRfFieldElement stateVariable, IRfNamedElement designEnclosingScope, LogicForm normalizedForm, IProgressMonitor monitor) {
        Map<IFSMState, IFSMState> stateValues;
        IRfNamedElement translatedType;
        if (normalizedForm == null) {
            FSMDebugUtils.debugLevelOne("NULL normalized form for variable: " + stateVariable + "\n", new Object[0]);
            return null;
        }
        LanguageKind languageKind = stateVariable.getLanguageKind();
        LinkedHashSet<String> collectedStateVarNames = new LinkedHashSet<String>();
        IRfSingleLangProject rfProject = designEnclosingScope.getRfProject();
        if (rfProject == null) {
            FSMDebugUtils.debugLevelOne("Could not determine state values for variable: " + stateVariable + "\n", new Object[0]);
            return null;
        }
        ELManager manager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig(false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        IRfNamedElement stateVariableType = stateVariable.getAssociatedType();
        if (stateVariableType instanceof IRfTypeAliasElement && (translatedType = ((IRfTypeAliasElement)stateVariableType).getTranslatedType(stateVariable.getEnclosingScope())) != null) {
            stateVariableType = translatedType;
        }
        if ((stateValues = FSMConverter.getValuesOfStateVariables(stateVariable, stateVariableType, designEnclosingScope, collectedStateVarNames, languageKind, monitor, manager)).isEmpty()) {
            FSMDebugUtils.debugLevelOne("Could not determine state values for variable: " + stateVariable + "\n", new Object[0]);
            return null;
        }
        Set<IFSMState> stateValueKeys = stateValues.keySet();
        FSMDebugUtils.debugLevelOne("Starting state values are: ", stateValueKeys);
        LinkedHashSet<IRfFieldElement> stateVariables = new LinkedHashSet<IRfFieldElement>(2);
        stateVariables.add(stateVariable);
        LinkedHashSet<String> collectedNextStateVarNames = new LinkedHashSet<String>();
        FSMConverter.computeNextStateVariable(normalizedForm, stateVariable, stateVariableType, designEnclosingScope, stateValues, stateVariables, collectedNextStateVarNames, monitor, manager);
        if (stateValues.isEmpty()) {
            return null;
        }
        FSMDebugUtils.debugLevelOne("State variables are: ", stateVariables);
        FSMDebugUtils.debugLevelOne("Final state values are: ", stateValueKeys);
        LogicForm filteredForm = normalizedForm.apply(LFCloneTransformation.INSTANCE).apply(new LFFilterTransformation(prog -> FSMConverter.isAssignmentOfState(prog, stateVariables, true)));
        FSMConverter.replaceStateVariablesWithValues(filteredForm, stateVariables, stateValueKeys);
        IFSMModel model = FSMConverter.createModel(stateValueKeys, stateVariables, stateVariableType, filteredForm, collectedStateVarNames, collectedNextStateVarNames, languageKind, designEnclosingScope, manager);
        IRfNamedElement type = stateVariable.getAssociatedType();
        Collection<IRfNamedElement> enumValues = FSMConverter.getEnumValues(type);
        if (enumValues == null || enumValues.isEmpty()) {
            return model;
        }
        FSMConverter.replaceDefaultState(model, enumValues, stateVariables, languageKind);
        return model;
    }

    private static void replaceStateVariablesWithValues(LogicForm filteredForm, Set<IRfFieldElement> stateVariables, Set<IFSMState> stateValueKeys) {
        if (filteredForm == null || filteredForm.isEmpty()) {
            return;
        }
        filteredForm.apply(new LFFilterTransformation(program -> {
            if (!(program instanceof LFProgram.LFImplication)) {
                return true;
            }
            LinkedHashMap<IRfNamedElement, IHid> stateVariableValues = new LinkedHashMap<IRfNamedElement, IHid>(2);
            FSMConverter.collectStateVariableValues(((LFProgram.LFImplication)program).antec, stateVariables, stateValueKeys, stateVariableValues);
            LFProgram conseq = ((LFProgram.LFImplication)program).conseq;
            if (!(conseq instanceof LFProgram.LFAtomicProgram)) {
                return true;
            }
            LFFanIn fan = ((LFProgram.LFAtomicProgram)conseq).fan;
            List<IHid> border = fan.getBorder();
            if (border == null) {
                return true;
            }
            ArrayList<IHid> borderCopy = new ArrayList<IHid>(border);
            for (IHid borderHid : borderCopy) {
                IHid value = (IHid)stateVariableValues.get(borderHid.getElement());
                if (value == null) continue;
                fan.replaceHidFromBorder(borderHid, value);
            }
            return true;
        }));
    }

    private static void collectStateVariableValues(LFFormula startFormula, Set<IRfFieldElement> stateVariables, Set<IFSMState> stateValueKeys, Map<IRfNamedElement, IHid> result) {
        LFUtils.flattenFormula(startFormula, atomicFormula -> {
            block10: {
                IRfNamedElement secondElement;
                IRfNamedElement firstElement;
                IHid firstMember;
                block11: {
                    if (!(atomicFormula instanceof LFFormula.LFAtomicFormula)) {
                        return true;
                    }
                    IHidObject expression = ((LFFormula.LFAtomicFormula)atomicFormula).getExpr();
                    if (!(expression instanceof HidOperator)) {
                        return true;
                    }
                    if (((HidOperator)expression).isIfCondition()) {
                        expression = ((HidOperator)expression).getLHValue();
                    }
                    if (!(expression instanceof HidOperator) || !((HidOperator)expression).isEquality() && !((HidOperator)expression).isCaseItemCondition()) {
                        return true;
                    }
                    ArrayList<IHid> flattenToHids = new ArrayList<IHid>(HidUtils.flattenToHids(expression, HidFlatteningOption.IMPLICITS_EXCLUDED));
                    if (flattenToHids.size() != 2) {
                        return true;
                    }
                    firstMember = (IHid)flattenToHids.get(0);
                    IHid secondMember = (IHid)flattenToHids.get(1);
                    if (!(firstMember instanceof Hid) || !(secondMember instanceof Hid)) {
                        return true;
                    }
                    firstElement = firstMember.getElement();
                    if (firstElement == null) {
                        return true;
                    }
                    secondElement = secondMember.getElement();
                    if (secondElement == null) {
                        return true;
                    }
                    if (!stateVariables.contains(firstElement)) break block11;
                    for (IFSMState state : stateValueKeys) {
                        if (!state.getID().equals(secondElement.getName())) continue;
                        result.put(firstElement, secondMember);
                        break block10;
                    }
                    break block10;
                }
                if (!stateVariables.contains(secondElement)) break block10;
                for (IFSMState state : stateValueKeys) {
                    if (!state.getID().equals(firstElement.getName())) continue;
                    result.put(secondElement, firstMember);
                    break;
                }
            }
            return true;
        });
    }

    private static void replaceDefaultState(IFSMModel model, Collection<IRfNamedElement> enumValues, Set<IRfFieldElement> stateVariables, LanguageKind languageKind) {
        IFSMState defaultState = model.getDefaultState();
        if (defaultState == null) {
            return;
        }
        Iterator<IRfFieldElement> iterator = stateVariables.iterator();
        String stateVarName = iterator.next().getName();
        String nextStateVarName = !iterator.hasNext() ? stateVarName : iterator.next().getName();
        model.getStates().remove(defaultState);
        model.getStartStates().remove(defaultState);
        ArrayList<IFSMState> resolveToDefault = new ArrayList<IFSMState>(4);
        Iterator<IRfNamedElement> enumValueIter = enumValues.iterator();
        block0: while (enumValueIter.hasNext()) {
            IRfNamedElement enumValue = enumValueIter.next();
            for (IFSMState iFSMState : model.getStates()) {
                if (!FSMUtils.isEqual(iFSMState, enumValue, languageKind)) continue;
                if (iFSMState.getOutgoingTransitions().isEmpty()) {
                    resolveToDefault.add(iFSMState);
                }
                enumValueIter.remove();
                continue block0;
            }
        }
        for (IFSMState defaultCandidate : resolveToDefault) {
            for (IFSMTransition iFSMTransition : defaultState.getOutgoingTransitions()) {
                FSMTransition fSMTransition = FSMFactory.createTransition((FSMInput)iFSMTransition.getSourceInput(), defaultCandidate, iFSMTransition.getDestination(), stateVarName, nextStateVarName);
                for (GoToInfo marker : ((IFSMViewSelectable)((Object)iFSMTransition)).hasGoToSource()) {
                    fSMTransition.addMarker(marker);
                }
            }
        }
        for (IRfNamedElement enumValue : enumValues) {
            FSMState fSMState = FSMFactory.createState(enumValue, languageKind);
            GoToInfo newStateMarker = GoToInfo.sourceOf(enumValue);
            fSMState.addMarker(newStateMarker);
            for (IFSMTransition iFSMTransition : defaultState.getOutgoingTransitions()) {
                FSMTransition newTrans = FSMFactory.createTransition((FSMInput)iFSMTransition.getSourceInput(), fSMState, iFSMTransition.getDestination(), stateVarName, nextStateVarName);
                for (GoToInfo marker : ((IFSMViewSelectable)((Object)iFSMTransition)).hasGoToSource()) {
                    newTrans.addMarker(marker);
                }
            }
            model.addState(fSMState);
        }
    }

    private static Collection<IRfNamedElement> getEnumValues(IRfNamedElement type) {
        if ((type = FSMConverter.unpackListType(type)) instanceof IRfEnumElement) {
            return ((IRfEnumElement)type).getEnumValues();
        }
        return null;
    }

    private static IRfNamedElement unpackListType(IRfNamedElement type) {
        LinkedHashSet<String> typeAliasNames = new LinkedHashSet<String>(4);
        while (type instanceof IRfListType || type instanceof IRfTypeAliasElement) {
            if (typeAliasNames.contains(type.getName())) break;
            if (type instanceof IRfListType) {
                typeAliasNames.add(type.getName());
                type = ((IRfListType)type).getAssociatedType();
            }
            if (!(type instanceof IRfTypeAliasElement)) continue;
            typeAliasNames.add(type.getName());
            type = ((IRfTypeAliasElement)type).getTranslatedType(type.getEnclosingScope());
        }
        return type;
    }

    private static void computeNextStateVariable(LogicForm normalizedForm, IRfFieldElement stateVariable, IRfNamedElement stateVariableType, IRfNamedElement designEnclosingScope, Map<IFSMState, IFSMState> stateValues, Set<IRfFieldElement> stateVariables, Set<String> collectedNextStateVarNames, IProgressMonitor monitor, ELManager manager) {
        if (stateValues == null || stateValues.isEmpty() || normalizedForm == null) {
            return;
        }
        LinkedHashSet<IFSMState> nextStateVariables = new LinkedHashSet<IFSMState>();
        LinkedHashSet<IFSMState> nextStateValues = new LinkedHashSet<IFSMState>();
        IRfScopeElement stateVariableEnclosingScope = stateVariable.getEnclosingScope();
        for (IFSMState stateValue : stateValues.keySet()) {
            IRfNamedElement translatedType;
            IRfFieldElement nextStateVariable;
            IRfNamedElement resolved = stateValue.getElement();
            if (!(resolved instanceof IRfFieldElement) || ELUtils.isVLOGConstant(nextStateVariable = (IRfFieldElement)resolved) || ELUtils.isVHDLConstant(nextStateVariable) || !stateVariableEnclosingScope.equals(nextStateVariable.getEnclosingScope())) continue;
            IRfNamedElement assocType = nextStateVariable.getAssociatedType();
            if (assocType instanceof IRfTypeAliasElement && (translatedType = ((IRfTypeAliasElement)assocType).getTranslatedType(nextStateVariable.getEnclosingScope())) != null) {
                assocType = translatedType;
            }
            if (assocType == null || !assocType.equals(stateVariableType) && (!(assocType instanceof IRfListType) || !(stateVariableType instanceof IRfListType))) continue;
            LogicForm filteredForm = normalizedForm.apply(LFCloneTransformation.INSTANCE).apply(new LFFilterTransformation(prog -> FSMConverter.isAssignmentOfState(prog, Collections.singleton(nextStateVariable), false)));
            if (filteredForm.content.isEmpty()) continue;
            boolean hasSequentialLogic = filteredForm.content.stream().map(LFUtils::getFormulaFromProgram).filter(formula -> DesignUtils.isSequentialFormula(formula)).findAny().isPresent();
            if (hasSequentialLogic) {
                FSMDebugUtils.debugLevelOne("Candidate for next state '" + nextStateVariable + "' has sequential logic", new Object[0]);
                continue;
            }
            boolean[] shouldStop = new boolean[1];
            List<IRfFieldElement> counterVars = Arrays.asList(stateVariable, nextStateVariable);
            Predicate<HidOperator> checkForCounter = operator -> {
                Set<IHid> flattened = HidUtils.flattenToHids(operator, HidFlatteningOption.FSM_ONLY_HIDS);
                for (IHid rhHid : flattened) {
                    if (!counterVars.contains(rhHid.getElement())) continue;
                    return true;
                }
                return false;
            };
            Map<IFSMState, IFSMState> candidateNextStateValues = FSMConverter.getValuesOfStateVariables(Collections.singleton(nextStateVariable), assocType, designEnclosingScope, nextStateVariable.getLanguageKind(), shouldStop, checkForCounter, collectedNextStateVarNames, monitor, manager);
            if (shouldStop[0]) {
                FSMDebugUtils.debugLevelOne("Unsupported operations (E.g. counters, bit select) for variables " + counterVars, new Object[0]);
                stateValues.clear();
                return;
            }
            nextStateVariables.add(stateValue);
            if (candidateNextStateValues.isEmpty()) continue;
            for (IFSMState nextStateValue : candidateNextStateValues.keySet()) {
                if (stateVariable == nextStateValue.getElement()) continue;
                nextStateValues.add(nextStateValue);
            }
        }
        if (2 * nextStateVariables.size() >= stateValues.size()) {
            return;
        }
        for (IFSMState newStateValue : nextStateValues) {
            FSMConverter.addValueToExisting(stateValues, newStateValue);
        }
        for (IFSMState nextStateVariable : nextStateVariables) {
            stateVariables.add((IRfFieldElement)nextStateVariable.getElement());
            stateValues.remove(nextStateVariable);
        }
    }

    private static IFSMModel createModel(Set<IFSMState> states, Set<IRfFieldElement> stateVariables, IRfNamedElement stateVarType, LogicForm form, Set<String> collectedStateVarNames, Set<String> collectedNextStateVarNames, LanguageKind languageKind, IRfNamedElement enclosingScope, ELManager manager) {
        if (states == null || states.isEmpty() || stateVariables == null || stateVariables.isEmpty() || form.isEmpty()) {
            return null;
        }
        Iterator<IRfFieldElement> iterator = stateVariables.iterator();
        IRfFieldElement stateVar = iterator.next();
        IRfFieldElement nextStateVar = !iterator.hasNext() ? stateVar : iterator.next();
        String stateVarName = !collectedStateVarNames.isEmpty() ? collectedStateVarNames.iterator().next() : stateVar.getName();
        String nextStateVarName = !collectedNextStateVarNames.isEmpty() ? collectedNextStateVarNames.iterator().next() : nextStateVar.getName();
        FSMModel model = FSMFactory.createModel(languageKind);
        model.addStateVar(stateVar);
        if (stateVar != nextStateVar) {
            model.addNextStateVar(nextStateVar);
        }
        for (IFSMState state : states) {
            model.addState(state);
            List list = form.content.stream().filter(prog -> FSMConverter.isTransitionToState(prog, stateVariables, state, languageKind)).collect(Collectors.toList());
            if (list.isEmpty()) {
                FSMDebugUtils.debugLevelOne("Could not determine transitions to state " + state.getID(), new Object[0]);
                continue;
            }
            for (LFProgram transitionProg : list) {
                LFFormula lFFormula = LFUtils.getFormulaFromProgram(transitionProg);
                LinkedHashSet collectedStates = new LinkedHashSet();
                LFUtils.flattenFormula(lFFormula, formula -> {
                    if (!(formula instanceof LFFormula.LFAtomicFormula)) {
                        return false;
                    }
                    if (DesignUtils.isSequentialAtomicFormula(formula)) {
                        return false;
                    }
                    Set<IHidOperator> memberOperators = HidUtils.flattenToOperators(LFUtils.getHidOperator((LFFormula.LFAtomicFormula)formula));
                    if (memberOperators == null || memberOperators.isEmpty()) {
                        return false;
                    }
                    for (IHidOperator memberOperator : memberOperators) {
                        Collection<IFSMState> validOtherObjects = FSMConverter.getValidStateValues(memberOperator, stateVariables, stateVarType, null, null, null, false, null, languageKind, true, enclosingScope, manager);
                        if (validOtherObjects == null || validOtherObjects.isEmpty()) continue;
                        block1: for (IFSMState validOtherObject : validOtherObjects) {
                            for (IFSMState otherState : states) {
                                if (!FSMUtils.isEqual(otherState, validOtherObject)) continue;
                                collectedStates.add(otherState);
                                continue block1;
                            }
                        }
                    }
                    return false;
                });
                if (!collectedStates.isEmpty()) {
                    FSMDebugUtils.debugLevelOne(collectedStates.size() > 1, "Multiple source states " + collectedStates + " for '" + state + "'", new Object[0]);
                    LFFormula inputFormula = FSMConverter.makeInputFromFormula(lFFormula, stateVariables);
                    if (inputFormula == null) {
                        FSMDebugUtils.debugLevelOne("Input from formula " + lFFormula + " is null", new Object[0]);
                        continue;
                    }
                    for (IFSMState otherState : collectedStates) {
                        FSMTransition trans = FSMFactory.createTransition(FSMFactory.createInput(inputFormula), otherState, state, stateVarName, nextStateVarName);
                        if (trans == null) {
                            FSMDebugUtils.debugLevelOne("Could not create trans from " + otherState + " to " + state + " for condition " + inputFormula, new Object[0]);
                            continue;
                        }
                        model.setHasTransitions(otherState != state);
                        LFUtils.checkFanInOfProgram(transitionProg, fan -> {
                            trans.addMarker(fan.getMarker());
                            return true;
                        });
                    }
                    continue;
                }
                if (model.hasStartState(state)) {
                    FSMDebugUtils.debugLevelOne("Already added start state '" + state + "'", new Object[0]);
                    continue;
                }
                state.setIsStart(true);
                model.addStart(state);
            }
        }
        LinkedHashSet<IFSMState> pseudoStarts = new LinkedHashSet<IFSMState>();
        Collection<? extends IFSMState> initialStartStates = model.getStartStates();
        for (IFSMState iFSMState : initialStartStates) {
            if (pseudoStarts.contains(iFSMState)) continue;
            Collection<? extends IFSMTransition> outgoingTransitions = iFSMState.getOutgoingTransitions();
            for (IFSMTransition iFSMTransition : outgoingTransitions) {
                IFSMState dest = iFSMTransition.getDestination();
                if (!dest.isStart() || dest == iFSMState) continue;
                iFSMState.setIsStart(false);
                dest.setIsStart(false);
                pseudoStarts.add(iFSMState);
                pseudoStarts.add(dest);
            }
        }
        FSMDebugUtils.debugLevelOne(!pseudoStarts.isEmpty(), "Found pseudo start states " + pseudoStarts, new Object[0]);
        initialStartStates.removeAll(pseudoStarts);
        return model;
    }

    private static boolean isTransitionToState(LFProgram prog, Set<IRfFieldElement> stateVariables, IFSMState state, LanguageKind languageKind) {
        return LFUtils.checkFanInOfProgram(prog, fanIn -> {
            if (!stateVariables.contains(fanIn.getSimpleCenterResolved())) {
                return false;
            }
            for (IHid hid : fanIn.getBorder()) {
                if (!FSMUtils.isEqual(state, hid, languageKind)) continue;
                return true;
            }
            return false;
        });
    }

    @NotNull
    private static LFFormula makeInputFromFormula(LFFormula startFormula, Set<IRfFieldElement> stateVariables) {
        List<LFFormula> filteredFormulas = LFUtils.flattenFormula(startFormula, formula -> {
            if (LFUtils.isEmptyFormula(formula)) {
                return false;
            }
            HashSet<IHid> collected = new HashSet<IHid>();
            formula.collectExprHids(collected, HidFlatteningOption.NONE_EXCLUDED);
            for (IHid formulaHid : collected) {
                if (!stateVariables.contains(formulaHid.getElement())) continue;
                return false;
            }
            return !DesignUtils.isSequentialAtomicFormula(formula);
        });
        return LFUtils.andFormulas(filteredFormulas);
    }

    private static boolean isAssignmentOfState(LFProgram prog, Set<IRfFieldElement> vars, boolean acceptInitialValue) {
        return LFUtils.checkFanInOfProgram(prog, fanin -> vars.contains(fanin.getSimpleCenterResolved()) && (acceptInitialValue || !fanin.isDeclaration()));
    }

    private static Collection<IFSMState> getValidStateValues(IHidOperator operator, Set<IRfFieldElement> inputVars, IRfNamedElement inputVarType, Predicate<HidOperator> testForCounter, boolean[] shouldStop, Set<String> collectedInputVarNames, boolean allowInequality, ParserPath parserPath, LanguageKind languageKind, boolean exitWhenValidState, IRfNamedElement enclosingScope, ELManager manager) {
        IHidObject lhObject;
        ListContainer<IHidObject> rhValues;
        boolean isAssignment = operator.hasOccurrence(ASSIGNMENT_QUALIFIERS);
        boolean isSelectedAssignment = operator.hasOccurrence(HidQualifierCache.ALL_SELECT_ASSIGN_QUALIFIERS);
        boolean isEquality = allowInequality ? operator.isEqualityOrInequality() : operator.isEquality();
        boolean isCaseItemExpression = operator.hasOccurrence(HidQualifierCache.IS_CASE_ITEM_EXPRESSION_QUALIFIER);
        boolean isInsideExpression = operator.isInside();
        if (!(isAssignment || isEquality || isSelectedAssignment || isCaseItemExpression || isInsideExpression)) {
            return null;
        }
        if (isSelectedAssignment && (rhValues = operator.getRHValues()).size() == 1) {
            IHidObject rfHidObject = rhValues.get(0);
            if (rfHidObject.getHidKind() != IHidObject.HidKind.OPERATOR) {
                return null;
            }
            operator = (IHidOperator)rfHidObject;
        }
        if (HidUtils.isHidAccess(lhObject = operator.getLHValue())) {
            IHid lhHid = HidUtils.getHidFrom(lhObject);
            List<IHidObject> selects = ((HidAccess)lhObject).getSelects();
            if (selects != null && !selects.isEmpty() && lhHid != null && !lhHid.isMethodCall(false)) {
                lhObject = lhHid;
            }
        }
        if (HidUtils.isHid(lhObject)) {
            IHidObject candidate;
            IRfNamedElement lhVar = HidUtils.getResolvedElement(lhObject);
            if (!inputVars.contains(lhVar)) {
                return null;
            }
            ListContainer<IHidObject> rhHids = operator.getRHValues();
            if (rhHids == null || rhHids.size() != 1) {
                return null;
            }
            if (collectedInputVarNames != null) {
                collectedInputVarNames.add(HidUtils.toNiceString(operator.getLHValue()));
            }
            if (HidUtils.isOperator(candidate = rhHids.get(0))) {
                HidOperator rhOperator = (HidOperator)candidate;
                if (isAssignment) {
                    if (rhOperator.isConditionalTernary()) {
                        return FSMConverter.internalCollectTernaryRHValues(rhOperator, inputVars, operator.getOccurrence(), parserPath, languageKind, exitWhenValidState, testForCounter, shouldStop);
                    }
                    if (testForCounter != null && shouldStop != null) {
                        shouldStop[0] = testForCounter.test(rhOperator);
                        return null;
                    }
                }
                if ((isCaseItemExpression || isInsideExpression) && rhOperator.getOperatorKind() == IHidOperatorConstants.OperatorKind.VARIADIC_OPERATOR && rhOperator.hasRHValues()) {
                    LinkedHashSet<IFSMState> stateValues = new LinkedHashSet<IFSMState>();
                    HidOperatorOccurrence rhOperatorOccurrence = rhOperator.getOccurrence();
                    ListContainer<IHidObject> rhValues2 = rhOperator.getRHValues();
                    int i = rhValues2.size() - 1;
                    while (i >= 0) {
                        IHidObject member = rhValues2.get(i);
                        IFSMState stateValue = FSMConverter.internalGetValidStateValue(member, inputVars, rhOperatorOccurrence, parserPath, languageKind, exitWhenValidState);
                        if (stateValue != null) {
                            stateValues.add(stateValue);
                        }
                        --i;
                    }
                    if (!stateValues.isEmpty()) {
                        return stateValues;
                    }
                }
            } else {
                IFSMState stateValue = FSMConverter.internalGetValidStateValue(candidate, inputVars, operator.getOccurrence(), parserPath, languageKind, exitWhenValidState);
                if (stateValue != null) {
                    return Collections.singleton(stateValue);
                }
            }
        } else if (isCaseItemExpression && HidUtils.isHidImplicit(lhObject) && manager != null) {
            ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
            IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM, enclosingScope, null, false, manager);
            BitVectorContext noContext = BitVectorContext.of(enclosingScope, false);
            IELParamValue lhValue = XUtils.getValue(ELUtils.evaluate(lhObject, evaluator, noContext, guardian));
            if (!(lhValue instanceof ELParamValues.ParamValueNumber)) {
                return null;
            }
            DVTNumber lhNumber = lhValue.getDVTNumber();
            if (!(lhNumber instanceof VlogBitVector)) {
                return null;
            }
            if (!lhNumber.equals(VlogBitVector.BIT_ONE) && lhNumber.getSize() == 1) {
                return null;
            }
            ListContainer<IHidObject> rhHids = operator.getRHValues();
            if (rhHids == null || rhHids.size() != 1) {
                return null;
            }
            IHidObject rhHidObject = rhHids.get(0);
            if (HidUtils.isHidAccess(rhHidObject) && ((HidAccess)rhHidObject).isSelect()) {
                List<IHidObject> selects = ((HidAccess)rhHidObject).getSelects();
                if (selects == null || selects.size() != 1) {
                    return null;
                }
                if (!(enclosingScope instanceof IRfConstantsHolder)) {
                    return null;
                }
                ((IRfConstantsHolder)enclosingScope).elaborateConstants(manager);
                ELParamValues localConstants = manager.getExternalConstants(enclosingScope);
                if (localConstants == null || localConstants.isEmpty()) {
                    return null;
                }
                evaluator = localConstants.getHidEvaluator(manager);
                IHidObject select = selects.get(0);
                IELParamValue selectValue = XUtils.getValue(ELUtils.evaluate(select, evaluator, noContext, guardian));
                if (!(lhValue instanceof ELParamValues.ParamValueNumber)) {
                    return null;
                }
                Map<String, IELParamValue> entries = localConstants.getEntries();
                for (Map.Entry<String, IELParamValue> candidateEntry : entries.entrySet()) {
                    FSMState state;
                    IRfFieldElement candidateVariableField;
                    IRfNamedElement associatedType;
                    IRfNamedElement candidateVariable;
                    VlogBitVector candidateStateBitVector;
                    VlogBitVector powerOfTwo;
                    DVTNumber candidateStateNumber;
                    IELParamValue candidateStateValue = candidateEntry.getValue();
                    if (!(candidateStateValue instanceof ELParamValues.ParamValueNumber) || !((candidateStateNumber = ((ELParamValues.ParamValueNumber)candidateStateValue).getDVTNumber()) instanceof VlogBitVector) || !(powerOfTwo = VlogBitVector.create(false, (candidateStateBitVector = (VlogBitVector)candidateStateNumber).getSize() - 1, 0, VlogBitVector.getPowerOfTwo(selectValue.intValue()))).equals(candidateStateBitVector) || !((candidateVariable = enclosingScope.semanticGetMember(candidateEntry.getKey(), null, null, enclosingScope, null, true, true, false)) instanceof IRfFieldElement) || (associatedType = (candidateVariableField = (IRfFieldElement)candidateVariable).getAssociatedType()) == null || !associatedType.equals(inputVarType) || (state = FSMFactory.createState(candidateVariable, languageKind)) == null) continue;
                    return Collections.singleton(state);
                }
                return null;
            }
        }
        return null;
    }

    private static IFSMState internalGetValidStateValue(IHidObject candidate, Set<IRfFieldElement> inputVars, HidOperatorOccurrence occurrence, ParserPath parserPath, LanguageKind languageKind, boolean exitWhenValidState) {
        switch (candidate.getHidKind()) {
            case ACCESS: {
                List<IHidObject> selects = ((HidAccess)candidate).getSelects();
                if (selects == null || selects.isEmpty()) {
                    return null;
                }
                Hid parentHid = ((HidAccess)candidate).getParentHid();
                if (parentHid == null || parentHid.isMethodCall(false)) {
                    return null;
                }
                return FSMConverter.internalGetValidStateValue(parentHid, inputVars, occurrence, parserPath, languageKind, exitWhenValidState, false);
            }
            case IMPLICIT: {
                if (((HidImplicit)candidate).isOthers()) {
                    return FSMConverter.internalGetValidStateValue((IHid)candidate, inputVars, occurrence, parserPath, languageKind, exitWhenValidState, true);
                }
            }
            case HID: {
                return FSMConverter.internalGetValidStateValue((IHid)candidate, inputVars, occurrence, parserPath, languageKind, exitWhenValidState, false);
            }
        }
        return null;
    }

    private static Collection<IFSMState> internalCollectTernaryRHValues(IHidObject hidObject, Set<IRfFieldElement> inputVars, HidOperatorOccurrence hidOperatorOccurrence, ParserPath parserPath, LanguageKind languageKind, boolean exitWhenValidState, Predicate<HidOperator> testForCounter, boolean[] shouldStop) {
        switch (hidObject.getHidKind()) {
            case HID: 
            case IMPLICIT: 
            case ACCESS: {
                IFSMState stateValue = FSMConverter.internalGetValidStateValue(hidObject, inputVars, hidOperatorOccurrence, parserPath, languageKind, exitWhenValidState);
                if (stateValue == null) break;
                return Collections.singleton(stateValue);
            }
            case OPERATOR: {
                HidOperator hidOperator = (HidOperator)hidObject;
                if (hidOperator.isConditionalTernary()) {
                    Collection<IFSMState> falsePartValues;
                    ListContainer<IHidObject> values = hidOperator.getRHValues();
                    LinkedHashSet<IFSMState> stateValues = new LinkedHashSet<IFSMState>();
                    Collection<IFSMState> truePartValues = FSMConverter.internalCollectTernaryRHValues(values.get(1), inputVars, hidOperatorOccurrence, parserPath, languageKind, exitWhenValidState, testForCounter, shouldStop);
                    if (truePartValues != null) {
                        stateValues.addAll(truePartValues);
                    }
                    if ((falsePartValues = FSMConverter.internalCollectTernaryRHValues(values.get(0), inputVars, hidOperatorOccurrence, parserPath, languageKind, exitWhenValidState, testForCounter, shouldStop)) != null) {
                        stateValues.addAll(falsePartValues);
                    }
                    return stateValues;
                }
                if (!hidOperator.hasOccurrence(ASSIGNMENT_QUALIFIERS) || testForCounter == null || shouldStop == null) break;
                shouldStop[0] = testForCounter.test(hidOperator);
                return null;
            }
        }
        return null;
    }

    private static IFSMState internalGetValidStateValue(IHid candidateHid, Set<IRfFieldElement> inputVars, HidOperatorOccurrence occurrence, ParserPath parserPath, LanguageKind languageKind, boolean exitWhenValidState, boolean isDefault) {
        IRfNamedElement element = candidateHid.getElement();
        if (inputVars.contains(element)) {
            return null;
        }
        FSMState state = FSMFactory.createState(candidateHid, element, languageKind);
        if (state == null) {
            FSMDebugUtils.debugLevelOne("Could not create state for " + candidateHid, new Object[0]);
            return null;
        }
        state.setIsDefault(isDefault);
        if (!exitWhenValidState) {
            FSMConverter.addMarkerToStateValue(candidateHid, state, occurrence, parserPath, languageKind);
        }
        return state;
    }

    private static void addMarkerToStateValue(IHid stateHid, IFSMState state, HidOperatorOccurrence operatorOccurrence, ParserPath operatorParserPath, LanguageKind languageKind) {
        if (state == null) {
            return;
        }
        if (HidUtils.isHidImplicit(stateHid)) {
            IHidImplicit hidImplicit = (IHidImplicit)stateHid;
            IReparseElement reparseInfo = hidImplicit.getLastReparseElement();
            if (reparseInfo != null) {
                niceID = reparseInfo.getReparseMacroName();
                state.setNiceID("`" + niceID);
                ParserPath macroParserPath = reparseInfo.getReparseMacroFile();
                if (macroParserPath != null) {
                    GoToInfo marker = GoToInfo.of(macroParserPath.path, -1, -1, reparseInfo.getReparseMacroLine(), niceID, languageKind);
                    state.addMarker(marker);
                }
            } else {
                niceID = HidUtils.toNiceString(hidImplicit);
                state.setNiceID(niceID);
                int operatorOffset = operatorOccurrence.getOffset();
                int operatorVirtualOffset = operatorOccurrence.getVirtualOffset();
                int operatorLine = operatorOccurrence.getLine();
                GoToInfo marker = GoToInfo.of(operatorParserPath != null ? operatorParserPath.path : null, operatorOffset, operatorVirtualOffset, operatorLine, niceID, languageKind);
                state.addMarker(marker);
            }
        }
        if (HidUtils.isHid(stateHid)) {
            IRfNamedElement element = stateHid.getElement();
            String niceID = HidUtils.toNiceString(stateHid);
            state.setNiceID(niceID);
            GoToInfo marker = GoToInfo.sourceOf(element);
            if (marker == null) {
                FSMDebugUtils.debugLevelOne("No \"GoTo\" info for " + stateHid, new Object[0]);
                int offset = operatorOccurrence.getOffset();
                int virtualOffset = operatorOccurrence.getVirtualOffset();
                int line = operatorOccurrence.getLine();
                marker = GoToInfo.of(operatorParserPath != null ? operatorParserPath.path : null, offset, virtualOffset, line, niceID, languageKind);
            }
            state.addMarker(marker);
        }
    }

    @NotNull
    private static Map<IFSMState, IFSMState> getValuesOfStateVariables(IRfFieldElement inputVariable, IRfNamedElement inputVariableType, IRfNamedElement enclosingScope, Set<String> collectedStateVarNames, LanguageKind languageKind, IProgressMonitor monitor, ELManager manager) {
        Set<IRfFieldElement> inputVars = Collections.singleton(inputVariable);
        return FSMConverter.getValuesOfStateVariables(inputVars, inputVariableType, enclosingScope, languageKind, new boolean[1], operator -> {
            for (IHid rhHid : HidUtils.flattenToHids(operator, HidFlatteningOption.FSM_ONLY_HIDS)) {
                if (!inputVars.contains(rhHid.getElement())) continue;
                return true;
            }
            return false;
        }, collectedStateVarNames, monitor, manager);
    }

    @NotNull
    private static Map<IFSMState, IFSMState> getValuesOfStateVariables(final Set<IRfFieldElement> inputVars, final IRfNamedElement inputVarType, final IRfNamedElement enclosingScope, final LanguageKind languageKind, final boolean[] shouldStop, final Predicate<HidOperator> checkForCounter, final Set<String> collectedInputVarNames, final IProgressMonitor monitor, final ELManager manager) {
        final LinkedHashMap states = new LinkedHashMap();
        enclosingScope.visitHidObject(null, new HidOperatorVisitor(null){

            @Override
            public boolean visit(HidOperator operator) {
                if (monitor.isCanceled()) {
                    return false;
                }
                if (shouldStop[0]) {
                    return false;
                }
                if (operator.hasQualifier(HidQualifierCache.IS_CASE_ITEM_EXPRESSION_QUALIFIER)) {
                    boolean isConcatenation;
                    boolean bl = isConcatenation = operator.getLHValue() instanceof IHidOperator && ((IHidOperator)operator.getLHValue()).hasOccurrence(HidQualifierCache.IS_CONCATENATION_QUALIFIER);
                    if (isConcatenation) {
                        List<IHidOperator> subOperators = LFElementConverter.transformConcatenationOperator(operator, new StateVariableCheck(inputVars));
                        if (subOperators == null) {
                            return false;
                        }
                        for (IHidOperator subOperator : subOperators) {
                            Collection<IFSMState> stateValues = FSMConverter.getValidStateValues(subOperator, inputVars, inputVarType, checkForCounter, shouldStop, collectedInputVarNames, true, this.parserPath, languageKind, false, enclosingScope, manager);
                            if (shouldStop[0]) {
                                FSMDebugUtils.debugLevelOne("Unsupported operations (E.g. counters, bit select) for variables " + inputVars, new Object[0]);
                                continue;
                            }
                            if (stateValues == null || stateValues.isEmpty()) continue;
                            for (IFSMState stateValue : stateValues) {
                                FSMConverter.addValueToExisting(states, stateValue);
                            }
                        }
                        return true;
                    }
                }
                Collection<IFSMState> stateValues = FSMConverter.getValidStateValues(operator, inputVars, inputVarType, checkForCounter, shouldStop, collectedInputVarNames, true, this.parserPath, languageKind, false, enclosingScope, manager);
                if (shouldStop[0]) {
                    FSMDebugUtils.debugLevelOne("Unsupported operations (E.g. counters, bit select) for variables " + inputVars, new Object[0]);
                    return false;
                }
                if (stateValues == null || stateValues.isEmpty()) {
                    return true;
                }
                for (IFSMState stateValue : stateValues) {
                    FSMConverter.addValueToExisting(states, stateValue);
                }
                return true;
            }
        });
        return shouldStop[0] ? Collections.emptyMap() : states;
    }

    private static boolean addValueToExisting(Map<IFSMState, IFSMState> statesValues, IFSMState newValue) {
        if (newValue == null) {
            return false;
        }
        IFSMState prevState = statesValues.get(newValue);
        if (prevState != null && prevState.hasNiceID()) {
            return false;
        }
        statesValues.remove(prevState);
        statesValues.put(newValue, newValue);
        return true;
    }

    public static void collectRecursiveActionBlocks(IRfDesignElement element, Collection<IRfActionBlockElement> actionBlocks) {
        Collection<? extends IRfActionBlockElement> collection;
        if (element == null) {
            return;
        }
        Collection<? extends IRfBlockElement> localgenerateBlocks = element.getLocalGenerateBlocks();
        if (localgenerateBlocks != null) {
            for (IRfBlockElement iRfBlockElement : localgenerateBlocks) {
                FSMConverter.collectRecursiveActionBlocks(iRfBlockElement, actionBlocks);
            }
        }
        if ((collection = element.getLocalActionBlocks()) != null && !collection.isEmpty()) {
            actionBlocks.addAll(collection);
        }
    }

    public static Map<IRfFieldElement, IFSMModel> convert(IRfNamedElement designElement, int parallelism, long timeout, final IProgressMonitor monitor) {
        IRfDesignElement design = DesignUtils.getDesign(DesignUtils.DesignRequest.of(designElement, false));
        if (!(design instanceof IRfDesignElement)) {
            return null;
        }
        IRfSingleLangProject rfProject = design.getRfProject();
        if (rfProject == null) {
            return null;
        }
        ArrayList<IRfActionBlockElement> actionBlocks = new ArrayList<IRfActionBlockElement>();
        FSMConverter.collectRecursiveActionBlocks(design, actionBlocks);
        if (actionBlocks.isEmpty()) {
            return null;
        }
        final HashMap blocks = new HashMap();
        final LinkedHashSet candidateAssign = new LinkedHashSet();
        final LinkedHashSet candidateEquality = new LinkedHashSet();
        final ELManager manager = new ELManager(rfProject.getMixedLangProjectParent(), IELMemory.ELMemoryType.STANDARD, ELBuildPhase.NONE, ELManagerConfiguration.newDummyWithControlConfig(false, EnumSet.noneOf(ElaborationExpressionControl.class), Collections.emptySet(), false), new ELConstantsManager(), EnumSet.noneOf(ElaborationDebugZone.class));
        final ELParamValuesHidEvaluator evaluator = ELParamValues.EMPTY.getHidEvaluator(manager);
        final IHidEvaluationGuardian guardian = ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.DEFAULT_VALUE_PARAM, design, null, false, manager);
        final BitVectorContext noContext = BitVectorContext.of(design, false);
        for (final IRfActionBlockElement actionBlock : actionBlocks) {
            final boolean isSequentialRelevant = !actionBlock.hasBlockQualifier(IRfActionBlockElement.BlockQualifier.ALWAYS_COMB.value() | IRfActionBlockElement.BlockQualifier.ALWAYS_LATCH.value());
            actionBlock.visitHidObject(null, new HidOperatorVisitor(null){

                @Override
                public boolean visit(HidOperator operator) {
                    ListContainer<IHidObject> rhValues;
                    if (monitor.isCanceled()) {
                        return false;
                    }
                    boolean isAssignment = operator.hasOccurrence(ASSIGNMENT_QUALIFIERS);
                    boolean isSelectedAssignment = operator.hasOccurrence(HidQualifierCache.ALL_SELECT_ASSIGN_QUALIFIERS);
                    boolean isEquality = operator.isEqualityOrInequality();
                    boolean isCaseItemExpression = operator.hasOccurrence(HidQualifierCache.IS_CASE_ITEM_EXPRESSION_QUALIFIER);
                    if (isSelectedAssignment && (rhValues = operator.getRHValues()).size() == 1) {
                        IHidObject rfHidObject = rhValues.get(0);
                        if (rfHidObject.getHidKind() != IHidObject.HidKind.OPERATOR) {
                            return true;
                        }
                        operator = (HidOperator)rfHidObject;
                    }
                    if (!(isAssignment |= isSelectedAssignment) && !(isEquality |= isCaseItemExpression)) {
                        return true;
                    }
                    IHidObject lhObject = operator.getLHValue();
                    if (HidUtils.isHidAccess(lhObject)) {
                        IHid lhHid = HidUtils.getHidFrom(lhObject);
                        List<IHidObject> selects = ((HidAccess)lhObject).getSelects();
                        if (selects != null && !selects.isEmpty() && lhHid != null && !lhHid.isMethodCall(false)) {
                            lhObject = lhHid;
                        }
                    }
                    if (HidUtils.isHid(lhObject)) {
                        IRfNamedElement lhVar = HidUtils.getResolvedElement(lhObject);
                        if (!(lhVar instanceof IRfFieldElement)) {
                            return true;
                        }
                        if (!isSequentialRelevant && isAssignment) {
                            return true;
                        }
                        if (isAssignment) {
                            candidateAssign.add((IRfFieldElement)lhVar);
                            blocks.put((IRfFieldElement)lhVar, actionBlock);
                        }
                        if (isEquality) {
                            candidateEquality.add((IRfFieldElement)lhVar);
                            blocks.put((IRfFieldElement)lhVar, actionBlock);
                        }
                    } else if (isCaseItemExpression && HidUtils.isHidImplicit(lhObject) && manager != null) {
                        IELParamValue lhValue = XUtils.getValue(ELUtils.evaluate(lhObject, evaluator, noContext, guardian));
                        if (!(lhValue instanceof ELParamValues.ParamValueNumber)) {
                            return true;
                        }
                        DVTNumber lhNumber = lhValue.getDVTNumber();
                        if (!(lhNumber instanceof VlogBitVector)) {
                            return true;
                        }
                        if (!lhNumber.equals(VlogBitVector.BIT_ONE) && lhNumber.getSize() == 1) {
                            return true;
                        }
                        ListContainer<IHidObject> rhHids = operator.getRHValues();
                        if (rhHids == null || rhHids.size() != 1) {
                            return true;
                        }
                        IHidObject rhHidObject = rhHids.get(0);
                        if (HidUtils.isHidAccess(rhHidObject) && ((HidAccess)rhHidObject).isSelect()) {
                            List<IHidObject> selects = ((HidAccess)rhHidObject).getSelects();
                            if (selects == null || selects.size() != 1) {
                                return true;
                            }
                            Hid candidateStateHid = ((HidAccess)rhHidObject).getParentHid();
                            IRfNamedElement candidateState = HidUtils.getResolvedElement(candidateStateHid);
                            if (!(candidateState instanceof IRfFieldElement)) {
                                return true;
                            }
                            candidateEquality.add((IRfFieldElement)candidateState);
                            blocks.put((IRfFieldElement)candidateState, actionBlock);
                        }
                    }
                    return true;
                }
            });
        }
        if (monitor.isCanceled()) {
            return null;
        }
        if (candidateAssign.isEmpty() || candidateEquality.isEmpty()) {
            return null;
        }
        candidateAssign.retainAll(candidateEquality);
        int nofCandidates = candidateAssign.size();
        ExecutorService executor = Executors.newWorkStealingPool(parallelism);
        ArrayList<IRfFieldElement> candidates = new ArrayList<IRfFieldElement>(candidateAssign);
        LogicForm normalizedForm = LFConverter.INSTANCE.convertElementAndNormalize(design, new StateVariableCheck(candidates), LFConverterOptions.FSM_SET, HidFlatteningOption.NONE_EXCLUDED, monitor);
        IFSMModel[] array = new IFSMModel[nofCandidates];
        int i = 0;
        while (i < nofCandidates) {
            int currentIndex = i++;
            executor.submit(() -> {
                IFSMModel model = FSMConverter.internalConvert((IRfFieldElement)candidates.get(currentIndex), design, normalizedForm, monitor);
                iFSMModelArray[n] = model = model != null && !model.hasTransitions() ? null : model;
            });
        }
        executor.shutdown();
        try {
            executor.awaitTermination(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            monitor.setCanceled(true);
        }
        LinkedHashMap<IRfFieldElement, IFSMModel> result = new LinkedHashMap<IRfFieldElement, IFSMModel>(array.length);
        int i2 = 0;
        while (i2 < nofCandidates) {
            if (array[i2] != null) {
                array[i2].setEnclosingScope((IRfActionBlockElement)blocks.get(candidates.get(i2)));
                result.put((IRfFieldElement)candidates.get(i2), array[i2]);
            }
            ++i2;
        }
        return result.isEmpty() ? null : result;
    }

    static class StateVariableCheck
    implements Predicate<IHidObject> {
        Collection<IRfFieldElement> stateVariables;

        public StateVariableCheck(Collection<IRfFieldElement> stateVariables) {
            this.stateVariables = stateVariables;
        }

        @Override
        public boolean test(IHidObject hidObject) {
            block5: for (IRfNamedElement iRfNamedElement : this.stateVariables) {
                switch (hidObject.getHidKind()) {
                    case HID: {
                        if (iRfNamedElement != ((Hid)hidObject).getElement()) break;
                        return true;
                    }
                    case ACCESS: {
                        Hid parentHid = ((HidAccess)hidObject).getParentHid();
                        if (parentHid == null || iRfNamedElement != parentHid.getElement()) continue block5;
                        return true;
                    }
                    case OPERATOR: {
                        Set<IHid> flatten;
                        if (!((HidOperator)hidObject).isConcatOrAssignPatternOperator() || (flatten = HidUtils.flattenToHids(hidObject, HidFlatteningOption.NONE_EXCLUDED)) == null) continue block5;
                        for (IHid memberHid : flatten) {
                            if (iRfNamedElement != memberHid.getElement()) continue;
                            return true;
                        }
                        continue block5;
                    }
                }
            }
            return false;
        }
    }
}

