/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.debug;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.fsm.debug.FSMDebugConstants;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMExecutors;
import ro.amiq.dvt.fsm.utils.FSMVisitors;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class FSMDebugUtils {
    private FSMDebugUtils() {
    }

    public static final void debugLevelOne(String message, Object ... objects) {
        FSMDebugUtils.debugLevelOne(true, message, objects);
    }

    public static final void debugLevelOne(boolean condition, String message, Object ... objects) {
        FSMDebugUtils.debugOnLevel(FSMDebugConstants.DEBUG_ONE, condition, "DEBUG ONE ### " + message, objects);
    }

    public static final void debugLevelTwo(String message, Object ... objects) {
        FSMDebugUtils.debugLevelTwo(true, message, objects);
    }

    public static final void debugLevelTwo(boolean condition, String message, Object ... objects) {
        FSMDebugUtils.debugOnLevel(FSMDebugConstants.DEBUG_TWO, condition, "DEBUG TWO ### " + message, objects);
    }

    public static final void debugLevelThree(String message, Object ... objects) {
        FSMDebugUtils.debugLevelThree(true, message, objects);
    }

    public static final void debugLevelThree(boolean condition, String message, Object ... objects) {
        FSMDebugUtils.debugOnLevel(FSMDebugConstants.DEBUG_THREE, condition, "DEBUG THREE ### " + message, objects);
    }

    private static final void debugOnLevel(boolean debugCondition, boolean condition, String message, Object ... objects) {
        if (!debugCondition) {
            return;
        }
        if (condition) {
            StringBuilder sb = new StringBuilder("\n" + message);
            if (objects != null && objects.length > 0) {
                sb.append(DVTStringUtil.join(objects, ", "));
            }
            DVTLogger.INSTANCE.logInfo(sb.toString());
        }
    }

    public static void printModel(IFSMModel model) {
        if (model == null) {
            FSMDebugUtils.debugLevelOne("Model is NULL", new Object[0]);
            return;
        }
        FSMExecutors.newBFS().setModel(model, false, (IProgressMonitor)new NullProgressMonitor()).addVisitor(new FSMVisitors.StateTransitionVisitor(){

            @Override
            public void visit(IFSMState state) {
                DVTLogger.INSTANCE.logInfo("State: " + state);
            }

            @Override
            public void visit(IFSMTransition transition) {
                DVTLogger.INSTANCE.logInfo("** " + transition);
            }
        }).start();
    }
}

