/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.model;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import ro.amiq.dvt.fsm.model.IFSMBase;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMMarkerHolder;
import ro.amiq.dvt.fsm.model.IFSMOutput;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.fsm.utils.FSMUtils;
import ro.amiq.dvt.model.reflection.IRfNamedElement;

public interface IFSMState
extends IFSMBase,
IFSMMarkerHolder {
    public String getID();

    public String getNiceID();

    public IRfNamedElement getElement();

    public void setNiceID(String var1);

    default public boolean hasNiceID() {
        String niceID = this.getNiceID();
        return niceID != null && !niceID.equals(this.getID());
    }

    public boolean isStart();

    public boolean isDefault();

    public void setIsStart(boolean var1);

    public void setIsDefault(boolean var1);

    public Collection<? extends IFSMTransition> getOutgoingTransitions();

    public Collection<? extends IFSMTransition> getOutgoingTransitions(boolean var1);

    public Collection<? extends IFSMTransition> getIncomingTransitions();

    public Collection<? extends IFSMTransition> getIncomingTransitions(boolean var1);

    public void addOutgoingTransition(IFSMTransition var1);

    public void addIncomingTransition(IFSMTransition var1);

    public boolean removeIncomingTransition(IFSMTransition var1);

    public IFSMTransition getOutgoingTransition(IFSMInput var1);

    default public IFSMState getNextState(IFSMInput input) {
        return this.getOutgoingTransition(input).getDestination();
    }

    default public Set<IFSMState> getNextStates() {
        Collection<? extends IFSMTransition> transitions = this.getOutgoingTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IFSMState> states = new LinkedHashSet<IFSMState>();
        for (IFSMTransition iFSMTransition : transitions) {
            if (FSMUtils.isLoopbackTransition(iFSMTransition)) continue;
            states.add(iFSMTransition.getDestination());
        }
        return states;
    }

    default public Set<IFSMState> getPreviousStates() {
        Collection<? extends IFSMTransition> transitions = this.getIncomingTransitions();
        if (transitions == null || transitions.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<IFSMState> states = new LinkedHashSet<IFSMState>();
        for (IFSMTransition iFSMTransition : transitions) {
            if (FSMUtils.isLoopbackTransition(iFSMTransition)) continue;
            states.add(iFSMTransition.getSource());
        }
        return states;
    }

    default public IFSMOutput getOutput() {
        return IFSMOutput.DO_NOTHING;
    }

    default public void performOutput() {
        this.getOutput().perform();
    }
}

