/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import ro.amiq.dvt.diagrams.fsm.model.FSMFactory;
import ro.amiq.dvt.fsm.IFSMExecutor;
import ro.amiq.dvt.fsm.IFSMVisitor;
import ro.amiq.dvt.fsm.debug.FSMDebugUtils;
import ro.amiq.dvt.fsm.model.IFSMModel;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;

public final class FSMExecutors {
    private FSMExecutors() {
    }

    public static final IFSMExecutor newBFS() {
        return new BFSExecutor();
    }

    public static final IFSMExecutor newDFS() {
        return new DFSExecutor();
    }

    private static final boolean checkStart(IFSMModel model, List<IFSMVisitor> visitors) {
        if (model == null) {
            FSMDebugUtils.debugLevelOne("No model was passed to the engine!", new Object[0]);
            return false;
        }
        Collection<? extends IFSMState> states = model.getStates();
        if (states == null || states.isEmpty()) {
            FSMDebugUtils.debugLevelOne("The model passed to the engine has no states!", new Object[0]);
            return false;
        }
        if (visitors.isEmpty()) {
            FSMDebugUtils.debugLevelOne("No visitors have been added to the engine!", new Object[0]);
            return false;
        }
        if (model.getStartStates().isEmpty()) {
            FSMDebugUtils.debugLevelOne("The model passed to the engine has no initial transaction!", new Object[0]);
            return true;
        }
        return true;
    }

    private static final class BFSExecutor
    implements IFSMExecutor {
        private IFSMModel model;
        private IProgressMonitor monitor;
        private List<IFSMVisitor> visitors = new ArrayList<IFSMVisitor>(4);
        private boolean sortTransitions;

        private BFSExecutor() {
        }

        @Override
        public IFSMExecutor setModel(IFSMModel model, boolean sortTransitions, IProgressMonitor monitor) {
            this.model = model;
            this.monitor = monitor;
            this.sortTransitions = sortTransitions;
            return this;
        }

        @Override
        public IFSMExecutor addVisitor(IFSMVisitor visitor) {
            this.visitors.add(visitor);
            return this;
        }

        @Override
        public boolean start() {
            if (!FSMExecutors.checkStart(this.model, this.visitors)) {
                return false;
            }
            block0: for (IFSMVisitor visitor : this.visitors) {
                if (this.monitor.isCanceled()) {
                    return false;
                }
                LinkedHashSet<? extends IFSMState> remaining = new LinkedHashSet<IFSMState>(this.model.getStates());
                LinkedHashSet<IFSMState> visited = new LinkedHashSet<IFSMState>(remaining.size());
                for (IFSMState iFSMState : this.model.getStartStates()) {
                    BFSExecutor.bfs(FSMFactory.createStartTransition(iFSMState), visited, visitor, this.sortTransitions, this.monitor);
                }
                while (!this.monitor.isCanceled()) {
                    remaining.removeAll(visited);
                    if (remaining.isEmpty()) continue block0;
                    IFSMState iFSMState = (IFSMState)remaining.iterator().next();
                    BFSExecutor.bfs(FSMFactory.createStartTransition(iFSMState), visited, visitor, this.sortTransitions, this.monitor);
                }
                return false;
            }
            return true;
        }

        private static void bfs(IFSMTransition trans, Set<IFSMState> visited, IFSMVisitor visitor, boolean sortTransitions, IProgressMonitor monitor) {
            ArrayDeque<IFSMState> boundary = new ArrayDeque<IFSMState>();
            boundary.add(trans.getDestination());
            visitor.visit(trans.getSourceInput());
            visitor.visit(trans);
            while (!boundary.isEmpty()) {
                if (monitor.isCanceled()) {
                    return;
                }
                IFSMState cState = (IFSMState)boundary.poll();
                if (visited.contains(cState)) continue;
                visited.add(cState);
                visitor.visit(cState);
                for (IFSMTransition iFSMTransition : cState.getOutgoingTransitions(sortTransitions)) {
                    visitor.visit(iFSMTransition.getSourceInput());
                    visitor.visit(iFSMTransition);
                    boundary.add(iFSMTransition.getDestination());
                }
            }
        }

        @Override
        public boolean stop() {
            this.monitor.setCanceled(true);
            return false;
        }
    }

    private static final class DFSExecutor
    implements IFSMExecutor {
        private IFSMModel model;
        private IProgressMonitor monitor;
        private List<IFSMVisitor> visitors = new ArrayList<IFSMVisitor>(4);
        private boolean sortTransitions;

        private DFSExecutor() {
        }

        @Override
        public IFSMExecutor setModel(IFSMModel model, boolean sortTransitions, IProgressMonitor monitor) {
            this.model = model;
            this.monitor = monitor;
            this.sortTransitions = sortTransitions;
            return this;
        }

        @Override
        public IFSMExecutor addVisitor(IFSMVisitor visitor) {
            this.visitors.add(visitor);
            return this;
        }

        @Override
        public boolean start() {
            if (!FSMExecutors.checkStart(this.model, this.visitors)) {
                return false;
            }
            block0: for (IFSMVisitor visitor : this.visitors) {
                if (this.monitor.isCanceled()) {
                    return false;
                }
                LinkedHashSet<? extends IFSMState> remaining = new LinkedHashSet<IFSMState>(this.model.getStates());
                LinkedHashSet<IFSMState> visited = new LinkedHashSet<IFSMState>(remaining.size());
                for (IFSMState iFSMState : this.model.getStartStates()) {
                    DFSExecutor.dfs(FSMFactory.createStartTransition(iFSMState), visited, visitor, this.sortTransitions, this.monitor);
                }
                while (!this.monitor.isCanceled()) {
                    remaining.removeAll(visited);
                    if (remaining.isEmpty()) continue block0;
                    IFSMState iFSMState = (IFSMState)remaining.iterator().next();
                    DFSExecutor.dfs(FSMFactory.createStartTransition(iFSMState), visited, visitor, this.sortTransitions, this.monitor);
                }
                return false;
            }
            return true;
        }

        private static void dfs(IFSMTransition trans, Set<IFSMState> visited, IFSMVisitor visitor, boolean sortTransitions, IProgressMonitor monitor) {
            IFSMState cState = trans.getDestination();
            visitor.visit(trans.getSourceInput());
            visitor.visit(trans);
            visitor.visit(cState);
            if (visited.contains(cState)) {
                return;
            }
            visited.add(cState);
            for (IFSMTransition iFSMTransition : cState.getOutgoingTransitions(sortTransitions)) {
                if (monitor.isCanceled()) {
                    return;
                }
                DFSExecutor.dfs(iFSMTransition, visited, visitor, sortTransitions, monitor);
            }
        }

        @Override
        public boolean stop() {
            this.monitor.setCanceled(true);
            return false;
        }
    }
}

