/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.utils;

import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.diagrams.fsm.model.FSMFactory;
import ro.amiq.dvt.fsm.utils.FSMFilterVisitor;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.utils.LFUtils;

public class FSMFilterCommonExpressionsVisitor
extends FSMFilterVisitor {
    private final Set<String> commonExpressions;

    public FSMFilterCommonExpressionsVisitor(Set<String> commonExpressions) {
        this.commonExpressions = commonExpressions;
    }

    @Override
    protected FSMCondition filterCondition(FSMCondition condition) {
        List<LFFormula> commonFormulas = LFUtils.flattenFormula(condition.getFormula(), formula -> {
            if (LFUtils.isEmptyFormula(formula)) {
                return false;
            }
            return !this.commonExpressions.contains(formula.toString());
        });
        if (commonFormulas.isEmpty()) {
            return FSMFactory.createCondition(LFFormula.FILTERED_FORMULA);
        }
        LFFormula andFormulas = LFUtils.andFormulas(commonFormulas);
        return FSMFactory.createCondition(andFormulas);
    }
}

