/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.utils;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.diagrams.fsm.model.FSMFactory;
import ro.amiq.dvt.fsm.utils.FSMFilterVisitor;
import ro.amiq.dvt.logic.form.model.LFFormula;
import ro.amiq.dvt.logic.form.utils.LFUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.HidFlatteningOption;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;

public class FSMFilterNamesVisitor
extends FSMFilterVisitor {
    private final boolean isVhdl;
    private final Set<String> filteredSignalNames;

    public FSMFilterNamesVisitor(boolean isVhdl, Set<String> filteredSignalNames) {
        this.isVhdl = isVhdl;
        this.filteredSignalNames = filteredSignalNames;
    }

    @Override
    protected FSMCondition filterCondition(FSMCondition condition) {
        boolean[] changed = new boolean[1];
        List<LFFormula> remaining = LFUtils.flattenFormula(condition.getFormula(), formula -> {
            if (LFUtils.isEmptyFormula(formula)) {
                return false;
            }
            LinkedHashSet<IHid> flattened = new LinkedHashSet<IHid>();
            formula.collectExprHids(flattened, HidFlatteningOption.NONE_EXCLUDED);
            for (IHid hid : flattened) {
                String hidName;
                if (!HidUtils.isHid(hid)) continue;
                String string = hidName = this.isVhdl ? HidUtils.toNiceString(hid).toLowerCase() : HidUtils.toNiceString(hid);
                if (!this.filteredSignalNames.contains(hidName)) continue;
                blArray[0] = true;
                return false;
            }
            return true;
        });
        if (!changed[0]) {
            return null;
        }
        if (remaining.isEmpty()) {
            return FSMFactory.createCondition(LFFormula.FILTERED_FORMULA);
        }
        LFFormula andFormulas = LFUtils.andFormulas(remaining);
        return FSMFactory.createCondition(andFormulas);
    }
}

