/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.fsm.utils;

import de.cau.cs.kieler.kiml.options.Direction;
import de.cau.cs.kieler.klay.layered.p4nodes.NodePlacementStrategy;
import de.cau.cs.kieler.klay.layered.properties.LayerConstraint;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.diagrams.fsm.FSMDiagramConfiguration;
import ro.amiq.dvt.diagrams.fsm.editor.actions.TransitionLabelType;
import ro.amiq.dvt.diagrams.fsm.model.FSMCondition;
import ro.amiq.dvt.diagrams.fsm.model.FSMFactory;
import ro.amiq.dvt.diagrams.fsm.model.FSMInput;
import ro.amiq.dvt.diagrams.fsm.model.FSMState;
import ro.amiq.dvt.fsm.model.IFSMBase;
import ro.amiq.dvt.fsm.model.IFSMCondition;
import ro.amiq.dvt.fsm.model.IFSMInput;
import ro.amiq.dvt.fsm.model.IFSMState;
import ro.amiq.dvt.fsm.model.IFSMTransition;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.IHid;
import ro.amiq.dvt.utils.DVTStringUtil;

public final class FSMUtils {
    private FSMUtils() {
    }

    public static final boolean isEqual(IFSMState state, IHid other, LanguageKind languageKind) {
        if (state == null || other == null) {
            return false;
        }
        return state.equals(FSMFactory.createState(other, other.getElement(), languageKind));
    }

    public static final boolean isEqual(IFSMState state, IRfNamedElement other, LanguageKind languageKind) {
        if (state == null || other == null) {
            return false;
        }
        return state.equals(FSMFactory.createState(other, languageKind));
    }

    public static final boolean isEqual(IFSMState state, IFSMState other) {
        if (state == null || other == null) {
            return false;
        }
        return state.equals(other);
    }

    public static final boolean isStartTransition(IFSMTransition trans) {
        if (trans == null) {
            return false;
        }
        return FSMState.VOID == trans.getSource() && FSMInput.EMPTY == trans.getSourceInput() && FSMState.VOID != trans.getDestination();
    }

    public static final boolean isLoopbackTransition(IFSMTransition trans) {
        if (trans == null) {
            return false;
        }
        return trans.getSource() == trans.getDestination();
    }

    public static final boolean isStartState(IFSMBase base) {
        return base instanceof FSMState && ((FSMState)base).isStart();
    }

    public static final boolean isEmptyCondition(IFSMCondition condition) {
        return condition instanceof FSMCondition && ((FSMCondition)condition).isEmpty();
    }

    public static final boolean isEmptyInput(IFSMInput input) {
        if (!(input instanceof FSMInput)) {
            return false;
        }
        List<IFSMCondition> conditions = ((FSMInput)input).getConditions();
        for (IFSMCondition ifsmCondition : conditions) {
            if (FSMUtils.isEmptyCondition(ifsmCondition)) continue;
            return true;
        }
        return false;
    }

    public static Direction getDirectionFromString(String direction) {
        return Direction.valueOf((String)direction.toUpperCase());
    }

    public static NodePlacementStrategy getNodePlacementStrategyFromString(String nodePlacementStrategy) {
        switch (nodePlacementStrategy) {
            case "Network Simplex": {
                return NodePlacementStrategy.NETWORK_SIMPLEX;
            }
        }
        return NodePlacementStrategy.BRANDES_KOEPF;
    }

    public static FSMDiagramConfiguration.EnforceTransitionPortsOption getEnforceTransitionPortsFromString(String enforceTransitionPorts) {
        switch (DVTStringUtil.toNiceTitleCase(enforceTransitionPorts)) {
            case "None": {
                return FSMDiagramConfiguration.EnforceTransitionPortsOption.NONE;
            }
            case "All States": {
                return FSMDiagramConfiguration.EnforceTransitionPortsOption.ALL_STATES;
            }
        }
        return FSMDiagramConfiguration.EnforceTransitionPortsOption.ALL_STATES_EXCEPT_INITIAL;
    }

    public static LayerConstraint getLayerConstraintFromString(String layerConstraint) {
        switch (layerConstraint) {
            case "Free": {
                return LayerConstraint.NONE;
            }
            case "Last": {
                return LayerConstraint.LAST_SEPARATE;
            }
        }
        return LayerConstraint.FIRST_SEPARATE;
    }

    public static TransitionLabelType getTransitionLabelTypeFromString(String transitionLabelType) {
        switch (transitionLabelType) {
            case "None": {
                return TransitionLabelType.NONE;
            }
            case "Condition": {
                return TransitionLabelType.CONDITION;
            }
        }
        return TransitionLabelType.INDEX;
    }

    public static Set<String> getNamesFilteredInCondition(String namesInCondition) {
        String[] newValueArray = namesInCondition.split(",");
        Set<String> newValues = Collections.emptySet();
        if (newValueArray.length > 0) {
            newValues = new LinkedHashSet<String>(newValueArray.length);
            String[] stringArray = newValueArray;
            int n = newValueArray.length;
            int n2 = 0;
            while (n2 < n) {
                String newValue = stringArray[n2];
                String trim = newValue.trim();
                if (!trim.isEmpty()) {
                    newValues.add(trim);
                }
                ++n2;
            }
        }
        return newValues;
    }
}

