/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.eclipse.debug.core.ILaunch;

public class DVTRunLaunchCache {
    private static DVTRunLaunchCache fInstance;
    private static final Object fSyncInstance;
    private Queue<ILaunch> launches = new ConcurrentLinkedDeque<ILaunch>(new ArrayList(1));

    static {
        fSyncInstance = new Object();
    }

    private DVTRunLaunchCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DVTRunLaunchCache getInstance() {
        if (fInstance == null) {
            Object object = fSyncInstance;
            synchronized (object) {
                fInstance = new DVTRunLaunchCache();
            }
        }
        return fInstance;
    }

    public Queue<ILaunch> getLaunches() {
        return this.launches;
    }

    public void addLaunch(ILaunch launch) {
        if (launch == null) {
            return;
        }
        this.launches.add(launch);
    }

    public ILaunch getLaunch() {
        return this.launches.peek();
    }

    public void clear() {
        this.launches.clear();
    }

    public boolean isDVTRunInProgress() {
        if (this.launches == null || this.launches.isEmpty()) {
            return false;
        }
        for (ILaunch launch : this.launches) {
            if (launch.isTerminated() || launch.getDebugTarget() == null || launch.getDebugTarget().isTerminated()) continue;
            return true;
        }
        return false;
    }
}

