/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import ro.amiq.dvt.diagrams.ch.model.XVMBuildPhaseXMLParser;
import ro.amiq.dvt.settings.DVTSConstants;

public interface DVTXRunBuildPhaseUtils {
    public static final String UVM_ROOT = "uvm_root";
    public static final String OVM_ROOT = "ovm_root";
    public static final String UVM_PKG__UVM_ROOT = "uvm_pkg::uvm_root";
    public static final String OVM_PKG__OVM_ROOT = "ovm_pkg::ovm_root";
    public static final List<String> XVM_ROOT = Arrays.asList("uvm_root", "ovm_root", "uvm_pkg::uvm_root", "ovm_pkg::ovm_root");
    public static final String RUN_BUILD_PHASE_DEFAULT_CONFIG_TYPE = "ro.amiq.dvt.launch.DVTRunBuildPhaseConfigurationType";
    public static final String SIM_DEBUG_CUSTOM_DIALOG = "RunAllDefaultCustomDialog.swtxml";
    public static final String SIMULATION_CUSTOM_ARGS = "Runtime arguments:";
    public static final String BUILD_PHASE_VERSION = "4";
    public static final String DOT_SWTXML = ".swtxml";
    public static final String ERROR_DVT_RUN_BUILD_PHASE = "DVT Run Build Phase Error";
    public static final String ERROR_TEST_NAME_NOT_PROVIDED = "Must provide test name!";
    public static final String ERROR_TEST_NOT_FOUND = "Could not find test class with name %s!";
    public static final String ERROR_CUSTOM_DIALOG_TEST_NAME = "Custom dialog should include at least the test name";
    public static final String DOT_DVT = ".dvt";
    public static final String DVT_DETAILS_CUSTOM_DIALOG = "[dvt_details: build_phase_dialog_version=\"4\"]";

    public static IFolder getDVTProjectFolder(String projectName) {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFolder(DOT_DVT);
    }

    public static IFile getOrCreateFileCustomDialog(String fileName) throws Exception {
        IFolder dvtUserSettingsFolder = ResourcesPlugin.getWorkspace().getRoot().getProject("DVT-Settings").getFolder("user");
        dvtUserSettingsFolder.refreshLocal(1, null);
        IFile file = dvtUserSettingsFolder.getFile(fileName);
        if (file.exists()) {
            Document document = XVMBuildPhaseXMLParser.getDocument(new File(file.getLocation().toOSString()));
            Node firstChild = document.getFirstChild();
            if (DVT_DETAILS_CUSTOM_DIALOG.equals(firstChild.toString())) {
                return file;
            }
            file.delete(true, null);
        }
        String resourceName = fileName.equals(SIM_DEBUG_CUSTOM_DIALOG) ? SIM_DEBUG_CUSTOM_DIALOG : "UVM_Elaboration_CustomDialog.swtxml";
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStream openStream = DVTXRunBuildPhaseUtils.class.getResource(resourceName).openStream();){
            file.create(openStream, DVTSConstants.MANAGE_SETTINGS, null);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }
}

