/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfScopeElement;

public interface IXConfigDBConstants {
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String OPEN_TYPE_DECLARATION = "Open Type Declaration";
    public static final String INSPECT_VALUE = "Inspect Value";
    public static final String INSPECT_CONTEXT = "Inspect Context";
    public static final String WRITE = "write";
    public static final String IS_TRACING = "is_tracing";
    public static final String UVM_CONFIG_DB = "uvm_config_db";
    public static final String UVM_RESOURCE = "uvm_resource";
    public static final String ARG_CNTXT = "cntxt";
    public static final String ARG_INST_NAME = "inst_name";
    public static final String ARG_FIELD_NAME = "field_name";
    public static final String ARG_VALUE = "value";
    public static final String STATEMENT_RESOURCE = "r";
    public static final String STATEMENT_NEW_VALUE = "t";
    public static final String FUNC_IS_READ_ONLY = "is_read_only";
    public static final String FIELD_VAL = "val";
    public static final String UNKNOWN = "<unknown>";
    public static final String DEFAULT_PARAMETERIZED_VALUE = "T";
    public static final String NULL = "null";
    public static final String COPY_INST_NAME = "Copy instance name";
    public static final String COPY_FIELD_NAME = "Copy field name";
    public static final String FILTERED_ELEMENTS_DETECTED = "Elements filtered By Content Filters";
    public static final String VAL = "val";

    public static String getValueToString(IELParamValue value) {
        if (value == null) {
            return "";
        }
        if (value instanceof XValueHolder) {
            return ((XValueHolder)value).toStringConfigDB();
        }
        return IELParamValue.NULL_VALUE.equals(value) ? NULL : ELUtils.valueToString(value);
    }

    public static ConfigDBCallType isConfigDBCall(IRfMethodElement rfFunction) {
        String methodName = rfFunction.getName();
        if (!SET.equals(methodName) && !GET.equals(methodName)) {
            return ConfigDBCallType.NONE;
        }
        IRfScopeElement enclosingScope = rfFunction.getEnclosingScope();
        if (!(enclosingScope instanceof IRfClassElement)) {
            return ConfigDBCallType.NONE;
        }
        String enclosingName = enclosingScope.getName();
        if (!UVM_CONFIG_DB.equals(enclosingName)) {
            return ConfigDBCallType.NONE;
        }
        return SET.equals(methodName) ? ConfigDBCallType.SET : ConfigDBCallType.GET;
    }

    public static enum ConfigDBCallType {
        SET,
        GET,
        NONE;

    }
}

