/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.XUVMElaborationSetup;
import ro.amiq.dvt.interpreter.dpi.types.IXDPITypeMapperManager;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.ui.views.IBuildEventManagerListener;
import ro.amiq.dvt.ui.views.lazy.views.verification.hierarchy.UVMRuntimeSettings;
import ro.amiq.dvt.utils.DVTStringUtil;

public interface IXUVMElaborationStarter {
    public static final String XML = "xml";
    public static final String DVT_UVM_BUILD_PHASE_REFERENCE_MODELS = "dvt_uvm_build_phase_reference_models";
    public static final String DVT_UVM_ELABORATION_MODELS = "dvt_uvm_elaboration_models";
    public static final String UVM_TESTNAME = "UVM_TESTNAME";
    public static final String OVM_TESTNAME = "OVM_TESTNAME";

    public void notifyContributorsSuccessMode(XUVMElaborationSetup var1);

    public void notifyContributorsErrorMode(XUVMElaborationSetup var1);

    public void setLoadModelSuccesfully(IProject var1, String var2);

    public IXDPITypeMapperManager getDPICMapperManager();

    default public List<File> getUVMBuildPhaseSerializedModels(IProject project, boolean serachInReferences) {
        try {
            IFolder folder = null;
            folder = serachInReferences ? project.getFolder(DVT_UVM_BUILD_PHASE_REFERENCE_MODELS) : project.getFolder(DVT_UVM_ELABORATION_MODELS);
            if (!folder.exists()) {
                return Collections.emptyList();
            }
            folder.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            Throwable throwable = null;
            Object var5_7 = null;
            try (Stream<Path> walk = Files.walk(Paths.get(folder.getLocation().toOSString(), new String[0]), new FileVisitOption[0]);){
                return walk.filter(pathToFile -> XML.equals(FilenameUtils.getExtension((String)pathToFile.toFile().getName())) && pathToFile.toFile().isFile()).map(Path::toFile).collect(Collectors.toList());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            DVTLogger.INSTANCE.logError(e);
            return Collections.emptyList();
        }
    }

    default public UVMRuntimeSettings getRuntimeSettings(IProject project, String elementName) {
        return null;
    }

    public XUVMElaborationSetup buildSetup(String[] var1, IProject var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public XUVMElaborationSetup buildSetupFromCustomArgs(String[] var1, IProject var2, String var3, boolean var4, boolean var5, boolean var6, boolean var7);

    public void start(XUVMElaborationSetup var1);

    public IStatus saveModel(XUVMElaborationSetup var1);

    public IStatus loadModelAction(IProject var1, String var2);

    public void loadModel(IProject var1, File var2);

    public IBuildEventManagerListener getXModelEventListener();

    public LanguageKind getLanguageKind();

    public IStatus generate(IProject var1, UVMRuntimeSettings var2);

    public IStatus generateDPICHeader(IProject var1, boolean var2);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeArgumentValue(List<String> customArgs, List<String> prefixes, boolean remove) {
        try {
            if (customArgs == null) return null;
            if (customArgs.isEmpty()) {
                return null;
            }
            Iterator<String> iterator = customArgs.iterator();
            while (iterator.hasNext()) {
                String arg = iterator.next();
                if (arg == null) continue;
                for (String prefix : prefixes) {
                    String[] split;
                    if (!arg.startsWith(prefix)) continue;
                    if (remove) {
                        iterator.remove();
                    }
                    if ((split = DVTStringUtil.split("=", arg)) == null) return null;
                    if (split.length == 0) {
                        return null;
                    }
                    if (split.length != 2) return split[0];
                    return split[1];
                }
            }
            return null;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return null;
        }
    }
}

