/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BinaryOperator;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.IDVTConstants;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.elaboration.ELConstants;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.DVTXVariableInfo;
import ro.amiq.dvt.interpreter.IXArrayValues;
import ro.amiq.dvt.interpreter.IXInternalForeachLoopAction;
import ro.amiq.dvt.interpreter.IXIterator;
import ro.amiq.dvt.interpreter.IXLoopAction;
import ro.amiq.dvt.interpreter.XComputedSelect;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMapValues;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XQueueValues;
import ro.amiq.dvt.interpreter.XSelectProxy;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUnknownSizeIterator;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.interpreter.constraints.XCModel;
import ro.amiq.dvt.interpreter.dpi.IXSystemCFactory;
import ro.amiq.dvt.interpreter.dpi.types.IXDPITypeMapperManager;
import ro.amiq.dvt.interpreter.sim.XSimRegion;
import ro.amiq.dvt.model.BuildCancelException;
import ro.amiq.dvt.model.reflection.IRfClockingBlockElement;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfInterface;
import ro.amiq.dvt.model.reflection.IRfListType;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfModportElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.RfDummyElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.HidAccess;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOccurrence;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperatorWrapper;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.DVTUnpackedArray;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;

public class XArrayValueHolder
extends XValueHolder {
    public static final Set<String> METHODS_WITH_ITERATOR = new HashSet<String>(Arrays.asList("find", "find_first", "find_last", "find_index", "find_first_index", "find_last_index", "sort", "rsort", "sum", "product", "and", "or", "xor", "unique", "unique_index"));
    private IXArrayValues arrayValues;
    private BitVectorContext indexContext;
    private BitVectorContext itemContext;
    private IRfNamedElement itemElementType;
    private IELParamValue itemEnclosing;
    private int leftBound = -1;
    private int rightBound = -1;
    private boolean hasUnknownSize;
    private String instancePrefixName;
    public static final Comparator<? super IELParamValue> COMPARATOR = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null || o2 == null) {
            return 0;
        }
        if (o1 instanceof IELParamValue.UndefinedXValue && o2 instanceof IELParamValue.UndefinedXValue) {
            return 0;
        }
        if (o1 instanceof IELParamValue.UndefinedXValue) {
            return -1;
        }
        if (o2 instanceof IELParamValue.UndefinedXValue) {
            return 1;
        }
        if (o1 instanceof ELParamValues.ParamValueNumber && o2 instanceof ELParamValues.ParamValueNumber) {
            if (DVTNumber.isString(o1.getDVTNumber()) && DVTNumber.isString(o2.getDVTNumber())) {
                return ELUtils.valueToString(o1).compareTo(ELUtils.valueToString(o2));
            }
            return o1.bigIntegerValue().compareTo(o2.bigIntegerValue());
        }
        if (o1 instanceof ELParamValues.ParamValueNumber && o2 instanceof ELParamValues.ParamValueNumber) {
            return o1.bigIntegerValue().compareTo(o2.bigIntegerValue());
        }
        if (o1 instanceof XValueHolder && o2 instanceof XValueHolder) {
            return ((XValueHolder)o1).uniqueValuesId() - ((XValueHolder)o2).uniqueValuesId();
        }
        throw new UnsupportedOperationException();
    };

    public XArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        this(factory, xAssociatedType, enclosing, instanceScope, null);
    }

    public XArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean init, XComputedSelect subRange, boolean initForQueue) {
        super(factory, xAssociatedType, enclosing, instanceScope, false, false, false);
        this.initValues(subRange, init, initForQueue);
    }

    public XArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, String instancePrefixName) {
        this(factory, xAssociatedType, enclosing, instanceScope, instancePrefixName, true);
    }

    private XArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, String instancePrefixName, boolean initValues) {
        super(factory, xAssociatedType, enclosing, instanceScope, false, false, false);
        this.instancePrefixName = instancePrefixName;
        this.initValues(null, initValues, false);
    }

    public XArrayValueHolder(XArrayValueHolder other) {
        super(other.factory, other.xAssociatedType, other.enclosing, other.instanceScope, false, false, false);
        this.instancePrefixName = other.instancePrefixName;
        this.indexContext = other.indexContext;
        this.itemContext = other.itemContext;
        this.itemElementType = other.itemElementType;
        this.hasUnknownSize = other.hasUnknownSize;
        this.leftBound = other.leftBound;
        this.rightBound = other.rightBound;
        boolean isQueue = other.arrayValues instanceof XQueueValues;
        this.arrayValues = isQueue ? new XQueueValues((XQueueValues)other.arrayValues) : new XMapValues((XMapValues)other.arrayValues);
    }

    public XArrayValueHolder copyByValue() {
        XArrayValueHolder result = new XArrayValueHolder(this);
        result.arrayValues.copyByValue(this.arrayValues, true);
        return result;
    }

    @Override
    public IELParamValue scalarCopy() {
        return this.copyByValue();
    }

    @Override
    public XValueHolder copy() {
        return this.copyByValue();
    }

    public boolean isQueue() {
        return this.arrayValues instanceof XQueueValues;
    }

    public boolean isMapEntry() {
        return this.arrayValues instanceof XMapValues && ((XMapValues)this.arrayValues).getDebuggerIsMapEntry();
    }

    public boolean isQueueArray() {
        return this.xAssociatedType.getNamedElement().xIsQueue();
    }

    public boolean isAssociativeArray() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        boolean isAssociativeArray = namedElement.xIsAssociativeArray();
        return isAssociativeArray;
    }

    public boolean isDynamicArray() {
        IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
        boolean isDynamicArray = namedElement.xIsDynamicArray();
        return isDynamicArray;
    }

    public IELParamValue getFirstValueAtUnpackedDimension(Integer depth) {
        if (depth != null && depth < 0 || !(this.arrayValues instanceof XQueueValues)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        int offset = ((XQueueValues)this.arrayValues).getIndexOffset();
        IELParamValue value = this.arrayValues.getZValue(0 + offset);
        while ((depth == null || (depth = Integer.valueOf(depth - 1)) > 0) && value instanceof XArrayValueHolder) {
            if (!(((XArrayValueHolder)value).arrayValues instanceof XQueueValues)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            offset = ((XArrayValueHolder)value).getIndexOffset();
            value = ((XArrayValueHolder)value).arrayValues.getZValue(0 + offset);
        }
        return value != null ? value.copy() : IELParamValue.UNDEFINED_VALUE;
    }

    public boolean defaultFromAtUnpackedDimension(IELParamValue value, Integer depth, IHidEvaluationGuardian guardian) {
        if (value == null || depth != null && depth < 0 || !(this.arrayValues instanceof XQueueValues)) {
            return false;
        }
        if (this.isEmpty()) {
            return false;
        }
        int offset = ((XQueueValues)this.arrayValues).getIndexOffset();
        IELParamValue firstZValue = this.arrayValues.getZValue(0 + offset);
        if ((depth == null || (depth = Integer.valueOf(depth - 1)) > 0) && firstZValue instanceof XArrayValueHolder) {
            if (!((XArrayValueHolder)firstZValue).defaultFromAtUnpackedDimension(value, depth, guardian)) {
                return false;
            }
            int i = 1;
            while (i < this.arrayValues.size()) {
                IELParamValue zValue = this.arrayValues.getZValue(i + offset);
                if (!zValue.updateValue(firstZValue, guardian)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        int i = 0;
        while (i < this.arrayValues.size()) {
            IELParamValue zValue = this.arrayValues.getZValue(i + offset);
            if (!zValue.updateValue(value, guardian)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isSubList() {
        XSelectProxy selectProxy = this.getSelectProxy();
        if (selectProxy == null) {
            return false;
        }
        if (selectProxy.computedSelects == null || selectProxy.computedSelects.size() != 1 || selectProxy.computedSelects.get(0).getIndexes().length != 2) {
            return false;
        }
        int[] indexes = selectProxy.computedSelects.get(0).getIndexes();
        return indexes[0] != indexes[1];
    }

    private void initValues(XComputedSelect subListRange, boolean initValues, boolean initForQueue) {
        try {
            IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
            IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
            boolean isAssociative = namedElement.xIsAssociativeArray();
            boolean isQueue = namedElement.xIsQueue();
            this.arrayValues = isAssociative ? new XMapValues(isAssociative, this) : new XQueueValues(isQueue, this);
            this.indexContext = ((IRfListType)namedElement).xGetIndexBitVectorContext(this, guardian.isLinterStaticAnalysisMode() ? ELUtils.getEvalGuardian(ELConstants.EvalExceptionZone.RANGE, namedElement, null, false, this.getManager()) : guardian.copy(), null);
            this.itemElementType = this.factory.xGetAssociatedType((IRfListType)namedElement, this);
            if (this.itemElementType == null) {
                return;
            }
            if (guardian.isLinterStaticAnalysisMode()) {
                this.itemContext = this.getBitVectorContext(this.itemElementType);
            } else if (!XValueHolderFactory.xIsClass(this.itemElementType, true) && this.instancePrefixName == null) {
                IRfFieldElement itemField;
                if (namedElement.getLanguageKind() == LanguageKind.VHDL && (itemField = this.getItemElementField()) != null) {
                    this.itemContext = itemField.getDataTypeBitVectorContext(this, true, null, this.getManager());
                }
                if (this.itemContext == null) {
                    this.itemContext = this.getBitVectorContext(this.itemElementType);
                }
            }
            if (!initValues) {
                return;
            }
            if (isAssociative) {
                return;
            }
            XComputedSelect range = subListRange;
            int[] computedBounds = ((IRfListType)namedElement).xGetComputedBounds();
            if (computedBounds != null) {
                this.leftBound = computedBounds[0];
                this.rightBound = computedBounds[1];
            } else {
                IELParamValue leftValue;
                if (range == null) {
                    List<IHidObject> vhdlElementConstraints = this.xAssociatedType.getVHDLElementConstraints();
                    if (vhdlElementConstraints != null && !vhdlElementConstraints.isEmpty()) {
                        range = this.computeRangeSelectFromHidObject(vhdlElementConstraints.iterator().next(), isQueue, guardian);
                    }
                    if (!(range != null && range.computedValues != null && range.computedValues.length != 0 || (range = this.computeRangeSelectFromHidObject(((IRfListType)namedElement).xGetRangeObject(), isQueue, guardian)) != null && range.computedValues != null && range.computedValues.length != 0)) {
                        return;
                    }
                }
                if (ELUtils.isUnsuccessfulEval(leftValue = range.computedValues[0]) || DVTNumber.isUndefined(leftValue.getDVTNumber())) {
                    guardian.logError("Evaluation fail for array range LHS!");
                }
                this.hasUnknownSize |= leftValue.isUnknown();
                if (range.computedValues.length > 1) {
                    IELParamValue rightValue = range.computedValues[1];
                    if (ELUtils.isUnsuccessfulEval(rightValue) || DVTNumber.isUndefined(rightValue.getDVTNumber())) {
                        guardian.logError("Evaluation fail for array range RHS!");
                    }
                    this.hasUnknownSize |= rightValue.isUnknown();
                    int[] indexes = range.getIndexes();
                    this.leftBound = indexes[0];
                    this.rightBound = indexes[1];
                } else {
                    this.leftBound = 0;
                    this.rightBound = isQueue ? leftValue.getDVTNumber().intValue() : leftValue.getDVTNumber().intValue() - 1;
                }
            }
            this.arrayValues.setReversed(this.leftBound > this.rightBound);
            if (this.hasUnknownSize) {
                this.setIsUnknown(true);
                return;
            }
            if (isQueue) {
                ((XQueueValues)this.arrayValues).setMaxSize(this.rightBound + 1);
                if (!initForQueue) {
                    return;
                }
            }
            if (this.itemElementType == null) {
                return;
            }
            guardian.callbackStartInitVars(false);
            try {
                int min = Math.min(this.leftBound, this.rightBound);
                int max = Math.max(this.leftBound, this.rightBound);
                int size = max - min + 1;
                if (size >= 0x7FFFFF || size < 0) {
                    if (min >= 0) {
                        max = 32 + min - 1;
                    } else {
                        min = max - 32 + 1;
                    }
                    guardian.logWarning("Array of " + size + " entries limited to " + 32 + " entries.");
                }
                if (this.instancePrefixName != null) {
                    if (this.instanceScope == null) {
                        return;
                    }
                    int i = min;
                    while (i <= max) {
                        guardian.checkBuildCanceled();
                        String instanceItemName = DVTStringUtil.appendString(this.instancePrefixName, "[", i, "]");
                        IELParamValue initValue = this.instanceScope.getValueDirectly(instanceItemName);
                        if (ELUtils.isUnsuccessfulEval(initValue)) {
                            guardian.logError("Evaluation fail for '" + instanceItemName + "' in '" + this.enclosing + "' scope.");
                        }
                        this.arrayValues.put(i, initValue, guardian);
                        ++i;
                    }
                    return;
                }
                if (this.arrayValues instanceof XQueueValues) {
                    if (subListRange == null) {
                        ((XQueueValues)this.arrayValues).setMaxSize(size);
                    }
                    ((XQueueValues)this.arrayValues).setIndexOffset(min);
                }
                int i = min;
                while (i <= max) {
                    guardian.checkBuildCanceled();
                    this.arrayValues.put(i, null, guardian);
                    ++i;
                }
            }
            finally {
                guardian.callbackEndInitVars(false);
            }
        }
        catch (BuildCancelException e) {
            throw e;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public IRfFieldElement getItemElementField() {
        return ((IRfListType)this.getNamedElement()).xGetItemField(this.itemElementType);
    }

    public IELParamValue getItemElementValue() {
        if (this.itemElementType == null) {
            return null;
        }
        return this.getInitValue();
    }

    private XComputedSelect computeRangeSelectFromHidObject(IHidObject rangeObject, boolean isQueue, IHidEvaluationGuardian guardian) {
        if (rangeObject == null) {
            return null;
        }
        if (isQueue && HidUtils.isHidImplicit(rangeObject) && ((HidImplicit)rangeObject).isDollar()) {
            return null;
        }
        if (HidUtils.isHidImplicit(rangeObject) && ((HidImplicit)rangeObject).isEmptyType()) {
            return null;
        }
        if (HidUtils.isOperator(rangeObject) && ((IHidOperator)rangeObject).isLiteralRange()) {
            rangeObject = ((IHidOperator)rangeObject).getFirstRHValue();
        }
        if (isQueue && HidUtils.isOperator(rangeObject)) {
            rangeObject = ((HidOperator)rangeObject).getFirstRHValue();
        }
        return XValueHolderFactory.computeSelect(rangeObject, this.enclosing, guardian.copy(), false, this.getNamedElement(), this);
    }

    public IELParamValue getInitValue() {
        if (!this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode() && XValueHolderFactory.xIsClass(this.itemElementType, true)) {
            return null;
        }
        IELParamValue initValue = this.createElementValueHolder();
        if (initValue != null && ELUtils.isUnsuccessfulEval(initValue)) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        if (initValue instanceof XValueHolder) {
            ((XValueHolder)initValue).enclosing = this;
        }
        return initValue;
    }

    @Override
    public ELParamValueScope getValueImpl(String name, IRfNamedElement element, boolean isSuperAccess, boolean isMethod, boolean isDeclareMissingVariable, IHidEvaluationGuardian guardian) {
        IRfNamedElement member;
        if (this.instancePrefixName != null && this.itemElementType instanceof IRfInterface && this.factory.hasMember(this.itemElementType, name) && ((member = this.itemElementType.xGetMember(name)) instanceof IRfModportElement || member instanceof IRfClockingBlockElement)) {
            int size = this.size();
            String arrayOfMembersName = DVTStringUtil.appendString(this.instancePrefixName, ".", name, "[", size - 1, ":0]");
            IELParamValue result = this.getValueDirectly(arrayOfMembersName);
            if (result != null) {
                return ELParamValueScope.of(result, this);
            }
            InterfaceMembersList assocType = new InterfaceMembersList(arrayOfMembersName, member);
            XArrayValueHolder result2 = new XArrayValueHolder(this.factory, XNamedElement.create(assocType, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), this.enclosing, this.instanceScope, name, false);
            result2.arrayValues = new XQueueValues(false, result2);
            result2.leftBound = this.leftBound;
            result2.rightBound = this.rightBound;
            IHidEvaluationGuardian newGuardian = guardian == null ? this.factory.getEvaluationGuardian(false) : guardian;
            this.arrayValues.foreach((key, value) -> {
                newGuardian.checkBuildCanceled();
                if (value == null) {
                    return true;
                }
                Hid hid = HidUtils.makeStandInHid(name, member, HidOccurrence.DUMMY_OCCURRENCE, 0L);
                IELParamValue newValue = XUtils.getValue(ELUtils.evaluate(hid, value, null, this.factory.getEvaluationGuardian(true)));
                xArrayValueHolder.arrayValues.push_back(newValue);
                return true;
            });
            this.putValueDirectly(arrayOfMembersName, result2);
            return ELParamValueScope.of(result2, this);
        }
        return super.getValueImpl(name, element, isSuperAccess, isMethod, isDeclareMissingVariable, guardian);
    }

    public IELParamValue containsValue(IELParamValue itemValue) {
        itemValue = this.itemContext == null ? itemValue : this.itemContext.transform(itemValue);
        boolean containsValue = this.arrayValues.containsValue(itemValue);
        if (containsValue) {
            return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
        }
        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
    }

    @Override
    protected String getTypeSignature() {
        IRfNamedElement namedElement = this.getNamedElement();
        return namedElement.xGetListSignature();
    }

    @Override
    public String toNiceString(BitVectorContext context, int radix, boolean useCharLimit, boolean useLowerCaseMaskType) {
        StringBuilder result = new StringBuilder("'{");
        boolean[] addComma = new boolean[1];
        boolean isAssociativeArray = this.isAssociativeArray();
        this.arrayValues.foreach((key, value) -> {
            if (addComma[0]) {
                result.append(", ");
            }
            if (isAssociativeArray) {
                result.append(key.toStringRadix(10)).append(": ");
            }
            if (value == null) {
                result.append("null");
            } else if (value instanceof ELParamValues.ParamValueNumber && !value.isString()) {
                result.append("'h");
                XUtils.stripLeadingZeroes(result, value.toStringRadix(16));
            } else {
                result.append(value.toStringRadix(16));
            }
            blArray[0] = true;
            if (result.length() > 2000) {
                result.append("... ");
                return false;
            }
            return true;
        });
        result.append("}");
        return result.toString();
    }

    @Override
    public String toUniqueString(boolean isFullQualified) {
        return DVTStringUtil.appendString(this.xAssociatedType.getQualifiedName(isFullQualified), "@", this.uniqueId);
    }

    /*
     * WARNING - void declaration
     */
    public IELParamValue createXValueHolderSelectProxy(XSelectProxy selectProxy, boolean evaluateForSize, boolean isConstraint, boolean initQueueOutOfBounds, LanguageKind languageKind) {
        ListContainer<XComputedSelect> computedSelects = selectProxy.computedSelects;
        if (computedSelects == null || computedSelects.isEmpty()) {
            return IELParamValue.UNDEFINED_VALUE;
        }
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        XComputedSelect firstSelect = computedSelects.get(0);
        if (firstSelect.computedValues != null && firstSelect.computedValues.length > 0) {
            boolean isIndexUnknownOrHighImpedance;
            IELParamValue leftIndexValue;
            boolean isSubArray = firstSelect.computedValues.length == 2;
            IELParamValue rightIndexValue = isSubArray ? firstSelect.computedValues[1] : firstSelect.computedValues[0];
            IELParamValue iELParamValue = leftIndexValue = isSubArray ? firstSelect.computedValues[0] : null;
            if (ELUtils.isUnsuccessfulEval(rightIndexValue)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (isSubArray && ELUtils.isUnsuccessfulEval(leftIndexValue)) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (rightIndexValue instanceof ELParamValues.ParamValueNumber && DVTNumber.isUndefined(rightIndexValue.getDVTNumber())) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (leftIndexValue instanceof ELParamValues.ParamValueNumber && DVTNumber.isUndefined(leftIndexValue.getDVTNumber())) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            if (isSubArray && (rightIndexValue instanceof ELParamValues.ParamValueNumber && rightIndexValue.getDVTNumber().hasMask(MaskType.Z, MaskType.X) || leftIndexValue instanceof ELParamValues.ParamValueNumber && leftIndexValue.getDVTNumber().hasMask(MaskType.Z, MaskType.X))) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            IRfNamedElement namedElement = this.xAssociatedType.getNamedElement();
            boolean isQueue = namedElement.xIsQueue();
            boolean isAssociativeArray = namedElement.xIsAssociativeArray();
            boolean bl = isIndexUnknownOrHighImpedance = this.itemContext != null && rightIndexValue instanceof ELParamValues.ParamValueNumber && rightIndexValue.getDVTNumber().hasMask(MaskType.Z, MaskType.X);
            if (isIndexUnknownOrHighImpedance) {
                IELParamValue result = this.createElementValueHolder();
                if (result instanceof ELParamValues.ParamValueNumber) {
                    DVTNumber dvtNumber = result.getDVTNumber();
                    VlogBitVector value = null;
                    if (dvtNumber instanceof VlogBitVector) {
                        value = VlogBitVector.copy((VlogBitVector)dvtNumber, VlogBitVector.createMaskOfType(MaskType.X, this.itemContext.getSize()));
                    } else {
                        VlogBitVector zero = VlogBitVector.create(true, this.itemContext.getSize() - 1, 0, BigInteger.ZERO);
                        value = VlogBitVector.copy(zero, VlogBitVector.createMaskOfType(MaskType.X, this.itemContext.getSize()));
                    }
                    result = ELParamValues.ParamValueNumber.of(this.itemContext.transform(value));
                }
                if (computedSelects.size() > 1) {
                    XSelectProxy subListSelectProxy = selectProxy.getDecreasedSelectProxy(result);
                    return XValueHolderFactory.createSelectProxyValue(result, subListSelectProxy, evaluateForSize, isConstraint, languageKind);
                }
                return result;
            }
            if (isSubArray && leftIndexValue != null) {
                XNamedElement resultXNamedElement = this.xAssociatedType.getTypeWithRangeSelect(firstSelect);
                if (resultXNamedElement == null) {
                    return IELParamValue.UNDEFINED_VALUE;
                }
                if (this.isEmpty() && this.isQueueArray() && !initQueueOutOfBounds && !selectProxy.guardian.isLHS()) {
                    void rhSide;
                    IHidImplicit zero;
                    void selectOperator;
                    IHidOperator value;
                    IHidObject iHidObject;
                    XArrayValueHolder result = new XArrayValueHolder(this.factory, resultXNamedElement, this.enclosing, this.instanceScope, false, firstSelect, false);
                    if (leftIndexValue.isUnknown() || rightIndexValue.isUnknown()) {
                        result.setHasUnknownSize(true);
                    } else if (this.hasUnknownSize() && (iHidObject = firstSelect.getSelectObject()) instanceof IHidOperator && (value = (IHidOperator)iHidObject) == (IHidOperator)iHidObject && ( instanceOfPatternExpressionValue = selectOperator.getFirstRHValue()) instanceof IHidImplicit && (zero = (IHidImplicit) instanceOfPatternExpressionValue) == (IHidImplicit) instanceOfPatternExpressionValue && rhSide.isDollar()) {
                        result.setHasUnknownSize(true);
                    } else {
                        result.setIsUnknown(this.isUnknown());
                    }
                    result.setSelectProxy(selectProxy.getFirstSelectProxy());
                    return result;
                }
                XArrayValueHolder result = new XArrayValueHolder(this.factory, resultXNamedElement, this.enclosing, this.instanceScope, true, firstSelect, initQueueOutOfBounds || selectProxy.guardian.isLHS());
                if (leftIndexValue.isUnknown() || rightIndexValue.isUnknown()) {
                    result.setHasUnknownSize(true);
                } else {
                    result.setIsUnknown(this.isUnknown());
                }
                int[] indexes = firstSelect.getIndexes();
                int min = Math.min(indexes[0], indexes[1]);
                int max = Math.max(indexes[0], indexes[1]);
                int size = max - min + 1;
                if (size >= 0x7FFFFF || size < 0) {
                    if (min > 0) {
                        max = 0x7FFFFF + min - 1;
                    } else {
                        min = max - 0x7FFFFF + 1;
                    }
                    guardian.logWarning("Array of " + size + " entries limited to " + 0x7FFFFF + " entries.");
                }
                int offset = 0;
                if (result.arrayValues instanceof XQueueValues) {
                    offset = ((XQueueValues)result.arrayValues).getIndexOffset();
                }
                if (this.isQueueArray()) {
                    int queueSize = this.arrayValues.size();
                    if (!(min != max || min >= 0 && min < queueSize || initQueueOutOfBounds || selectProxy.guardian.isLHS())) {
                        XArrayValueHolder emptyResult = new XArrayValueHolder(this.factory, resultXNamedElement, this.enclosing, this.instanceScope, false, firstSelect, false);
                        if (leftIndexValue.isUnknown() || rightIndexValue.isUnknown()) {
                            emptyResult.setHasUnknownSize(true);
                        } else {
                            emptyResult.setIsUnknown(this.isUnknown());
                        }
                        emptyResult.setSelectProxy(selectProxy.getFirstSelectProxy());
                        return emptyResult;
                    }
                    if (min < 0) {
                        min = 0;
                    }
                    if (max >= queueSize && !initQueueOutOfBounds && !selectProxy.guardian.isLHS()) {
                        max = queueSize - 1;
                    }
                }
                int i = min;
                while (i < max + 1) {
                    guardian.checkBuildCanceled();
                    IELParamValue srcIndexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(i)));
                    IELParamValue dstIndexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf((long)i - (long)min + (long)offset)));
                    IELParamValue itemValue = evaluateForSize | this.hasUnknownSize ? this.createElementValueHolder(this.hasUnknownSize) : this.arrayValues.get(srcIndexValue, null);
                    result.arrayValues.put(dstIndexValue, itemValue, guardian);
                    ++i;
                }
                result.setSelectProxy(selectProxy.getFirstSelectProxy());
                return result;
            }
            rightIndexValue = this.indexContext != null ? this.indexContext.transform(rightIndexValue) : rightIndexValue;
            leftIndexValue = this.indexContext != null && isSubArray ? this.indexContext.transform(leftIndexValue) : leftIndexValue;
            IELParamValue result = null;
            if (rightIndexValue.isUnknown()) {
                if (isQueue | isAssociativeArray) {
                    this.setHasUnknownSize(true);
                }
                result = this.createElementValueHolder(true);
            } else {
                if (evaluateForSize | this.hasUnknownSize) {
                    result = this.createElementValueHolder(this.hasUnknownSize);
                } else if (this.arrayValues != null) {
                    result = this.arrayValues.get(rightIndexValue, guardian);
                }
                if (result == null) {
                    result = this.createElementValueHolder();
                    if (!isQueue && this.itemContext != null && this.arrayValues instanceof XQueueValues && !isConstraint) {
                        if (result instanceof ELParamValues.ParamValueNumber) {
                            VlogBitVector zero = VlogBitVector.create(true, this.itemContext.getSize() - 1, 0, BigInteger.ZERO);
                            VlogBitVector value = VlogBitVector.copy(zero, VlogBitVector.createMaskOfType(MaskType.X, this.itemContext.getSize()));
                            result = ELParamValues.ParamValueNumber.of(this.itemContext.transform(value));
                        }
                        if (computedSelects.size() > 1) {
                            XSelectProxy subListSelectProxy = selectProxy.getDecreasedSelectProxy(result);
                            return XValueHolderFactory.createSelectProxyValue(result, subListSelectProxy, evaluateForSize, isConstraint, languageKind);
                        }
                        return result;
                    }
                    if (result instanceof XValueHolder && guardian.isLHS()) {
                        this.arrayValues.put(rightIndexValue, result, guardian);
                    }
                }
            }
            if (result == null) {
                return IELParamValue.UNDEFINED_VALUE;
            }
            result.setSelectProxy(selectProxy.getFirstSelectProxy());
            if (computedSelects.size() > 1) {
                XSelectProxy subListSelectProxy = selectProxy.getDecreasedSelectProxy(result);
                return XValueHolderFactory.createSelectProxyValue(result, subListSelectProxy, evaluateForSize, isConstraint, languageKind);
            }
            return selectProxy.context != null ? selectProxy.context.transform(result) : result;
        }
        return IELParamValue.UNDEFINED_VALUE;
    }

    public IELParamValue createElementValueHolder(IELParamValue fromValue) {
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        IELParamValue newValue = this.createElementValueHolder();
        fromValue = this.itemContext != null ? this.itemContext.transform(fromValue) : fromValue;
        newValue.updateValue(fromValue, guardian);
        return newValue;
    }

    public IELParamValue createElementValueHolder() {
        return this.createElementValueHolder(this.isUnknown());
    }

    private IELParamValue createElementValueHolder(boolean createUnknown) {
        IELParamValue memberValue = null;
        if (this.itemContext != null && !this.itemContext.isUnpackedStructContext() && !this.itemContext.isUnpackedArrayContext()) {
            memberValue = this.createNumericScalarMemberValue(this.xAssociatedType.getNamedElement(), this.itemContext, false);
        }
        if (memberValue == null && this.itemElementType != null) {
            memberValue = this.factory.createValueHolder(XNamedElement.create(this.itemElementType, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), this.itemEnclosing, this.instanceScope);
            this.itemEnclosing = ((XValueHolder)memberValue).getEnclosingValue();
        }
        if (createUnknown) {
            ELUtils.setUnknownValue(memberValue);
        }
        return memberValue;
    }

    @Override
    protected boolean updateValue(IELParamValue newResult, boolean keepRef) {
        if (newResult == this) {
            return false;
        }
        boolean isModified = false;
        if (newResult instanceof XArrayValueHolder) {
            XArrayValueHolder newArray = (XArrayValueHolder)newResult;
            isModified = this.arrayValues.copyByValue(newArray.arrayValues, true);
            boolean hasUnknownSize = newArray.hasUnknownSize();
            if (this.hasUnknownSize ^ hasUnknownSize) {
                this.setHasUnknownSize(hasUnknownSize);
            } else {
                this.setIsUnknown(newArray.isUnknown());
            }
        } else if (newResult != null && newResult.getDVTNumber() != null && newResult.getDVTNumber().hasUnknownSize()) {
            this.setHasUnknownSize(true);
        }
        this.factory.getEvaluationGuardian(false).callbackValueChanged(this);
        return isModified |= this.updateProxy();
    }

    @Override
    public IELParamValue doUpdate(IHidOperator parentOperator, IELParamValue rightValue, int updateEvaluator, AtomicBoolean isModified, int uniqueClassScopeId, IHidEvaluator evaluator, IHidObject leftOp, IHidEvaluationGuardian guardian) {
        if (this.arrayValues instanceof XQueueValues && rightValue instanceof XArrayValueHolder && parentOperator != null && parentOperator.isAssignment()) {
            IHidObject rhValue = parentOperator.getFirstRHValue();
            Hid rhValueHid = null;
            if (rhValue instanceof Hid) {
                rhValueHid = (Hid)rhValue;
            } else if (rhValue instanceof HidAccess) {
                rhValueHid = ((HidAccess)rhValue).getParentHid();
            }
            if (rhValueHid != null && "new".equals(XUtils.getName(rhValueHid))) {
                ((XQueueValues)this.arrayValues).setMaxSize(((XArrayValueHolder)rightValue).arrayValues.getMaxSize());
            }
        }
        return super.doUpdate(parentOperator, rightValue, updateEvaluator, isModified, uniqueClassScopeId, evaluator, leftOp, guardian);
    }

    @Override
    public boolean updateProxyValue(XSelectProxy selectProxy, IELParamValue withValue, boolean onlyIfArrayItemExists) {
        if (this.hasUnknownSize) {
            return false;
        }
        if (selectProxy == null) {
            return false;
        }
        ListContainer<XComputedSelect> computedSelects = selectProxy.computedSelects;
        if (computedSelects == null || computedSelects.isEmpty()) {
            return false;
        }
        XComputedSelect firstSelect = computedSelects.get(0);
        if (firstSelect.computedValues == null || firstSelect.computedValues.length < 1) {
            return false;
        }
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        if (firstSelect.computedValues.length == 1) {
            boolean isModified;
            IELParamValue indexValue;
            block14: {
                indexValue = firstSelect.computedValues[0];
                indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                isModified = false;
                if (!onlyIfArrayItemExists || this.arrayValues.get(indexValue, guardian) != null) break block14;
                return false;
            }
            try {
                isModified = this.arrayValues.put(indexValue, withValue, guardian);
            }
            catch (XQueueValues.ExceedMaxSize ex) {
                selectProxy.guardian.logWarning(ex.getMessage());
            }
            return isModified;
        }
        if (!(withValue instanceof XArrayValueHolder)) {
            return false;
        }
        if (!(((XArrayValueHolder)withValue).arrayValues instanceof XQueueValues)) {
            return false;
        }
        int[] indexes = firstSelect.getIndexes();
        int min = Math.min(indexes[0], indexes[1]);
        int max = Math.max(indexes[0], indexes[1]);
        XQueueValues withArrayValues = (XQueueValues)((XArrayValueHolder)withValue).arrayValues;
        boolean isModified = false;
        int i = min;
        while (i <= max) {
            IELParamValue indexValue = ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(i));
            indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
            try {
                if (!onlyIfArrayItemExists || this.arrayValues.get(indexValue, guardian) != null) {
                    isModified |= this.arrayValues.put(indexValue, withArrayValues.getZValue(i), guardian);
                }
            }
            catch (XQueueValues.ExceedMaxSize ex) {
                selectProxy.guardian.logWarning(ex.getMessage());
            }
            ++i;
        }
        return isModified;
    }

    @Override
    public IXIterator iterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian) {
        return this.hasUnknownSize ? new XUnknownSizeArrayIterator(selects, evaluator, guardian, this) : this.arrayValues.iterator(selects, evaluator, guardian);
    }

    @Override
    public void foreach(List<IHidObject> hidObjectSelects, IHidEvaluator evaluator, IXLoopAction loopAction, IHidEvaluationGuardian guardian) {
        if (hidObjectSelects == null || hidObjectSelects.isEmpty()) {
            return;
        }
        IHidObject indexHidObject = hidObjectSelects.get(0);
        BitVectorContext defaultContext = BitVectorContext.of(null, false);
        IELParamValue indexValue = XUtils.getValue(ELUtils.evaluate(indexHidObject, evaluator, defaultContext, guardian));
        this.arrayValues.foreach((key, value) -> {
            guardian.checkBuildCanceled();
            indexValue.updateValue(key, guardian);
            if (hidObjectSelects.size() > 1) {
                if (value != null) {
                    value.foreach(hidObjectSelects.subList(1, hidObjectSelects.size()), evaluator, loopAction, guardian);
                }
            } else {
                loopAction.execute();
            }
            return true;
        });
    }

    @Override
    protected ELParamValueScope getMethod(String name, IRfNamedElement element, boolean isSuperAccess, XInstValueHolder instanceScope) {
        IRfNamedElement member = null;
        IELParamValue value = this.values.getValue(name, element);
        member = value instanceof XMethodValueHolder ? ((XMethodValueHolder)value).getNamedElement() : this.xAssociatedType.getNamedElement().xGetMember(name);
        if (member != null) {
            return ELParamValueScope.of(this.factory.createCustomMethodValueHolder(XNamedElement.create(member, this, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), this, instanceScope, false), this);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    public IELParamValue executePredefinedMethod(IHidOperator hidObject, IHidEvaluator methodValueHolder, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        block110: {
            final IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
            try {
                boolean isEmpty;
                String methodName = methodValueHolder.getNamedElement().getName();
                boolean bl = isEmpty = this.arrayValues.size() == 0;
                if ("delete".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                    }
                    try {
                        IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                        if (indexValue == null) {
                            this.arrayValues.clear();
                            IELParamValue iELParamValue = ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                            return iELParamValue;
                        }
                        indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                        this.arrayValues.remove(indexValue, guardian);
                        IELParamValue iELParamValue = ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                        return iELParamValue;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("exists".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                    IELParamValue iELParamValue = indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                    if (this.arrayValues.containsKey(indexValue)) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
                    }
                    return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                }
                if ("reverse".equals(methodName)) {
                    if (isEmpty) {
                        return this;
                    }
                    int size = this.arrayValues.size();
                    int i = 0;
                    while (i < (size - size % 2) / 2) {
                        guardian.checkBuildCanceled();
                        IELParamValue index1 = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(i)));
                        IELParamValue value1 = this.arrayValues.get(index1, guardian);
                        IELParamValue index2 = ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf((long)(size - i) - 1L)));
                        IELParamValue value2 = this.arrayValues.get(index2, guardian);
                        this.arrayValues.put(index2, value1, guardian);
                        this.arrayValues.put(index1, value2, guardian);
                        ++i;
                    }
                    return this;
                }
                if ("sort".equals(methodName) || "rsort".equals(methodName)) {
                    if (isEmpty) {
                        return this;
                    }
                    String computedIteratorName = "item";
                    if (specifiedArgumentValues != null && !specifiedArgumentValues.isEmpty()) {
                        HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = XUtils.getFirstEntry(specifiedArgumentValues).getValue();
                        if (HidUtils.isHid(argumentInfo.argHidObject)) {
                            computedIteratorName = ((Hid)argumentInfo.argHidObject).getName();
                        }
                    }
                    IRfNamedElement withBlockElementWorkAround = methodValueHolder.getNamedElement();
                    IELParamValue iteratorEvaluator = this.factory.createValueHolder(withBlockElementWorkAround, (IELParamValue)argumentsEvaluator, null);
                    String iteratorName = computedIteratorName;
                    LinkedHashMap indexesMap = new LinkedHashMap();
                    HidOperatorWrapper withClause = hidObject.xGetWithClause();
                    if (withClause == null || withClause.hidObject == null || ((HidOperator)withClause.hidObject).getLHValue() == null) {
                        this.arrayValues.foreach((key, value) -> {
                            guardian.checkBuildCanceled();
                            indexesMap.put(key, value);
                            return true;
                        });
                    } else {
                        IHidObject withExpression = ((HidOperator)withClause.hidObject).getLHValue();
                        this.arrayValues.foreach((key, value) -> {
                            guardian.checkBuildCanceled();
                            ((XValueHolder)iteratorEvaluator).putValueDirectly(iteratorName, value);
                            IELParamValue withClauseValue = XUtils.getValue(ELUtils.evaluate(withExpression, iteratorEvaluator, null, this.factory.getEvaluationGuardian(true)));
                            indexesMap.put(key, withClauseValue);
                            return true;
                        });
                    }
                    ArrayList indexesEntryList = new ArrayList(indexesMap.entrySet());
                    Collections.sort(indexesEntryList, (o1, o2) -> COMPARATOR.compare((IELParamValue)o1.getValue(), (IELParamValue)o2.getValue()));
                    XArrayValueHolder resultHolder = new XArrayValueHolder(this.factory, this.xAssociatedType, this.enclosing, this.instanceScope);
                    resultHolder.arrayValues.setDefaultValue(this.arrayValues.getDefaultValue());
                    boolean isReversed = "rsort".equals(methodName);
                    if (this.isQueueArray()) {
                        for (Map.Entry entry : indexesEntryList) {
                            guardian.checkBuildCanceled();
                            IELParamValue key2 = (IELParamValue)entry.getKey();
                            IELParamValue value2 = this.arrayValues.get(key2, guardian);
                            if (isReversed) {
                                resultHolder.arrayValues.push_front(value2);
                                continue;
                            }
                            resultHolder.arrayValues.push_back(value2);
                        }
                    } else {
                        boolean bl2 = false;
                        for (Map.Entry entry : indexesEntryList) {
                            void var17_99;
                            guardian.checkBuildCanceled();
                            IELParamValue key3 = (IELParamValue)entry.getKey();
                            IELParamValue value3 = this.arrayValues.get(key3, guardian);
                            void sortIndex = isReversed ? indexesEntryList.size() - 1 - var17_99 : var17_99;
                            resultHolder.arrayValues.put((int)sortIndex, value3, guardian);
                            ++var17_99;
                        }
                    }
                    this.arrayValues = resultHolder.arrayValues;
                    return this;
                }
                if ("sum".equals(methodName) || "product".equals(methodName) || "and".equals(methodName) || "or".equals(methodName) || "xor".equals(methodName)) {
                    IELParamValue iteratorEvaluator;
                    IHidObject withExpression;
                    String iteratorName;
                    IELParamValue result = ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    if (isEmpty) {
                        return result;
                    }
                    char firstLetterOfFunction = methodName.charAt(0);
                    BinaryOperator reduceOperator = firstLetterOfFunction == 's' ? DVTNumber::plus : (firstLetterOfFunction == 'p' ? DVTNumber::multiply : (firstLetterOfFunction == 'a' ? DVTNumber::and : (firstLetterOfFunction == 'o' ? DVTNumber::or : DVTNumber::xor)));
                    HidOperatorWrapper withClause = hidObject.xGetWithClause();
                    if (withClause != null && withClause.hidObject != null) {
                        String computedIteratorName = "item";
                        if (specifiedArgumentValues != null && !specifiedArgumentValues.isEmpty()) {
                            HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = XUtils.getFirstEntry(specifiedArgumentValues).getValue();
                            if (HidUtils.isHid(argumentInfo.argHidObject)) {
                                computedIteratorName = ((Hid)argumentInfo.argHidObject).getName();
                            }
                        }
                        iteratorName = computedIteratorName;
                        withExpression = ((HidOperator)withClause.hidObject).getLHValue();
                        iteratorEvaluator = this.factory.createValueHolder(methodValueHolder.getNamedElement(), (IELParamValue)argumentsEvaluator, null);
                    } else {
                        iteratorName = null;
                        withExpression = null;
                        iteratorEvaluator = null;
                    }
                    XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, iteratorEvaluator, null, this.factory.getEvaluationGuardian(true), withExpression, IDVTConstants.PRESERVE_PATH, methodName, true);
                    try {
                        DVTNumber[] reductionTotal = new DVTNumber[1];
                        guardian.startEvalScope(xEvalScope);
                        this.arrayValues.foreach((key, value) -> {
                            guardian.checkBuildCanceled();
                            if (iteratorEvaluator != null) {
                                iteratorEvaluator.putValueDirectly(iteratorName, value);
                                value = XUtils.getValue(ELUtils.evaluate(withExpression, iteratorEvaluator, null, this.factory.getEvaluationGuardian(true)));
                            }
                            dVTNumberArray[0] = reductionTotal[0] == null ? value.getDVTNumber() : (DVTNumber)reduceOperator.apply(reductionTotal[0], value.getDVTNumber());
                            return true;
                        });
                        result = ELParamValues.ParamValueNumber.of(reductionTotal[0]);
                    }
                    finally {
                        guardian.endEvalScope(xEvalScope);
                    }
                    return result;
                }
                if ("find".equals(methodName) || "find_index".equals(methodName) || "find_first".equals(methodName) || "find_first_index".equals(methodName) || "find_last".equals(methodName) || "find_last_index".equals(methodName)) {
                    IELParamValue result = methodValueHolder.getResult(XValueHolderFactory.getNoContext());
                    if (isEmpty) {
                        return result;
                    }
                    final boolean isFindFirst = "find_first".equals(methodName) || "find_first_index".equals(methodName);
                    final boolean isFindLast = "find_last".equals(methodName) || "find_last_index".equals(methodName);
                    final boolean isReturnIndex = methodName.endsWith("_index");
                    String computedIteratorName = "item";
                    if (specifiedArgumentValues != null && !specifiedArgumentValues.isEmpty()) {
                        HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = XUtils.getFirstEntry(specifiedArgumentValues).getValue();
                        if (HidUtils.isHid(argumentInfo.argHidObject)) {
                            computedIteratorName = ((Hid)argumentInfo.argHidObject).getName();
                        }
                    }
                    IRfNamedElement withBlockElementWorkAround = methodValueHolder.getNamedElement();
                    final IELParamValue iteratorEvaluator = this.factory.createValueHolder(withBlockElementWorkAround, (IELParamValue)argumentsEvaluator, null);
                    final String iteratorName = computedIteratorName;
                    if (!(result instanceof XArrayValueHolder)) {
                        guardian.logError("Expecting XArrayValueHolder!");
                        return IELParamValue.UNDEFINED_VALUE;
                    }
                    final XArrayValueHolder resultArray = (XArrayValueHolder)result;
                    HidOperatorWrapper hidOperatorWrapper = hidObject.xGetWithClause();
                    if (hidOperatorWrapper == null || hidOperatorWrapper.hidObject == null) {
                        guardian.logError("Missing 'with' clause!");
                        return IELParamValue.UNDEFINED_VALUE;
                    }
                    final IHidObject iHidObject = ((HidOperator)hidOperatorWrapper.hidObject).getLHValue();
                    if (iHidObject == null) {
                        guardian.logError("Missing 'with' clause!");
                        return IELParamValue.UNDEFINED_VALUE;
                    }
                    XFrameBlockEvalScope xEvalScope = new XFrameBlockEvalScope(null, iteratorEvaluator, null, this.factory.getEvaluationGuardian(true), iHidObject, IDVTConstants.PRESERVE_PATH, methodName, true);
                    final BitVectorContext noContext = XValueHolderFactory.getNoContext();
                    try {
                        guardian.startEvalScope(xEvalScope);
                        this.arrayValues.foreach(new IXInternalForeachLoopAction(){
                            int foundCounter;

                            @Override
                            public boolean execute(IELParamValue key, IELParamValue value) {
                                guardian.checkBuildCanceled();
                                ((XValueHolder)iteratorEvaluator).putValueDirectly(iteratorName, value);
                                IELParamValue withClauseValue = null;
                                XThread xThread = guardian.getActiveThread();
                                try {
                                    guardian.callbackStartStatement(xThread, iHidObject);
                                    withClauseValue = XUtils.getValue(ELUtils.evaluate(iHidObject, iteratorEvaluator, noContext, XArrayValueHolder.this.factory.getEvaluationGuardian(true)));
                                }
                                finally {
                                    guardian.callbackEndStatement(xThread, iHidObject);
                                }
                                if (ELUtils.isFalse(withClauseValue)) {
                                    return true;
                                }
                                if (isFindLast) {
                                    this.foundCounter = 0;
                                    resultArray.arrayValues.clear();
                                }
                                if (isReturnIndex) {
                                    resultArray.arrayValues.put(this.foundCounter, key, guardian);
                                } else {
                                    resultArray.arrayValues.put(this.foundCounter, value, guardian);
                                }
                                if (isFindFirst) {
                                    return false;
                                }
                                ++this.foundCounter;
                                return true;
                            }
                        });
                    }
                    finally {
                        guardian.endEvalScope(xEvalScope);
                    }
                    return result;
                }
                if ("first".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                    indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                    indexValue.updateValue(this.arrayValues.first(), guardian);
                    return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
                }
                if ("insert".equals(methodName)) {
                    try {
                        IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                        indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                        IELParamValue itemValue = methodValueHolder.getValueDirectly("item");
                        this.arrayValues.insert(indexValue, itemValue, guardian);
                        IELParamValue isReturnIndex = ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                        return isReturnIndex;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("last".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                    indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                    indexValue.updateValue(this.arrayValues.last(), guardian);
                    return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
                }
                if ("max".equals(methodName) || "min".equals(methodName)) {
                    IELParamValue result = methodValueHolder.getResult(XValueHolderFactory.getNoContext());
                    if (!(result instanceof XArrayValueHolder)) {
                        guardian.logError("Expecting XArrayValueHolder!");
                        return IELParamValue.UNDEFINED_VALUE;
                    }
                    XArrayValueHolder resultArray = (XArrayValueHolder)result;
                    if (isEmpty) {
                        return resultArray;
                    }
                    IELParamValue maxValue = this.computeMinMax("min".equals(methodName));
                    if (!ELUtils.isUnsuccessfulEval(maxValue)) {
                        resultArray.arrayValues.put(0, maxValue, guardian);
                    }
                    return resultArray;
                }
                if ("new".equals(methodName)) {
                    try {
                        this.initValues(null, true, false);
                        IELParamValue itemValue = methodValueHolder.getValueDirectly("item");
                        IELParamValue rov = methodValueHolder.getValueDirectly("__rov__");
                        if (rov != null) {
                            if (rov.isUnknown()) {
                                this.setHasUnknownSize(true);
                                XArrayValueHolder resultArray = this;
                                return resultArray;
                            }
                            DVTNumber rovNumber = rov.getDVTNumber();
                            if (!DVTNumber.isUndefined(rovNumber)) {
                                int rovInt = rovNumber.intValue();
                                int i = 0;
                                while (i < rovInt) {
                                    IELParamValue value4;
                                    guardian.checkBuildCanceled();
                                    if (itemValue instanceof XArrayValueHolder && i < ((XArrayValueHolder)itemValue).size()) {
                                        int offset = ((XArrayValueHolder)itemValue).getIndexOffset();
                                        value4 = ((XArrayValueHolder)itemValue).getZValue(i + offset);
                                    } else {
                                        value4 = this.createElementValueHolder();
                                    }
                                    this.arrayValues.put(i, value4, guardian);
                                    ++i;
                                }
                                if (this.arrayValues instanceof XQueueValues) {
                                    ((XQueueValues)this.arrayValues).setMaxSize(rovInt);
                                }
                            }
                        } else if (itemValue instanceof XArrayValueHolder) {
                            this.arrayValues.copyByValue(((XArrayValueHolder)itemValue).arrayValues, false);
                        }
                        XArrayValueHolder resultArray = this;
                        return resultArray;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("next".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                    indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                    IELParamValue next = this.arrayValues.next(indexValue);
                    if (ELUtils.isUnsuccessfulEval(next)) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    indexValue.updateValue(next, guardian);
                    return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
                }
                if ("num".equals(methodName) || "size".equals(methodName)) {
                    return ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(this.arrayValues.size()));
                }
                if ("pop_back".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    try {
                        IELParamValue popValue = this.arrayValues.pop_back();
                        if (popValue == null) {
                            IELParamValue rovNumber = this.createElementValueHolder();
                            return rovNumber;
                        }
                        IELParamValue rovNumber = popValue;
                        return rovNumber;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("pop_front".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    try {
                        IELParamValue popValue = this.arrayValues.pop_front();
                        if (popValue == null) {
                            IELParamValue rovNumber = this.createElementValueHolder();
                            return rovNumber;
                        }
                        IELParamValue rovNumber = popValue;
                        return rovNumber;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("prev".equals(methodName)) {
                    if (isEmpty) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    IELParamValue indexValue = methodValueHolder.getValueDirectly("index");
                    indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
                    IELParamValue prev = this.arrayValues.prev(indexValue);
                    if (ELUtils.isUnsuccessfulEval(prev)) {
                        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
                    }
                    indexValue.updateValue(prev, guardian);
                    return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
                }
                if ("push_back".equals(methodName)) {
                    try {
                        IELParamValue itemValue = methodValueHolder.getValueDirectly("item");
                        this.arrayValues.push_back(itemValue);
                        IELParamValue rovNumber = ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                        return rovNumber;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("push_front".equals(methodName)) {
                    try {
                        IELParamValue itemValue = methodValueHolder.getValueDirectly("item");
                        this.arrayValues.push_front(itemValue);
                        IELParamValue rovNumber = ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                        return rovNumber;
                    }
                    finally {
                        this.notifyWaitingThreads(hidObject, methodValueHolder);
                    }
                }
                if ("shuffle".equals(methodName)) {
                    this.arrayValues.shuffle(this.factory.getShuffleRandom());
                    return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
                }
                if (!"unique".equals(methodName) && !"unique_index".equals(methodName)) break block110;
                IELParamValue result = methodValueHolder.getResult(XValueHolderFactory.getNoContext());
                if (isEmpty) {
                    return result;
                }
                if (!(result instanceof XArrayValueHolder)) {
                    guardian.logError("Expecting XArrayValueHolder!");
                    return IELParamValue.UNDEFINED_VALUE;
                }
                XArrayValueHolder resultArray = (XArrayValueHolder)result;
                boolean isReturnIndex = methodName.endsWith("_index");
                String computedIteratorName = "iterator";
                if (specifiedArgumentValues != null && !specifiedArgumentValues.isEmpty()) {
                    HidEvalCenter.MethodCallStatement.ArgumentInfo argumentInfo = XUtils.getFirstEntry(specifiedArgumentValues).getValue();
                    if (HidUtils.isHid(argumentInfo.argHidObject)) {
                        computedIteratorName = ((Hid)argumentInfo.argHidObject).getName();
                    }
                }
                IRfNamedElement withBlockElementWorkAround = methodValueHolder.getNamedElement();
                IELParamValue iteratorEvaluator = this.factory.createValueHolder(withBlockElementWorkAround, (IELParamValue)argumentsEvaluator, null);
                String iteratorName = computedIteratorName;
                HidOperatorWrapper withClause = hidObject.xGetWithClause();
                IHidObject withExpression = withClause == null ? null : ((HidOperator)withClause.hidObject).getLHValue();
                HashSet hashSet = new HashSet();
                XFrameBlockEvalScope xFrameBlockEvalScope = new XFrameBlockEvalScope(null, iteratorEvaluator, null, this.factory.getEvaluationGuardian(true), withExpression, IDVTConstants.PRESERVE_PATH, methodName, true);
                BitVectorContext noContext = XValueHolderFactory.getNoContext();
                try {
                    guardian.startEvalScope(xFrameBlockEvalScope);
                    this.arrayValues.foreach((key, value) -> {
                        guardian.checkBuildCanceled();
                        ((XValueHolder)iteratorEvaluator).putValueDirectly(iteratorName, value);
                        IELParamValue withClauseValue = null;
                        XThread xThread = guardian.getActiveThread();
                        try {
                            guardian.callbackStartStatement(xThread, withExpression);
                            withClauseValue = XUtils.getValue(ELUtils.evaluate(withExpression, iteratorEvaluator, noContext, this.factory.getEvaluationGuardian(true)));
                        }
                        finally {
                            guardian.callbackEndStatement(xThread, withExpression);
                        }
                        if (withClauseValue == null) {
                            if (hashSet.contains(value)) {
                                return true;
                            }
                            hashSet.add(value);
                        } else {
                            if (hashSet.contains(withClauseValue)) {
                                return true;
                            }
                            hashSet.add(withClauseValue);
                        }
                        int lastIndex = xArrayValueHolder.arrayValues.size();
                        if (isReturnIndex) {
                            xArrayValueHolder.arrayValues.put(lastIndex, key, guardian);
                        } else {
                            xArrayValueHolder.arrayValues.put(lastIndex, value, guardian);
                        }
                        return true;
                    });
                }
                finally {
                    guardian.endEvalScope(xFrameBlockEvalScope);
                }
                return result;
            }
            catch (XQueueValues.ExceedMaxSize e) {
                guardian.logWarning(e.getMessage());
            }
        }
        return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
    }

    public void notifyWaitingThreads(IHidOperator hidObject, IHidEvaluator methodValueHolder) {
        this.factory.scheduleWaitingThreads(this.uniqueId, XSimRegion.XRegionKind.Active);
        this.factory.getEvaluationGuardian(false).callbackValueChanged(this.uniqueId, hidObject, methodValueHolder, null, null, IELParamValue.NULL_VALUE, this);
    }

    public IELParamValue computeMinMax(boolean isMinNotMax) {
        return isMinNotMax ? this.arrayValues.min() : this.arrayValues.max();
    }

    public boolean put(IELParamValue indexValue, IELParamValue value) {
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        indexValue = this.indexContext == null ? indexValue : this.indexContext.transform(indexValue);
        return this.arrayValues.put(indexValue, value, guardian);
    }

    public void initFromNofBits(int nofBits, IHidEvaluationGuardian guardian) {
        if (this.getSize() == nofBits) {
            return;
        }
        this.initValues(null, false, false);
        if (this.isQueueArray() && this.leftBound != -1 && this.rightBound != -1) {
            int size = Math.abs(this.leftBound - this.rightBound) + 1;
            int i = 0;
            while (i < size) {
                IELParamValue newValue = this.createElementValueHolder();
                this.arrayValues.put(i, newValue, guardian);
                ++i;
            }
            return;
        }
        int elementSize = this.getItemElementContext().getSize();
        int nofElements = nofBits / elementSize;
        int i = 0;
        while (i < nofElements) {
            IELParamValue newValue = this.createElementValueHolder();
            this.arrayValues.put(i, newValue, guardian);
            ++i;
        }
    }

    @Override
    public boolean hasUnknownSize() {
        return this.hasUnknownSize;
    }

    public void setHasUnknownSize(boolean hasUnknownSize) {
        this.setIsUnknown(hasUnknownSize);
        if (hasUnknownSize && !this.hasUnknownSize && this.arrayValues != null) {
            this.arrayValues.clear();
        }
        this.hasUnknownSize = hasUnknownSize;
    }

    public List<IELParamValue> getZValues() {
        return this.arrayValues.getZValues();
    }

    public boolean isEmpty() {
        return this.arrayValues.size() == 0;
    }

    public IELParamValue getZValue(int index) {
        return this.arrayValues.getZValue(index);
    }

    public void foreach(IXInternalForeachLoopAction action) {
        this.arrayValues.foreach(action);
    }

    @Override
    public boolean debuggerHasVariables(boolean isFirstStackFrame) {
        return this.arrayValues.debuggerHasVariables();
    }

    @Override
    public int debuggerCollectionSize() {
        if (this.isMapEntry()) {
            return -1;
        }
        return this.arrayValues.size();
    }

    @Override
    public Map<DVTXVariableInfo, IELParamValue> debuggerGetVariables(boolean isFirstStackFrame, boolean isBreakOnFirst) {
        return this.arrayValues.debuggerGetVariables();
    }

    public String mUvmStringQueueJoin() {
        return this.arrayValues.mUvmStringQueueJoin();
    }

    public int size() {
        return this.arrayValues.size();
    }

    public int getLeftBound() {
        return this.leftBound;
    }

    public int getRightBound() {
        return this.rightBound;
    }

    public int getIndexOffset() {
        if (this.arrayValues instanceof XQueueValues) {
            return ((XQueueValues)this.arrayValues).getIndexOffset();
        }
        throw new UnsupportedOperationException();
    }

    public static boolean isListFuncWithIteratorArg(IRfMethodElement methodElement) {
        if (methodElement == null || !methodElement.isPredefined() || !(methodElement.getEnclosingScope() instanceof IRfListType)) {
            return false;
        }
        return METHODS_WITH_ITERATOR.contains(methodElement.getName());
    }

    public void setDefaultValue(IELParamValue defaultValue) {
        this.arrayValues.setDefaultValue(defaultValue);
    }

    public void constrainArraySize(int size) {
        IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
        if (this.arrayValues.size() > size) {
            while (this.arrayValues.size() > size) {
                if (this.arrayValues instanceof XQueueValues) {
                    this.arrayValues.pop_back();
                    continue;
                }
                this.arrayValues.remove(this.arrayValues.last(), guardian);
            }
            return;
        }
        int i = this.arrayValues.size();
        while (i < size) {
            guardian.checkBuildCanceled();
            this.arrayValues.put(i, this.createElementValueHolder(), guardian);
            ++i;
        }
    }

    public int $size() {
        int rightBound;
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement.xIsQueue() || namedElement.xIsDynamicArray()) {
            return this.size();
        }
        int leftBound = this.getLeftBound();
        return leftBound >= (rightBound = this.getRightBound()) ? leftBound - rightBound + 1 : rightBound - leftBound + 1;
    }

    public int $left() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement.xIsQueue() || namedElement.xIsDynamicArray()) {
            return 0;
        }
        return this.getLeftBound();
    }

    public int $right() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement.xIsQueue() || namedElement.xIsDynamicArray()) {
            Long l = (long)this.size() - 1L;
            return l.intValue();
        }
        return this.getRightBound();
    }

    public int $increment() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (namedElement.xIsAssociativeArray() || namedElement.xIsQueue() || namedElement.xIsDynamicArray()) {
            return -1;
        }
        if (this.getLeftBound() >= this.getRightBound()) {
            return 1;
        }
        return -1;
    }

    public int $low() {
        if (this.$increment() > 0) {
            return this.$right();
        }
        return this.$left();
    }

    public int $high() {
        if (this.$increment() > 0) {
            return this.$left();
        }
        return this.$right();
    }

    @Override
    public DVTNumber getDVTNumber() {
        try {
            if (this.itemContext == null) {
                return DVTNumber.UNDEFINED;
            }
            if (this.hasUnknownSize) {
                return VlogBitVector.create(false, 0, 0, null, false, this.itemContext.isString(), false, true, null, null);
            }
            if (this.isEmpty()) {
                return DVTNumber.UNDEFINED;
            }
            int nofBits = 0;
            boolean decreasing = this.leftBound > this.rightBound;
            boolean is4State = false;
            boolean isString = false;
            boolean isUnpacked = false;
            LinkedList<DVTNumber> operands = new LinkedList<DVTNumber>();
            List<IELParamValue> zValues = this.arrayValues.getZValues();
            IHidEvaluationGuardian guardian = this.factory.getEvaluationGuardian(false);
            int i = 0;
            while (i < this.arrayValues.size()) {
                guardian.checkBuildCanceled();
                IELParamValue tempOpValue = zValues.get(i);
                DVTNumber tempOp = tempOpValue.getDVTNumber();
                if (ELUtils.isUnsuccessfulEval(tempOpValue) || DVTNumber.isUndefined(tempOp)) {
                    return DVTNumber.UNDEFINED;
                }
                if (tempOpValue instanceof XArrayValueHolder || tempOpValue instanceof XValueHolder && ((XValueHolder)tempOpValue).isUnpackedStructOrUnion()) {
                    isUnpacked = true;
                }
                if (!(tempOp == VlogBitVector.EMPTY_CONCATENATION || this.itemContext.isString() && ((VlogBitVector)tempOp).isEmptyString())) {
                    if (!isString) {
                        isString = DVTNumber.isString(tempOp);
                    }
                    if (!is4State && tempOp.is4State()) {
                        is4State = true;
                    }
                    if (decreasing) {
                        operands.addFirst(tempOp);
                    } else {
                        operands.add(tempOp);
                    }
                    nofBits += tempOp.getSize();
                }
                ++i;
            }
            if (nofBits == 0) {
                if (this.itemContext.isString()) {
                    return VlogBitVector.EMPTY_STRING_CHARACTER;
                }
                return VlogBitVector.ZERO;
            }
            DVTNumber result = isUnpacked ? new DVTUnpackedArray(this.leftBound, this.rightBound, this.itemContext.getContextNumber(), operands.toArray(new DVTNumber[0])) : VlogBitVector.create(false, nofBits - 1, 0, null, is4State, isString);
            nofBits = result.getSize() - 1;
            if (result instanceof VlogBitVector) {
                for (DVTNumber op : operands) {
                    guardian.checkBuildCanceled();
                    if (!(op instanceof VlogBitVector)) {
                        throw new UnknownHidObjectEvaluationException(null, "Array item is not a number");
                    }
                    result = ((VlogBitVector)result).updateSlice(nofBits - op.getSize() + 1, nofBits, (VlogBitVector)op, 0, 0);
                    nofBits -= op.getSize();
                }
            }
            return result;
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
            return DVTNumber.UNDEFINED;
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.instancePrefixName, this.itemElementType, this.leftBound, this.rightBound);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XArrayValueHolder other = (XArrayValueHolder)obj;
        if (this.leftBound != other.leftBound) {
            return false;
        }
        if (this.rightBound != other.rightBound) {
            return false;
        }
        return Objects.equals(this.instancePrefixName, other.instancePrefixName) && Objects.equals(this.itemElementType, other.itemElementType);
    }

    @Override
    public void xSystemCPackValue(IRfNamedElement associatedType, int options, MessagePacker buffer, boolean preSpecifyMaker) throws Exception {
        boolean isFixedSizeArray = IXDPITypeMapperManager.DPIMapperOptions.contains(2, options);
        boolean isReadOpenArrayPtr = IXDPITypeMapperManager.DPIMapperOptions.contains(options, 4);
        if (isFixedSizeArray) {
            if (!isReadOpenArrayPtr) {
                buffer.packInt(this.getNofElements());
            }
            this.xSystemCPackFixedSizeArrayValue(options, buffer, preSpecifyMaker);
            return;
        }
        boolean isOutput = IXDPITypeMapperManager.DPIMapperOptions.contains(1, options);
        XArrayValueHolder arrayHolder = this;
        if (!isOutput) {
            arrayHolder = this.copyByValue();
        }
        IXSystemCFactory systemCFactory = this.getFactory().getVlogContributor().getSystemCFactory();
        int dpicId = systemCFactory.getDPICId(arrayHolder);
        buffer.packInt(dpicId);
    }

    private void xSystemCPackFixedSizeArrayValue(int options, MessagePacker buffer, boolean preSpecifyMaker) throws Exception {
        ArrayDeque<Iterator<IELParamValue>> stack = new ArrayDeque<Iterator<IELParamValue>>();
        stack.push(this.getZValues().iterator());
        boolean isReadOpenArrayPtr = IXDPITypeMapperManager.DPIMapperOptions.contains(options, 4);
        IRfNamedElement itemType = this.itemElementType;
        while (!stack.isEmpty()) {
            Iterator iterator = (Iterator)stack.peek();
            if (!iterator.hasNext()) {
                stack.pop();
                continue;
            }
            IELParamValue value = (IELParamValue)iterator.next();
            if (value instanceof XArrayValueHolder) {
                XArrayValueHolder nestedArrayHolder = (XArrayValueHolder)value;
                stack.push(nestedArrayHolder.getZValues().iterator());
                itemType = nestedArrayHolder.itemElementType;
                continue;
            }
            if (isReadOpenArrayPtr) {
                if (value.isStruct(false)) {
                    buffer.packInt(-63);
                    buffer.packString(((XValueHolder)value).computeCStructName());
                } else if (itemType instanceof IRfListType && ((IRfListType)itemType).isPacked()) {
                    buffer.packInt(value.is4State() ? 2 : 1);
                }
            }
            value.xSystemCPackValue(itemType, options, buffer, preSpecifyMaker);
        }
        buffer.flush();
    }

    public void clear() {
        this.arrayValues.clear();
    }

    public void push_back(IELParamValue value) {
        this.arrayValues.push_back(value);
    }

    public void push_front(IELParamValue value) {
        this.arrayValues.push_front(value);
    }

    public IELParamValue pop_back() {
        IELParamValue popValue = this.arrayValues.pop_back();
        if (popValue == null) {
            return this.createElementValueHolder();
        }
        return popValue;
    }

    public IELParamValue pop_front() {
        IELParamValue popValue = this.arrayValues.pop_front();
        if (popValue == null) {
            return this.createElementValueHolder();
        }
        return popValue;
    }

    public IELParamValue exists(IELParamValue value) {
        if (this.arrayValues.containsKey(value)) {
            return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ONE);
        }
        return ELParamValues.ParamValueNumber.of(VlogBitVector.BIT_ZERO);
    }

    @Override
    public IELParamValue vlogEq(IELParamValue obj, BitVectorContext context) {
        if (this.isUnknown() || obj.isUnknown()) {
            return IELParamValue.getAmbiguousInContext(context, true);
        }
        if (this.isNull() && obj.isNull()) {
            return IELParamValue.getTrueInContext(context);
        }
        if (this.isNull() || obj.isNull()) {
            return IELParamValue.getFalseInContext(context);
        }
        if (!(obj instanceof XArrayValueHolder)) {
            return IELParamValue.getFalseInContext(context);
        }
        return this.arrayValues.vlogEq(((XArrayValueHolder)obj).arrayValues, context);
    }

    @Override
    public IELParamValue vlogNeq(IELParamValue obj, BitVectorContext context) {
        if (this.isUnknown() || obj.isUnknown()) {
            return IELParamValue.getAmbiguousInContext(context, true);
        }
        if (this.isNull() && obj.isNull()) {
            return IELParamValue.getFalseInContext(context);
        }
        if (this.isNull() || obj.isNull()) {
            return IELParamValue.getTrueInContext(context);
        }
        if (!(obj instanceof XArrayValueHolder)) {
            return IELParamValue.getTrueInContext(context);
        }
        IELParamValue vlogEq = this.arrayValues.vlogEq(((XArrayValueHolder)obj).arrayValues, context);
        return ELUtils.isFalse(vlogEq) ? IELParamValue.getTrueInContext(context) : IELParamValue.getFalseInContext(context);
    }

    @Override
    public int intValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long longValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BigInteger bigIntegerValue() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isStruct(boolean isStructOrUnion) {
        return false;
    }

    @Override
    public boolean isUnion() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isAmbiguous() {
        return false;
    }

    @Override
    public boolean hasSign() {
        if (this.itemContext != null) {
            return this.itemContext.hasSign();
        }
        IELParamValue itemValue = this.getItemElementValue();
        return itemValue.hasSign();
    }

    @Override
    public boolean is4State() {
        if (this.itemContext != null) {
            return this.itemContext.is4State();
        }
        IELParamValue itemValue = this.getItemElementValue();
        return itemValue.is4State();
    }

    @Override
    public int getSize() {
        int size = this.size();
        if (size == 0) {
            return 0;
        }
        IELParamValue itemElementValue = this.getItemElementValue();
        while (itemElementValue instanceof XArrayValueHolder) {
            int itemArraySize = ((XArrayValueHolder)itemElementValue).size();
            if (itemArraySize < 0) {
                this.factory.logError("Fail to get size of '" + itemElementValue + "'");
                return -1;
            }
            size *= itemArraySize;
            itemElementValue = ((XArrayValueHolder)itemElementValue).getItemElementValue();
        }
        if (ELUtils.isUnsuccessfulEval(itemElementValue)) {
            this.factory.logError("Fail to get size of '" + itemElementValue + "'");
            return -1;
        }
        int elementSize = itemElementValue.getSize();
        if (elementSize < 0) {
            this.factory.logError("Fail to get size of '" + itemElementValue + "'");
            return -1;
        }
        return size * elementSize;
    }

    public int getNofElements() {
        int nofElements = this.size();
        if (nofElements == 0) {
            return 0;
        }
        IELParamValue itemElementValue = this.getItemElementValue();
        while (itemElementValue instanceof XArrayValueHolder) {
            int itemArraySize = ((XArrayValueHolder)itemElementValue).size();
            if (itemArraySize < 0) {
                this.factory.logError("Fail to get size of '" + itemElementValue + "'");
                return -1;
            }
            nofElements *= itemArraySize;
            itemElementValue = ((XArrayValueHolder)itemElementValue).getItemElementValue();
        }
        return nofElements;
    }

    public BitVectorContext getItemElementContext() {
        return this.itemContext;
    }

    public BitVectorContext getIndexElementContext() {
        return this.indexContext;
    }

    public void setItemElementContext(BitVectorContext indexContext) {
        this.indexContext = indexContext;
    }

    public static XArrayValueHolder from(XValueHolderFactory factory, IRfNamedElement associatedType, DVTUnpackedArray value, XInstValueHolder instanceScope) {
        XArrayValueHolder result = new XArrayValueHolder(factory, XNamedElement.create(associatedType, null, true, factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), (IELParamValue)instanceScope, instanceScope, null, true);
        DVTNumber[] arrayItemValues = value.getValues();
        result.arrayValues.clear();
        int i = 0;
        while (i < arrayItemValues.length) {
            result.arrayValues.put(ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(i))), ELParamValues.ParamValueNumber.of(arrayItemValues[i]), factory.getEvaluationGuardian(false));
            ++i;
        }
        return result;
    }

    public boolean isFixedSizeArray() {
        IRfNamedElement namedElement = this.getNamedElement();
        return namedElement instanceof IRfListType && ((IRfListType)namedElement).isFixedArray();
    }

    public boolean hasMaxSize() {
        return this.arrayValues.getMaxSize() >= 0;
    }

    @Override
    public String getVarName(boolean isAppendLast) {
        XSelectProxy selectProxy = this.getSelectProxy();
        if (selectProxy == null) {
            String varName = ((XValueHolder)this.enclosing).getVarName(false);
            return isAppendLast && this.element != null ? DVTStringUtil.appendString(varName, ".", this.element.getName()) : varName;
        }
        StringBuilder result = new StringBuilder();
        IELParamValue valueBeforeSelect = selectProxy.getValueBeforeSelect();
        result.append(((XValueHolder)valueBeforeSelect).getVarName(isAppendLast));
        XCModel.appendSelects(result, selectProxy, isAppendLast ? 0 : 1);
        return result.toString();
    }

    public IXArrayValues getArrayValues() {
        return this.arrayValues;
    }

    public IRfNamedElement getItemElementType() {
        return this.itemElementType;
    }

    public boolean isReversed() {
        return this.arrayValues.isReversed();
    }

    private static class InterfaceMembersList
    extends RfDummyElement
    implements IRfListType {
        private IRfNamedElement itemElement;

        public InterfaceMembersList(String name, IRfNamedElement itemElement) {
            super(name);
            this.itemElement = itemElement;
        }

        @Override
        public IRfNamedElement getResolvedType(boolean resolveIfNotCached) {
            return null;
        }

        @Override
        public String getAssociatedTypeName() {
            return this.itemElement.getName();
        }

        @Override
        public IRfNamedElement getAssociatedType() {
            return this.itemElement;
        }

        @Override
        public IRfNamedElement getAssociatedBaseType() {
            return this.itemElement;
        }

        @Override
        public IRfListType xGetTypeWithRangeSelect(XComputedSelect computedRangeSelect) {
            return this;
        }
    }

    public static class LazyInitArrayList
    extends ArrayList<IELParamValue> {
        private static final long serialVersionUID = 1L;
        private XArrayValueHolder xArrayValueHolder;

        public LazyInitArrayList(XArrayValueHolder xArrayValueHolder) {
            this.xArrayValueHolder = xArrayValueHolder;
        }

        public LazyInitArrayList(XArrayValueHolder xArrayValueHolder, Collection<IELParamValue> values) {
            super(values);
            this.xArrayValueHolder = xArrayValueHolder;
        }

        @Override
        public IELParamValue get(int index) {
            IELParamValue value = (IELParamValue)super.get(index);
            if (value == null) {
                value = this.defaultValue();
                this.set(index, value);
            }
            return value;
        }

        private IELParamValue defaultValue() {
            IELParamValue defaultValue = this.xArrayValueHolder.arrayValues.getDefaultValue();
            if (defaultValue == null) {
                return this.xArrayValueHolder.getInitValue();
            }
            if (defaultValue instanceof XArrayValueHolder) {
                return defaultValue.scalarCopy();
            }
            return defaultValue.shallowCopy();
        }

        @Override
        public Iterator<IELParamValue> iterator() {
            return new Iterator<IELParamValue>(){
                int index;

                @Override
                public boolean hasNext() {
                    return this.index < this.size();
                }

                @Override
                public IELParamValue next() {
                    if (this.index >= this.size()) {
                        throw new NoSuchElementException();
                    }
                    return this.get(this.index++);
                }
            };
        }
    }

    private static class XUnknownSizeArrayIterator
    extends XUnknownSizeIterator {
        private final XArrayValueHolder array;

        public XUnknownSizeArrayIterator(List<IHidObject> selects, IHidEvaluator evaluator, IHidEvaluationGuardian guardian, XArrayValueHolder array) {
            super(selects, evaluator, guardian, array.indexContext);
            this.array = array;
        }

        @Override
        protected IELParamValue createUnknownIndexValue(IHidObject indexHidObject) {
            IELParamValue indexValue = null;
            if (indexHidObject instanceof Hid) {
                IRfNamedElement indexTypeElement = indexHidObject instanceof Hid ? ((Hid)indexHidObject).getElement() : null;
                indexValue = XUtils.getValue(this.array.createMemberValue(indexTypeElement));
                if (indexValue == null) {
                    indexValue = this.array.createNumericScalarMemberValue(indexTypeElement, this.array.getBitVectorContext(indexTypeElement), false);
                }
            } else {
                indexValue = this.array.indexContext != null ? ELParamValues.ParamValueNumber.of(this.array.indexContext.getContextNumber()) : ELParamValues.ParamValueNumber.of(VlogBitVector.createConstant(0));
            }
            return ELUtils.createUnknownValue(indexValue);
        }
    }
}

