/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXCBinArray;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XCoverageUtils;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTNumber;

public class XCBinArrayValueHolder
extends XCBinValueHolder
implements IXCBinArray {
    protected Map<IELParamValue, XCBinValueHolder.InternalSingleElementWrapper> valueToBinHolder;
    protected Set<XCBinValueHolder.InternalRangeWrapper> rangeWrappers;
    private long elementNo;
    private long lastElementHit;
    private XCBinValueHolder lastInternalBinHit;

    public XCBinArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope);
    }

    public XCBinArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, String name, Map<IELParamValue, IELParamValue> range) {
        super(factory, xAssociatedType, enclosing, instanceScope);
        this.setName(name);
        this.rangeWrappers = new TreeSet<XCBinValueHolder.InternalRangeWrapper>();
        int orderNo = 0;
        for (Map.Entry<IELParamValue, IELParamValue> entry : range.entrySet()) {
            this.rangeWrappers.add(new XCBinValueHolder.InternalRangeWrapper(entry.getKey(), entry.getValue(), orderNo++));
        }
    }

    protected void computeWithCondition() {
        if (!(this.enclosing instanceof XCPointValueHolder)) {
            return;
        }
        IHidObject cpExpression = ((XCPointValueHolder)this.enclosing).getExpression();
        ELParamValueScope paramValueScope = ELUtils.evaluate(cpExpression, this, null, this.getCachedSimGuardian(false));
        if (ELUtils.isUnsuccessfulEval(paramValueScope)) {
            return;
        }
        IELParamValue itemValue = XUtils.getValue(paramValueScope).copy();
        if (!(itemValue instanceof ELParamValues.ParamValueNumber)) {
            return;
        }
        ELParamValues.ParamValueNumber itemNumber = (ELParamValues.ParamValueNumber)itemValue;
        for (IELParamValue iELParamValue : this.binValues) {
            DVTNumber dvtNumber = iELParamValue.getDVTNumber();
            if (!this.evaluateWithConditionForValue(itemNumber, this.withExpression, dvtNumber)) continue;
            ++this.size;
        }
        for (Map.Entry entry : this.binRanges.entrySet()) {
            IELParamValue start = (IELParamValue)entry.getKey();
            IELParamValue end = (IELParamValue)entry.getValue();
            if (!(start instanceof ELParamValues.ParamValueNumber) || !(end instanceof ELParamValues.ParamValueNumber)) continue;
            this.computeWithConditionInRange(start.getDVTNumber(), itemNumber, this.withExpression, end.getDVTNumber());
        }
    }

    private void computeWithConditionInRange(DVTNumber start, ELParamValues.ParamValueNumber itemNumber, IHidObject withExpression, DVTNumber end) {
        for (DVTNumber number : XCoverageUtils.INSTANCE.iterateRange(start, end)) {
            if (!this.evaluateWithConditionForValue(itemNumber, withExpression, number)) continue;
            ++this.size;
        }
    }

    private boolean evaluateWithConditionForValue(ELParamValues.ParamValueNumber itemNumber, IHidObject withExpression, DVTNumber counter) {
        itemNumber.setDVTNumber(counter);
        this.values.put("item", itemNumber);
        IELParamValue condition = ELUtils.evaluateCondition(withExpression, this, null, this.getCachedSimGuardian(false));
        if (ELUtils.isUnsuccessfulEval(condition)) {
            return false;
        }
        return condition.intValue() == 1;
    }

    @Override
    protected int getBinsHitNo() {
        int binsHit = 0;
        for (XCBinValueHolder.InternalSingleElementWrapper internalElement : this.valueToBinHolder.values()) {
            XCBinValueHolder bin = internalElement.getBinHolder();
            binsHit += bin == null ? 0 : bin.getBinsHitNo();
        }
        for (XCBinValueHolder.InternalRangeWrapper rangeWrapper : this.rangeWrappers) {
            binsHit += rangeWrapper.getBinsHitNo();
        }
        return binsHit;
    }

    @Override
    protected long getBinsNo() {
        if (this.size != 0) {
            return this.size;
        }
        if (this.withExpression != null) {
            this.computeWithCondition();
            return this.size;
        }
        this.size += this.valueToBinHolder.size();
        for (XCBinValueHolder.InternalRangeWrapper rangeWrapper : this.rangeWrappers) {
            this.size = (int)((long)this.size + rangeWrapper.getSize());
        }
        return this.size;
    }

    @Override
    protected boolean init() {
        if (this.rangeWrappers != null) {
            this.valueToBinHolder = new HashMap<IELParamValue, XCBinValueHolder.InternalSingleElementWrapper>();
            return true;
        }
        if (!super.init()) {
            return false;
        }
        this.valueToBinHolder = new HashMap<IELParamValue, XCBinValueHolder.InternalSingleElementWrapper>();
        this.rangeWrappers = new HashSet<XCBinValueHolder.InternalRangeWrapper>();
        return true;
    }

    @Override
    protected boolean hit(IELParamValue value) {
        if (!this.checkWithCondition(value)) {
            return false;
        }
        if (this.valueToBinHolder.containsKey(value)) {
            XCBinValueHolder.InternalSingleElementWrapper internalSingleElementWrapper = this.valueToBinHolder.get(value);
            XCBinValueHolder xcBinValueHolder = internalSingleElementWrapper.getBinHolder();
            if (xcBinValueHolder == null) {
                xcBinValueHolder = new XCBinValueHolder(this.factory, this.xAssociatedType, this, this.instanceScope);
                xcBinValueHolder.setName(String.valueOf(this.getName()) + "[" + internalSingleElementWrapper.getOrderNo() + "]");
                internalSingleElementWrapper.setBinHolder(xcBinValueHolder);
            }
            this.lastElementHit = internalSingleElementWrapper.getOrderNo();
            xcBinValueHolder.hit(value);
            this.setLastInternalBinHit(xcBinValueHolder);
            return true;
        }
        if (this.rangeWrappers == null) {
            return false;
        }
        for (XCBinValueHolder.InternalRangeWrapper rangeWrapper : this.rangeWrappers) {
            if (!rangeWrapper.isInRange(value)) continue;
            rangeWrapper.hit(value, this);
            this.lastElementHit = rangeWrapper.getOrderNo();
            return true;
        }
        return false;
    }

    public IHidObject getWithCondition() {
        return this.withExpression;
    }

    @Override
    protected Map<IELParamValue, XCBinValueHolder> intersectWithValues(Set<IELParamValue> values) {
        LinkedHashMap<IELParamValue, XCBinValueHolder> bins = new LinkedHashMap<IELParamValue, XCBinValueHolder>();
        LinkedList<IELParamValue> valuesToRemove = new LinkedList<IELParamValue>();
        for (IELParamValue value : values) {
            if (this.valueToBinHolder.containsKey(value)) {
                XCBinValueHolder.InternalSingleElementWrapper internalSingleElementWrapper = this.valueToBinHolder.get(value);
                XCBinValueHolder binValueHolder = internalSingleElementWrapper.getBinHolder();
                if (binValueHolder == null) {
                    binValueHolder = new XCBinValueHolder(this.factory, this.xAssociatedType, this, this.instanceScope);
                    internalSingleElementWrapper.setBinHolder(binValueHolder);
                }
                bins.put(value, this);
                valuesToRemove.add(value);
                continue;
            }
            for (XCBinValueHolder.InternalRangeWrapper rangeWrapper : this.rangeWrappers) {
                if (!rangeWrapper.isInRange(value)) continue;
                bins.put(value, this);
                valuesToRemove.add(value);
                values.removeAll(valuesToRemove);
                return bins;
            }
        }
        values.removeAll(valuesToRemove);
        return bins;
    }

    @Override
    protected Map<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> intersectWithRanges(Map<IELParamValue, IELParamValue> ranges) {
        LinkedHashMap<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> rangeToBin = new LinkedHashMap<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder>();
        TreeMap<IELParamValue, IELParamValue> remainingRanges = new TreeMap<IELParamValue, IELParamValue>(IELPARAM_VALUE_COMPARATOR);
        for (Map.Entry<IELParamValue, IELParamValue> range : ranges.entrySet()) {
            LinkedList<DVTNumber> valuesToRemove = new LinkedList<DVTNumber>();
            TreeMap<DVTNumber, DVTNumber> rangeToRemove = new TreeMap<DVTNumber, DVTNumber>(DVTNUMBER_COMPARATOR);
            for (Map.Entry<IELParamValue, XCBinValueHolder.InternalSingleElementWrapper> entry : this.valueToBinHolder.entrySet()) {
                IELParamValue value = entry.getKey();
                DVTNumber binValueNumber = value.getDVTNumber();
                if (!this.isValueInRange(binValueNumber, range)) continue;
                rangeToBin.put(Map.entry(value, value), this);
                valuesToRemove.add(((ELParamValues.ParamValueNumber)value).getDVTNumber());
            }
            for (XCBinValueHolder.InternalRangeWrapper binRange : this.rangeWrappers) {
                Map.Entry<IELParamValue, IELParamValue> intersectionRange = this.getIntersectionRange(binRange.getRange(), range);
                if (intersectionRange == null) continue;
                rangeToBin.put(intersectionRange, this);
                rangeToRemove.put(((ELParamValues.ParamValueNumber)intersectionRange.getKey()).getDVTNumber(), ((ELParamValues.ParamValueNumber)intersectionRange.getValue()).getDVTNumber());
            }
            remainingRanges.putAll(this.computeRaminingRanges(range, valuesToRemove, rangeToRemove));
        }
        ranges.clear();
        ranges.putAll(remainingRanges);
        return rangeToBin;
    }

    @Override
    protected String computeToString() {
        return "\n" + this.rangeWrappers.toString() + "\n\n" + this.valueToBinHolder.keySet().toString();
    }

    @Override
    public long getOrderNo() {
        return super.getOrderNo() + this.lastElementHit;
    }

    @Override
    public List<XCBinValueHolder> getBins() {
        LinkedList<XCBinValueHolder> bins = new LinkedList<XCBinValueHolder>();
        for (Map.Entry<IELParamValue, XCBinValueHolder.InternalSingleElementWrapper> entry : this.valueToBinHolder.entrySet()) {
            XCBinValueHolder binHolder = entry.getValue().getBinHolder();
            if (binHolder == null) {
                binHolder = new XCBinValueHolder(this.factory, this.xAssociatedType, this, this.instanceScope, entry.getKey());
            }
            binHolder.isPartOfArray(true);
            bins.add(binHolder);
        }
        for (XCBinValueHolder.InternalRangeWrapper rangeWrapper : this.rangeWrappers) {
            bins.addAll(rangeWrapper.getAllBins(this));
        }
        return bins;
    }

    public Map<DVTNumber, DVTNumber> getRanges() {
        HashMap<DVTNumber, DVTNumber> ranges = new HashMap<DVTNumber, DVTNumber>();
        for (XCBinValueHolder.InternalRangeWrapper range : this.rangeWrappers) {
            ranges.put(range.getStart(), range.getEnd());
        }
        return ranges;
    }

    public Map<IELParamValue, IELParamValue> getRangesAndValues() {
        HashMap<IELParamValue, IELParamValue> rangesAndValues = new HashMap<IELParamValue, IELParamValue>();
        for (XCBinValueHolder.InternalRangeWrapper range : this.rangeWrappers) {
            rangesAndValues.put(range.getStartValue(), range.getEndValue());
        }
        for (IELParamValue value : this.valueToBinHolder.keySet()) {
            rangesAndValues.put(value, value);
        }
        return rangesAndValues;
    }

    public XCBinValueHolder getLastInternalBinHit() {
        return this.lastInternalBinHit;
    }

    public void setLastInternalBinHit(XCBinValueHolder lastInternalBinHit) {
        this.lastInternalBinHit = lastInternalBinHit;
    }

    @Override
    public boolean resolveOverlappingWithIgnoredBins(List<XCBinValueHolder> binsToIntersect) {
        boolean overlappingIntervals = super.resolveOverlappingWithIgnoredBins(binsToIntersect);
        List valuesAndRanges = Stream.concat(this.binValues.stream().map(v -> v), this.binRanges.entrySet().stream().map(e -> e)).sorted(Comparator.comparing(o -> o instanceof Map.Entry ? (IELParamValue)((Map.Entry)o).getKey() : (IELParamValue)o, IELPARAM_VALUE_COMPARATOR)).collect(Collectors.toList());
        for (Object valueOrRange : valuesAndRanges) {
            if (valueOrRange instanceof Map.Entry var6_6) {
                Object k = entry.getKey();
                if (!(k instanceof IELParamValue) || (var8_8 = (IELParamValue)k) != (IELParamValue)k || !(( instanceOfPatternExpressionValue = entry.getValue()) instanceof IELParamValue) || (var9_9 = (IELParamValue) instanceOfPatternExpressionValue) != (IELParamValue) instanceOfPatternExpressionValue) continue;
                XCBinValueHolder.InternalRangeWrapper internalBinWrapper = new XCBinValueHolder.InternalRangeWrapper(start, (IELParamValue)end, this.elementNo);
                this.elementNo += internalBinWrapper.getSize();
                this.rangeWrappers.add(internalBinWrapper);
            }
            if (!(( instanceOfPatternExpressionValue = valueOrRange) instanceof IELParamValue) || (start = (IELParamValue) instanceOfPatternExpressionValue) != (IELParamValue) instanceOfPatternExpressionValue) continue;
            XCBinValueHolder.InternalSingleElementWrapper internalSingleElementWrapper = new XCBinValueHolder.InternalSingleElementWrapper(this.elementNo++);
            XCBinValueHolder xcBinValueHolder = new XCBinValueHolder(this.factory, this.xAssociatedType, this, this.instanceScope);
            xcBinValueHolder.setName(String.valueOf(this.getName()) + "[" + value.intValue() + "]");
            internalSingleElementWrapper.setBinHolder(xcBinValueHolder);
            DVTNumber dvtNumber = ((ELParamValues.ParamValueNumber)value).getDVTNumber();
            IELParamValue valueHolderForSize = ((XCPointValueHolder)this.enclosing).getValueHolderForSize();
            if (valueHolderForSize == null) {
                this.valueToBinHolder.put(value, internalSingleElementWrapper);
                continue;
            }
            value = valueHolderForSize.copy();
            DVTNumber numberWithCorrectSize = valueHolderForSize.getDVTNumber();
            numberWithCorrectSize = DVTNumber.or(numberWithCorrectSize, dvtNumber, numberWithCorrectSize.getSize());
            ((ELParamValues.ParamValueNumber)value).setDVTNumber(numberWithCorrectSize);
            this.valueToBinHolder.put(value, internalSingleElementWrapper);
        }
        return overlappingIntervals;
    }
}

