/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinCrossValueHolder;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCPointCrossValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.utils.VlogIntegerNumberFactory;

public class XCBinCrossDefaultValueHolder
extends XCBinValueHolder {
    private Map<String, Integer> coveredBins = new HashMap<String, Integer>();

    public XCBinCrossDefaultValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope);
    }

    public void hit(List<XCBinValueHolder> bins) {
        StringBuilder indexBuilder = new StringBuilder("<");
        int i = 0;
        while (i < bins.size()) {
            XCBinValueHolder bin = bins.get(i);
            if (bin instanceof XCBinArrayValueHolder var5_6) {
                indexBuilder.append(String.valueOf(arrayHolder.getLastInternalBinHit().getName()) + (i != bins.size() - 1 ? "," : ""));
            } else {
                indexBuilder.append(String.valueOf(bin.getName()) + (i != bins.size() - 1 ? "," : ""));
            }
            ++i;
        }
        indexBuilder.append(">");
        String index = indexBuilder.toString();
        this.coveredBins.put(index, this.getCoveredBins().getOrDefault(index, 0) + 1);
    }

    @Override
    protected int getBinsHitNo() {
        return this.getCoveredBins().size();
    }

    @Override
    protected long getBinsNo() {
        IELParamValue binsNoValue = this.staticHolder.getValueDirectly("defaultBinsNo");
        if (this.value != null) {
            return binsNoValue.intValue();
        }
        this.computeSize();
        return this.staticHolder.getValueDirectly("defaultBinsNo").bigIntegerValue().longValue();
    }

    /*
     * WARNING - void declaration
     */
    private void computeSize() {
        void crossValueHolder;
        void var2_1;
        XCPointCrossValueHolder xCPointCrossValueHolder;
        IELParamValue iELParamValue = this.enclosing;
        if (!(iELParamValue instanceof XCPointCrossValueHolder) || (xCPointCrossValueHolder = (XCPointCrossValueHolder)iELParamValue) != (XCPointCrossValueHolder)var2_1) {
            return;
        }
        LinkedHashMap<XCPointValueHolder, Integer> crossItems = crossValueHolder.getCrossItems();
        int binsNo = 1;
        for (XCPointValueHolder cPointValueHolder : crossItems.keySet()) {
            int cPointSize = 0;
            List<XCBinValueHolder> binHolders = cPointValueHolder.getAllBinHolders();
            for (XCBinValueHolder binHolder : binHolders) {
                cPointSize = (int)((long)cPointSize + binHolder.getBinsNo());
            }
            binsNo *= cPointSize;
        }
        List<XCBinValueHolder> crossBins = crossValueHolder.getAllBinHolders();
        this.staticHolder.putValueDirectly("defaultBinsNo", ELParamValues.ParamValueNumber.of(VlogIntegerNumberFactory.createInteger(BigInteger.valueOf(binsNo -= this.computeCrossBinsSize(crossBins)))));
    }

    private int computeCrossBinsSize(List<XCBinValueHolder> crossBins) {
        int crossBinsSize = 0;
        for (XCBinValueHolder bin : crossBins) {
            if (!(bin instanceof XCBinCrossValueHolder var5_5)) continue;
            crossBinsSize += crossBin.computeCoveredBinsNo();
        }
        return crossBinsSize;
    }

    public Map<String, Integer> getCoveredBins() {
        return this.coveredBins;
    }

    public void setCoveredBins(Map<String, Integer> coveredBins) {
        this.coveredBins = coveredBins;
    }

    public long getHitCountOfBin(String crossBinName) {
        Integer hitCount = this.coveredBins.get(crossBinName);
        return hitCount == null ? 0 : hitCount;
    }
}

