/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinCrossDefaultValueHolder;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCPointCrossValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.utils.DVTNumber;

public class XCBinCrossValueHolder
extends XCBinValueHolder {
    private XCBinCrossValueHolder parent;
    private List<XCBinCrossValueHolder> crossBinsDNF;
    private List<XCPointFragment> binFragments;
    private int crossItemsNo;

    public int computeCoveredBinsNo() {
        if (this.binFragments != null && !this.binFragments.isEmpty()) {
            int size = 1;
            for (XCPointFragment cPointFragment : this.binFragments) {
                if (cPointFragment.isEmpty) {
                    return 0;
                }
                size *= cPointFragment.getSize();
            }
            return size;
        }
        int m = this.crossBinsDNF.size();
        int total = 0;
        int mask = 1;
        while (mask < 1 << m) {
            XCBinCrossValueHolder intersection = null;
            int bits = Integer.bitCount(mask);
            int i = 0;
            while (i < m) {
                if ((mask & 1 << i) != 0) {
                    if (intersection == null) {
                        intersection = (XCBinCrossValueHolder)this.crossBinsDNF.get(i).copy();
                    } else {
                        intersection.intersectCrossBins(this.crossBinsDNF.get(i));
                    }
                }
                ++i;
            }
            if (intersection != null) {
                int size = intersection.computeCoveredBinsNo();
                total = bits % 2 == 1 ? (total += size) : (total -= size);
            }
            ++mask;
        }
        return total;
    }

    @Override
    public XValueHolder copy() {
        XCBinCrossValueHolder result = new XCBinCrossValueHolder(this.factory, this.xAssociatedType, this.parent, this.instanceScope);
        result.crossItemsNo = this.crossItemsNo;
        ArrayList<XCPointFragment> binFragmentsCopy = new ArrayList<XCPointFragment>();
        for (XCPointFragment binFragment : this.binFragments) {
            binFragmentsCopy.add(binFragment.copy());
        }
        result.binFragments = binFragmentsCopy;
        return result;
    }

    public XCBinCrossValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope);
        this.binType = XCBinValueHolder.BIN_TYPE.CROSS_BIN;
        if (enclosing instanceof XCPointCrossValueHolder) {
            this.crossItemsNo = ((XCPointCrossValueHolder)enclosing).getCrossItemsNo();
        }
    }

    public static XCBinCrossDefaultValueHolder createDefaultBinHolder(XCPointCrossValueHolder crossHolder) {
        XNamedElement xAssociatedType = XNamedElement.create(crossHolder.getNamedElement(), crossHolder, true, crossHolder.getCachedSimGuardian(false).isLinterStaticAnalysisMode());
        XCBinCrossDefaultValueHolder defaultBinHolder = new XCBinCrossDefaultValueHolder(crossHolder.getFactory(), xAssociatedType, crossHolder, crossHolder.getInstanceScope());
        return defaultBinHolder;
    }

    public static XCBinCrossValueHolder createBinCrossValueHolderFromFragments(XCPointCrossValueHolder crossHolder, List<XCPointFragment> binFragments) {
        XNamedElement xAssociatedType = XNamedElement.create(crossHolder.getNamedElement(), crossHolder, true, crossHolder.getCachedSimGuardian(false).isLinterStaticAnalysisMode());
        XCBinCrossValueHolder crossBinHolder = new XCBinCrossValueHolder(crossHolder.getFactory(), xAssociatedType, crossHolder, crossHolder.getInstanceScope());
        crossBinHolder.binFragments = binFragments;
        return crossBinHolder;
    }

    public static XCBinCrossValueHolder createBinCrossValueHolderFromCrossBins(XCPointCrossValueHolder crossHolder, List<XCBinCrossValueHolder> crossValueHolders) {
        XNamedElement xAssociatedType = XNamedElement.create(crossHolder.getNamedElement(), crossHolder, true, crossHolder.getCachedSimGuardian(false).isLinterStaticAnalysisMode());
        XCBinCrossValueHolder crossBinHolder = new XCBinCrossValueHolder(crossHolder.getFactory(), xAssociatedType, crossHolder, crossHolder.getInstanceScope());
        crossBinHolder.crossBinsDNF = crossValueHolders;
        return crossBinHolder;
    }

    public static XCBinCrossValueHolder createCrossBinHolderFromBins(XCPointCrossValueHolder xcPointCrossValueHolder, List<XCBinValueHolder> resultedBins) {
        int crossItemsNo = xcPointCrossValueHolder.getCrossItemsNo();
        ArrayList<XCPointFragment> binFragments = new ArrayList<XCPointFragment>(crossItemsNo);
        XCBinCrossValueHolder crossBinHolder = XCBinCrossValueHolder.createBinCrossValueHolderFromFragments(xcPointCrossValueHolder, binFragments);
        if (resultedBins == null || resultedBins.isEmpty()) {
            return crossBinHolder;
        }
        int orderNoForBin = xcPointCrossValueHolder.getOrderNoForBin(resultedBins.get(0));
        int i = 0;
        for (XCPointValueHolder cPointHolder : xcPointCrossValueHolder.getCrossItems().keySet()) {
            XCPointFragment xBinFragments;
            if (orderNoForBin == i) {
                xBinFragments = new XCPointFragment(new HashMap<XCBinValueHolder, XFragments>(), cPointHolder);
                xBinFragments.addFullBins(resultedBins);
                binFragments.add(i++, xBinFragments);
                continue;
            }
            xBinFragments = new XCPointFragment(true, cPointHolder, true);
            binFragments.add(i++, xBinFragments);
        }
        return crossBinHolder;
    }

    public static XCPointFragment computeFragments(Map<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> rangeToBin, Map<IELParamValue, XCBinValueHolder> valueToBin, XCPointValueHolder cPointHolder) {
        XFragments binFragments;
        HashMap<IELParamValue, IELParamValue> fragmentMap;
        XCBinValueHolder binHolder;
        XCPointFragment binsFragments = new XCPointFragment(new HashMap<XCBinValueHolder, XFragments>(), cPointHolder);
        for (Map.Entry<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> entry : rangeToBin.entrySet()) {
            Map.Entry<IELParamValue, IELParamValue> range = entry.getKey();
            binHolder = entry.getValue();
            fragmentMap = new HashMap<IELParamValue, IELParamValue>();
            fragmentMap.put(range.getKey(), range.getValue());
            binFragments = new XFragments(fragmentMap);
            binsFragments.updateBinsFragments(binHolder, binFragments);
        }
        for (Map.Entry<Object, XCBinValueHolder> entry : valueToBin.entrySet()) {
            IELParamValue value = (IELParamValue)entry.getKey();
            binHolder = entry.getValue();
            fragmentMap = new HashMap();
            fragmentMap.put(value, value);
            binFragments = new XFragments(fragmentMap);
            binsFragments.updateBinsFragments(binHolder, binFragments);
        }
        return binsFragments;
    }

    public void intersectCrossBins(XCBinCrossValueHolder crossHolder) {
        List<XCPointFragment> otherBinFragments = crossHolder.binFragments;
        int i = 0;
        while (i < this.crossItemsNo) {
            this.binFragments.get(i).intersectBinFragments(otherBinFragments.get(i));
            if (this.binFragments.get(i).isEmpty()) {
                return;
            }
            ++i;
        }
    }

    private void mergeBinFragments(Map<XCBinValueHolder, Map<IELParamValue, IELParamValue>> binFragments, Map<XCBinValueHolder, Map<IELParamValue, IELParamValue>> otherBinFragments) {
        for (Map.Entry<XCBinValueHolder, Map<IELParamValue, IELParamValue>> entry : otherBinFragments.entrySet()) {
            XCBinValueHolder bin = entry.getKey();
            Map<IELParamValue, IELParamValue> otherRange = entry.getValue();
            if (!binFragments.containsKey(bin)) {
                binFragments.put(bin, otherRange);
                continue;
            }
            Map<IELParamValue, IELParamValue> range = binFragments.get(bin);
            if (range == null) continue;
            if (otherRange == null) {
                binFragments.put(bin, null);
                continue;
            }
            binFragments.put(bin, this.concatIntervals(otherRange, range));
        }
    }

    private Map<IELParamValue, IELParamValue> concatIntervals(Map<IELParamValue, IELParamValue> range1, Map<IELParamValue, IELParamValue> range2) {
        ArrayList<Map.Entry<IELParamValue, IELParamValue>> allIntervals = new ArrayList<Map.Entry<IELParamValue, IELParamValue>>();
        allIntervals.addAll(range1.entrySet());
        allIntervals.addAll(range2.entrySet());
        Collections.sort(allIntervals, PARAM_RANGE_COMPARATOR);
        LinkedHashMap<IELParamValue, IELParamValue> merged = new LinkedHashMap<IELParamValue, IELParamValue>();
        IELParamValue curStart = null;
        IELParamValue curEnd = null;
        for (Map.Entry entry : allIntervals) {
            DVTNumber newStartNum;
            IELParamValue start = (IELParamValue)entry.getKey();
            IELParamValue end = (IELParamValue)entry.getValue();
            if (curStart == null) {
                curStart = start;
                curEnd = end;
                continue;
            }
            if (curEnd == null) continue;
            DVTNumber curEndNum = ((ELParamValues.ParamValueNumber)curEnd).getDVTNumber();
            if (DVTNumber.gte(curEndNum, newStartNum = ((ELParamValues.ParamValueNumber)start).getDVTNumber())) {
                DVTNumber newEndNum = ((ELParamValues.ParamValueNumber)end).getDVTNumber();
                if (!DVTNumber.gte(newEndNum, curEndNum)) continue;
                curEnd = end;
                continue;
            }
            merged.put(curStart, curEnd);
            curStart = start;
            curEnd = end;
        }
        if (curStart != null) {
            merged.put(curStart, curEnd);
        }
        return merged;
    }

    public boolean checkBinCondition(List<XCBinValueHolder> binHolders) {
        if (this.crossBinsDNF != null && !this.crossBinsDNF.isEmpty()) {
            for (XCBinCrossValueHolder crossBin : this.crossBinsDNF) {
                if (!crossBin.checkBinCondition(binHolders)) continue;
                return true;
            }
            return false;
        }
        if (binHolders.size() != this.crossItemsNo) {
            return false;
        }
        int i = 0;
        while (i < this.crossItemsNo) {
            XCBinValueHolder currentBin;
            XCPointFragment xBinsFragments = this.binFragments.get(i);
            if (!xBinsFragments.checkBin(currentBin = binHolders.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void logicalNot() {
        if (this.binFragments == null || this.binFragments.isEmpty()) {
            return;
        }
        int i = 0;
        while (i < this.binFragments.size()) {
            this.binFragments.set(i, this.binFragments.get(i).logicalNot());
            ++i;
        }
    }

    @Override
    protected String computeToString() {
        if (this.binFragments != null && !this.binFragments.isEmpty()) {
            return "\n" + this.binFragments.toString();
        }
        return "\n" + this.crossBinsDNF.toString();
    }

    public void hit(List<XCBinValueHolder> crossedBins) {
        ++this.hitCount;
    }

    static class XCPointFragment {
        private Map<XCBinValueHolder, XFragments> binsFragments;
        private boolean isFullCp;
        private boolean isEmpty;
        private boolean isImplicit;
        private XCPointValueHolder cPointHolder;
        int size = -1;

        public XCPointFragment(Map<XCBinValueHolder, XFragments> binsFragments, XCPointValueHolder cPointHolder) {
            this.binsFragments = binsFragments;
            this.cPointHolder = cPointHolder;
        }

        public XCPointFragment copy() {
            if (this.isFullCp && (this.binsFragments == null || this.binsFragments.isEmpty())) {
                return new XCPointFragment(this.isFullCp, this.cPointHolder, this.isImplicit);
            }
            return new XCPointFragment(new HashMap<XCBinValueHolder, XFragments>(this.binsFragments), this.cPointHolder);
        }

        public int getSize() {
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            if (this.isFullCp) {
                List<XCBinValueHolder> binHolders = this.cPointHolder.getAllBinHolders();
                for (XCBinValueHolder binHolder : binHolders) {
                    this.size = (int)((long)this.size + binHolder.getBinsNo());
                }
                return this.size;
            }
            for (Map.Entry<XCBinValueHolder, XFragments> entry : this.binsFragments.entrySet()) {
                XCBinValueHolder bin = entry.getKey();
                XFragments fragments = entry.getValue();
                if (bin instanceof XCBinArrayValueHolder && !fragments.isFullBin) {
                    this.size += fragments.getSize();
                    continue;
                }
                if (bin instanceof XCBinArrayValueHolder && fragments.isFullBin) {
                    this.size = (int)((long)this.size + bin.getBinsNo());
                    continue;
                }
                ++this.size;
            }
            return this.size;
        }

        public XCPointFragment(boolean isFullCp, XCPointValueHolder cPointHolder, boolean isImplicit) {
            this.isFullCp = isFullCp;
            this.isEmpty = !isFullCp;
            this.cPointHolder = cPointHolder;
            this.isImplicit = isImplicit;
        }

        private void updateBinsFragments(XCBinValueHolder binHolder, XFragments newBinFragment) {
            if (!this.binsFragments.containsKey(binHolder)) {
                this.binsFragments.put(binHolder, newBinFragment);
                return;
            }
            this.binsFragments.get(binHolder).addFragment(newBinFragment);
        }

        private void addFullBin(XCBinValueHolder valueHolder) {
            this.binsFragments.put(valueHolder, new XFragments());
        }

        private void addFullBins(List<XCBinValueHolder> binHolders) {
            for (XCBinValueHolder binHolder : binHolders) {
                this.binsFragments.put(binHolder, new XFragments());
            }
        }

        public boolean checkBin(XCBinValueHolder currentBin) {
            if (this.isFullCp) {
                return true;
            }
            if (!this.binsFragments.containsKey(currentBin)) {
                return false;
            }
            XFragments xBinFragments = this.binsFragments.get(currentBin);
            if (xBinFragments.isEmpty()) {
                return false;
            }
            return xBinFragments.isValueInFragments(currentBin.getLastValue());
        }

        private void intersectBinFragments(XCPointFragment otherBinFragments) {
            if (this.isImplicit && !otherBinFragments.isImplicit) {
                this.isFullCp = false;
                this.binsFragments = otherBinFragments.binsFragments;
                this.isImplicit = true;
                return;
            }
            if (otherBinFragments.isFullCp || this.isEmpty) {
                return;
            }
            if (otherBinFragments.isEmpty) {
                this.binsFragments = null;
                this.isEmpty = true;
            }
            HashMap<XCBinValueHolder, XFragments> newFragments = new HashMap<XCBinValueHolder, XFragments>();
            boolean intersectionExists = false;
            for (Map.Entry<XCBinValueHolder, XFragments> entry : otherBinFragments.binsFragments.entrySet()) {
                Map<IELParamValue, IELParamValue> otherRange;
                XCBinValueHolder bin = entry.getKey();
                if (this.binsFragments == null || !this.binsFragments.containsKey(bin) || (otherRange = entry.getValue().fragments) == null) continue;
                XFragments xBinFragments = this.binsFragments.get(bin);
                if (xBinFragments.isFullBin) {
                    newFragments.put(bin, new XFragments(otherRange));
                    intersectionExists = true;
                    continue;
                }
                Map<IELParamValue, IELParamValue> range = xBinFragments.fragments;
                XFragments intersectedFragments = new XFragments(this.intersectIntervals(otherRange, range));
                if (!intersectedFragments.isEmpty()) {
                    intersectionExists = true;
                }
                newFragments.put(bin, intersectedFragments);
            }
            if (this.binsFragments != null) {
                this.binsFragments.clear();
            }
            this.binsFragments = newFragments;
            if (!intersectionExists) {
                this.isEmpty = !intersectionExists;
                this.binsFragments = null;
            }
        }

        public XCBinValueHolder getFirstBin() {
            if (this.binsFragments.isEmpty()) {
                return null;
            }
            return this.binsFragments.keySet().iterator().next();
        }

        private Map<IELParamValue, IELParamValue> intersectIntervals(Map<IELParamValue, IELParamValue> range1, Map<IELParamValue, IELParamValue> range2) {
            if (range1 == null) {
                range1 = Collections.emptyMap();
            }
            if (range2 == null) {
                range2 = Collections.emptyMap();
            }
            if (range1.isEmpty() || range2.isEmpty()) {
                return new LinkedHashMap<IELParamValue, IELParamValue>();
            }
            ArrayList<Map.Entry<IELParamValue, IELParamValue>> list1 = new ArrayList<Map.Entry<IELParamValue, IELParamValue>>(range1.entrySet());
            ArrayList<Map.Entry<IELParamValue, IELParamValue>> list2 = new ArrayList<Map.Entry<IELParamValue, IELParamValue>>(range2.entrySet());
            list1.sort(PARAM_RANGE_COMPARATOR);
            list2.sort(PARAM_RANGE_COMPARATOR);
            LinkedHashMap<IELParamValue, IELParamValue> result = new LinkedHashMap<IELParamValue, IELParamValue>();
            int i = 0;
            int j = 0;
            while (i < list1.size() && j < list2.size()) {
                DVTNumber interEndNum;
                Map.Entry e1 = (Map.Entry)list1.get(i);
                Map.Entry e2 = (Map.Entry)list2.get(j);
                IELParamValue aStart = (IELParamValue)e1.getKey();
                IELParamValue aEnd = (IELParamValue)e1.getValue();
                IELParamValue bStart = (IELParamValue)e2.getKey();
                IELParamValue bEnd = (IELParamValue)e2.getValue();
                DVTNumber aStartNum = ((ELParamValues.ParamValueNumber)aStart).getDVTNumber();
                DVTNumber aEndNum = ((ELParamValues.ParamValueNumber)aEnd).getDVTNumber();
                DVTNumber bStartNum = ((ELParamValues.ParamValueNumber)bStart).getDVTNumber();
                DVTNumber bEndNum = ((ELParamValues.ParamValueNumber)bEnd).getDVTNumber();
                IELParamValue interStart = DVTNumber.gt(aStartNum, bStartNum) ? aStart : bStart;
                IELParamValue interEnd = DVTNumber.lt(aEndNum, bEndNum) ? aEnd : bEnd;
                DVTNumber interStartNum = ((ELParamValues.ParamValueNumber)interStart).getDVTNumber();
                if (DVTNumber.lte(interStartNum, interEndNum = ((ELParamValues.ParamValueNumber)interEnd).getDVTNumber())) {
                    result.put(interStart, interEnd);
                }
                if (DVTNumber.lt(aEndNum, bEndNum)) {
                    ++i;
                    continue;
                }
                if (DVTNumber.gt(aEndNum, bEndNum)) {
                    ++j;
                    continue;
                }
                ++i;
                ++j;
            }
            return result;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public XCPointFragment logicalNot() {
            if (this.isImplicit) {
                return this;
            }
            XCPointFragment newBinsFragments = new XCPointFragment(new HashMap<XCBinValueHolder, XFragments>(), this.cPointHolder);
            if (this.isFullCp) {
                newBinsFragments.isEmpty = true;
                return newBinsFragments;
            }
            List<XCBinValueHolder> binHolders = this.cPointHolder.getAllBinHolders();
            for (XCBinValueHolder binHolder : binHolders) {
                if (!this.binsFragments.containsKey(binHolder)) {
                    newBinsFragments.addFullBin(binHolder);
                    continue;
                }
                if (!(binHolder instanceof XCBinArrayValueHolder var5_5)) continue;
                XFragments xBinFragments = this.binsFragments.get(binHolder);
                if (xBinFragments.isFullBin) continue;
                XCBinArrayValueHolder dummyHolder = new XCBinArrayValueHolder(binHolder.getFactory(), binHolder.xAssociatedType, (IELParamValue)binHolder, binHolder.instanceScope, "", xBinFragments.fragments);
                ((XCBinValueHolder)dummyHolder).init();
                Map<IELParamValue, IELParamValue> rangesAndValues = arrayHolder.getRangesAndValues();
                ((XCBinValueHolder)dummyHolder).intersectWithRanges(rangesAndValues);
                newBinsFragments.binsFragments.put(binHolder, new XFragments(rangesAndValues));
            }
            return newBinsFragments;
        }

        public String toString() {
            StringBuilder strBuilder = new StringBuilder("\n" + this.cPointHolder.toString() + ":\n");
            if (this.isFullCp) {
                strBuilder.append("\tFULL CP");
                return strBuilder.toString();
            }
            for (Map.Entry<XCBinValueHolder, XFragments> entry : this.binsFragments.entrySet()) {
                strBuilder.append("\t" + entry.getKey().getAddress() + " = " + entry.getValue().toString() + " \n");
            }
            return strBuilder.toString();
        }
    }

    static class XFragments {
        private Map<IELParamValue, IELParamValue> fragments;
        int size = -1;
        boolean isFullBin;

        public XFragments(Map<IELParamValue, IELParamValue> fragments) {
            this.fragments = fragments;
        }

        public XFragments() {
            this.isFullBin = true;
        }

        public int getSize() {
            if (this.size != -1) {
                return this.size;
            }
            this.size = 0;
            if (this.fragments == null) {
                return this.size;
            }
            for (Map.Entry<IELParamValue, IELParamValue> fragment : this.fragments.entrySet()) {
                IELParamValue left = fragment.getKey();
                IELParamValue right = fragment.getValue();
                this.size += DVTNumber.minus(right.getDVTNumber(), left.getDVTNumber()).intValue() + 1;
            }
            return this.size;
        }

        public boolean isValueInFragments(IELParamValue value) {
            if (this.isFullBin) {
                return true;
            }
            DVTNumber dvtNumber = value.getDVTNumber();
            for (Map.Entry<IELParamValue, IELParamValue> range : this.fragments.entrySet()) {
                if (range == null) {
                    return true;
                }
                IELParamValue value1 = range.getKey();
                IELParamValue value2 = range.getValue();
                DVTNumber dvtNumber1 = value1.getDVTNumber();
                DVTNumber dvtNumber2 = value2.getDVTNumber();
                if (!DVTNumber.gte(dvtNumber2, dvtNumber) || !DVTNumber.gte(dvtNumber, dvtNumber1)) continue;
                return true;
            }
            return false;
        }

        private void addFragment(XFragments newBinFragment) {
            this.fragments.putAll(newBinFragment.fragments);
        }

        public String toString() {
            return this.isFullBin ? "FULL BIN" : this.fragments.toString();
        }

        public boolean isEmpty() {
            return !this.isFullBin && (this.fragments == null || this.fragments.isEmpty());
        }
    }
}

