/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXCBinArray;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCPointSimpleValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XCoverageUtils;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XCBinFixedSizeArrayValueHolder
extends XCBinValueHolder
implements IXCBinArray {
    private int binsNo;
    private int binsHit;
    private TreeMap<XCBinValueHolder.ValuesAndRanges, XCBinValueHolder> valuesToBins = new TreeMap();

    public XCBinFixedSizeArrayValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int binsNo) {
        super(factory, xAssociatedType, enclosing, instanceScope);
        this.binsNo = binsNo;
    }

    @Override
    public long getBinsNo() {
        return this.binsNo;
    }

    @Override
    protected boolean init() {
        long totalSize = this.extractValuesAndRanges(this.binValues, this.binRanges);
        if (totalSize <= (long)this.binsNo) {
            return false;
        }
        List valuesAndRanges = Stream.concat(this.binValues.stream().map(v -> v), this.binRanges.entrySet().stream().map(e -> e)).sorted(Comparator.comparing(o -> o instanceof Map.Entry ? (IELParamValue)((Map.Entry)o).getKey() : (IELParamValue)o, IELPARAM_VALUE_COMPARATOR)).collect(Collectors.toList());
        long binSize = totalSize / (long)this.binsNo;
        int binsCounter = 1;
        XCBinValueHolder.ValuesAndRanges currentVaR = new XCBinValueHolder.ValuesAndRanges();
        int currentSize = 0;
        for (Object valueOrRange : valuesAndRanges) {
            if (valueOrRange instanceof IELParamValue var11_9) {
                currentVaR.addValue((IELParamValue)value);
                if (binsCounter >= this.binsNo || (long)(++currentSize) < binSize - 1L) continue;
                this.valuesToBins.put(currentVaR, new XCBinValueHolder(this.factory, this.xAssociatedType, (IELParamValue)this, this.instanceScope, currentVaR, this.getBinName(binsCounter, currentVaR)));
                currentSize = 0;
                ++binsCounter;
                currentVaR = new XCBinValueHolder.ValuesAndRanges();
                continue;
            }
             instanceOfPatternExpressionValue = valueOrRange;
            if (!( instanceOfPatternExpressionValue instanceof Map.Entry) || (var13_11 = (Map.Entry) instanceOfPatternExpressionValue) != (Map.Entry) instanceOfPatternExpressionValue || !(( instanceOfPatternExpressionValue = entry.getKey()) instanceof IELParamValue) || (var15_13 = (IELParamValue) instanceOfPatternExpressionValue) != (IELParamValue) instanceOfPatternExpressionValue || !(( instanceOfPatternExpressionValue = entry.getValue()) instanceof IELParamValue) || (var16_14 = (IELParamValue) instanceOfPatternExpressionValue) != (IELParamValue) instanceOfPatternExpressionValue) continue;
            long currentRangeSize = DVTNumber.minus(endValue.getDVTNumber(), startValue.getDVTNumber()).bigIntegerValue().longValue();
            while (binSize - (long)currentSize < currentRangeSize && binsCounter < this.binsNo) {
                IELParamValue iELParamValue = startValue.copy();
                if (!(iELParamValue instanceof ELParamValues.ParamValueNumber var21_18)) break;
                BigInteger newStartInt = startValue.bigIntegerValue().add(BigInteger.valueOf(binSize - (long)currentSize - 1L));
                DVTNumber  instanceOfPatternExpressionValue2 = newStart.getDVTNumber().copy();
                if (!( instanceOfPatternExpressionValue2 instanceof VlogBitVector var24_21)) break;
                newStartDVTNumber.setNumber(newStartInt);
                newStart.setDVTNumber((DVTNumber)newStartDVTNumber);
                currentVaR.addRange(startValue, newStart);
                this.valuesToBins.put(currentVaR, new XCBinValueHolder(this.factory, this.xAssociatedType, (IELParamValue)this, this.instanceScope, currentVaR, this.getBinName(binsCounter, currentVaR)));
                newStart = (ELParamValues.ParamValueNumber)newStart.copy();
                newStart.setDVTNumber(DVTNumber.plus((DVTNumber)newStartDVTNumber, XCoverageUtils.ONE, newStartDVTNumber.getSize()));
                startValue = newStart;
                currentVaR = new XCBinValueHolder.ValuesAndRanges();
                currentSize = 0;
                ++binsCounter;
                currentRangeSize = DVTNumber.minus(endValue.getDVTNumber(), newStart.getDVTNumber()).bigIntegerValue().longValue();
            }
            currentVaR.addRange(startValue, (IELParamValue)endValue);
            currentSize = (int)((long)currentSize + currentRangeSize);
        }
        if (!currentVaR.isEmpty()) {
            this.valuesToBins.put(currentVaR, new XCBinValueHolder(this.factory, this.xAssociatedType, (IELParamValue)this, this.instanceScope, currentVaR, this.getBinName(binsCounter, currentVaR)));
        }
        return true;
    }

    private String getBinName(int binsCounter, XCBinValueHolder.ValuesAndRanges currentVaR) {
        String binName = "";
        binName = this instanceof XCBinAutomaticValueHolder ? String.valueOf(this.getName()) + "[" + currentVaR.getOrderKey().intValue() + ":" + currentVaR.getMaxValue().intValue() + "]" : String.valueOf(this.getName()) + "[" + (binsCounter - 1) + "]";
        return binName;
    }

    @Override
    public boolean resolveOverlappingWithIgnoredBins(List<XCBinValueHolder> binsToIntersect) {
        XCBinValueHolder.ValuesAndRanges newValues;
        HashMap<XCBinValueHolder.ValuesAndRanges, XCBinValueHolder.ValuesAndRanges> oldValuesNewValues = new HashMap<XCBinValueHolder.ValuesAndRanges, XCBinValueHolder.ValuesAndRanges>();
        boolean overallpingIntervals = false;
        for (Map.Entry<XCBinValueHolder.ValuesAndRanges, XCBinValueHolder> entry : this.valuesToBins.entrySet()) {
            XCBinValueHolder bin = entry.getValue();
            if (!bin.resolveOverlappingWithIgnoredBins(binsToIntersect)) continue;
            overallpingIntervals = true;
            newValues = null;
            if (!bin.coveredByIgnoreBins) {
                newValues = new XCBinValueHolder.ValuesAndRanges(bin.binValues, bin.binRanges);
            }
            oldValuesNewValues.put(entry.getKey(), newValues);
        }
        for (Map.Entry<XCBinValueHolder.ValuesAndRanges, XCBinValueHolder> entry : oldValuesNewValues.entrySet()) {
            XCBinValueHolder.ValuesAndRanges oldValue = entry.getKey();
            newValues = (XCBinValueHolder.ValuesAndRanges)((Object)entry.getValue());
            XCBinValueHolder bin = this.valuesToBins.get(oldValue);
            this.valuesToBins.remove(oldValue);
            if (newValues == null) continue;
            this.valuesToBins.put(newValues, bin);
        }
        this.binsNo = this.valuesToBins.size();
        return overallpingIntervals;
    }

    @Override
    protected boolean hit(IELParamValue value) {
        if (!this.checkWithCondition(value)) {
            return false;
        }
        XCBinValueHolder.ValuesAndRanges key = new XCBinValueHolder.ValuesAndRanges(value.bigIntegerValue());
        Map.Entry<XCBinValueHolder.ValuesAndRanges, XCBinValueHolder> entry = this.valuesToBins.floorEntry(key);
        if (entry == null) {
            return false;
        }
        XCBinValueHolder bin = entry.getValue();
        if (bin == null) {
            return false;
        }
        if (bin.getBinsHitNo() == 0) {
            ++this.binsHit;
        }
        bin.hit(value);
        if (bin.getBinsHitNo() == 0) {
            --this.binsHit;
        }
        if (this.enclosing instanceof XCPointSimpleValueHolder var5_6) {
            cPoint.setLastBinHit(bin);
            cPoint.setLastValue(value);
        }
        return true;
    }

    @Override
    public List<XCBinValueHolder> getBins() {
        return new LinkedList<XCBinValueHolder>(this.valuesToBins.values());
    }

    @Override
    protected String computeToString() {
        return "\n" + this.valuesToBins.keySet();
    }

    @Override
    protected int getBinsHitNo() {
        return this.binsHit;
    }

    public boolean isArray() {
        return true;
    }

    public static class XCBinAutomaticValueHolder
    extends XCBinFixedSizeArrayValueHolder {
        public Map<IELParamValue, IELParamValue> range = new HashMap<IELParamValue, IELParamValue>();

        public XCBinAutomaticValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, int binSize) {
            super(factory, xAssociatedType, enclosing, instanceScope, binSize);
            this.setName(AUTOMATIC_BIN_NAME);
        }

        @Override
        protected long extractValuesAndRanges(Set<IELParamValue> binValues, Map<IELParamValue, IELParamValue> binRanges) {
            IHidObject cpExpression = ((XCPointValueHolder)this.enclosing).getExpression();
            ELParamValueScope paramValueScope = ELUtils.evaluateForSize(cpExpression, ((XValueHolder)this.enclosing).getEnclosingValue(), null, this.getCachedSimGuardian(false));
            if (ELUtils.isUnsuccessfulEval(paramValueScope)) {
                return -1L;
            }
            IELParamValue iELParamValue = XUtils.getValue(paramValueScope).copy();
            if (!(iELParamValue instanceof ELParamValues.ParamValueNumber var5_6)) {
                return -1L;
            }
            ELParamValues.ParamValueNumber startValueNumber = (ELParamValues.ParamValueNumber)valueNumber.copy();
            ELParamValues.ParamValueNumber endValueNumber = (ELParamValues.ParamValueNumber)valueNumber.copy();
            DVTNumber start = startValueNumber.getDVTNumber();
            if (start instanceof VlogBitVector var10_11) {
                vlogBitVector.setNumber(BigInteger.ZERO);
                start = vlogBitVector.createNoMaskEquivalent();
                startValueNumber.setDVTNumber(start);
            }
            DVTNumber end = DVTNumber.minus(DVTNumber.xor(start, start), XCoverageUtils.ONE);
            long totalValues = DVTNumber.minus(end, start).bigIntegerValue().longValue() + 1L;
            endValueNumber.setDVTNumber(end);
            binRanges.put((IELParamValue)valueNumber, endValueNumber);
            this.getRange().put(startValueNumber, endValueNumber);
            return totalValues;
        }

        public Map<IELParamValue, IELParamValue> getRange() {
            return this.range;
        }
    }
}

