/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import com.google.common.collect.Iterators;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinFixedSizeArrayValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XCoverageUtils;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfCoverbin;
import ro.amiq.dvt.model.reflection.IRfFieldElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.Hid;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogIntegerNumberFactory;

public class XCBinValueHolder
extends XValueHolder {
    public static final Comparator<? super DVTNumber> DVTNUMBER_COMPARATOR = (x, y) -> DVTNumber.gte(x, y) ? (DVTNumber.eq(x, y) ? 0 : 1) : -1;
    public static final Comparator<Map.Entry<IELParamValue, IELParamValue>> PARAM_RANGE_COMPARATOR = (e1, e2) -> {
        DVTNumber n2;
        DVTNumber n1 = ((ELParamValues.ParamValueNumber)e1.getKey()).getDVTNumber();
        return DVTNumber.lt(n1, n2 = ((ELParamValues.ParamValueNumber)e2.getKey()).getDVTNumber()) ? -1 : (DVTNumber.eq(n1, n2) ? 0 : 1);
    };
    public static final Comparator<? super IELParamValue> IELPARAM_VALUE_COMPARATOR = (e1, e2) -> {
        DVTNumber n2;
        DVTNumber n1 = ((ELParamValues.ParamValueNumber)e1).getDVTNumber();
        return DVTNumber.lt(n1, n2 = ((ELParamValues.ParamValueNumber)e2).getDVTNumber()) ? -1 : (DVTNumber.eq(n1, n2) ? 0 : 1);
    };
    protected int hitCount;
    protected List<IHidObject> binExpressions;
    protected IELParamValue value;
    protected IHidObject withExpression;
    protected static String AUTOMATIC_BIN_NAME = "auto";
    protected int size;
    protected int valuesSize;
    protected int orderNo;
    protected Set<IELParamValue> binValues = new TreeSet<IELParamValue>(IELPARAM_VALUE_COMPARATOR);
    protected Map<IELParamValue, IELParamValue> binRanges = new TreeMap<IELParamValue, IELParamValue>(IELPARAM_VALUE_COMPARATOR);
    private int binUCISId;
    protected boolean isPartOfArray;
    protected boolean coveredByIgnoreBins;
    private String name;
    protected boolean isIgnoreBin;
    protected boolean isIllegalBin;
    protected BIN_TYPE binType = BIN_TYPE.SIMPLE_BIN;

    public XCBinValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope, false, false, false);
        this.name = this.getNamedElement().getName();
    }

    public XCBinValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, ValuesAndRanges valuesAndRanges, String name) {
        super(factory, xAssociatedType, enclosing, instanceScope, false, false, false);
        this.binValues.addAll(valuesAndRanges.values);
        this.binRanges.putAll(valuesAndRanges.ranges);
        this.name = name;
    }

    public XCBinValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, IELParamValue value) {
        super(factory, xAssociatedType, enclosing, instanceScope, false, false, false);
        this.value = value;
    }

    protected void setBinExpressions(List<IHidObject> binExpressions) {
        this.binExpressions = new ArrayList<IHidObject>(binExpressions);
        Collections.reverse(this.binExpressions);
    }

    protected boolean hit(IELParamValue value) {
        if (!this.checkWithCondition(value)) {
            return false;
        }
        ++this.hitCount;
        return true;
    }

    protected boolean checkBinExpression(IELParamValue value) {
        if (!this.checkWithCondition(value)) {
            return false;
        }
        if (this.binValues.contains(value)) {
            return true;
        }
        for (Map.Entry<IELParamValue, IELParamValue> binRange : this.binRanges.entrySet()) {
            DVTNumber startNumber = binRange.getKey().getDVTNumber();
            DVTNumber endNumber = binRange.getValue().getDVTNumber();
            if (!DVTNumber.gte(value.getDVTNumber(), startNumber) || !DVTNumber.gte(endNumber, value.getDVTNumber())) continue;
            return true;
        }
        return false;
    }

    protected boolean checkWithCondition(IELParamValue value) {
        if (this.withExpression == null) {
            return true;
        }
        this.values.put("item", value);
        IELParamValue condition = ELUtils.evaluateCondition(this.withExpression, this, null, this.getCachedSimGuardian(false));
        return !ELUtils.isUnsuccessfulEval(condition) && condition.intValue() != 0;
    }

    protected boolean init() {
        IRfNamedElement namedElement = this.getNamedElement();
        if (!(namedElement instanceof IRfCoverbin)) {
            return false;
        }
        IRfCoverbin binElement = (IRfCoverbin)namedElement;
        this.withExpression = binElement.getWithExpression();
        if (this.binExpressions != null) {
            this.extractValuesAndRanges(this.binValues, this.binRanges);
        }
        return true;
    }

    protected long extractValuesAndRanges(Set<IELParamValue> binValues, Map<IELParamValue, IELParamValue> binRanges) {
        long totalSize = 0L;
        for (IHidObject expression : this.binExpressions) {
            IHidObject iHidObject = expression;
            if (!(iHidObject instanceof IHidOperator) || (var7_6 = (IHidOperator)iHidObject) != (IHidOperator)iHidObject || !operator.isColon()) {
                ELParamValueScope valueScope = null;
                if (expression instanceof Hid && (hidElement = ((Hid)expression).getElement()) instanceof IRfFieldElement && ((IRfFieldElement)hidElement).isEnumElement()) {
                    valueScope = ELUtils.evaluate(expression, this.instanceScope, null, this.getCachedSimGuardian(true));
                }
                if (valueScope == null) {
                    valueScope = ELUtils.evaluate(expression, this.enclosing, null, this.getCachedSimGuardian(true));
                }
                if (ELUtils.isUnsuccessfulEval(valueScope)) continue;
                IELParamValue expressionValue = XUtils.getValue(valueScope);
                binValues.add(expressionValue.copy());
                ++totalSize;
                continue;
            }
            if (!operator.isColon()) continue;
            IELParamValue startValue = null;
            IELParamValue endValue = null;
            IHidObject endRangeHid = operator.getFirstRHValue();
            IHidObject startRangeHid = operator.getLHValue();
            if (endRangeHid instanceof IHidImplicit var13_12 && "$".equals(implicitHid.getName())) {
                startValue = this.getCpMinValue();
            }
            if (( instanceOfPatternExpressionValue = startRangeHid) instanceof IHidImplicit var15_14 && "$".equals(implicitHid.getName())) {
                endValue = this.getCpMaxValue();
            }
            if (startValue == null) {
                ELParamValueScope startValueScope = ELUtils.evaluate(startRangeHid, this.enclosing, null, this.getCachedSimGuardian(false));
                if (ELUtils.isUnsuccessfulEval(startValueScope)) continue;
                startValue = XUtils.getValue(startValueScope);
            }
            if (endValue == null) {
                ELParamValueScope endValueScope = ELUtils.evaluate(endRangeHid, this.enclosing, null, this.getCachedSimGuardian(false));
                if (ELUtils.isUnsuccessfulEval(endValueScope)) continue;
                endValue = XUtils.getValue(endValueScope);
            }
            totalSize += DVTNumber.minus(endValue.getDVTNumber(), startValue.getDVTNumber()).bigIntegerValue().longValue() + 1L;
            binRanges.put(startValue, endValue);
        }
        return totalSize;
    }

    /*
     * WARNING - void declaration
     */
    private IELParamValue getCpMaxValue() {
        void paramValue;
        void var2_1;
        ELParamValues.ParamValueNumber paramValueNumber;
        IELParamValue iELParamValue = this.getCpMinValue();
        if (!(iELParamValue instanceof ELParamValues.ParamValueNumber) || (paramValueNumber = (ELParamValues.ParamValueNumber)iELParamValue) != (ELParamValues.ParamValueNumber)var2_1) {
            return null;
        }
        paramValue.setDVTNumber(DVTNumber.minus(paramValue.getDVTNumber(), XCoverageUtils.ONE, paramValue.getSize()));
        return paramValue;
    }

    /*
     * WARNING - void declaration
     */
    private IELParamValue getCpMinValue() {
        void cPointHolder;
        void var2_1;
        XCPointValueHolder xCPointValueHolder;
        IELParamValue iELParamValue = this.enclosing;
        if (!(iELParamValue instanceof XCPointValueHolder) || (xCPointValueHolder = (XCPointValueHolder)iELParamValue) != (XCPointValueHolder)var2_1) {
            return null;
        }
        IELParamValue valueHolderForSize = cPointHolder.getValueHolderForSize();
        if (valueHolderForSize == null) {
            return null;
        }
        valueHolderForSize = valueHolderForSize.copy();
        return valueHolderForSize;
    }

    protected long getBinsNo() {
        return 1L;
    }

    protected int getBinsHitNo() {
        return this.hitCount >= this.getAtLeast() ? 1 : 0;
    }

    /*
     * WARNING - void declaration
     */
    protected int getAtLeast() {
        void var2_1;
        XCPointValueHolder xCPointValueHolder;
        IELParamValue iELParamValue = this.enclosing;
        if (iELParamValue instanceof XCPointValueHolder && (xCPointValueHolder = (XCPointValueHolder)iELParamValue) == (XCPointValueHolder)var2_1) {
            void xcPoint;
            return xcPoint.getAtLeast();
        }
         instanceOfPatternExpressionValue = this.enclosing;
        if ( instanceOfPatternExpressionValue instanceof XCBinValueHolder var3_4) {
            void binHolder;
            return binHolder.getAtLeast();
        }
        DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid bin enclosing: " + this.enclosing.toString() + "for bin " + this.toString() + "!"));
        return 1;
    }

    protected Map<IELParamValue, XCBinValueHolder> intersectWithValues(Set<IELParamValue> values) {
        LinkedHashMap<IELParamValue, XCBinValueHolder> bins = new LinkedHashMap<IELParamValue, XCBinValueHolder>();
        LinkedList<IELParamValue> valuesToRemove = new LinkedList<IELParamValue>();
        for (IELParamValue value : values) {
            if (this.binValues.contains(value)) {
                bins.put(value, this);
                valuesToRemove.add(value);
                return bins;
            }
            DVTNumber dvtNumber = value.getDVTNumber();
            for (Map.Entry<IELParamValue, IELParamValue> binRange : this.binRanges.entrySet()) {
                IELParamValue endValue = binRange.getValue();
                IELParamValue startValue = binRange.getKey();
                if (!DVTNumber.gte(dvtNumber, startValue.getDVTNumber()) || !DVTNumber.gte(endValue.getDVTNumber(), dvtNumber)) continue;
                bins.put(value, this);
                valuesToRemove.add(value);
                return bins;
            }
        }
        values.removeAll(valuesToRemove);
        return bins;
    }

    protected Map<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> intersectWithRanges(Map<IELParamValue, IELParamValue> ranges) {
        LinkedHashMap<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> rangeToBin = new LinkedHashMap<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder>();
        Map<IELParamValue, IELParamValue> remainingRanges = new HashMap<IELParamValue, IELParamValue>();
        if (this.value != null) {
            DVTNumber binValueNumber = this.value.getDVTNumber();
            IELParamValue startRangeToRemove = null;
            for (Map.Entry<IELParamValue, IELParamValue> range : ranges.entrySet()) {
                if (!this.isValueInRange(binValueNumber, range)) continue;
                rangeToBin.put(Map.entry(this.value, this.value), this);
                ArrayList<DVTNumber> arrayList = new ArrayList<DVTNumber>();
                arrayList.add(((ELParamValues.ParamValueNumber)this.value).getDVTNumber());
                remainingRanges = this.computeRaminingRanges(range, arrayList, Collections.emptyMap());
                startRangeToRemove = range.getKey();
                break;
            }
            if (!remainingRanges.isEmpty()) {
                ranges.remove(startRangeToRemove);
                ranges.putAll(remainingRanges);
            }
            return rangeToBin;
        }
        for (Map.Entry<IELParamValue, IELParamValue> range : ranges.entrySet()) {
            LinkedList<DVTNumber> valuesToRemove = new LinkedList<DVTNumber>();
            TreeMap<DVTNumber, DVTNumber> rangeToRemove = new TreeMap<DVTNumber, DVTNumber>(DVTNUMBER_COMPARATOR);
            for (IELParamValue iELParamValue : this.binValues) {
                DVTNumber binValueNumber = iELParamValue.getDVTNumber();
                if (!this.isValueInRange(binValueNumber, range)) continue;
                rangeToBin.put(Map.entry(iELParamValue, iELParamValue), this);
                valuesToRemove.add(((ELParamValues.ParamValueNumber)iELParamValue).getDVTNumber());
            }
            for (Map.Entry entry : this.binRanges.entrySet()) {
                Map.Entry<IELParamValue, IELParamValue> intersectionRange = this.getIntersectionRange(entry, range);
                if (intersectionRange == null) continue;
                rangeToBin.put(intersectionRange, this);
                rangeToRemove.put(((ELParamValues.ParamValueNumber)intersectionRange.getKey()).getDVTNumber(), ((ELParamValues.ParamValueNumber)intersectionRange.getValue()).getDVTNumber());
            }
            remainingRanges.putAll(this.computeRaminingRanges(range, valuesToRemove, rangeToRemove));
        }
        ranges.clear();
        ranges.putAll(remainingRanges);
        return rangeToBin;
    }

    protected static DVTNumber dvtNumberMax(DVTNumber x, DVTNumber y) {
        if (DVTNumber.gt(x, y)) {
            return x;
        }
        return y;
    }

    protected static DVTNumber dvtNumberMin(DVTNumber x, DVTNumber y) {
        if (DVTNumber.gt(x, y)) {
            return y;
        }
        return x;
    }

    protected Map.Entry<IELParamValue, IELParamValue> getIntersectionRange(Map.Entry<IELParamValue, IELParamValue> range1, Map.Entry<IELParamValue, IELParamValue> range2) {
        DVTNumber intersectionEnd;
        IELParamValue startValue = range1.getKey();
        IELParamValue endValue = range1.getValue();
        if (!(startValue instanceof ELParamValues.ParamValueNumber) || !(endValue instanceof ELParamValues.ParamValueNumber)) {
            return null;
        }
        DVTNumber start1 = startValue.getDVTNumber();
        DVTNumber end1 = endValue.getDVTNumber();
        DVTNumber start2 = range2.getKey().getDVTNumber();
        DVTNumber end2 = range2.getValue().getDVTNumber();
        DVTNumber intersectionStart = XCBinValueHolder.dvtNumberMax(start1, start2);
        if (DVTNumber.gt(intersectionStart, intersectionEnd = XCBinValueHolder.dvtNumberMin(end1, end2))) {
            return null;
        }
        IELParamValue intersectionStartValue = startValue.copy();
        ((ELParamValues.ParamValueNumber)intersectionStartValue).setDVTNumber(intersectionStart);
        IELParamValue intersectionEndValue = endValue.copy();
        ((ELParamValues.ParamValueNumber)intersectionEndValue).setDVTNumber(intersectionEnd);
        return Map.entry(intersectionStartValue, intersectionEndValue);
    }

    protected boolean isValueInRange(DVTNumber binValueNumber, Map.Entry<IELParamValue, IELParamValue> range) {
        IELParamValue startValue = range.getKey();
        IELParamValue endValue = range.getValue();
        DVTNumber startNumber = startValue.getDVTNumber();
        DVTNumber endNumber = endValue.getDVTNumber();
        return DVTNumber.gte(binValueNumber, startNumber) && DVTNumber.gte(endNumber, binValueNumber);
    }

    protected Map<IELParamValue, IELParamValue> computeRaminingRanges(Map.Entry<IELParamValue, IELParamValue> range, List<DVTNumber> valuesToRemove, Map<DVTNumber, DVTNumber> rangesToRemove) {
        HashMap<IELParamValue, IELParamValue> resultedFragmentation = new HashMap<IELParamValue, IELParamValue>();
        ELParamValues.ParamValueNumber startValue = (ELParamValues.ParamValueNumber)range.getKey();
        ELParamValues.ParamValueNumber endValue = (ELParamValues.ParamValueNumber)range.getValue();
        DVTNumber startNumber = startValue.getDVTNumber();
        DVTNumber endNumber = endValue.getDVTNumber();
        valuesToRemove.sort(DVTNUMBER_COMPARATOR);
        Iterator valuesIt = Iterators.concat(valuesToRemove.iterator(), Collections.singleton(null).iterator());
        Iterator rangesIt = Iterators.concat(rangesToRemove.keySet().iterator(), Collections.singleton(null).iterator());
        DVTNumber valuesNext = (DVTNumber)valuesIt.next();
        DVTNumber rangesNext = (DVTNumber)rangesIt.next();
        while (valuesNext != null && rangesNext != null && valuesIt.hasNext() && rangesIt.hasNext()) {
            if (DVTNumber.gt(rangesNext, valuesNext)) {
                startNumber = this.removeInterval(resultedFragmentation, startValue, startNumber, valuesNext, valuesNext);
                valuesNext = (DVTNumber)valuesIt.next();
            }
            startNumber = this.removeInterval(resultedFragmentation, startValue, startNumber, rangesNext, rangesToRemove.get(rangesNext));
            rangesNext = (DVTNumber)rangesIt.next();
        }
        while (valuesNext != null && valuesIt.hasNext()) {
            startNumber = this.removeInterval(resultedFragmentation, startValue, startNumber, valuesNext, valuesNext);
            valuesIt.next();
        }
        while (rangesNext != null && rangesIt.hasNext()) {
            startNumber = this.removeInterval(resultedFragmentation, startValue, startNumber, rangesNext, rangesToRemove.get(rangesNext));
            rangesNext = (DVTNumber)rangesIt.next();
        }
        if (DVTNumber.gte(endNumber, startNumber)) {
            ELParamValues.ParamValueNumber startInterval = (ELParamValues.ParamValueNumber)startValue.copy();
            startInterval.setDVTNumber(startNumber);
            resultedFragmentation.put(startInterval, endValue);
        }
        return resultedFragmentation;
    }

    protected DVTNumber removeInterval(Map<IELParamValue, IELParamValue> resultedFragmentation, IELParamValue valueHolder, DVTNumber startNumber, DVTNumber startToRemove, DVTNumber endToRemove) {
        if (DVTNumber.eq(startToRemove, startNumber)) {
            return DVTNumber.plus(endToRemove, XCoverageUtils.ONE);
        }
        ELParamValues.ParamValueNumber startInterval = (ELParamValues.ParamValueNumber)valueHolder.copy();
        ELParamValues.ParamValueNumber endInterval = (ELParamValues.ParamValueNumber)valueHolder.copy();
        startInterval.setDVTNumber(startNumber);
        endInterval.setDVTNumber(DVTNumber.minus(startToRemove, XCoverageUtils.ONE));
        resultedFragmentation.put(startInterval, endInterval);
        return DVTNumber.plus(endToRemove, XCoverageUtils.ONE);
    }

    protected void computeValuesSize() {
        for (Map.Entry<IELParamValue, IELParamValue> entry : this.binRanges.entrySet()) {
            IELParamValue startValue = entry.getKey();
            IELParamValue endValue = entry.getValue();
            DVTNumber startNum = startValue.getDVTNumber();
            DVTNumber endNum = endValue.getDVTNumber();
            this.valuesSize += DVTNumber.minus(endNum, startNum).intValue();
        }
        this.valuesSize += this.binValues.size();
    }

    public static boolean isBinArray(XCBinValueHolder left) {
        return left instanceof XCBinArrayValueHolder || left instanceof XCBinFixedSizeArrayValueHolder && ((XCBinFixedSizeArrayValueHolder)left).isArray();
    }

    /*
     * WARNING - void declaration
     */
    public IELParamValue getLastValue() {
        void var2_1;
        XCPointValueHolder xCPointValueHolder;
        IELParamValue iELParamValue = this.enclosing;
        if (iELParamValue instanceof XCPointValueHolder && (xCPointValueHolder = (XCPointValueHolder)iELParamValue) == (XCPointValueHolder)var2_1) {
            void cPointHolder;
            return cPointHolder.lastValue;
        }
         instanceOfPatternExpressionValue = this.enclosing;
        if ( instanceOfPatternExpressionValue instanceof XCBinValueHolder var3_4) {
            void binHolder;
            return binHolder.getLastValue();
        }
        return null;
    }

    public int getValuesSize() {
        if (this.valuesSize == 0) {
            this.computeValuesSize();
        }
        return this.valuesSize;
    }

    public long getOrderNo() {
        return this.orderNo;
    }

    public void setOrderNo(int orderNo) {
        this.orderNo = orderNo;
    }

    protected String computeToString() {
        return "\n" + this.binRanges.toString() + "\n\n" + this.binValues.toString();
    }

    public String getAddress() {
        return super.toString();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + this.computeToString();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setBinId(int binId) {
        this.setBinUCISId(binId);
    }

    public void isPartOfArray(boolean isPartOfArray) {
        this.isPartOfArray = isPartOfArray;
    }

    public long getHitCount() {
        return this.hitCount;
    }

    public int getBinUCISId() {
        return this.binUCISId;
    }

    public void setBinUCISId(int binUCISId) {
        this.binUCISId = binUCISId;
    }

    @Override
    public IRfNamedElement getNamedElement() {
        XNamedElement xNamedElement = this.getXNamedElement();
        if (xNamedElement != null) {
            return xNamedElement.getNamedElement();
        }
        return null;
    }

    public boolean isIgnoreBin() {
        return this.binType == BIN_TYPE.IGNORE_BIN;
    }

    public void setIgnoreBin() {
        this.binType = BIN_TYPE.IGNORE_BIN;
    }

    public void setIllegalBin() {
        this.binType = BIN_TYPE.ILLEGAL_BIN;
    }

    public boolean isIllegalBin() {
        return this.binType == BIN_TYPE.ILLEGAL_BIN;
    }

    public boolean resolveOverlappingWithIgnoredBins(List<XCBinValueHolder> binsToIntersect) {
        if (this.value != null) {
            this.binValues.add(this.value);
        }
        boolean overlappingIntervals = false;
        for (XCBinValueHolder binHolder : binsToIntersect) {
            if (!binHolder.intersectWithValues(this.binValues).isEmpty()) {
                overlappingIntervals = true;
            }
            if (binHolder.intersectWithRanges(this.binRanges).isEmpty()) continue;
            overlappingIntervals = true;
        }
        if (this.binValues.isEmpty() && this.binRanges.isEmpty()) {
            this.coveredByIgnoreBins = true;
        }
        return overlappingIntervals;
    }

    public int getType() {
        return this.binType.getId();
    }

    public static enum BIN_TYPE {
        SIMPLE_BIN(0),
        FSM_BIN(1),
        CROSS_BIN(2),
        IGNORE_BIN(3),
        ILLEGAL_BIN(4);

        int id;

        private BIN_TYPE(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }

    protected static class InternalArrayElement {
        protected long orderNo;

        public InternalArrayElement(long orderNo) {
            this.orderNo = orderNo;
        }

        public long getOrderNo() {
            return this.orderNo;
        }
    }

    protected static class InternalRangeWrapper
    extends InternalArrayElement
    implements Comparable<InternalRangeWrapper> {
        private DVTNumber startValue;
        private DVTNumber endValue;
        private IELParamValue start;
        private IELParamValue end;
        private long size;
        private int lastElementHit;
        public Map<IELParamValue, XCBinValueHolder> valueToBinHolder;

        public InternalRangeWrapper(IELParamValue start, IELParamValue end, long orderNo) {
            super(orderNo);
            this.start = start;
            this.end = end;
            this.startValue = start.getDVTNumber();
            this.endValue = DVTNumber.plus(end.getDVTNumber(), VlogIntegerNumberFactory.createInteger(BigInteger.ONE));
            this.size = DVTNumber.minus(this.endValue, this.startValue).bigIntegerValue().longValue();
            this.valueToBinHolder = new HashMap<IELParamValue, XCBinValueHolder>();
        }

        public boolean isInRange(IELParamValue value) {
            DVTNumber dvtNumber = value.getDVTNumber();
            return DVTNumber.gte(dvtNumber, this.startValue) && DVTNumber.gt(this.endValue, dvtNumber);
        }

        public void hit(IELParamValue value, XCBinValueHolder parent) {
            XCBinValueHolder binValueHolder = null;
            binValueHolder = this.valueToBinHolder.containsKey(value) ? this.valueToBinHolder.get(value) : this.createBin(value, parent);
            if (parent instanceof XCBinArrayValueHolder var4_5) {
                arrayHolder.setLastInternalBinHit(binValueHolder);
            }
            this.lastElementHit = DVTNumber.minus(value.getDVTNumber(), this.startValue).intValue();
            binValueHolder.hit(value);
        }

        private XCBinValueHolder createBin(IELParamValue value, XCBinValueHolder parent) {
            XCBinValueHolder binValueHolder = new XCBinValueHolder(parent.getFactory(), parent.xAssociatedType, parent, parent.getInstanceScope(), value);
            binValueHolder.setName(String.valueOf(parent.getName()) + "[" + value.intValue() + "]");
            this.valueToBinHolder.put(value, binValueHolder);
            return binValueHolder;
        }

        public Map.Entry<IELParamValue, IELParamValue> getRange() {
            return Map.entry(this.getStartValue(), this.getEndValue());
        }

        @Override
        public long getOrderNo() {
            return this.orderNo + (long)this.lastElementHit;
        }

        public long getOrderNo(IELParamValue value) {
            return this.orderNo + DVTNumber.minus(value.getDVTNumber(), this.startValue).bigIntegerValue().longValue();
        }

        public boolean equals(Object obj) {
            return super.equals(obj);
        }

        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public int compareTo(InternalRangeWrapper o) {
            return DVTNumber.minus(this.startValue, o.startValue).intValue();
        }

        public int getBinsHitNo() {
            int binsHitNo = 0;
            for (XCBinValueHolder binHolder : this.valueToBinHolder.values()) {
                binsHitNo = (int)((long)binsHitNo + binHolder.getBinsNo());
            }
            return binsHitNo;
        }

        public long getSize() {
            return this.size;
        }

        public String toString() {
            return "[" + this.getStartValue() + " , " + this.getEndValue() + "]";
        }

        public DVTNumber getStart() {
            return this.startValue;
        }

        public DVTNumber getEnd() {
            return this.endValue;
        }

        public IELParamValue getStartValue() {
            return this.start;
        }

        public IELParamValue getEndValue() {
            return this.end;
        }

        /*
         * WARNING - void declaration
         */
        public List<XCBinValueHolder> getAllBins(XCBinValueHolder parent) {
            LinkedList<XCBinValueHolder> bins = new LinkedList<XCBinValueHolder>();
            DVTNumber counter = this.startValue.copy();
            while (DVTNumber.gt(this.endValue, counter)) {
                void valueNumber;
                IELParamValue iELParamValue = this.start.copy();
                if (!(iELParamValue instanceof ELParamValues.ParamValueNumber var4_4)) {
                    counter = DVTNumber.plus(counter, VlogBitVector.ONE);
                    continue;
                }
                valueNumber.setDVTNumber(counter.copy());
                bins.add(this.valueToBinHolder.getOrDefault(valueNumber, this.createBin((IELParamValue)valueNumber, parent)));
                counter = DVTNumber.plus(counter, VlogBitVector.ONE);
            }
            return bins;
        }
    }

    protected static class InternalSingleElementWrapper
    extends InternalArrayElement {
        private XCBinValueHolder binHolder;

        public InternalSingleElementWrapper(long orderNo) {
            super(orderNo);
        }

        public void setBinHolder(XCBinValueHolder binHolder) {
            this.binHolder = binHolder;
        }

        public XCBinValueHolder getBinHolder() {
            return this.binHolder;
        }
    }

    protected static class ValuesAndRanges
    implements Comparable<Object> {
        Set<IELParamValue> values;
        Map<IELParamValue, IELParamValue> ranges;
        BigInteger orderKey;
        BigInteger maxValue;

        public ValuesAndRanges() {
            this.values = new HashSet<IELParamValue>();
            this.ranges = new HashMap<IELParamValue, IELParamValue>();
        }

        /*
         * WARNING - void declaration
         */
        public ValuesAndRanges(Set<IELParamValue> values, Map<IELParamValue, IELParamValue> ranges) {
            TreeMap treeMap;
            TreeSet treeSet;
            this.values = values;
            this.ranges = ranges;
            this.orderKey = BigInteger.valueOf(Long.MAX_VALUE);
            if (!values.isEmpty()) {
                this.orderKey = values.iterator().next().bigIntegerValue();
            }
            if (!ranges.isEmpty()) {
                this.orderKey = this.orderKey.min(ranges.entrySet().iterator().next().getKey().bigIntegerValue());
            }
            this.maxValue = this.orderKey;
            Set<IELParamValue> set = values;
            if (!(set instanceof TreeSet) || (treeSet = (TreeSet)set) != (TreeSet)set || !(( instanceOfPatternExpressionValue = ranges) instanceof TreeMap) || (treeMap = (TreeMap) instanceOfPatternExpressionValue) != (TreeMap) instanceOfPatternExpressionValue) {
                return;
            }
            if (!values.isEmpty()) {
                void treeSetValues;
                this.maxValue = ((IELParamValue)treeSetValues.descendingIterator().next()).bigIntegerValue();
            }
            if (!ranges.isEmpty()) {
                void treeMapRanges;
                this.maxValue = this.maxValue.max(((IELParamValue)treeMapRanges.get(treeMapRanges.descendingKeySet().iterator().next())).bigIntegerValue());
            }
        }

        public ValuesAndRanges(BigInteger orderKey) {
            this.orderKey = orderKey;
        }

        public void addValue(IELParamValue value) {
            if (this.getOrderKey() == null) {
                this.orderKey = value.bigIntegerValue();
            }
            this.values.add(value);
            this.maxValue = value.bigIntegerValue();
        }

        public void addRange(IELParamValue start, IELParamValue end) {
            if (this.getOrderKey() == null) {
                this.orderKey = start.bigIntegerValue();
            }
            this.ranges.put(start, end);
            this.maxValue = end.bigIntegerValue();
        }

        @Override
        public int compareTo(Object o) {
            Object object = o;
            if (object instanceof ELParamValues.ParamValueNumber && (var2_3 = (ELParamValues.ParamValueNumber)object) == (ELParamValues.ParamValueNumber)var3_2) {
                return this.getOrderKey().compareTo(valueNumber.bigIntegerValue());
            }
            if (o instanceof ValuesAndRanges var4_5) {
                return this.getOrderKey().compareTo(other.getOrderKey());
            }
            return 0;
        }

        public boolean equals(Object obj) {
            Object object = obj;
            if (object instanceof ELParamValues.ParamValueNumber && (var2_3 = (ELParamValues.ParamValueNumber)object) == (ELParamValues.ParamValueNumber)var3_2) {
                return this.orderKey.equals(valueNumber.bigIntegerValue());
            }
            if (obj instanceof ValuesAndRanges var4_5) {
                return this.orderKey.equals(other.orderKey);
            }
            return false;
        }

        public int hashCode() {
            return this.getOrderKey().hashCode();
        }

        public boolean isEmpty() {
            return this.getOrderKey() == null;
        }

        public BigInteger getOrderKey() {
            return this.orderKey;
        }

        public String toString() {
            return "<<\n" + this.values.toString() + "\n" + this.ranges.toString() + "\n>>";
        }

        public BigInteger getMaxValue() {
            return this.maxValue;
        }
    }
}

