/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.IXSim;
import ro.amiq.dvt.interpreter.XCOption;
import ro.amiq.dvt.interpreter.XCPointCrossValueHolder;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfClassElement;
import ro.amiq.dvt.model.reflection.IRfCovergroup;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfMethodElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.optimized.collections.ArrayListContainer;
import ro.amiq.dvt.ucis.UCISDBWriter;
import ro.amiq.dvt.utils.VlogRealNumber;

public class XCGroupValueHolder
extends XValueHolder {
    private HidEvalCenter.CovergroupStatement cgStatement;
    private boolean isOff;
    private boolean isSampled;
    private int cGroupIdUCIS;
    private int instanceIdUCIS;

    public XCGroupValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, HidEvalCenter.CovergroupStatement cgStatement, boolean isStaticHolder) {
        super(factory, xAssociatedType, enclosing, instanceScope, isStaticHolder, false, false);
        this.cgStatement = cgStatement;
    }

    private void initSampleArguments() {
        IRfCovergroup cgNamedElement = this.cgStatement.getNamedElement();
        IRfMethodElement sampleFunction = cgNamedElement.xGetLocalMethod("sample");
        if (sampleFunction == null) {
            return;
        }
        Collection<? extends IRfNamedElement> xGetLocalMembers = sampleFunction.xGetLocalMembers();
        if (xGetLocalMembers == null) {
            return;
        }
        for (IRfNamedElement iRfNamedElement : xGetLocalMembers) {
            this.createMemberValue(iRfNamedElement);
        }
    }

    private void init() {
        this.initOptions();
        this.initSampleArguments();
        this.initCpMembers();
    }

    private void initOptions() {
        IRfNamedElement optionElement = this.cgStatement.getNamedElement().xGetMember("option");
        if (!(optionElement instanceof IRfTypeAliasElement)) {
            return;
        }
        IRfNamedElement optionAssociatedType = ((IRfTypeAliasElement)optionElement).getAssociatedType();
        XNamedElement optionXAssociatedType = XNamedElement.create(optionAssociatedType, null, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
        XValueHolder optionValueHolder = new XValueHolder(this.factory, optionXAssociatedType, this.enclosing, this.instanceScope, false, false);
        IELParamValue typeOptionValueHolder = this.staticHolder.getValues().getValue("type_option");
        if (typeOptionValueHolder == null) {
            typeOptionValueHolder = new XValueHolder(this.factory, optionXAssociatedType, this.staticHolder, this.instanceScope, false, false);
            for (XCOption xCOption : XCOption.getAllOptionsFor(this.getClass())) {
                ((XValueHolder)typeOptionValueHolder).putValue(xCOption.getName(), xCOption.getDefaultValue());
            }
            this.staticHolder.putValue("type_option", typeOptionValueHolder);
        }
        for (XCOption xCOption : XCOption.getAllOptionsFor(this.getClass())) {
            optionValueHolder.putValue(xCOption.getName(), xCOption.getDefaultValue());
        }
        this.putValue("option", optionValueHolder);
        for (IHidOperator iHidOperator : this.cgStatement.getOptions().values()) {
            ELUtils.evaluate(iHidOperator, this, null, this.getCachedSimGuardian(false));
        }
    }

    private void initCpMembers() {
        List<HidEvalCenter.CoverpointStatement> coverpoints = this.cgStatement.getCoverpoints();
        if (coverpoints == null) {
            return;
        }
        for (HidEvalCenter.CoverpointStatement cpStatement : coverpoints) {
            IRfCoverpoint namedElement = cpStatement.getNamedElement();
            IELParamValue memberValue = this.createValue(namedElement);
            if (!(memberValue instanceof XCPointValueHolder var6_6)) continue;
            cPointValueHolder.setCpStatement(cpStatement);
            cPointValueHolder.init();
            this.putValue(namedElement.getName(), (IELParamValue)cPointValueHolder);
        }
    }

    public List<XCPointValueHolder> getCpoints() {
        if (this.values == null) {
            return Collections.emptyList();
        }
        LinkedList<XCPointValueHolder> cPoints = new LinkedList<XCPointValueHolder>();
        for (IELParamValue value : this.values.getEntries().values()) {
            if (!(value instanceof XCPointValueHolder var4_4)) continue;
            cPoints.add((XCPointValueHolder)cPointHolder);
        }
        return cPoints;
    }

    @Override
    protected ELParamValueScope getMethod(String name, IRfNamedElement element, boolean isSuperAccess, XInstValueHolder instanceScope) {
        IRfNamedElement member = null;
        IELParamValue value = this.values.getValue(name, element);
        member = value instanceof XMethodValueHolder ? ((XMethodValueHolder)value).getNamedElement() : this.xAssociatedType.getNamedElement().xGetMember(name);
        if (member != null) {
            return ELParamValueScope.of(this.factory.createCustomMethodValueHolder(XNamedElement.create(member, this, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), this, instanceScope, false), this);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    public void sample(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
        if (this.isOff) {
            return;
        }
        this.isSampled = true;
        LinkedList<XCPointValueHolder> crossPoints = new LinkedList<XCPointValueHolder>();
        for (XCPointValueHolder xCPointValueHolder : this.getCpoints()) {
            if (xCPointValueHolder instanceof XCPointCrossValueHolder) {
                crossPoints.add(xCPointValueHolder);
                continue;
            }
            xCPointValueHolder.sample(specifiedArgumentValues, guardian);
        }
        for (XCPointValueHolder crossPoint : crossPoints) {
            crossPoint.sample(specifiedArgumentValues, guardian);
        }
    }

    public double getCoverage() {
        double coverage = 0.0;
        double coverPoints = 0.0;
        for (XCPointValueHolder xCPointValueHolder : this.getCpoints()) {
            if (!this.isSampled) continue;
            int cpWeight = xCPointValueHolder.getWeight();
            coverage += xCPointValueHolder.getCoverage() * (double)cpWeight;
            coverPoints += (double)cpWeight;
        }
        return coverage /= coverPoints != 0.0 ? coverPoints : 1.0;
    }

    public int getWeight() {
        return this.getValueDirectly("option").getValueDirectly("weight").intValue();
    }

    private void forkThread() {
        List<IHidOperator> events = this.getCgStatement().getEvents();
        if (events == null || events.isEmpty()) {
            return;
        }
        IHidOperator event = events.get(0);
        if (!event.isVlogEventControl()) {
            return;
        }
        ArrayListContainer<IHidObject> statements = new ArrayListContainer<IHidObject>(2);
        statements.add(event);
        statements.add(this.getCgStatement());
        HidOperator statement = HidEvalCenter.INSTANCE.createStatement(this.element, IHidOperatorConstants.OperatorType.SEQ_BLOCK_STATEMENT.id, -1, -1, -1, false, statements);
        IXSim xSim = this.factory.xSim;
        XThreadDefinition xThreadDefinition = xSim.createThreadDefinition(statement, this.enclosing, this.getParserPath(), "always", XThreadDefinition.ThreadKind.ALWAYS);
        xSim.getXThreadScheduler().forkThread(null, "CoverGroup", xThreadDefinition, true, false, this.instanceScope);
    }

    private void putValues(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        if (specifiedArgumentValues == null) {
            return;
        }
        for (Map.Entry<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> entry : specifiedArgumentValues.entrySet()) {
            IELParamValue paramValue;
            IELParamValue original;
            HidEvalCenter.MethodCallStatement.ArgumentInfo argInfo = entry.getValue();
            this.putValue(entry.getKey(), (original = (paramValue = argInfo.argValueScope.value).getOriginal()) != null ? original : paramValue);
        }
    }

    public XNamedElement getInstance() {
        return this.xAssociatedType.getEnclosing();
    }

    public Deque<XNamedElement> getHierarchyPath() {
        LinkedList<XNamedElement> hierarchy = new LinkedList<XNamedElement>();
        XInstValueHolder instScope = this.instanceScope;
        while (instScope != null) {
            XNamedElement xNamedElement = instScope.getXNamedElement();
            hierarchy.addFirst(xNamedElement);
            instScope = instScope.getParentInstance();
        }
        return hierarchy;
    }

    private void writeCovergroup() {
        UCISDBWriter ucisDBWriter = this.factory.getUcisDBWriter();
        ucisDBWriter.addCoverGroupDef(this);
        ucisDBWriter.addCoverGroupInstance(this);
    }

    @Override
    public IRfNamedElement getNamedElement() {
        XNamedElement xNamedElement = this.getXNamedElement();
        if (xNamedElement != null) {
            return xNamedElement.getNamedElement();
        }
        return null;
    }

    public IELParamValue executePredefinedMethod(IHidOperator hidObject, IHidEvaluator methodValueHolder, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
        if (!this.factory.isCoverage()) {
            return null;
        }
        String methodName = methodValueHolder.getNamedElement().getName();
        if ("new".equals(methodName)) {
            this.putValues(specifiedArgumentValues);
            if (this.staticHolder instanceof XCGroupValueHolder) {
                this.staticHolder.putValue(this.getNamedElement().getName(), this);
            }
            this.init();
            this.forkThread();
            if (this.factory.isUCIS()) {
                this.writeCovergroup();
            }
        } else {
            if ("get_coverage".equals(methodName)) {
                return this.getStaticCoverage();
            }
            if ("get_inst_coverage".equals(methodName)) {
                return ELParamValues.ParamValueNumber.of(VlogRealNumber.create(this.getCoverage()));
            }
            if ("sample".equals(methodName)) {
                this.sample(specifiedArgumentValues, guardian);
            } else if (!"set_inst_name".equals(methodName)) {
                if ("start".equals(methodName)) {
                    this.isOff = false;
                } else if ("stop".equals(methodName)) {
                    this.isOff = true;
                }
            }
        }
        return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
    }

    private IELParamValue getStaticCoverage() {
        ELParamValues cgValues = this.values;
        if (this.staticHolder != null) {
            cgValues = this.staticHolder.getValues();
        }
        double coverage = 0.0;
        double weightsSum = 0.0;
        Collection<IELParamValue> valuesToCheck = cgValues.getEntries().values();
        if (valuesToCheck == null) {
            return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
        }
        for (IELParamValue value : valuesToCheck) {
            if (value instanceof XValueHolder.XShadowHolder) {
                for (IELParamValue childValue : ((XValueHolder.XShadowHolder)value).values) {
                    if (!(childValue instanceof XCGroupValueHolder)) continue;
                    int weigth = ((XCGroupValueHolder)childValue).getWeight();
                    double coverageValue = ((XCGroupValueHolder)childValue).getCoverage();
                    weightsSum += (double)weigth;
                    coverage += (double)weigth * coverageValue;
                }
                continue;
            }
            if (!(value instanceof XCGroupValueHolder)) continue;
            int weigth = ((XCGroupValueHolder)value).getWeight();
            double coverageValue = ((XCGroupValueHolder)value).getCoverage();
            weightsSum += (double)weigth;
            coverage += (double)weigth * coverageValue;
        }
        return ELParamValues.ParamValueNumber.of(VlogRealNumber.create(coverage /= weightsSum != 0.0 ? weightsSum : 1.0));
    }

    public HidEvalCenter.CovergroupStatement getCgStatement() {
        return this.cgStatement;
    }

    public int getcGroupIdUCIS() {
        return this.cGroupIdUCIS;
    }

    public void setcGroupIdUCIS(int cGroupIdUCIS) {
        this.cGroupIdUCIS = cGroupIdUCIS;
    }

    public int getInstanceIdUCIS() {
        return this.instanceIdUCIS;
    }

    public void setInstanceIdUCIS(int instanceIdUCIS) {
        this.instanceIdUCIS = instanceIdUCIS;
    }

    public boolean isInClass() {
        return this.enclosing.getNamedElement() instanceof IRfClassElement;
    }

    public String getCompleteTypeName() {
        return this.xAssociatedType.getQualifiedName(true);
    }

    private String getInstancePathFromUVM() {
        IELParamValue iELParamValue = this.enclosing;
        if (!(iELParamValue instanceof XValueHolder) || (var1_2 = (XValueHolder)iELParamValue) != (XValueHolder)var2_1) {
            return null;
        }
        IELParamValue fullPathValue = enclosingUVMComponent.values.getValue("m_name");
        if (!(fullPathValue instanceof ELParamValues.ParamValueNumber.ParamValueNumber_Element var4_5)) {
            return null;
        }
        return fullPathElement.getDVTNumber().toString().replace(".", "/").replace("\"", "");
    }

    public String getInstanceKnownName() {
        String enclosingString;
        String cGroupName = ELUtils.valueToString(this.getValueDirectly("option").getValueDirectly("name"));
        if (!cGroupName.isEmpty()) {
            cGroupName = "/" + cGroupName;
        }
        if ((enclosingString = this.getInstancePathFromUVM()) != null) {
            return String.valueOf(enclosingString) + "/" + this.getNamedElement().getName() + cGroupName;
        }
        enclosingString = this.instanceScope.getNamedElement().getNameAndEnclosing();
        IRfNamedElement enclosingNamedElement = this.enclosing.getNamedElement();
        if (enclosingNamedElement.xIsClass(false)) {
            enclosingString = String.valueOf(enclosingString) + "/" + enclosingNamedElement.getNameAndEnclosing();
        }
        return String.valueOf(enclosingString) + "/" + this.getNamedElement().getName() + cGroupName;
    }
}

