/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCGroupValueHolder;
import ro.amiq.dvt.interpreter.XCPointCrossValueHolder;
import ro.amiq.dvt.interpreter.XCPointSimpleValueHolder;
import ro.amiq.dvt.utils.VlogBitVector;
import ro.amiq.dvt.utils.VlogIntegerNumberFactory;

public enum XCOption {
    NAME("name", ELParamValues.ParamValueNumber.of(VlogBitVector.stringToValue("")), XCGroupValueHolder.class),
    WEIGHT("weight", ELParamValues.ParamValueNumber.of(VlogIntegerNumberFactory.createInteger(BigInteger.valueOf(1L))), XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    GOAL("goal", "", XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    COMMENT("comment", "", XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    AT_LEAST("at_least", ELParamValues.ParamValueNumber.of(VlogIntegerNumberFactory.createInteger(BigInteger.valueOf(1L))), XCGroupValueHolder.class),
    AUTO_BIN_MAX("auto_bin_max", ELParamValues.ParamValueNumber.of(VlogIntegerNumberFactory.createInteger(BigInteger.valueOf(64L))), XCGroupValueHolder.class),
    CROSS_NUM_PRINT_MISSING("cross_num_print_missing", "", XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    CROSS_RETAIN_AUTO_BINS("cross_retain_auto_bins", "", XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    DETECT_OVERLAP("detect_overlap", "", XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    PER_INSTANCE("per_instance", ELParamValues.ParamValueNumber.of(VlogIntegerNumberFactory.createInteger(BigInteger.valueOf(0L))), XCGroupValueHolder.class),
    GET_INST_COVERAGE("get_inst_coverage", "", XCGroupValueHolder.class, XCPointSimpleValueHolder.class, XCPointCrossValueHolder.class),
    MERGE_INSTANCES("merge_instances", "", XCGroupValueHolder.class),
    STROBE("strobe", "", XCGroupValueHolder.class),
    DISTRIBUTE_FIRST("distribute_first", "", XCGroupValueHolder.class),
    REAL_INTERVAL("real_interval", "", XCGroupValueHolder.class);

    private final String name;
    private final Object defaultValue;
    private final Set<Class<?>> categories;

    private XCOption(String name, Object defaultValue, Class<?> ... categories) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.categories = Set.of(categories);
    }

    public String getName() {
        return this.name;
    }

    public IELParamValue getDefaultValue() {
        if (!(this.defaultValue instanceof IELParamValue)) {
            return ELParamValues.ParamValueNumber.of(VlogBitVector.stringToValue(""));
        }
        return (IELParamValue)this.defaultValue;
    }

    public static List<XCOption> getAllOptionsFor(Class<?> category) {
        return Arrays.stream(XCOption.values()).filter(opt -> opt.categories.contains(category)).collect(Collectors.toList());
    }
}

