/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class XCPointCrossDNF {
    Expression expr;

    public XCPointCrossDNF(Expression expr) {
        this.expr = expr;
    }

    public List<Set<Expression>> toDNF() {
        Expression pushed = this.pushNegations(this.expr);
        Expression distributed = this.distribute(pushed);
        return this.extractTerms(distributed);
    }

    private Expression pushNegations(Expression expr) {
        if (expr instanceof Variable) {
            return expr;
        }
        Expression expression = expr;
        if (expression instanceof Not && (var2_3 = (Not)expression) == (Not)var3_2) {
            Expression inner = notExpr.getExpr();
            if (inner instanceof Not var5_8) {
                return this.pushNegations(innerNot.getExpr());
            }
            if (inner instanceof And var7_11) {
                return new Or(this.pushNegations(new Not(andExpr.getLeft())), this.pushNegations(new Not(andExpr.getRight())));
            }
            if (inner instanceof Or var9_14) {
                return new And(this.pushNegations(new Not(orExpr.getLeft())), this.pushNegations(new Not(orExpr.getRight())));
            }
            return expr;
        }
        if (expr instanceof And inner) {
            return new And(this.pushNegations(andExpr.getLeft()), this.pushNegations(andExpr.getRight()));
        }
         instanceOfPatternExpressionValue = expr;
        if ( instanceOfPatternExpressionValue instanceof Or && ( instanceOfPatternExpressionValue = (Or) instanceOfPatternExpressionValue) == (Or) instanceOfPatternExpressionValue) {
            return new Or(this.pushNegations(orExpr.getLeft()), this.pushNegations(orExpr.getRight()));
        }
        return expr;
    }

    private Expression distribute(Expression expr) {
        if (expr instanceof Variable || expr instanceof Not) {
            return expr;
        }
        Expression expression = expr;
        if (expression instanceof Or && (var2_3 = (Or)expression) == (Or)var3_2) {
            Expression left = this.distribute(orExpr.getLeft());
            Expression right = this.distribute(orExpr.getRight());
            return new Or(left, right);
        }
        if (expr instanceof And left) {
            Expression left = this.distribute(andExpr.getLeft());
            Expression right = this.distribute(andExpr.getRight());
            if (left instanceof Or var8_11) {
                return new Or(this.distribute(new And(leftOr.getLeft(), right)), this.distribute(new And(leftOr.getRight(), right)));
            }
            if (right instanceof Or var10_13) {
                return new Or(this.distribute(new And(left, rightOr.getLeft())), this.distribute(new And(left, rightOr.getRight())));
            }
            return new And(left, right);
        }
        return expr;
    }

    private List<Set<Expression>> extractTerms(Expression expr) {
        ArrayList<Set<Expression>> terms = new ArrayList<Set<Expression>>();
        if (expr instanceof Or var3_4) {
            terms.addAll(this.extractTerms(orExpr.getLeft()));
            terms.addAll(this.extractTerms(orExpr.getRight()));
        } else if (expr instanceof And) {
            terms.add(this.extractLiterals(expr));
        } else if (expr instanceof Variable || expr instanceof Not) {
            HashSet<Expression> singleLiteral = new HashSet<Expression>();
            singleLiteral.add(expr);
            terms.add(singleLiteral);
        }
        return terms;
    }

    private Set<Expression> extractLiterals(Expression expr) {
        HashSet<Expression> literals = new HashSet<Expression>();
        if (expr instanceof Variable || expr instanceof Not) {
            literals.add(expr);
        } else {
            if (expr instanceof And var3_4) {
                literals.addAll(this.extractLiterals(andExpr.getLeft()));
                literals.addAll(this.extractLiterals(andExpr.getRight()));
            }
        }
        return literals;
    }

    static class And
    implements Expression {
        private final Expression left;
        private final Expression right;

        public And(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public String toString() {
            return "(" + this.left.toString() + " && " + this.right.toString() + ")";
        }
    }

    public static interface Expression {
    }

    static class Not
    implements Expression {
        private final Expression expr;

        public Not(Expression expr) {
            this.expr = expr;
        }

        public Expression getExpr() {
            return this.expr;
        }

        public String toString() {
            return "!" + this.expr.toString();
        }
    }

    static class Or
    implements Expression {
        private final Expression left;
        private final Expression right;

        public Or(Expression left, Expression right) {
            this.left = left;
            this.right = right;
        }

        public Expression getLeft() {
            return this.left;
        }

        public Expression getRight() {
            return this.right;
        }

        public String toString() {
            return "(" + this.left.toString() + " || " + this.right.toString() + ")";
        }
    }

    static class Variable<T>
    implements Expression {
        private final T info;

        public Variable(T info) {
            this.info = info;
        }

        public T getInfo() {
            return this.info;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object obj) {
            void other;
            void var3_2;
            Variable variable;
            if (this == obj) {
                return true;
            }
            Object object = obj;
            if (!(object instanceof Variable) || (variable = (Variable)object) != (Variable)var3_2) {
                return false;
            }
            return this.info.equals(other.info);
        }

        public int hashCode() {
            return this.info.hashCode();
        }

        public String toString() {
            return this.info.toString();
        }
    }
}

