/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinCrossDefaultValueHolder;
import ro.amiq.dvt.interpreter.XCBinCrossValueHolder;
import ro.amiq.dvt.interpreter.XCBinFixedSizeArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCGroupValueHolder;
import ro.amiq.dvt.interpreter.XCPointCrossDNF;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfCoverpoint;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;

public class XCPointCrossValueHolder
extends XCPointValueHolder {
    private LinkedHashMap<XCPointValueHolder, Integer> crossItems = new LinkedHashMap();
    private boolean isDefault = true;

    public XCPointCrossValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope);
    }

    public static List<XCBinValueHolder> evaluateBinOperations(XCGroupValueHolder evaluator, XCPointCrossValueHolder crossHolder, IHidOperator expression) {
        IHidObject lhValue = expression.getLHValue();
        IHidObject rhValue = expression.getFirstRHValue();
        if (expression.isBinsof()) {
            return XCPointCrossValueHolder.evaluateBinsof(evaluator, lhValue);
        }
        if (expression.isIntersect()) {
            return XCPointCrossValueHolder.evaluateIntersect(evaluator, crossHolder, lhValue, rhValue);
        }
        if (expression.isLogicalAnd()) {
            return XCPointCrossValueHolder.evaluateLogicalExpression(evaluator, crossHolder, lhValue, rhValue, LogicalExpression.AND);
        }
        if (expression.isLogicalOr()) {
            return XCPointCrossValueHolder.evaluateLogicalExpression(evaluator, crossHolder, lhValue, rhValue, LogicalExpression.OR);
        }
        if (expression.isLogicalNot()) {
            return XCPointCrossValueHolder.evaluateLogicalExpression(evaluator, crossHolder, lhValue, rhValue, LogicalExpression.NOT);
        }
        return Collections.emptyList();
    }

    private static XCPointCrossDNF.Expression evaluateLogicalExpressions(XCGroupValueHolder evaluator, XCPointCrossValueHolder crossHolder, IHidOperator expression) {
        IHidObject lhValue = expression.getLHValue();
        IHidObject rhValue = expression.getFirstRHValue();
        if (expression.isLogicalAnd()) {
            return new XCPointCrossDNF.And(XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)lhValue), XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)rhValue));
        }
        if (expression.isLogicalOr()) {
            return new XCPointCrossDNF.Or(XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)lhValue), XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)rhValue));
        }
        if (expression.isLogicalNot()) {
            return new XCPointCrossDNF.Not(XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)lhValue));
        }
        return new XCPointCrossDNF.Variable<List<XCBinValueHolder>>(XCPointCrossValueHolder.evaluateBinOperations(evaluator, crossHolder, expression));
    }

    private static List<XCBinValueHolder> evaluateLogicalExpression(XCGroupValueHolder evaluator, XCPointCrossValueHolder crossHolder, IHidObject lhValue, IHidObject rhValue, LogicalExpression expressionType) {
        XCPointCrossDNF.Expression expression = null;
        switch (expressionType) {
            case NOT: {
                expression = new XCPointCrossDNF.Not(XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)lhValue));
                break;
            }
            case AND: {
                expression = new XCPointCrossDNF.And(XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)lhValue), XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)rhValue));
                break;
            }
            case OR: {
                expression = new XCPointCrossDNF.Or(XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)lhValue), XCPointCrossValueHolder.evaluateLogicalExpressions(evaluator, crossHolder, (IHidOperator)rhValue));
            }
        }
        XCPointCrossDNF dnf = new XCPointCrossDNF(expression);
        List<Set<XCPointCrossDNF.Expression>> finalExpressionTerms = dnf.toDNF();
        LinkedList<XCBinCrossValueHolder> crossBinsDNF = new LinkedList<XCBinCrossValueHolder>();
        for (Set<XCPointCrossDNF.Expression> term : finalExpressionTerms) {
            crossBinsDNF.add(XCPointCrossValueHolder.evaluateExpressionTerms(crossHolder, term));
        }
        return List.of(XCBinCrossValueHolder.createBinCrossValueHolderFromCrossBins(crossHolder, crossBinsDNF));
    }

    private static XCBinCrossValueHolder evaluateSimpleExpression(XCPointCrossValueHolder crossPointValueHolder, XCPointCrossDNF.Expression expression) {
        XCPointCrossDNF.Expression expression2 = expression;
        if (expression2 instanceof XCPointCrossDNF.Not && (var2_3 = (XCPointCrossDNF.Not)expression2) == (XCPointCrossDNF.Not)var3_2) {
            XCPointCrossDNF.Expression expr = notExpr.getExpr();
            if (!(expr instanceof XCPointCrossDNF.Variable var5_7)) {
                return null;
            }
            XCBinCrossValueHolder crossBinValueHolder = XCPointCrossValueHolder.getCrossBinFromVariable(crossPointValueHolder, (XCPointCrossDNF.Variable<List>)variable);
            if (crossBinValueHolder != null) {
                crossBinValueHolder.logicalNot();
            }
            return crossBinValueHolder;
        }
        if (expression instanceof XCPointCrossDNF.Variable expr) {
            return XCPointCrossValueHolder.getCrossBinFromVariable(crossPointValueHolder, (XCPointCrossDNF.Variable<List>)variable);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static XCBinCrossValueHolder getCrossBinFromVariable(XCPointCrossValueHolder crossPointValueHolder, XCPointCrossDNF.Variable<List> variable) {
        void binsList;
        List list;
        List info = variable.getInfo();
        List list2 = info;
        if (!(list2 instanceof List) || (list = list2) != list2) {
            return null;
        }
        if (!binsList.isEmpty() && !(binsList.get(0) instanceof XCBinCrossValueHolder)) {
            return XCBinCrossValueHolder.createCrossBinHolderFromBins(crossPointValueHolder, (List<XCBinValueHolder>)binsList);
        }
        if (binsList.size() == 1 && binsList.get(0) instanceof XCBinCrossValueHolder) {
            return (XCBinCrossValueHolder)binsList.get(0);
        }
        return null;
    }

    private static XCBinCrossValueHolder evaluateExpressionTerms(XCPointCrossValueHolder crossPointholder, Set<XCPointCrossDNF.Expression> terms) {
        XCBinCrossValueHolder crossPointValueHolder = null;
        for (XCPointCrossDNF.Expression term : terms) {
            if (crossPointValueHolder == null) {
                crossPointValueHolder = XCPointCrossValueHolder.evaluateSimpleExpression(crossPointholder, term);
                continue;
            }
            crossPointValueHolder.intersectCrossBins(XCPointCrossValueHolder.evaluateSimpleExpression(crossPointholder, term));
        }
        return crossPointValueHolder;
    }

    private static List<XCBinValueHolder> evaluateBinsof(XCGroupValueHolder evaluator, IHidObject lhValue) {
        if (lhValue == null) {
            return null;
        }
        ELParamValueScope valueScope = ELUtils.evaluate(lhValue, evaluator, null, evaluator.getCachedSimGuardian(false));
        if (ELUtils.isUnsuccessfulEval(valueScope)) {
            return null;
        }
        IELParamValue value = XUtils.getValue(valueScope);
        if (value instanceof XCPointValueHolder) {
            return ((XCPointValueHolder)value).getAllBinHolders();
        }
        if (value instanceof XCBinFixedSizeArrayValueHolder var4_5) {
            return fixedSizeArrayHolder.getBins();
        }
        if (value instanceof XCBinValueHolder) {
            return List.of((XCBinValueHolder)value);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    private static List<XCBinValueHolder> evaluateIntersect(XCGroupValueHolder evaluator, XCPointCrossValueHolder crossHolder, IHidObject lhValue, IHidObject rhValue) {
        HashSet<IELParamValue> intersectValues = new HashSet<IELParamValue>();
        LinkedHashMap<IELParamValue, IELParamValue> intersectRanges = new LinkedHashMap<IELParamValue, IELParamValue>();
        List<XCBinValueHolder> binsToFilter = XCPointCrossValueHolder.evaluateBinOperations(evaluator, crossHolder, (IHidOperator)lhValue);
        if (rhValue instanceof IHidOperator && ((IHidOperator)rhValue).isComma()) {
            ListContainer<IHidObject> rhValues = ((IHidOperator)rhValue).getRHValues();
            XCPointCrossValueHolder.computeIntersectHids(evaluator, intersectValues, intersectRanges, rhValues);
        } else {
            XCPointCrossValueHolder.computeIntersectHids(evaluator, intersectValues, intersectRanges, List.of(rhValue));
        }
        HashMap<IELParamValue, XCBinValueHolder> valueToBin = new HashMap<IELParamValue, XCBinValueHolder>();
        HashMap<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder> rangeToBin = new HashMap<Map.Entry<IELParamValue, IELParamValue>, XCBinValueHolder>();
        XCPointValueHolder cPointHolder = null;
        int crossItemsIndex = -1;
        for (XCBinValueHolder bin : binsToFilter) {
            Object object;
            void binArrayHolder;
            XCBinFixedSizeArrayValueHolder xCBinFixedSizeArrayValueHolder;
            IELParamValue iELParamValue;
            XCPointValueHolder xCPointValueHolder;
            IELParamValue iELParamValue2;
            if (crossItemsIndex == -1) {
                crossItemsIndex = crossHolder.getOrderNoForBin(bin);
            }
            if (cPointHolder == null && (iELParamValue2 = bin.getEnclosingValue()) instanceof XCPointValueHolder && (xCPointValueHolder = (XCPointValueHolder)iELParamValue2) == (XCPointValueHolder)iELParamValue2) {
                void binEnclosing;
                cPointHolder = binEnclosing;
            }
            if (cPointHolder == null && (iELParamValue = bin.getEnclosingValue()) instanceof XCBinFixedSizeArrayValueHolder && (xCBinFixedSizeArrayValueHolder = (XCBinFixedSizeArrayValueHolder)iELParamValue) == (XCBinFixedSizeArrayValueHolder)iELParamValue && ( instanceOfPatternExpressionValue = binArrayHolder.getEnclosingValue()) instanceof XCPointValueHolder && (object = (XCPointValueHolder) instanceOfPatternExpressionValue) == (XCPointValueHolder) instanceOfPatternExpressionValue) {
                void binEnclosing;
                cPointHolder = binEnclosing;
            }
            rangeToBin.putAll(bin.intersectWithRanges(intersectRanges));
            valueToBin.putAll(bin.intersectWithValues(intersectValues));
        }
        XCBinCrossValueHolder.XCPointFragment binFragments = XCBinCrossValueHolder.computeFragments(rangeToBin, valueToBin, cPointHolder);
        if (binFragments.isEmpty()) {
            return Collections.emptyList();
        }
        int crossItemsNo = crossHolder.getCrossItemsNo();
        ArrayList<XCBinCrossValueHolder.XCPointFragment> binsFragments = new ArrayList<XCBinCrossValueHolder.XCPointFragment>(crossItemsNo);
        if (crossItemsIndex == -1) {
            return Collections.emptyList();
        }
        int i = 0;
        for (XCPointValueHolder cPoint : crossHolder.crossItems.keySet()) {
            if (i == crossItemsIndex) {
                binsFragments.add(i++, binFragments);
                continue;
            }
            binsFragments.add(i++, new XCBinCrossValueHolder.XCPointFragment(true, cPoint, true));
        }
        return List.of(XCBinCrossValueHolder.createBinCrossValueHolderFromFragments(crossHolder, binsFragments));
    }

    private static void computeIntersectHids(XCGroupValueHolder evaluator, Set<IELParamValue> intersectValues, Map<IELParamValue, IELParamValue> intersectRanges, Iterable<IHidObject> rhValues) {
        for (IHidObject hid : rhValues) {
            if (hid instanceof IHidOperator) {
                IHidOperator operator = (IHidOperator)hid;
                if (!operator.isColon()) continue;
                ELParamValueScope startValueScope = ELUtils.evaluate(operator.getLHValue(), evaluator, null, evaluator.getCachedSimGuardian(false));
                ELParamValueScope endValueScope = ELUtils.evaluate(operator.getFirstRHValue(), evaluator, null, evaluator.getCachedSimGuardian(false));
                if (ELUtils.isUnsuccessfulEval(startValueScope) || ELUtils.isUnsuccessfulEval(endValueScope)) continue;
                intersectRanges.put(XUtils.getValue(startValueScope), XUtils.getValue(endValueScope));
                continue;
            }
            ELParamValueScope valueScope = ELUtils.evaluate(hid, evaluator, null, evaluator.getCachedSimGuardian(false));
            if (ELUtils.isUnsuccessfulEval(valueScope)) continue;
            intersectValues.add(XUtils.getValue(valueScope));
        }
    }

    public void initDefaultBins() {
        XCBinCrossDefaultValueHolder defaultBin = XCBinCrossValueHolder.createDefaultBinHolder(this);
        this.values.put(XCBinValueHolder.AUTOMATIC_BIN_NAME, defaultBin);
    }

    @Override
    public void init() {
        this.initCrossItems();
        this.initOptions();
        List<HidEvalCenter.BinAssignmentStatement> bins = this.cpStatement.getBins();
        for (HidEvalCenter.BinAssignmentStatement bin : bins) {
            IHidOperator binAssignment = bin.getBinAssignment();
            XCBinCrossValueHolder crossBinHolder = null;
            List<XCBinValueHolder> resultedBins = XCPointCrossValueHolder.evaluateBinOperations((XCGroupValueHolder)this.enclosing, this, (IHidOperator)binAssignment.getFirstRHValue());
            if (resultedBins == null || resultedBins.isEmpty()) continue;
            crossBinHolder = resultedBins.size() > 1 || !(resultedBins.get(0) instanceof XCBinCrossValueHolder) ? XCBinCrossValueHolder.createCrossBinHolderFromBins(this, resultedBins) : (XCBinCrossValueHolder)resultedBins.get(0);
            crossBinHolder.setName(bin.getName());
            this.values.put(bin.getName(), crossBinHolder);
            this.isDefault = false;
        }
        this.initDefaultBins();
    }

    /*
     * WARNING - void declaration
     */
    private void initCrossItems() {
        IHidObject expression;
        IRfNamedElement namedElement = this.getNamedElement();
        if (!(namedElement instanceof IRfCoverpoint)) {
            return;
        }
        IRfCoverpoint cpElement = (IRfCoverpoint)namedElement;
        this.expression = expression = cpElement.getExpression();
        if (!(expression instanceof IHidOperator)) {
            return;
        }
        IHidOperator expressionOperator = (IHidOperator)expression;
        ListContainer<IHidObject> rhValues = expressionOperator.getRHValues();
        if (rhValues == null || rhValues.size() < 2) {
            return;
        }
        int index = -1;
        for (IHidObject hid : rhValues) {
            void cPointHolder;
            XCPointValueHolder xCPointValueHolder;
            IELParamValue paramValue;
            IELParamValue iELParamValue;
            ++index;
            ELParamValueScope valueScope = ELUtils.evaluate(hid, this.getEnclosingValue(), null, this.getCachedSimGuardian(false));
            if (ELUtils.isUnsuccessfulEval(valueScope) || !((iELParamValue = (paramValue = XUtils.getValue(valueScope))) instanceof XCPointValueHolder) || (xCPointValueHolder = (XCPointValueHolder)iELParamValue) != (XCPointValueHolder)iELParamValue) continue;
            if (cPointHolder.getExpression() == null) {
                cPointHolder.setExpression(hid);
                cPointHolder.setArtificial(true);
            }
            this.crossItems.put((XCPointValueHolder)paramValue, index);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sample(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
        void defaultBin;
        Object currentLastBinHit;
        this.putValues(specifiedArgumentValues);
        ArrayList<XCBinValueHolder> crossedBins = new ArrayList<XCBinValueHolder>();
        for (XCPointValueHolder crossItem : this.crossItems.keySet()) {
            currentLastBinHit = crossItem.getLastBinHit();
            if (currentLastBinHit == null) {
                return;
            }
            crossedBins.add((XCBinValueHolder)currentLastBinHit);
        }
        List<XCBinValueHolder> binHolders = this.getAllBinHolders();
        currentLastBinHit = binHolders.iterator();
        while (currentLastBinHit.hasNext()) {
            void crossHolder;
            XCBinCrossValueHolder xCBinCrossValueHolder;
            XCBinValueHolder binHolder = (XCBinValueHolder)currentLastBinHit.next();
            XCBinValueHolder xCBinValueHolder = binHolder;
            if (!(xCBinValueHolder instanceof XCBinCrossValueHolder) || (xCBinCrossValueHolder = (XCBinCrossValueHolder)xCBinValueHolder) != (XCBinCrossValueHolder)xCBinValueHolder || !crossHolder.checkBinCondition(crossedBins)) continue;
            crossHolder.hit(crossedBins);
            return;
        }
        IELParamValue bin = this.values.getValue(XCBinValueHolder.AUTOMATIC_BIN_NAME);
        IELParamValue iELParamValue = bin;
        if (!(iELParamValue instanceof XCBinCrossDefaultValueHolder) || (currentLastBinHit = (XCBinCrossDefaultValueHolder)iELParamValue) != (XCBinCrossDefaultValueHolder)iELParamValue) {
            return;
        }
        defaultBin.hit(crossedBins);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getCoverage() {
        void defaultCrossBin;
        IELParamValue defaultBin;
        IELParamValue iELParamValue;
        Object object;
        List<HidEvalCenter.BinAssignmentStatement> bins;
        double coverage = 0.0;
        double binsNo = 0.0;
        List<HidEvalCenter.BinAssignmentStatement> list = bins = this.cpStatement != null ? this.cpStatement.getBins() : null;
        if (bins != null && !bins.isEmpty()) {
            object = bins.iterator();
            while (object.hasNext()) {
                HidEvalCenter.BinAssignmentStatement bin = object.next();
                IELParamValue value = this.values.getValue(bin.getName());
                if (!(value instanceof XCBinValueHolder)) continue;
                XCBinValueHolder cBinValueHolder = (XCBinValueHolder)value;
                binsNo += (double)cBinValueHolder.getBinsNo();
                coverage += (double)cBinValueHolder.getBinsHitNo();
            }
        }
        if (!((iELParamValue = (defaultBin = this.values.getValue(XCBinValueHolder.AUTOMATIC_BIN_NAME))) instanceof XCBinCrossDefaultValueHolder) || (object = (XCBinCrossDefaultValueHolder)iELParamValue) != (XCBinCrossDefaultValueHolder)iELParamValue) {
            return 100.0 * (coverage / (binsNo != 0.0 ? binsNo : 1.0));
        }
        coverage += (double)defaultCrossBin.getBinsHitNo();
        coverage = 100.0 * (coverage / ((binsNo += (double)defaultCrossBin.getBinsNo()) != 0.0 ? binsNo : 1.0));
        return coverage;
    }

    public int getCrossItemsNo() {
        return this.crossItems.size();
    }

    public int getOrderNoForBin(XCBinValueHolder bin) {
        IELParamValue enclosingValue = bin.getEnclosingValue();
        if (enclosingValue instanceof XCBinValueHolder var3_4) {
            enclosingValue = binValueHolder.getEnclosingValue();
        }
        if (!(enclosingValue instanceof XCPointValueHolder)) {
            return -1;
        }
        return this.crossItems.getOrDefault(enclosingValue, -1);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public LinkedHashMap<XCPointValueHolder, Integer> getCrossItems() {
        return this.crossItems;
    }

    /*
     * WARNING - void declaration
     */
    public XCBinCrossDefaultValueHolder getAutomaticBinHolder() {
        void var3_2;
        XCBinCrossDefaultValueHolder xCBinCrossDefaultValueHolder;
        IELParamValue value = this.values.getEntries().get(XCBinValueHolder.AUTOMATIC_BIN_NAME);
        IELParamValue iELParamValue = value;
        if (iELParamValue instanceof XCBinCrossDefaultValueHolder && (xCBinCrossDefaultValueHolder = (XCBinCrossDefaultValueHolder)iELParamValue) == (XCBinCrossDefaultValueHolder)var3_2) {
            void crossBin;
            return crossBin;
        }
        return null;
    }

    public List<List<XCBinValueHolder>> getCrossItemsBins() {
        ArrayList<List<XCBinValueHolder>> crossItemsBins = new ArrayList<List<XCBinValueHolder>>();
        for (XCPointValueHolder crossItem : this.crossItems.keySet()) {
            ArrayList<XCBinValueHolder> crossItemBins = new ArrayList<XCBinValueHolder>();
            for (XCBinValueHolder binHolder : crossItem.getBinHolders(false, true)) {
                if (!(binHolder instanceof XCBinArrayValueHolder var7_7)) {
                    crossItemBins.add(binHolder);
                    continue;
                }
                crossItemBins.addAll(binArrayValueHolder.getBins());
            }
            crossItemsBins.add(crossItemBins);
        }
        return crossItemsBins;
    }

    static enum LogicalExpression {
        NOT,
        AND,
        OR;

    }
}

