/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinFixedSizeArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCOption;
import ro.amiq.dvt.interpreter.XCPointValueHolder;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfCoverbin;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XCPointSimpleValueHolder
extends XCPointValueHolder {
    private IELParamValue valueHolderForSize;

    public XCPointSimpleValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope);
    }

    private void initValueHolderForSize() {
        IHidObject expression = this.getExpression();
        ELParamValueScope paramValueScope = ELUtils.evaluateForSize(expression, this.enclosing, null, this.getCachedSimGuardian(false));
        if (ELUtils.isUnsuccessfulEval(paramValueScope)) {
            return;
        }
        this.valueHolderForSize = XUtils.getValue(paramValueScope);
        IELParamValue iELParamValue = this.valueHolderForSize;
        if (!(iELParamValue instanceof ELParamValues.ParamValueNumber var3_4)) {
            return;
        }
        DVTNumber dvtNumber = paramValueNumber.getDVTNumber();
        if (!(dvtNumber instanceof VlogBitVector var6_7)) {
            return;
        }
        vlogBitVector.setNumber(BigInteger.ZERO);
        vlogBitVector = vlogBitVector.createNoMaskEquivalent();
        paramValueNumber.setDVTNumber(vlogBitVector);
    }

    public int getAutoBinMax() {
        IELParamValue optionValueHolder = this.getValueDirectly("option");
        IELParamValue autoBinMaxValue = optionValueHolder.getValueDirectly(XCOption.AUTO_BIN_MAX.getName());
        if (autoBinMaxValue != null) {
            return autoBinMaxValue.intValue();
        }
        IELParamValue cgOptionValueHolder = this.getEnclosingValue().getValueDirectly("option");
        IELParamValue cgAutoBinMaxValue = cgOptionValueHolder.getValueDirectly(XCOption.AUTO_BIN_MAX.getName());
        return cgAutoBinMaxValue.intValue();
    }

    public void initBinHolders() {
        List<HidEvalCenter.BinAssignmentStatement> bins = null;
        HidEvalCenter.BinAssignmentStatement defaultBin = null;
        if (this.cpStatement != null) {
            bins = this.cpStatement.getBins();
            defaultBin = this.cpStatement.getDefaultBin();
        }
        if ((bins == null || bins.isEmpty()) && defaultBin == null) {
            this.initAutomaticBins();
            return;
        }
        if (bins == null) {
            return;
        }
        int orderNo = 0;
        this.onlyIgnoreAndIllegal = true;
        for (HidEvalCenter.BinAssignmentStatement bin : bins) {
            List<IHidObject> binsExpressions;
            IRfCoverbin namedElement = bin.getNamedElement();
            List<XCBinValueHolder> memberValue = this.createBins(namedElement, binsExpressions = bin.getBinsExpressions());
            if (memberValue.size() > 1) {
                this.onlyIgnoreAndIllegal = false;
                XValueHolder.XShadowHolder shadowHolder = new XValueHolder.XShadowHolder(new IELParamValue[0]);
                this.putValue(bin.getName(), shadowHolder);
                for (XCBinValueHolder binHolder : memberValue) {
                    shadowHolder.add(binHolder);
                }
                continue;
            }
            XCBinValueHolder cBinValueHolder = memberValue.get(0);
            cBinValueHolder.setBinExpressions(binsExpressions);
            if (!cBinValueHolder.init() && cBinValueHolder instanceof XCBinFixedSizeArrayValueHolder) {
                cBinValueHolder = new XCBinArrayValueHolder(this.factory, XNamedElement.create(namedElement, this, true, this.getCachedSimGuardian(false).isLinterStaticAnalysisMode()), this, this.instanceScope);
                cBinValueHolder.setBinExpressions(binsExpressions);
                cBinValueHolder.init();
            }
            cBinValueHolder.setOrderNo(orderNo++);
            if (bin.isIgnoreBins()) {
                cBinValueHolder.setIgnoreBin();
                this.ignoreBins.add(cBinValueHolder);
            } else if (bin.isIllegalBins()) {
                cBinValueHolder.setIllegalBin();
                this.illegalBins.add(cBinValueHolder);
            } else {
                this.onlyIgnoreAndIllegal = false;
            }
            this.putValue(bin.getName(), cBinValueHolder);
        }
        if (this.onlyIgnoreAndIllegal) {
            this.initAutomaticBins();
        }
        this.resolveOverlapingWithIgnoreAndIllegal();
    }

    private void resolveOverlapingWithIgnoreAndIllegal() {
        LinkedList<XCBinValueHolder> binsToIntersect = new LinkedList<XCBinValueHolder>();
        binsToIntersect.addAll(this.illegalBins);
        binsToIntersect.addAll(this.ignoreBins);
        List<XCBinValueHolder> binHolders = this.getBinHolders(true, false);
        for (XCBinValueHolder binHolder : binHolders) {
            binHolder.resolveOverlappingWithIgnoredBins(binsToIntersect);
        }
    }

    private void initAutomaticBins() {
        XNamedElement xCpNamedElement = XNamedElement.create(this.getNamedElement(), this, true, this.getCachedSimGuardian(false).isLinterStaticAnalysisMode());
        XCBinValueHolder xcBinArrayValueHolder = new XCBinFixedSizeArrayValueHolder.XCBinAutomaticValueHolder(this.factory, xCpNamedElement, (IELParamValue)this, this.instanceScope, this.getAutoBinMax());
        if (!xcBinArrayValueHolder.init()) {
            xcBinArrayValueHolder = new XCBinArrayValueHolder(this.factory, xCpNamedElement, (IELParamValue)this, this.instanceScope, XCBinValueHolder.AUTOMATIC_BIN_NAME, ((XCBinFixedSizeArrayValueHolder.XCBinAutomaticValueHolder)xcBinArrayValueHolder).getRange());
            xcBinArrayValueHolder.init();
        }
        this.putValue(XCBinValueHolder.AUTOMATIC_BIN_NAME, xcBinArrayValueHolder);
        this.setAutomatic(true);
    }

    @Override
    public void init() {
        this.initOptions();
        this.initBinHolders();
    }

    private boolean checkForIgnoreBins(IELParamValue intValue, List<HidEvalCenter.BinAssignmentStatement> bins) {
        if (bins == null) {
            return false;
        }
        List<HidEvalCenter.BinAssignmentStatement> ignoreBins = bins.stream().filter(bin -> bin.isIgnoreBins()).collect(Collectors.toList());
        return this.updateBins(intValue, ignoreBins);
    }

    private boolean checkForIllegalBins(IELParamValue intValue, List<HidEvalCenter.BinAssignmentStatement> bins) {
        if (bins == null) {
            return false;
        }
        List<HidEvalCenter.BinAssignmentStatement> ignoreBins = bins.stream().filter(bin -> bin.isIllegalBins()).collect(Collectors.toList());
        return this.updateBins(intValue, ignoreBins);
    }

    private boolean updateOrIgnoreBin(XCBinValueHolder binHolder, IELParamValue value) {
        this.lastBinHit = binHolder;
        return this.lastBinHit.hit(value);
    }

    private boolean updateBins(IELParamValue value, List<HidEvalCenter.BinAssignmentStatement> bins) {
        boolean binHit = false;
        for (HidEvalCenter.BinAssignmentStatement bin : bins) {
            List<IHidObject> binsExpressions = bin.getBinsExpressions();
            if (binsExpressions == null) continue;
            IELParamValue binValue = this.values.getEntries().get(bin.getName());
            if (binValue instanceof XValueHolder.XShadowHolder var8_8) {
                for (IELParamValue iELParamValue : shadowHolder.values) {
                     instanceOfPatternExpressionValue = iELParamValue;
                    if (!( instanceOfPatternExpressionValue instanceof XCBinValueHolder) || (var12_14 = (XCBinValueHolder) instanceOfPatternExpressionValue) != (XCBinValueHolder) instanceOfPatternExpressionValue || !binHolder.checkBinExpression(value)) continue;
                    this.updateOrIgnoreBin((XCBinValueHolder)binHolder, value);
                    binHit = true;
                }
                continue;
            }
             instanceOfPatternExpressionValue = binValue;
            if (!( instanceOfPatternExpressionValue instanceof XCBinValueHolder) || (var10_12 = (XCBinValueHolder) instanceOfPatternExpressionValue) != (XCBinValueHolder) instanceOfPatternExpressionValue || !var10_12.checkBinExpression(value)) continue;
            this.updateOrIgnoreBin(var10_12, value);
            binHit = true;
        }
        return binHit;
    }

    @Override
    public void sample(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
        this.putValues(specifiedArgumentValues);
        IHidObject enableExpression = this.cpStatement != null ? this.cpStatement.getEnableExpression() : null;
        this.lastBinHit = null;
        if (enableExpression != null) {
            ELParamValueScope result = ELUtils.evaluate(enableExpression, this, null, guardian);
            if (ELUtils.isUnsuccessfulEval(result)) {
                return;
            }
            IELParamValue enableExpressionValue = XUtils.getValue(result);
            if (enableExpressionValue.intValue() == 0) {
                return;
            }
        }
        if (ELUtils.isUnsuccessfulEval(result = ELUtils.evaluate(expression = this.getExpression(), this, null, guardian))) {
            return;
        }
        IELParamValue value = XUtils.getValue(result);
        List<HidEvalCenter.BinAssignmentStatement> bins = this.cpStatement != null ? this.cpStatement.getBins() : null;
        HidEvalCenter.BinAssignmentStatement defaultBin = this.cpStatement != null ? this.cpStatement.getDefaultBin() : null;
        this.checkForIllegalBins(value, bins);
        if (this.checkForIgnoreBins(value, bins)) {
            return;
        }
        if ((bins == null || bins.isEmpty() || this.onlyIgnoreAndIllegal) && defaultBin == null) {
            IELParamValue bin2 = this.values.getValue(XCBinValueHolder.AUTOMATIC_BIN_NAME);
            if (!(bin2 instanceof XCBinValueHolder var10_11)) {
                return;
            }
            binHolder.hit(value);
            if (binHolder instanceof XCBinArrayValueHolder) {
                this.setLastBinHit((XCBinValueHolder)binHolder);
                this.addLastValue(value);
            }
            return;
        }
        if (bins == null) {
            return;
        }
        if (!this.updateBins(value, bins = bins.stream().filter(bin -> !bin.isIgnoreBins() && !bin.isIllegalBins()).collect(Collectors.toList()))) {
            this.lastBinHit = null;
        }
        this.addLastValue(value);
    }

    public void addLastValue(IELParamValue lastValue) {
        this.lastValue = lastValue.copy();
    }

    @Override
    public double getCoverage() {
        double coverage = 0.0;
        double binsNo = 0.0;
        List<HidEvalCenter.BinAssignmentStatement> list = bins = this.cpStatement != null ? this.cpStatement.getBins() : null;
        if (bins == null || bins.isEmpty() || this.onlyIgnoreAndIllegal) {
            IELParamValue value = this.values.getValue(XCBinValueHolder.AUTOMATIC_BIN_NAME);
            if (value instanceof XCBinValueHolder) {
                XCBinValueHolder cBinValueHolder = (XCBinValueHolder)value;
                binsNo += (double)cBinValueHolder.getBinsNo();
                coverage += (double)cBinValueHolder.getBinsHitNo();
            }
        } else {
            for (HidEvalCenter.BinAssignmentStatement bin : bins) {
                if (bin.isIgnoreBins() || bin.isIllegalBins()) continue;
                IELParamValue value = this.values.getEntries().get(bin.getName());
                if (value instanceof XValueHolder.XShadowHolder var9_9) {
                    for (IELParamValue shadowValue : shadowHolder.values) {
                        if (!(shadowValue instanceof XCBinValueHolder var13_13)) continue;
                        binsNo += (double)binHolder.getBinsNo();
                        coverage += (double)binHolder.getBinsHitNo();
                    }
                    continue;
                }
                if (!(value instanceof XCBinValueHolder)) continue;
                XCBinValueHolder cBinValueHolder = (XCBinValueHolder)value;
                binsNo += (double)cBinValueHolder.getBinsNo();
                coverage += (double)cBinValueHolder.getBinsHitNo();
            }
        }
        coverage = 100.0 * (coverage / (binsNo != 0.0 ? binsNo : 1.0));
        return coverage;
    }

    @Override
    public IELParamValue getValueHolderForSize() {
        if (this.valueHolderForSize == null) {
            this.initValueHolderForSize();
        }
        return this.valueHolderForSize;
    }

    @Override
    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return this.expression != null ? this.expression.equals(obj) : super.equals(obj);
    }

    public void setLastBinHit(XCBinValueHolder bin) {
        this.lastBinHit = bin;
    }

    public void setLastValue(IELParamValue value) {
        this.lastValue = value;
    }
}

