/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XCBinArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinCrossDefaultValueHolder;
import ro.amiq.dvt.interpreter.XCBinFSMValueHolder;
import ro.amiq.dvt.interpreter.XCBinFixedSizeArrayValueHolder;
import ro.amiq.dvt.interpreter.XCBinValueHolder;
import ro.amiq.dvt.interpreter.XCOption;
import ro.amiq.dvt.interpreter.XCoverageUtils;
import ro.amiq.dvt.interpreter.XFSMTransition;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XMethodValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfCoverbin;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.IRfTypeAliasElement;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperatorConstants;
import ro.amiq.dvt.utils.VlogRealNumber;

public abstract class XCPointValueHolder
extends XValueHolder {
    protected IELParamValue lastValue;
    protected XCBinValueHolder lastBinHit;
    protected List<XCBinValueHolder> illegalBins = new LinkedList<XCBinValueHolder>();
    protected List<XCBinValueHolder> ignoreBins = new LinkedList<XCBinValueHolder>();
    protected HidEvalCenter.CoverpointStatement cpStatement;
    protected IHidObject expression;
    protected boolean onlyIgnoreAndIllegal;
    private int coverPointUCISId;
    protected boolean isArtificial;
    private boolean isAutomatic;

    protected XCPointValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope) {
        super(factory, xAssociatedType, enclosing, instanceScope, false, false, false);
    }

    @Override
    protected ELParamValueScope getMethod(String name, IRfNamedElement element, boolean isSuperAccess, XInstValueHolder instanceScope) {
        IRfNamedElement member = null;
        IELParamValue value = this.values.getValue(name, element);
        member = value instanceof XMethodValueHolder ? ((XMethodValueHolder)value).getNamedElement() : this.xAssociatedType.getNamedElement().xGetMember(name);
        if (member != null) {
            return ELParamValueScope.of(this.factory.createCustomMethodValueHolder(XNamedElement.create(member, this, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode()), this, instanceScope, false), this);
        }
        return ELParamValueScope.UNDEFINED_VALUE;
    }

    protected void initOptions() {
        if (this.cpStatement == null) {
            return;
        }
        IRfNamedElement optionElement = this.cpStatement.getNamedElement().xGetMember("option");
        if (!(optionElement instanceof IRfTypeAliasElement)) {
            return;
        }
        XValueHolder optionValueHolder = (XValueHolder)this.factory.createValueHolder(optionElement, (IELParamValue)this, this.instanceScope);
        for (XCOption xCOption : XCOption.getAllOptionsFor(this.getClass())) {
            IELParamValue defaultValue = xCOption.getDefaultValue();
            if (defaultValue != null) {
                defaultValue = defaultValue.copy();
            }
            optionValueHolder.putValue(xCOption.getName(), defaultValue);
        }
        this.putValue("option", optionValueHolder);
        for (IHidOperator iHidOperator : this.cpStatement.getOptions().values()) {
            ELUtils.evaluate(iHidOperator, this, null, this.getCachedSimGuardian(false));
        }
    }

    public List<XCBinValueHolder> getBinHolders(boolean compactBins, boolean includeIgnoreBins) {
        LinkedList<XCBinValueHolder> binHolders = new LinkedList<XCBinValueHolder>();
        if (this.cpStatement != null) {
            for (HidEvalCenter.BinAssignmentStatement binAssignmentStatement : this.cpStatement.getBins()) {
                IELParamValue value = this.values.getEntries().get(binAssignmentStatement.getName());
                if (value instanceof XValueHolder.XShadowHolder var7_8) {
                    for (IELParamValue iELParamValue : shadowHolder.values) {
                        if (!(iELParamValue instanceof XCBinValueHolder var11_14)) continue;
                        binHolders.add(binHolder);
                    }
                    continue;
                }
                 instanceOfPatternExpressionValue = value;
                if (!( instanceOfPatternExpressionValue instanceof XCBinValueHolder) || (var9_12 = (XCBinValueHolder) instanceOfPatternExpressionValue) != (XCBinValueHolder) instanceOfPatternExpressionValue || (var9_12.isIgnoreBin() || var9_12.isIllegalBin()) && !includeIgnoreBins) continue;
                 instanceOfPatternExpressionValue = value;
                if ( instanceOfPatternExpressionValue instanceof XCBinFixedSizeArrayValueHolder && (binHolder = (XCBinFixedSizeArrayValueHolder) instanceOfPatternExpressionValue) == (XCBinFixedSizeArrayValueHolder) instanceOfPatternExpressionValue) {
                    binHolders.addAll(fixedSizeHolder.getBins());
                    continue;
                }
                binHolders.add(var9_12);
            }
        }
        if (!this.values.containsKey(XCBinValueHolder.AUTOMATIC_BIN_NAME)) {
            return binHolders;
        }
        IELParamValue iELParamValue = this.values.getValue(XCBinValueHolder.AUTOMATIC_BIN_NAME);
        if (!(iELParamValue instanceof XCBinValueHolder) || (var4_6 = (XCBinValueHolder)iELParamValue) != (XCBinValueHolder)iELParamValue) {
            return binHolders;
        }
        if (var4_6 instanceof XCBinFixedSizeArrayValueHolder) {
            if (!compactBins) {
                binHolders.addAll(((XCBinFixedSizeArrayValueHolder)var4_6).getBins());
            } else {
                binHolders.add(var4_6);
            }
        }
        if (var4_6 instanceof XCBinArrayValueHolder) {
            binHolders.add(var4_6);
        }
        return binHolders;
    }

    public List<XCBinValueHolder> getAllBinHolders() {
        return this.getBinHolders(false, false);
    }

    protected void putValues(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues) {
        if (specifiedArgumentValues == null) {
            return;
        }
        for (Map.Entry<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> entry : specifiedArgumentValues.entrySet()) {
            HidEvalCenter.MethodCallStatement.ArgumentInfo argInfo = entry.getValue();
            IELParamValue paramValue = argInfo.argValueScope.value;
            String name = entry.getKey();
            if (this.values.containsKey(name)) {
                this.values.removeDirectly(name);
            }
            this.putValue(name, paramValue);
        }
    }

    public boolean isBinFSM(IRfCoverbin binElement) {
        List<IHidObject> binExpressions = binElement.getBinExpressions();
        for (IHidObject binExpression : binExpressions) {
            if (!(binExpression instanceof IHidOperator var5_5)) continue;
            if (expressionOperator.isImply()) {
                return true;
            }
            if (IHidOperatorConstants.OperatorType.TRANS_REPETITION.id != expressionOperator.getOperatorType()) continue;
            return true;
        }
        return false;
    }

    protected List<XCBinValueHolder> createBins(IRfNamedElement namedElement, List<IHidObject> binExpressions) {
        if (!(namedElement instanceof IRfCoverbin var3_4)) {
            return null;
        }
        XNamedElement xAssociatedType = XNamedElement.create(namedElement, this.enclosing, true, this.factory.getEvaluationGuardian(false).isLinterStaticAnalysisMode());
        if (coverBin.getKind() == 0 && coverBin.isArray()) {
            if (this.isBinFSM((IRfCoverbin)coverBin)) {
                LinkedList<XCBinValueHolder> bins = new LinkedList<XCBinValueHolder>();
                List<XFSMTransition> fsmTransitions = XCoverageUtils.INSTANCE.extractTransitions(binExpressions, this, this.getCachedSimGuardian(false));
                for (XFSMTransition fsmTransition : fsmTransitions) {
                    List<XFSMTransition> uniqueTransitions = fsmTransition.splitTransition();
                    for (XFSMTransition uniqueTransition : uniqueTransitions) {
                        XCBinFSMValueHolder bin = new XCBinFSMValueHolder(this.factory, xAssociatedType, (IELParamValue)this, this.instanceScope, List.of(uniqueTransition));
                        bin.setName(String.valueOf(namedElement.getName()) + "[" + uniqueTransition.toString() + "]");
                        bins.add(bin);
                    }
                }
                return bins;
            }
            if (coverBin.isOpen()) {
                return List.of(new XCBinArrayValueHolder(this.factory, xAssociatedType, this, this.instanceScope));
            }
            return List.of(new XCBinFixedSizeArrayValueHolder(this.factory, xAssociatedType, (IELParamValue)this, this.instanceScope, coverBin.getArraySize(this, this.instanceScope.getInstancePath())));
        }
        if (this.isBinFSM((IRfCoverbin)coverBin)) {
            return List.of(new XCBinFSMValueHolder(this.factory, xAssociatedType, (IELParamValue)this, this.instanceScope, XCoverageUtils.INSTANCE.extractTransitions(binExpressions, this, this.getCachedSimGuardian(false))));
        }
        return List.of(new XCBinValueHolder(this.factory, xAssociatedType, this, this.instanceScope));
    }

    public int getWeight() {
        return this.getValueDirectly("option").getValueDirectly("weight").intValue();
    }

    public IELParamValue executePredefinedMethod(IHidOperator hidObject, IHidEvaluator methodValueHolder, IHidEvaluator argumentsEvaluator, Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> specifiedArgumentValues, IHidEvaluationGuardian guardian) {
        if (!this.factory.isCoverage()) {
            return null;
        }
        String methodName = methodValueHolder.getNamedElement().getName();
        if (!"get_coverage".equals(methodName)) {
            if ("get_inst_coverage".equals(methodName)) {
                return ELParamValues.ParamValueNumber.of(VlogRealNumber.create(this.getCoverage()));
            }
            if ("sample".equals(methodName)) {
                this.sample(specifiedArgumentValues, guardian);
            } else if (!"start".equals(methodName)) {
                "stop".equals(methodName);
            }
        }
        return ELParamValues.ParamValueNumber.IMPLICIT_RESULT;
    }

    public void setCpStatement(HidEvalCenter.CoverpointStatement cpStatement) {
        this.cpStatement = cpStatement;
    }

    public XCBinValueHolder getLastBinHit() {
        return this.lastBinHit;
    }

    public IELParamValue getLastValue() {
        return this.lastValue;
    }

    public IELParamValue getValueHolderForSize() {
        return null;
    }

    public String getName() {
        return this.cpStatement.getLabel();
    }

    public IHidObject getExpression() {
        return this.expression != null ? this.expression : this.cpStatement.getExpression();
    }

    public String getExpressionText() {
        return this.getExpression().toString();
    }

    public int getCoverPointUCISId() {
        return this.coverPointUCISId;
    }

    public void setCoverPointUCISId(int coverPointUCISId) {
        this.coverPointUCISId = coverPointUCISId;
    }

    public void setExpression(IHidObject expression) {
        this.expression = expression;
    }

    public boolean isArtificial() {
        return this.isArtificial;
    }

    protected void setArtificial(boolean isArtificial) {
        this.isArtificial = isArtificial;
    }

    public boolean isAutomatic() {
        return this.isAutomatic;
    }

    public void setAutomatic(boolean isAutomatic) {
        this.isAutomatic = isAutomatic;
    }

    @Override
    public IRfNamedElement getNamedElement() {
        XNamedElement xNamedElement = this.getXNamedElement();
        if (xNamedElement != null) {
            return xNamedElement.getNamedElement();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Integer> getAutomaticBins() {
        void crossDefault;
        void var2_1;
        XCBinCrossDefaultValueHolder xCBinCrossDefaultValueHolder;
        IELParamValue iELParamValue = this.values.getValue(XCBinValueHolder.AUTOMATIC_BIN_NAME);
        if (!(iELParamValue instanceof XCBinCrossDefaultValueHolder) || (xCBinCrossDefaultValueHolder = (XCBinCrossDefaultValueHolder)iELParamValue) != (XCBinCrossDefaultValueHolder)var2_1) {
            return null;
        }
        return crossDefault.getCoveredBins();
    }

    public int getAtLeast() {
        IELParamValue optionValueHolder = this.getValueDirectly("option");
        IELParamValue atLeastValue = optionValueHolder.getValueDirectly(XCOption.AT_LEAST.getName());
        if (atLeastValue != null) {
            return atLeastValue.intValue();
        }
        IELParamValue cgOptionValueHolder = this.getEnclosingValue().getValueDirectly("option");
        IELParamValue cgAtLeastValue = cgOptionValueHolder.getValueDirectly(XCOption.AT_LEAST.getName());
        return cgAtLeastValue.intValue();
    }

    public abstract void init();

    public abstract void sample(Map<String, HidEvalCenter.MethodCallStatement.ArgumentInfo> var1, IHidEvaluationGuardian var2);

    public abstract double getCoverage();
}

