/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import java.util.BitSet;
import java.util.List;
import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XConditionalEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfActionBlockElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.NotNull;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicit;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.utils.BitSetUtils;
import ro.amiq.dvt.utils.BitVectorContext;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.MaskType;
import ro.amiq.dvt.utils.VlogBitVector;

public class XCaseEvalScope
extends XConditionalEvalScope {
    private ELParamValueScope cacheConditionValue;
    private List<IHidObject> caseItems;
    private int caseItemIndex;
    private IRfActionBlockElement.BlockQualifier caseBlockQualifier;
    private boolean isVLOG;
    private boolean hasExecuted;
    private boolean hasUnknownItemCondition;

    public XCaseEvalScope(IRfNamedElement namedElement, IHidOperator parentOperator, IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, IHidObject condition, List<IHidObject> caseItems, IRfActionBlockElement.BlockQualifier caseBlockQualifier, boolean isVLOG) {
        super(namedElement, parentOperator, evaluator, bvContext, guardian, condition);
        this.caseItems = caseItems;
        this.caseBlockQualifier = caseBlockQualifier;
        this.isVLOG = isVLOG;
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        if (this.guardian.isLinterStaticAnalysisMode()) {
            return this.getLinterStaticAnalysisNextStatement();
        }
        if (this.hasExecuted) {
            return null;
        }
        this.hasExecuted = true;
        return this.isVLOG ? this.getVLOGNextStatement() : this.getVHDLNextStatement();
    }

    /*
     * Unable to fully structure code
     */
    private IHidObject getLinterStaticAnalysisNextStatement() {
        guardian = this.guardian.copy();
        if (this.cacheConditionValue != null) ** GOTO lbl53
        this.cacheConditionValue = ELUtils.evaluate(this.condition, this.evaluator, this.bvContext, guardian);
        if (!ELUtils.isUnsuccessfulEval(this.cacheConditionValue)) ** GOTO lbl53
        throw new UnknownHidObjectEvaluationException(this.condition);
lbl-1000:
        // 1 sources

        {
            if (!HidUtils.isOperator(caseItem = this.caseItems.get(this.caseItemIndex++))) {
                throw new UnknownHidObjectEvaluationException(caseItem);
            }
            itemCondition = ((IHidOperator)caseItem).getLHValue();
            xThread = guardian.getActiveThread();
            try {
                guardian.callbackStartStatement(xThread, XUtils.toOperator(itemCondition));
                conditionValue = XUtils.getValue(this.cacheConditionValue);
                caseItemNamedElement = caseItem instanceof HidEvalCenter.BlockStatement != false ? ((HidEvalCenter.BlockStatement)caseItem).getNamedElement() : null;
                result = null;
                if (HidUtils.isHidImplicit(itemCondition) && ((IHidImplicit)itemCondition).isOthers()) {
                    this.hasUnknownItemCondition |= conditionValue.isUnknown();
                    this.hasExecuted = this.hasUnknownItemCondition == false;
                    result = this.hasUnknownItemCondition != false ? VlogBitVector.BIT_UNKNOWN : VlogBitVector.BIT_ONE;
                    guardian.guardControlFlowConditionTested(caseItemNamedElement, this.condition, this.evaluator, result, -1);
                    var18_17 = caseItem;
                    return var18_17;
                }
                itemValue = XUtils.getValue(ELUtils.evaluate(itemCondition, this.evaluator, this.bvContext, guardian));
                if (ELUtils.isUnsuccessfulEval(itemValue)) {
                    throw new UnknownHidObjectEvaluationException(itemCondition);
                }
                conditionNumber = conditionValue.getDVTNumber();
                itemNumber = itemValue.getDVTNumber();
                if (conditionNumber.isUnknown() || itemNumber.isUnknown()) {
                    result = DVTNumber.vlogEq(conditionNumber, itemNumber);
                } else {
                    isCaseX = this.caseBlockQualifier == IRfActionBlockElement.BlockQualifier.CASEX;
                    v0 = isCaseZ = this.caseBlockQualifier == IRfActionBlockElement.BlockQualifier.CASEZ;
                    if ((isCaseZ || isCaseX) && conditionNumber instanceof VlogBitVector && itemNumber instanceof VlogBitVector) {
                        leftNumber = (VlogBitVector)conditionNumber;
                        rightNumber = (VlogBitVector)itemNumber;
                        dontCareMask = this.oredMask(leftNumber.getMask(MaskType.Z), rightNumber.getMask(MaskType.Z));
                        if (isCaseX) {
                            dontCareMask = this.oredMask(this.oredMask(leftNumber.getMask(MaskType.X), rightNumber.getMask(MaskType.X)), dontCareMask);
                        }
                        if (!dontCareMask.isEmpty()) {
                            careMask = BitSetUtils.toBigInteger(dontCareMask).not();
                            conditionNumber = leftNumber.and(VlogBitVector.create(false, leftNumber.getSize() - 1, 0, careMask), leftNumber.getSize());
                            itemNumber = rightNumber.and(VlogBitVector.create(false, rightNumber.getSize() - 1, 0, careMask), rightNumber.getSize());
                        }
                    }
                    v1 = result = DVTNumber.eq(conditionNumber, itemNumber) != false ? VlogBitVector.BIT_ONE : VlogBitVector.BIT_ZERO;
                }
                if (result != VlogBitVector.BIT_ZERO) {
                    this.hasUnknownItemCondition |= guardian.guardControlFlowConditionTested(caseItemNamedElement, this.condition, this.evaluator, result, -1);
                    this.hasExecuted = this.hasUnknownItemCondition == false;
                    var18_18 = caseItem;
                    return var18_18;
                }
                continue;
            }
            finally {
                guardian.callbackEndStatement(xThread, itemCondition);
            }
lbl53:
            // 3 sources

            ** while (!this.hasExecuted && this.caseItemIndex < this.caseItems.size())
        }
lbl54:
        // 1 sources

        guardian.guardControlFlowConditionTested(this.hasExecuted == false && this.hasUnknownItemCondition == false ? this.namedElement : null, this.condition, this.evaluator, VlogBitVector.BIT_ZERO, -1);
        this.hasExecuted = true;
        return null;
    }

    private IHidObject getVLOGNextStatement() {
        IHidEvaluationGuardian localGuardian = this.guardian.copy();
        XThread xThread = this.guardian.getActiveThread();
        if (this.cacheConditionValue == null) {
            try {
                this.guardian.callbackStartStatement(xThread, XUtils.toOperator(this.condition));
                this.cacheConditionValue = ELUtils.evaluate(this.condition, this.evaluator, this.bvContext, localGuardian);
            }
            finally {
                this.guardian.callbackEndStatement(xThread, this.condition);
            }
        }
        if (ELUtils.isUnsuccessfulEval(this.cacheConditionValue)) {
            throw new UnknownHidObjectEvaluationException(this.condition);
        }
        boolean isCaseX = this.caseBlockQualifier == IRfActionBlockElement.BlockQualifier.CASEX;
        boolean isCaseZ = this.caseBlockQualifier == IRfActionBlockElement.BlockQualifier.CASEZ;
        for (IHidObject caseItem : this.caseItems) {
            if (!HidUtils.isOperator(caseItem)) {
                throw new UnknownHidObjectEvaluationException(caseItem);
            }
            DVTNumber caseNumber = this.cacheConditionValue.getDVTNumber();
            IHidObject itemCondition = ((IHidOperator)caseItem).getLHValue();
            try {
                this.guardian.callbackStartStatement(xThread, XUtils.toOperator(itemCondition));
                if (HidUtils.isHidImplicit(itemCondition) && ((IHidImplicit)itemCondition).isOthers()) {
                    IHidObject iHidObject = caseItem;
                    return iHidObject;
                }
                if (HidUtils.isOperator(itemCondition) && (((IHidOperator)itemCondition).isRangeOrPartSelect() || ((IHidOperator)itemCondition).isInsideSet())) {
                    HidOperator insideItemCondition = this.guardian.getFactory().createInsideOperator(this.condition, itemCondition);
                    ELParamValueScope itemValue = ELUtils.evaluate(insideItemCondition, this.evaluator, this.bvContext, localGuardian);
                    if (ELUtils.isUnsuccessfulEval(itemValue)) {
                        throw new UnknownHidObjectEvaluationException(itemCondition);
                    }
                    if (ELUtils.isFalse(itemValue.value)) continue;
                    IHidObject iHidObject = ((IHidOperator)caseItem).getFirstRHValue();
                    return iHidObject;
                }
                ELParamValueScope itemValue = ELUtils.evaluate(itemCondition, this.evaluator, this.bvContext, localGuardian);
                if (ELUtils.isUnsuccessfulEval(itemValue)) {
                    throw new UnknownHidObjectEvaluationException(itemCondition);
                }
                DVTNumber itemNumber = itemValue.getDVTNumber();
                if ((isCaseZ || isCaseX) && caseNumber instanceof VlogBitVector && itemNumber instanceof VlogBitVector) {
                    VlogBitVector leftNumber = (VlogBitVector)caseNumber;
                    VlogBitVector rightNumber = (VlogBitVector)itemNumber;
                    BitSet dontCareMask = this.oredMask(leftNumber.getMask(MaskType.Z), rightNumber.getMask(MaskType.Z));
                    if (isCaseX) {
                        dontCareMask = this.oredMask(this.oredMask(leftNumber.getMask(MaskType.X), rightNumber.getMask(MaskType.X)), dontCareMask);
                    }
                    if (!dontCareMask.isEmpty()) {
                        BigInteger careMask = BitSetUtils.toBigInteger(dontCareMask).not();
                        caseNumber = leftNumber.and(VlogBitVector.create(false, leftNumber.getSize() - 1, 0, careMask), leftNumber.getSize());
                        itemNumber = rightNumber.and(VlogBitVector.create(false, rightNumber.getSize() - 1, 0, careMask), rightNumber.getSize());
                    }
                }
                if (!DVTNumber.eq(caseNumber, itemNumber)) continue;
                IHidObject iHidObject = ((IHidOperator)caseItem).getFirstRHValue();
                return iHidObject;
            }
            finally {
                this.guardian.callbackEndStatement(xThread, itemCondition);
            }
        }
        return null;
    }

    private IHidObject getVHDLNextStatement() {
        for (IHidObject caseItem : this.caseItems) {
            if (!HidUtils.isOperator(caseItem)) {
                throw new UnknownHidObjectEvaluationException(caseItem);
            }
            IHidObject itemCondition = ((IHidOperator)caseItem).getLHValue();
            if (HidUtils.isHidImplicit(itemCondition) && ((IHidImplicit)itemCondition).isOthers()) {
                return ((IHidOperator)caseItem).getFirstRHValue();
            }
            if (!HidEvalCenter.testCondition(itemCondition, this.evaluator, this.bvContext, this.guardian.copy())) continue;
            return caseItem;
        }
        return null;
    }

    @NotNull
    private BitSet oredMask(BitSet mask1, BitSet mask2) {
        if (mask1 == null && mask2 == null) {
            return BitSetUtils.valueOf(0);
        }
        if (mask1 == null) {
            return (BitSet)mask2.clone();
        }
        if (mask2 == null) {
            return (BitSet)mask1.clone();
        }
        if (mask1.isEmpty() && mask2.isEmpty()) {
            return BitSetUtils.valueOf(0);
        }
        mask1 = (BitSet)mask1.clone();
        mask1.or(mask2);
        return mask1;
    }

    @Override
    protected boolean isLoopEvalScope() {
        return false;
    }

    public void hotSwap(IHidObject condition, List<IHidObject> caseItems, IRfActionBlockElement.BlockQualifier caseBlockQualifier, boolean isVLOG) {
        this.condition = condition;
        this.cacheConditionValue = null;
        this.caseItems = caseItems;
        this.caseBlockQualifier = caseBlockQualifier;
        this.isVLOG = isVLOG;
    }
}

