/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import org.msgpack.core.MessagePacker;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XNamedElement;
import ro.amiq.dvt.interpreter.XValueHolder;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.utils.DVTNumber;
import ro.amiq.dvt.utils.VlogBitVector;

public class XChandleValueHolder
extends XValueHolder {
    private long[] chandleAddress;

    public XChandleValueHolder(XValueHolderFactory factory, XNamedElement xAssociatedType, IELParamValue enclosing, XInstValueHolder instanceScope, boolean isStaticHolder, long chandleAddress) {
        super(factory, xAssociatedType, enclosing, instanceScope, isStaticHolder, chandleAddress == 0L);
        this.chandleAddress = new long[]{chandleAddress};
    }

    @Override
    protected boolean updateValue(IELParamValue newResult, boolean keepRef) {
        boolean isModified = super.updateValue(newResult, keepRef);
        if (newResult instanceof XChandleValueHolder) {
            isModified |= this.chandleAddress[0] != ((XChandleValueHolder)newResult).chandleAddress[0];
            this.chandleAddress = ((XChandleValueHolder)newResult).chandleAddress;
        }
        return isModified;
    }

    public long getChandle() {
        if (this.chandleAddress[0] == 0L && this.refValueHolder instanceof XChandleValueHolder) {
            return ((XChandleValueHolder)this.refValueHolder).getChandle();
        }
        return this.chandleAddress[0];
    }

    @Override
    public void xSystemCPackValue(IRfNamedElement typeElement, int options, MessagePacker buffer, boolean preSpecifyMaker) throws Exception {
        buffer.packLong(this.getChandle());
    }

    @Override
    public DVTNumber getDVTNumber() {
        if (this.isNull()) {
            return VlogBitVector.ZERO;
        }
        return VlogBitVector.create(true, 63, 0, BigInteger.valueOf(this.chandleAddress[0]));
    }
}

