/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.math.BigInteger;
import ro.amiq.dvt.elaboration.model.ELParamValues;
import ro.amiq.dvt.elaboration.model.IELParamValue;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidImplicitConstants;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.optimized.collections.ListContainer;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
import ro.amiq.dvt.utils.VlogBitVector;

public class XComputedSelect
implements ListContainer<XComputedSelect> {
    private IHidObject selectObject;
    public IELParamValue[] computedValues;
    public boolean isPlusIndexPartSelect;
    public boolean isMinusIndexPartSelect;

    public XComputedSelect(IHidObject selectObject) {
        this.selectObject = selectObject;
        this.isPlusIndexPartSelect = selectObject instanceof IHidOperator && ((IHidOperator)selectObject).isPlusIndexPartSelect();
        this.isMinusIndexPartSelect = selectObject instanceof IHidOperator && ((IHidOperator)selectObject).isMinusIndexPartSelect();
    }

    public XComputedSelect(IHidObject selectObject, IELParamValue ... computedValues) {
        this(selectObject);
        this.computedValues = computedValues;
    }

    public int[] getIndexes() {
        if (this.computedValues.length <= 1) {
            return new int[]{this.computedValues[0].intValue()};
        }
        int selectValue0 = this.computedValues[0].intValue();
        int selectValue1 = this.computedValues[1].intValue();
        if (this.isPlusIndexPartSelect) {
            return new int[]{selectValue0, selectValue0 + selectValue1 - 1};
        }
        if (this.isMinusIndexPartSelect) {
            return new int[]{selectValue0, selectValue0 - selectValue1 + 1};
        }
        return new int[]{selectValue0, selectValue1};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XComputedSelect intersect(XComputedSelect other) {
        try {
            int select0;
            int tempSelect;
            int otherSelect1;
            int thisSelect1;
            if (this.computedValues.length == 1 && other.computedValues.length == 1) {
                if (this.computedValues[0].intValue() != other.computedValues[0].intValue()) return null;
                return this;
            }
            boolean thisIsPlus = this.isPlusIndexPartSelect;
            boolean thisIsMinus = this.isMinusIndexPartSelect;
            boolean otherIsPlus = other.isPlusIndexPartSelect;
            boolean otherIsMinus = other.isMinusIndexPartSelect;
            boolean isDecreasing = false;
            int thisSelect0 = this.computedValues[0].intValue();
            int n = thisSelect1 = this.computedValues.length == 1 ? thisSelect0 : this.computedValues[1].intValue();
            if (this.computedValues.length != 1 && !thisIsPlus && !thisIsMinus) {
                isDecreasing = thisSelect0 < thisSelect1;
            }
            int otherSelect0 = other.computedValues[0].intValue();
            int n2 = otherSelect1 = other.computedValues.length == 1 ? otherSelect0 : other.computedValues[1].intValue();
            if (this.computedValues.length != 1 && !otherIsPlus && !otherIsMinus) {
                isDecreasing |= otherSelect0 < otherSelect1;
            }
            if (thisIsPlus) {
                if (isDecreasing) {
                    thisSelect1 = thisSelect0 + thisSelect1 - 1;
                } else {
                    tempSelect = thisSelect0;
                    thisSelect0 = thisSelect0 + thisSelect1 - 1;
                    thisSelect1 = tempSelect;
                }
            } else if (thisIsMinus) {
                if (isDecreasing) {
                    thisSelect1 = thisSelect0 - thisSelect1 + 1;
                } else {
                    tempSelect = thisSelect0;
                    thisSelect0 = thisSelect0 - thisSelect1 + 1;
                    thisSelect1 = tempSelect;
                }
            }
            if (otherIsPlus) {
                if (isDecreasing) {
                    otherSelect1 = otherSelect0 + otherSelect1 - 1;
                } else {
                    tempSelect = otherSelect0;
                    otherSelect0 = otherSelect0 + otherSelect1 - 1;
                    otherSelect1 = tempSelect;
                }
            } else if (otherIsMinus) {
                if (isDecreasing) {
                    otherSelect1 = otherSelect0 - otherSelect1 + 1;
                } else {
                    tempSelect = otherSelect0;
                    otherSelect0 = otherSelect0 - otherSelect1 + 1;
                    otherSelect1 = tempSelect;
                }
            }
            if (thisSelect0 >= thisSelect1 && otherSelect0 >= otherSelect1) {
                int select1;
                select0 = Math.min(thisSelect0, otherSelect0);
                if (select0 < (select1 = Math.max(thisSelect1, otherSelect1))) {
                    return null;
                }
                return new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(select0))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(select1))));
            }
            if (thisSelect0 > thisSelect1) return null;
            if (otherSelect0 > otherSelect1) return null;
            select0 = Math.max(thisSelect0, otherSelect0);
            int select1 = Math.min(thisSelect1, otherSelect1);
            if (select1 < select0) {
                return null;
            }
            return new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(select0))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(select1))));
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XComputedSelect[] diff(XComputedSelect other) {
        try {
            int right1;
            int left;
            int tempSelect;
            int otherSelect1;
            int thisSelect1;
            if (this.computedValues.length == 1 && other.computedValues.length == 1) {
                if (this.computedValues[0].intValue() == other.computedValues[0].intValue()) {
                    return null;
                }
                return new XComputedSelect[]{new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(this.computedValues[0].intValue()))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(this.computedValues[0].intValue()))))};
            }
            boolean thisIsPlus = this.isPlusIndexPartSelect;
            boolean thisIsMinus = this.isMinusIndexPartSelect;
            boolean otherIsPlus = other.isPlusIndexPartSelect;
            boolean otherIsMinus = other.isMinusIndexPartSelect;
            boolean isDecreasing = false;
            int thisSelect0 = this.computedValues[0].intValue();
            int n = thisSelect1 = this.computedValues.length == 1 ? thisSelect0 : this.computedValues[1].intValue();
            if (this.computedValues.length != 1 && !thisIsPlus && !thisIsMinus) {
                isDecreasing = thisSelect0 < thisSelect1;
            }
            int otherSelect0 = other.computedValues[0].intValue();
            int n2 = otherSelect1 = other.computedValues.length == 1 ? otherSelect0 : other.computedValues[1].intValue();
            if (this.computedValues.length != 1 && !otherIsPlus && !otherIsMinus) {
                isDecreasing |= otherSelect0 < otherSelect1;
            }
            if (thisIsPlus) {
                if (isDecreasing) {
                    thisSelect1 = thisSelect0 + thisSelect1 - 1;
                } else {
                    tempSelect = thisSelect0;
                    thisSelect0 = thisSelect0 + thisSelect1 - 1;
                    thisSelect1 = tempSelect;
                }
            } else if (thisIsMinus) {
                if (isDecreasing) {
                    thisSelect1 = thisSelect0 - thisSelect1 + 1;
                } else {
                    tempSelect = thisSelect0;
                    thisSelect0 = thisSelect0 - thisSelect1 + 1;
                    thisSelect1 = tempSelect;
                }
            }
            if (otherIsPlus) {
                if (isDecreasing) {
                    otherSelect1 = otherSelect0 + otherSelect1 - 1;
                } else {
                    tempSelect = otherSelect0;
                    otherSelect0 = otherSelect0 + otherSelect1 - 1;
                    otherSelect1 = tempSelect;
                }
            } else if (otherIsMinus) {
                if (isDecreasing) {
                    otherSelect1 = otherSelect0 - otherSelect1 + 1;
                } else {
                    tempSelect = otherSelect0;
                    otherSelect0 = otherSelect0 - otherSelect1 + 1;
                    otherSelect1 = tempSelect;
                }
            }
            if (thisSelect0 >= thisSelect1 && otherSelect0 >= otherSelect1) {
                if (otherSelect0 >= thisSelect0 && otherSelect1 <= thisSelect1) {
                    return null;
                }
                if (otherSelect0 >= thisSelect0) {
                    left = otherSelect1 - 1;
                    int right = Math.min(otherSelect1 - 1, thisSelect1);
                    return new XComputedSelect[]{this.getSelects(left, right)};
                }
                if (otherSelect1 <= thisSelect1) {
                    left = thisSelect0;
                    int right = Math.max(otherSelect0 + 1, thisSelect1);
                    return new XComputedSelect[]{this.getSelects(left, right)};
                }
                right1 = otherSelect0 + 1;
                int left2 = otherSelect1 - 1;
                XComputedSelect select1 = this.getSelects(thisSelect0, right1);
                XComputedSelect select2 = this.getSelects(left2, thisSelect1);
                return new XComputedSelect[]{select1, select2};
            }
            if (thisSelect0 > thisSelect1) return null;
            if (otherSelect0 > otherSelect1) return null;
            if (otherSelect0 <= thisSelect0 && otherSelect1 >= thisSelect1) {
                return null;
            }
            if (otherSelect0 <= thisSelect0) {
                left = Math.max(otherSelect1 + 1, thisSelect0);
                int right = thisSelect1;
                return new XComputedSelect[]{this.getSelects(left, right)};
            }
            if (otherSelect1 >= thisSelect1) {
                left = thisSelect0;
                int right = Math.min(thisSelect1, otherSelect0 - 1);
                return new XComputedSelect[]{this.getSelects(left, right)};
            }
            right1 = otherSelect0 - 1;
            int left2 = otherSelect1 + 1;
            XComputedSelect select1 = this.getSelects(thisSelect0, right1);
            XComputedSelect select2 = this.getSelects(left2, thisSelect1);
            return new XComputedSelect[]{select1, select2};
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
        return null;
    }

    private XComputedSelect getSelects(int left, int right) {
        if (left == right) {
            return new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(left))));
        }
        return new XComputedSelect(null, ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(left))), ELParamValues.ParamValueNumber.of(VlogBitVector.create(true, 31, 0, BigInteger.valueOf(right))));
    }

    public IHidObject getSelectObject() {
        if (this.selectObject != null) {
            return this.selectObject;
        }
        if (this.computedValues == null) {
            return null;
        }
        if (this.computedValues.length == 1) {
            this.selectObject = HidUtils.makeStandInImplicit(DVTStringUtil.appendString(this.computedValues[0].bigIntegerValue()), IHidImplicitConstants.ImplicitType.QUA_NUMBER.id);
        }
        this.selectObject = HidUtils.makeStandInImplicit(DVTStringUtil.appendString(this.computedValues[0].bigIntegerValue(), ":", this.computedValues[1].bigIntegerValue()), IHidImplicitConstants.ImplicitType.NO_TYPE.id);
        return this.selectObject;
    }

    public String toString() {
        if (this.computedValues == null) {
            return DVTStringUtil.appendString(this.selectObject);
        }
        if (this.computedValues.length == 1) {
            return DVTStringUtil.appendString(this.computedValues[0].bigIntegerValue());
        }
        return DVTStringUtil.appendString(this.computedValues[0].bigIntegerValue(), ":", this.computedValues[1].bigIntegerValue());
    }

    public String toNiceString() {
        if (this.computedValues == null) {
            return HidUtils.toNiceString(this.selectObject);
        }
        if (this.computedValues.length == 1) {
            return this.computedValues[0].bigIntegerValue().toString();
        }
        return DVTStringUtil.appendString(this.computedValues[0].bigIntegerValue(), ":", this.computedValues[1].bigIntegerValue());
    }

    @Override
    public XComputedSelect internalThis() {
        return this;
    }
}

