/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import ro.amiq.dvt.elaboration.ELUtils;
import ro.amiq.dvt.elaboration.model.ELParamValueScope;
import ro.amiq.dvt.interpreter.XFrameBlockEvalScope;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XUtils;
import ro.amiq.dvt.model.reflection.IRfDefElement;
import ro.amiq.dvt.model.reflection.IRfNamedElement;
import ro.amiq.dvt.model.reflection.ParserPath;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.assertion.AssertTMAbstractTransition;
import ro.amiq.dvt.model.reflection.assertion.AssertTMState;
import ro.amiq.dvt.model.reflection.assertion.IAssertTMState;
import ro.amiq.dvt.model.reflection.semantic.extension.HidEvalCenter;
import ro.amiq.dvt.model.reflection.semantic.extension.HidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.HidUtils;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluator;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidObject;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidOperator;
import ro.amiq.dvt.model.reflection.semantic.extension.UnknownHidObjectEvaluationException;
import ro.amiq.dvt.utils.BitVectorContext;

public class XConcurrentAssertBlockEvalScope
extends XFrameBlockEvalScope {
    private final HidEvalCenter.ConcurrentAssertStatement statement;
    private final AssertTM assertTM;
    private AssertTM.AssertTMCursor cursor;

    public XConcurrentAssertBlockEvalScope(IHidEvaluator evaluator, BitVectorContext bvContext, IHidEvaluationGuardian guardian, HidEvalCenter.ConcurrentAssertStatement statement, ParserPath parserPath, boolean isInitVariablesFrame) {
        super(null, evaluator, bvContext, guardian, statement, parserPath, null, isInitVariablesFrame);
        this.statement = statement;
        this.assertTM = statement.getAssertTM();
    }

    @Override
    protected IHidObject getNextStatement() {
        if (this.isDisabled) {
            return null;
        }
        this.nextStatement = this.getNextStatementInternal();
        return this.nextStatement;
    }

    private IHidObject getNextStatementInternal() {
        if (this.assertTM.states.isEmpty() || this.assertTM.transitionTable.isEmpty()) {
            return null;
        }
        if (this.pc == Integer.MAX_VALUE) {
            return null;
        }
        ++this.pc;
        IAssertTMState currentState = this.cursor.nextState().getCurrentState();
        IAssertTMState prevState = currentState.getPrevState();
        if (prevState != null && prevState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE && ((AssertTMState.AssertTMStateDelay)prevState).isNoDelay()) {
            this.cursor.removeFlag(4);
        }
        IHidObject hidObject = null;
        if (currentState instanceof AssertTMState.AssertTMStateExecute && (hidObject = ((AssertTMState.AssertTMStateExecute)currentState).execute(this.statement, this.evaluator, this.cursor, this.guardian)) == null) {
            return null;
        }
        if (!(this.cursor.getStartSimTime() != null || currentState.getKind() != AssertTMState.AssertStateKind.ATOM || currentState.getHidObject() instanceof HidOperator && ((HidOperator)currentState.getHidObject()).isVlogEventControl())) {
            this.cursor.setStartSimTime(this.guardian.getFactory().getCurrentSimTime());
            this.cursor.resetDelayCounter();
        }
        if (currentState.getKind() == AssertTMState.AssertStateKind.DELAY_RANGE && ((AssertTMState.AssertTMStateDelay)currentState).isNoDelay() && this.cursor.getDelayCounter() == 0 && !this.cursor.hasFlag(4)) {
            currentState = this.cursor.nextState().getCurrentState();
            this.cursor.setFlag(4);
        }
        hidObject = currentState.getHidObject();
        return hidObject;
    }

    @Override
    protected ELParamValueScope executeStatement(IHidObject nextStatement) {
        boolean prevEvalAssert = this.guardian.setEvalAssert(true);
        try {
            this.assertTM.evaluateDisableIffExpression(this.evaluator, this.guardian);
            ELParamValueScope result = super.executeStatement(nextStatement);
            if (ELUtils.isUnsuccessfulEval(result)) {
                throw new UnknownHidObjectEvaluationException(nextStatement);
            }
            boolean isFalse = ELUtils.isFalse(XUtils.getValue(result));
            this.cursor.storeAbbrevResult(isFalse);
            if (isFalse && !this.cursor.hasFlag(16)) {
                IAssertTMState currentState = this.cursor.getCurrentState();
                AssertTMAbstractTransition transition = this.assertTM.transitionTable.get(currentState);
                if (transition == null) {
                    throw new IllegalStateException("No transition found from '" + HidUtils.toNiceString(currentState.getHidObject()) + "'");
                }
                IHidOperator operator = transition.getOperator();
                if (this.cursor.getParentCursor() == null && operator != null && (operator.isOverlappingImplication() || operator.isNonOverlappingImplication())) {
                    XThread xThread = this.cursor.getXThread();
                    xThread.localTerminate(false);
                    ELParamValueScope eLParamValueScope = result;
                    return eLParamValueScope;
                }
                if (this.cursor.prevState() != null) {
                    ELParamValueScope eLParamValueScope = result;
                    return eLParamValueScope;
                }
                IAssertTMState failState = transition.getFailState();
                if (failState == null) {
                    this.guardian.logError("No fail state associated to operator '" + HidUtils.toNiceString(currentState.getHidObject()) + "'. Fallback to global fail state");
                    failState = this.assertTM.getFailure();
                }
                ((AssertTMState.AssertTMStateExecute)failState).execute(this.statement, this.evaluator, this.cursor, this.guardian);
            }
            ELParamValueScope eLParamValueScope = result;
            return eLParamValueScope;
        }
        finally {
            this.guardian.setEvalAssert(prevEvalAssert);
        }
    }

    public void setCursor(AssertTM.AssertTMCursor cursor) {
        this.cursor = cursor;
    }

    public void incrementCursorDelayCounter() {
        this.cursor.incrementDelayCounter();
    }

    @Override
    public IRfNamedElement getNamedElement() {
        return this.statement.getNamedElement();
    }

    @Override
    public int getLineNumber() {
        IRfNamedElement namedElement = this.getNamedElement();
        IRfDefElement declaration = namedElement.getDeclaration();
        if (declaration == null) {
            return -1;
        }
        return declaration.getStartLine();
    }

    public AssertTM getAssertTM() {
        return this.assertTM;
    }
}

