/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.Set;
import ro.amiq.dvt.interpreter.IXThreadScheduler;
import ro.amiq.dvt.interpreter.XConcurrentAssertBlockEvalScope;
import ro.amiq.dvt.interpreter.XInstValueHolder;
import ro.amiq.dvt.interpreter.XThread;
import ro.amiq.dvt.interpreter.XThreadDefinition;
import ro.amiq.dvt.interpreter.XValueHolderFactory;
import ro.amiq.dvt.model.reflection.IRfAssertExpectElement;
import ro.amiq.dvt.model.reflection.assertion.AssertTM;
import ro.amiq.dvt.model.reflection.semantic.extension.IHidEvaluationGuardian;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;

public class XConcurrentAssertThread
extends XThread {
    private XConcurrentAssertBlockEvalScope assertScope;

    public XConcurrentAssertThread(XConcurrentAssertBlockEvalScope assertScope, XThreadDefinition xThreadDefinition, int id, int spawnedById, Set<String> spawnedByLabels, IXThreadScheduler xThreadScheduler, XInstValueHolder instanceScope) {
        super(xThreadDefinition, id, spawnedById, spawnedByLabels, xThreadScheduler, instanceScope);
        this.assertScope = assertScope;
    }

    @Override
    protected void notifyEventControlDone() {
        this.assertScope.incrementCursorDelayCounter();
    }

    @Override
    protected void handleInternalException() {
        try {
            IHidEvaluationGuardian guardian = this.getHidEvaluationGuardian();
            if (!guardian.isInterpreter()) {
                return;
            }
            XValueHolderFactory factory = guardian.getFactory();
            if (factory == null) {
                return;
            }
            IRfAssertExpectElement assertElement = (IRfAssertExpectElement)this.assertScope.getNamedElement();
            XInstValueHolder instanceScope = this.getInstanceScope();
            guardian.logError(DVTStringUtil.appendString("Internal exception encountered when evaluating '", assertElement.getName(), "' in scope '", instanceScope, "'"));
            factory.registerAssertResult(instanceScope.getInstancePath(), assertElement, AssertTM.AssertResult.ERROR);
        }
        catch (Exception e) {
            DVTLogger.INSTANCE.logError((Throwable)e);
        }
    }

    public String toString() {
        return "xConcurrentThread@" + this.getId();
    }
}

