/*
 * Decompiled with CFR 0.152.
 */
package ro.amiq.dvt.interpreter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import ro.amiq.dvt.LanguageKind;
import ro.amiq.dvt.interpreter.IXContributor;
import ro.amiq.dvt.startup.core.DVTLogger;

public class XContributors {
    public static final String DVT_X_EXTENSION_POINT_ID = "ro.amiq.dvt.XContributor";
    public static final String DVT_X_CONTRIBUTOR_ELEMENT = "XContributor";
    private static List<IXContributor> fContributors = new ArrayList<IXContributor>();

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(DVT_X_EXTENSION_POINT_ID);
        IExtension[] iExtensionArray = extensionPoint.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if (!DVT_X_CONTRIBUTOR_ELEMENT.equals(configurationElement.getName())) {
                    DVTLogger.INSTANCE.logError((Throwable)new Exception("Invalid element: " + configurationElement + " for extension point: " + DVT_X_EXTENSION_POINT_ID));
                }
                try {
                    Object executableExtension = configurationElement.createExecutableExtension("class");
                    fContributors.add((IXContributor)executableExtension);
                }
                catch (CoreException e) {
                    DVTLogger.INSTANCE.logError((Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public static <T extends IXContributor> T getContributor(LanguageKind languageKind, String id) {
        if (languageKind == null || id == null) {
            return null;
        }
        if (fContributors == null) {
            return null;
        }
        for (IXContributor vc : fContributors) {
            if (vc.getLanguageKind() != languageKind || !id.equals(vc.getID())) continue;
            return (T)vc;
        }
        return null;
    }

    public static List<IXContributor> getAnyXContributor(String viewId) {
        if (viewId == null) {
            return Collections.emptyList();
        }
        if (fContributors == null) {
            return Collections.emptyList();
        }
        ArrayList<IXContributor> contributors = new ArrayList<IXContributor>();
        for (IXContributor vc : fContributors) {
            if (!viewId.equals(vc.getID())) continue;
            contributors.add(vc);
        }
        return contributors;
    }

    public static List<IXContributor> getContributors(LanguageKind languageKind) {
        if (languageKind == null) {
            return null;
        }
        if (fContributors == null) {
            return null;
        }
        ArrayList<IXContributor> xContributors = new ArrayList<IXContributor>();
        for (IXContributor vc : fContributors) {
            if (vc.getLanguageKind() != languageKind) continue;
            xContributors.add(vc);
        }
        return xContributors;
    }
}

